/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.StmtMetadataLoader;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.catalog.DatabaseNotFoundException;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.Table;
import org.apache.impala.common.AnalysisSessionFixture;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.QueryFixture;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.testutil.ImpaladTestCatalog;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ExprCardinalityTest {
    private static AnalysisSessionFixture session_ = new AnalysisSessionFixture();
    public static final double INEQUALITY_SEL = 0.33;

    @BeforeClass
    public static void setUp() {
        RuntimeEnv.INSTANCE.setTestEnv(true);
    }

    @AfterClass
    public static void cleanUp() {
        RuntimeEnv.INSTANCE.reset();
    }

    private void verifyTableCol(Table table, String colName, long expectedNdv, long expectedNullCount) {
        Column col = table.getColumn(colName);
        Assert.assertNotNull((Object)col);
        ColumnStats stats = col.getStats();
        Assert.assertNotNull((Object)stats);
        Assert.assertEquals((long)expectedNdv, (long)stats.getNumDistinctValues());
        Assert.assertEquals((long)expectedNullCount, (long)stats.getNumNulls());
    }

    @Test
    public void testMetadata() throws DatabaseNotFoundException, InternalException {
        ImpaladTestCatalog catalog = session_.catalog();
        Db db = catalog.getDb("functional");
        StmtMetadataLoader mdLoader = new StmtMetadataLoader(session_.frontend(), "functional", null);
        HashSet tables = Sets.newHashSet((Object[])new TableName[]{new TableName("functional", "alltypes"), new TableName("functional", "nullrows"), new TableName("functional", "manynulls")});
        mdLoader.loadTables((Set)tables);
        Table allTypes = db.getTable("alltypes");
        Assert.assertEquals((long)7300L, (long)allTypes.getTTableStats().getNum_rows());
        this.verifyTableCol(allTypes, "id", 7300L, 0L);
        this.verifyTableCol(allTypes, "bool_col", 2L, 0L);
        this.verifyTableCol(allTypes, "int_col", 10L, 0L);
        Table nullrows = db.getTable("nullrows");
        Assert.assertEquals((long)26L, (long)nullrows.getTTableStats().getNum_rows());
        this.verifyTableCol(nullrows, "id", 26L, 0L);
        this.verifyTableCol(nullrows, "null_str", 0L, 26L);
        this.verifyTableCol(nullrows, "group_str", 6L, 0L);
        this.verifyTableCol(nullrows, "some_nulls", 6L, 20L);
        this.verifyTableCol(nullrows, "bool_nulls", 3L, 15L);
        Table manynulls = db.getTable("manynulls");
        Assert.assertEquals((long)-1L, (long)manynulls.getTTableStats().getNum_rows());
        this.verifyTableCol(manynulls, "id", -1L, -1L);
    }

    public void verifySelectCol(String table, String col, long expectedNdv, long expectedNullCount) throws ImpalaException {
        QueryFixture.SelectFixture select = new QueryFixture.SelectFixture(session_).table("functional." + table).exprSql(col);
        Expr expr = select.analyzeExpr();
        SlotRef colRef = (SlotRef)expr;
        Assert.assertEquals((long)expectedNdv, (long)expr.getNumDistinctValues());
        Assert.assertEquals((long)expectedNullCount, (long)colRef.getDesc().getStats().getNumNulls());
        Assert.assertEquals((double)-1.0, (double)expr.getSelectivity(), (double)0.001);
    }

    @Test
    public void testColumnCardinality() throws ImpalaException {
        this.verifySelectCol("alltypes", "id", 7300L, 0L);
        this.verifySelectCol("alltypes", "bool_col", 2L, 0L);
        this.verifySelectCol("alltypes", "int_col", 10L, 0L);
        this.verifySelectCol("nullrows", "id", 26L, 0L);
        this.verifySelectCol("nullrows", "null_str", 1L, 26L);
        this.verifySelectCol("nullrows", "group_str", 6L, 0L);
        this.verifySelectCol("nullrows", "some_nulls", 6L, 20L);
        this.verifySelectCol("nullrows", "bool_nulls", 3L, 15L);
        this.verifySelectCol("manynulls", "id", -1L, -1L);
    }

    public void verifySelectExpr(String db, String table, String exprSql, long expectedNdv, double expectedSel) throws ImpalaException {
        QueryFixture.SelectFixture select = new QueryFixture.SelectFixture(session_).table(db + "." + table).exprSql(exprSql);
        Expr expr = select.analyzeExpr();
        Assert.assertEquals((long)expectedNdv, (long)expr.getNumDistinctValues());
        Assert.assertEquals((double)expectedSel, (double)expr.getSelectivity(), (double)1.0E-5);
    }

    public void verifySelectExpr(String table, String exprSql, long expectedNdv, double expectedSel) throws ImpalaException {
        this.verifySelectExpr("functional", table, exprSql, expectedNdv, expectedSel);
    }

    @Test
    public void testConstants() throws ImpalaException {
        this.verifySelectExpr("alltypes", "10", 1L, -1.0);
        this.verifySelectExpr("allTypes", "'foo'", 1L, -1.0);
        this.verifySelectExpr("alltypes", "NULL", 1L, 0.0);
        this.verifySelectExpr("alltypes", "true", 1L, 1.0);
        this.verifySelectExpr("alltypes", "false", 1L, 0.0);
    }

    @Test
    public void testEqSelectivity() throws ImpalaException {
        this.verifySelectExpr("alltypes", "id = 10", 3L, 1.36986301369863E-4);
        this.verifySelectExpr("alltypes", "bool_col = true", 3L, 0.5);
        this.verifySelectExpr("alltypes", "int_col = 10", 3L, 0.1);
        this.verifySelectExpr("nullrows", "id = 'foo'", 3L, 0.038461538461538464);
        this.verifySelectExpr("nullrows", "null_str = 'foo'", 3L, 0.0);
        this.verifySelectExpr("nullrows", "group_str = 'foo'", 3L, 0.16666666666666666);
        this.verifySelectExpr("nullrows", "some_nulls = 'foo'", 3L, 0.038461538461538464);
        this.verifySelectExpr("nullrows", "some_nulls = null", 3L, 0.0);
        this.verifySelectExpr("manynulls", "id = 10", 3L, -1.0);
    }

    @Test
    public void testNotDistinctSelectivity() throws ImpalaException {
        this.verifySelectExpr("alltypes", "id is not distinct from 10", 3L, 1.36986301369863E-4);
        this.verifySelectExpr("alltypes", "id is not distinct from null", 3L, 0.0);
        this.verifySelectExpr("alltypes", "bool_col is not distinct from true", 3L, 0.5);
        this.verifySelectExpr("alltypes", "bool_col is not distinct from null", 3L, 0.0);
        this.verifySelectExpr("alltypes", "int_col is not distinct from 10", 3L, 0.1);
        this.verifySelectExpr("alltypes", "int_col is not distinct from null", 3L, 0.0);
        this.verifySelectExpr("nullrows", "id is not distinct from 'foo'", 3L, 0.038461538461538464);
        this.verifySelectExpr("nullrows", "id is not distinct from null", 3L, 0.0);
        this.verifySelectExpr("nullrows", "null_str is not distinct from 'foo'", 3L, 0.0);
        this.verifySelectExpr("nullrows", "null_str is not distinct from null", 3L, 1.0);
        this.verifySelectExpr("nullrows", "group_str is not distinct from 'foo'", 3L, 0.16666666666666666);
        this.verifySelectExpr("nullrows", "group_str is not distinct from null", 3L, 0.0);
        this.verifySelectExpr("nullrows", "some_nulls is not distinct from 'foo'", 3L, 0.038461538461538464);
        this.verifySelectExpr("manynulls", "id is not distinct from 10", 3L, -1.0);
    }

    @Test
    public void testNeSelectivity() throws ImpalaException {
        this.verifySelectExpr("alltypes", "id != 10", 3L, 0.9998630136986302);
        this.verifySelectExpr("alltypes", "bool_col != true", 3L, 0.5);
        this.verifySelectExpr("alltypes", "int_col != 10", 3L, 0.9);
        this.verifySelectExpr("nullrows", "id != 'foo'", 3L, 0.9615384615384616);
        this.verifySelectExpr("nullrows", "null_str != 'foo'", 3L, 0.0);
        this.verifySelectExpr("nullrows", "group_str != 'foo'", 3L, 0.8333333333333334);
        this.verifySelectExpr("nullrows", "some_nulls != 'foo'", 3L, 0.19230769230769232);
        this.verifySelectExpr("nullrows", "some_nulls != null", 3L, 0.0);
        this.verifySelectExpr("emptytable", "field != 'foo'", 3L, -1.0);
        this.verifySelectExpr("emptytable", "f2 != 10", 3L, 0.0);
        this.verifySelectExpr("manynulls", "id != 10", 3L, -1.0);
    }

    @Test
    public void testDistinctSelectivity() throws ImpalaException {
        this.verifySelectExpr("alltypes", "id is distinct from 10", 3L, 0.9998630136986302);
        this.verifySelectExpr("alltypes", "id is distinct from null", 3L, 1.0);
        this.verifySelectExpr("alltypes", "bool_col is distinct from true", 3L, 0.5);
        this.verifySelectExpr("alltypes", "bool_col is distinct from null", 3L, 1.0);
        this.verifySelectExpr("alltypes", "int_col is distinct from 10", 3L, 0.9);
        this.verifySelectExpr("alltypes", "int_col is distinct from null", 3L, 1.0);
        this.verifySelectExpr("nullrows", "id is distinct from 'foo'", 3L, 0.9615384615384616);
        this.verifySelectExpr("nullrows", "id is distinct from null", 3L, 1.0);
        this.verifySelectExpr("nullrows", "null_str is distinct from 'foo'", 3L, 1.0);
        this.verifySelectExpr("nullrows", "null_str is distinct from null", 3L, 0.0);
        this.verifySelectExpr("nullrows", "group_str is distinct from 'foo'", 3L, 0.8333333333333334);
        this.verifySelectExpr("nullrows", "group_str is distinct from null", 3L, 1.0);
        this.verifySelectExpr("nullrows", "group_str is distinct from null", 3L, 1.0);
        this.verifySelectExpr("nullrows", "some_nulls is not distinct from 'foo'", 3L, 0.038461538461538464);
        this.verifySelectExpr("nullrows", "some_nulls is distinct from null", 3L, 0.23076923076923078);
        this.verifySelectExpr("manynulls", "id is distinct from 10", 3L, -1.0);
    }

    private void verifyInequalitySel(String table, String col, String value) throws ImpalaException {
        for (String op : new String[]{"<", "<=", ">", ">="}) {
            this.verifySelectExpr(table, col + " " + op + " " + value, 3L, -1.0);
        }
    }

    @Test
    public void testInequalitySelectivity() throws ImpalaException {
        this.verifyInequalitySel("alltypes", "id", "10");
        this.verifyInequalitySel("alltypes", "int_col", "10");
        this.verifyInequalitySel("nullrows", "id", "'foo'");
        this.verifyInequalitySel("nullrows", "null_str", "'foo'");
        this.verifyInequalitySel("nullrows", "group_str", "'foo'");
        this.verifyInequalitySel("nullrows", "some_nulls", "'foo'");
        this.verifyInequalitySel("manynulls", "id", "10");
    }

    @Test
    public void testIsNullSelectivity() throws ImpalaException {
        this.verifySelectExpr("alltypes", "id is null", 3L, 0.0);
        this.verifySelectExpr("alltypes", "bool_col is null", 3L, 0.0);
        this.verifySelectExpr("alltypes", "int_col is null", 3L, 0.0);
        this.verifySelectExpr("nullrows", "id is null", 3L, 0.0);
        this.verifySelectExpr("nullrows", "null_str is null", 3L, 1.0);
        this.verifySelectExpr("nullrows", "group_str is null", 3L, 0.0);
        this.verifySelectExpr("nullrows", "some_nulls is null", 3L, 0.7692307692307693);
        this.verifySelectExpr("nullrows", "bool_nulls is not null", 3L, 0.42307692307692313);
        this.verifySelectExpr("manynulls", "id is null", 3L, -1.0);
    }

    @Test
    public void testNotNullSelectivity() throws ImpalaException {
        this.verifySelectExpr("alltypes", "id is not null", 3L, 1.0);
        this.verifySelectExpr("alltypes", "bool_col is not null", 3L, 1.0);
        this.verifySelectExpr("alltypes", "int_col is not null", 3L, 1.0);
        this.verifySelectExpr("nullrows", "id is not null", 3L, 1.0);
        this.verifySelectExpr("nullrows", "null_str is not null", 3L, 0.0);
        this.verifySelectExpr("nullrows", "group_str is not null", 3L, 1.0);
        this.verifySelectExpr("nullrows", "some_nulls is not null", 3L, 0.23076923076923073);
        this.verifySelectExpr("nullrows", "bool_nulls is not null", 3L, 0.42307692307692313);
        this.verifySelectExpr("manynulls", "id is not null", 3L, -1.0);
    }

    @Test
    public void testInSelectivity() throws ImpalaException {
        this.verifySelectExpr("alltypes", "id in (1, 2, 3)", 3L, 4.1095890410958907E-4);
        this.verifySelectExpr("alltypes", "id in (1, 2, 3, 2, 3, 1)", 3L, 8.219178082191781E-4);
        this.verifySelectExpr("alltypes", "bool_col in (true)", 3L, 0.5);
        this.verifySelectExpr("alltypes", "bool_col in (true, false)", 3L, 1.0);
        this.verifySelectExpr("alltypes", "int_col in (1, 2, 3)", 3L, 0.3);
        this.verifySelectExpr("alltypes", "int_col in (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)", 3L, 1.0);
        this.verifySelectExpr("nullrows", "id in ('a', 'b', 'c')", 3L, 0.11538461538461539);
        this.verifySelectExpr("nullrows", "null_str in ('a', 'b', 'c')", 3L, 1.0);
        this.verifySelectExpr("nullrows", "group_str in ('a', 'b', 'c')", 3L, 0.5);
        this.verifySelectExpr("nullrows", "some_nulls in ('a', 'b', 'c')", 3L, 0.5);
        this.verifySelectExpr("manynulls", "id in (1, 3, 3)", 3L, -1.0);
    }

    @Test
    public void testNotInSelectivity() throws ImpalaException {
        this.verifySelectExpr("alltypes", "id not in (1, 2, 3)", 3L, 0.9995890410958904);
        this.verifySelectExpr("alltypes", "id not in (1, 2, 3, 2, 3, 1)", 3L, 0.9991780821917808);
        this.verifySelectExpr("alltypes", "bool_col not in (true)", 3L, 0.5);
        this.verifySelectExpr("alltypes", "bool_col not in (true, false)", 3L, 0.0);
        this.verifySelectExpr("alltypes", "int_col not in (1, 2, 3)", 3L, 0.7);
        this.verifySelectExpr("alltypes", "int_col not in (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)", 3L, 0.0);
        this.verifySelectExpr("nullrows", "id not in ('a', 'b', 'c')", 3L, 0.8846153846153846);
        this.verifySelectExpr("nullrows", "null_str not in ('a', 'b', 'c')", 3L, 0.0);
        this.verifySelectExpr("nullrows", "group_str not in ('a', 'b', 'c')", 3L, 0.5);
        this.verifySelectExpr("nullrows", "some_nulls not in ('a', 'b', 'c')", 3L, 0.5);
        this.verifySelectExpr("manynulls", "id not in (1, 3, 3)", 3L, -1.0);
    }

    @Test
    public void testNotSelectivity() throws ImpalaException {
        this.verifySelectExpr("alltypes", "not id in (1, 2, 3)", 3L, 0.9995890410958904);
        this.verifySelectExpr("alltypes", "not int_col in (1, 2)", 3L, 0.8);
        this.verifySelectExpr("alltypes", "not int_col = 10", 3L, 0.9);
        this.verifySelectExpr("manynulls", "not id = 10", 3L, -1.0);
    }

    @Test
    public void testAndSelectivity() throws ImpalaException {
        this.verifySelectExpr("alltypes", "bool_col = true", 3L, 0.5);
        this.verifySelectExpr("alltypes", "int_col = 10", 3L, 0.1);
        this.verifySelectExpr("alltypes", "bool_col = true and int_col = 10", 3L, 0.05);
        this.verifySelectExpr("alltypes", "int_col >= 10 and int_col <= 20", 3L, -1.0);
        this.verifySelectExpr("alltypes", "int_col = 10 AND smallint_col > 20", 3L, -1.0);
    }

    @Test
    public void testOrSelectivity() throws ImpalaException {
        this.verifySelectExpr("alltypes", "bool_col = true or int_col = 10", 3L, 0.5499999999999999);
        this.verifySelectExpr("alltypes", "int_col = 10 or int_col = 20", 3L, 0.2);
        this.verifySelectExpr("alltypes", "int_col = 10 or true", 1L, 1.0);
        this.verifySelectExpr("alltypes", "int_col = 10 or false", 3L, 0.1);
        this.verifySelectExpr("alltypes", "int_col = 10 or null", 3L, 0.1);
    }

    @Test
    public void testBetweenSelectivity() throws ImpalaException {
        this.verifySelectExpr("alltypes", "id between 30 and 60", 3L, 0.0042465753424657535);
        this.verifySelectExpr("alltypes", "id between 1 and 7298", 3L, -1.0);
        this.verifySelectExpr("alltypes", "int_col between 30 and 60", 3L, -1.0);
        this.verifySelectExpr("tpcds_partitioned_parquet_snap", "date_dim", "d_date between DATE '2001-03-13' and (DATE '2001-03-13' + interval 90 days)", 3L, 0.001245739161384824);
        this.verifySelectExpr("manynulls", "id between 30 and 60", 3L, -1.0);
    }

    @Test
    public void testNotBetweenSelectivity() throws ImpalaException {
        this.verifySelectExpr("alltypes", "id not between 30 and 60", 3L, -1.0);
        this.verifySelectExpr("alltypes", "id not between 1 and 7298", 3L, 2.73972602739726E-4);
        this.verifySelectExpr("alltypes", "int_col not between 30 and 60", 3L, -1.0);
        this.verifySelectExpr("tpcds_partitioned_parquet_snap", "date_dim", "d_date not between DATE '2001-03-13' and (DATE '2001-03-13' + interval 90 days)", 3L, -1.0);
        this.verifySelectExpr("manynulls", "id not between 30 and 60", 3L, -1.0);
    }
}

