/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.authorization.AuthorizationException;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FrontendTestBase;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.service.Frontend;
import org.apache.impala.testutil.ImpaladTestCatalog;
import org.apache.impala.thrift.TAccessEvent;
import org.apache.impala.thrift.TCatalogObjectType;
import org.junit.Assert;
import org.junit.Test;

public class AuditingTest
extends FrontendTestBase {
    @Test
    public void TestSelect() throws AuthorizationException, AnalysisException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("select * from functional.alltypesagg");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.alltypesagg", TCatalogObjectType.TABLE, "SELECT")}));
        accessEvents = this.AnalyzeAccessEvents("select * from functional.view_view");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.view_view", TCatalogObjectType.VIEW, "SELECT"), new TAccessEvent("functional.alltypes_view", TCatalogObjectType.VIEW, "SELECT"), new TAccessEvent("functional.alltypes", TCatalogObjectType.TABLE, "SELECT")}));
        accessEvents = this.AnalyzeAccessEvents("select * from functional_rc.subquery_view");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_rc.alltypessmall", TCatalogObjectType.TABLE, "SELECT"), new TAccessEvent("functional_rc.alltypes", TCatalogObjectType.TABLE, "SELECT"), new TAccessEvent("functional_rc.subquery_view", TCatalogObjectType.VIEW, "SELECT"), new TAccessEvent("_impala_builtins", TCatalogObjectType.DATABASE, "VIEW_METADATA")}));
        accessEvents = this.AnalyzeAccessEvents("select a.* from (select * from functional.alltypesagg) a");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.alltypesagg", TCatalogObjectType.TABLE, "SELECT")}));
        accessEvents = this.AnalyzeAccessEvents("select item from functional.allcomplextypes.int_array_col");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.allcomplextypes", TCatalogObjectType.TABLE, "SELECT")}));
        accessEvents = this.AnalyzeAccessEvents("select item from functional.allcomplextypes a, a.int_array_col");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.allcomplextypes", TCatalogObjectType.TABLE, "SELECT")}));
    }

    @Test
    public void TestUnion() throws AuthorizationException, AnalysisException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("select * from functional.alltypes union all select * from functional_rc.alltypes");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.alltypes", TCatalogObjectType.TABLE, "SELECT"), new TAccessEvent("functional_rc.alltypes", TCatalogObjectType.TABLE, "SELECT")}));
    }

    @Test
    public void TestInsert() throws AuthorizationException, AnalysisException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("insert into functional.alltypes partition(month,year) select * from functional_rc.alltypes");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_rc.alltypes", TCatalogObjectType.TABLE, "SELECT"), new TAccessEvent("functional.alltypes", TCatalogObjectType.TABLE, "INSERT")}));
        accessEvents = this.AnalyzeAccessEvents("insert into functional.alltypes partition(month,year) select b.* from functional.alltypesagg a join (select * from functional_rc.alltypes) b on (a.int_col = b.int_col)");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.alltypesagg", TCatalogObjectType.TABLE, "SELECT"), new TAccessEvent("functional_rc.alltypes", TCatalogObjectType.TABLE, "SELECT"), new TAccessEvent("functional.alltypes", TCatalogObjectType.TABLE, "INSERT")}));
    }

    @Test
    public void TestWithClause() throws AuthorizationException, AnalysisException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("with t as (select * from functional.alltypesagg) select * from t");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.alltypesagg", TCatalogObjectType.TABLE, "SELECT")}));
        accessEvents = this.AnalyzeAccessEvents("with t as (select * from functional.alltypes_view) select * from t");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.alltypes_view", TCatalogObjectType.VIEW, "SELECT"), new TAccessEvent("functional.alltypes", TCatalogObjectType.TABLE, "SELECT")}));
        accessEvents = this.AnalyzeAccessEvents("with t as (select 1 + 2) select * from t");
        Assert.assertEquals((long)0L, (long)accessEvents.size());
        accessEvents = this.AnalyzeAccessEvents("with t as (select * from functional.alltypes) select 'abc'");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.alltypes", TCatalogObjectType.TABLE, "SELECT")}));
        accessEvents = this.AnalyzeAccessEvents("with t as (select * from functional.alltypes) select * from functional_seq.alltypes");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.alltypes", TCatalogObjectType.TABLE, "SELECT"), new TAccessEvent("functional_seq.alltypes", TCatalogObjectType.TABLE, "SELECT")}));
    }

    @Test
    public void TestExplainEvents() throws AuthorizationException, AnalysisException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("explain select * from functional.alltypesagg");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.alltypesagg", TCatalogObjectType.TABLE, "SELECT")}));
    }

    @Test
    public void TestUseDb() throws AnalysisException, AuthorizationException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("use functional");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional", TCatalogObjectType.DATABASE, "ANY")}));
    }

    @Test
    public void TestResetMetadataEvents() throws AnalysisException, AuthorizationException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("invalidate metadata functional.alltypesagg");
        Assert.assertEquals((long)0L, (long)accessEvents.size());
        accessEvents = this.AnalyzeAccessEvents("refresh functional.alltypesagg");
        Assert.assertEquals((long)0L, (long)accessEvents.size());
    }

    @Test
    public void TestCreateTable() throws AnalysisException, AuthorizationException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("create table tpch.new_table (i int)");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("tpch.new_table", TCatalogObjectType.TABLE, "CREATE")}));
        accessEvents = this.AnalyzeAccessEvents("create table tpch.new_lineitem like tpch.lineitem");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("tpch.lineitem", TCatalogObjectType.TABLE, "VIEW_METADATA"), new TAccessEvent("tpch.new_lineitem", TCatalogObjectType.TABLE, "CREATE")}));
        accessEvents = this.AnalyzeAccessEvents("create table tpch.new_table like parquet '/test-warehouse/schemas/zipcode_incomes.parquet'");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("tpch.new_table", TCatalogObjectType.TABLE, "CREATE")}));
        accessEvents = this.AnalyzeAccessEvents("create table tpch.new_table as select * from functional.alltypesagg");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("tpch", TCatalogObjectType.DATABASE, "ANY"), new TAccessEvent("functional.alltypesagg", TCatalogObjectType.TABLE, "SELECT"), new TAccessEvent("tpch.new_table", TCatalogObjectType.TABLE, "CREATE")}));
    }

    @Test
    public void TestCreateView() throws AuthorizationException, AnalysisException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("create view tpch.new_view as select * from functional.alltypesagg");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.alltypesagg", TCatalogObjectType.TABLE, "SELECT"), new TAccessEvent("tpch.new_view", TCatalogObjectType.VIEW, "CREATE")}));
    }

    @Test
    public void TestCreateDatabase() throws AnalysisException, AuthorizationException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("create database newdb");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("newdb", TCatalogObjectType.DATABASE, "CREATE")}));
    }

    @Test
    public void TestDropDatabase() throws AnalysisException, AuthorizationException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("drop database tpch");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("tpch", TCatalogObjectType.DATABASE, "DROP")}));
    }

    @Test
    public void TestDropTable() throws AnalysisException, AuthorizationException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("drop table tpch.lineitem");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("tpch.lineitem", TCatalogObjectType.TABLE, "DROP")}));
        accessEvents = this.AnalyzeAccessEvents("drop table functional.unsupported_binary_partition");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.unsupported_binary_partition", TCatalogObjectType.TABLE, "DROP")}));
        accessEvents = this.AnalyzeAccessEvents("drop table unsupported_binary_partition", "functional");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.unsupported_binary_partition", TCatalogObjectType.TABLE, "DROP")}));
    }

    @Test
    public void TestDropView() throws AnalysisException, AuthorizationException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("drop view functional_seq_snap.alltypes_view");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_seq_snap.alltypes_view", TCatalogObjectType.VIEW, "DROP")}));
    }

    @Test
    public void AlterTable() throws AnalysisException, AuthorizationException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("ALTER TABLE functional_seq_snap.alltypes ADD COLUMNS (c1 int)");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_seq_snap.alltypes", TCatalogObjectType.TABLE, "ALTER")}));
        accessEvents = this.AnalyzeAccessEvents("ALTER TABLE functional_seq_snap.alltypes RENAME TO functional_seq_snap.t1");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_seq_snap.alltypes", TCatalogObjectType.TABLE, "ALL"), new TAccessEvent("functional_seq_snap.t1", TCatalogObjectType.TABLE, "CREATE")}));
    }

    @Test
    public void TestAlterView() throws AnalysisException, AuthorizationException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("ALTER VIEW functional_seq_snap.alltypes_view AS SELECT * FROM functional.alltypes");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_seq_snap.alltypes_view", TCatalogObjectType.VIEW, "ALTER"), new TAccessEvent("functional.alltypes", TCatalogObjectType.TABLE, "SELECT")}));
        accessEvents = this.AnalyzeAccessEvents("ALTER VIEW functional_seq_snap.alltypes_view rename to functional_seq_snap.v1");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_seq_snap.alltypes_view", TCatalogObjectType.VIEW, "ALL"), new TAccessEvent("functional_seq_snap.v1", TCatalogObjectType.VIEW, "CREATE")}));
    }

    @Test
    public void TestComputeStats() throws AnalysisException, AuthorizationException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("COMPUTE STATS functional_seq_snap.alltypes");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_seq_snap.alltypes", TCatalogObjectType.TABLE, "ALTER"), new TAccessEvent("functional_seq_snap.alltypes", TCatalogObjectType.TABLE, "SELECT")}));
        accessEvents = this.AnalyzeAccessEvents("COMPUTE STATS FUNCTIONAL_SEQ_SNAP.ALLTYPES");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_seq_snap.alltypes", TCatalogObjectType.TABLE, "ALTER"), new TAccessEvent("functional_seq_snap.alltypes", TCatalogObjectType.TABLE, "SELECT")}));
    }

    @Test
    public void TestDropStats() throws AnalysisException, AuthorizationException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("DROP STATS functional_seq_snap.alltypes");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_seq_snap.alltypes", TCatalogObjectType.TABLE, "ALTER")}));
    }

    @Test
    public void TestDescribeDb() throws AuthorizationException, AnalysisException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("describe database default");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("default", TCatalogObjectType.DATABASE, "VIEW_METADATA")}));
        accessEvents = this.AnalyzeAccessEvents("describe database extended default");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("default", TCatalogObjectType.DATABASE, "VIEW_METADATA")}));
    }

    @Test
    public void TestDescribe() throws AuthorizationException, AnalysisException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("describe functional.alltypesagg");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.alltypesagg", TCatalogObjectType.TABLE, "ANY")}));
        accessEvents = this.AnalyzeAccessEvents("describe formatted functional.alltypesagg");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.alltypesagg", TCatalogObjectType.TABLE, "ANY")}));
        accessEvents = this.AnalyzeAccessEvents("describe functional.complex_view");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.complex_view", TCatalogObjectType.VIEW, "ANY")}));
        accessEvents = this.AnalyzeAccessEvents("describe functional.allcomplextypes.int_array_col");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.allcomplextypes", TCatalogObjectType.TABLE, "ANY")}));
    }

    @Test
    public void TestShowViewMetadata() throws AnalysisException, AuthorizationException {
        String[] statsQuals;
        for (String qual : statsQuals = new String[]{"partitions", "table stats", "column stats"}) {
            Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents(String.format("show %s functional.alltypes", qual));
            Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.alltypes", TCatalogObjectType.TABLE, "VIEW_METADATA")}));
        }
    }

    @Test
    public void TestShowAny() throws AnalysisException, AuthorizationException {
        String[] statsQuals;
        for (String qual : statsQuals = new String[]{"tables", "functions"}) {
            Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents(String.format("show %s in functional", qual));
            Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional", TCatalogObjectType.DATABASE, "ANY")}));
        }
    }

    @Test
    public void TestShowCreateTable() throws AuthorizationException, AnalysisException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("show create table functional.alltypesagg");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.alltypesagg", TCatalogObjectType.TABLE, "VIEW_METADATA")}));
    }

    @Test
    public void TestLoad() throws AuthorizationException, AnalysisException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("load data inpath 'hdfs://localhost:20500/test-warehouse/tpch.lineitem' into table functional.alltypes partition(month=10, year=2009)");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional.alltypes", TCatalogObjectType.TABLE, "INSERT")}));
    }

    @Test
    public void TestAccessEventsOnAuthFailure() throws ImpalaException {
        AuthorizationFactory authzFactory = this.createAuthorizationFactory(false);
        try (ImpaladTestCatalog catalog = new ImpaladTestCatalog(authzFactory);){
            Frontend fe = new Frontend(authzFactory, (FeCatalog)catalog);
            AnalysisContext analysisCtx = this.createAnalysisCtx(authzFactory);
            try {
                this.parseAndAnalyze("create table foo_does_not_exist(i int)", analysisCtx, fe);
                Assert.fail((String)"Expected AuthorizationException");
            }
            catch (AuthorizationException e) {
                Assert.assertEquals((long)1L, (long)analysisCtx.getAnalyzer().getAccessEvents().size());
            }
        }
    }

    @Test
    public void TestDoubleAccess() throws AuthorizationException, AnalysisException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("select count(1), max(1) from functional.alltypesagg a join functional.alltypesagg b on a.id = b.id");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("_impala_builtins", TCatalogObjectType.DATABASE, "VIEW_METADATA"), new TAccessEvent("functional.alltypesagg", TCatalogObjectType.TABLE, "SELECT")}));
    }
}

