/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.impala.authorization.AuthorizationException;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FrontendTestBase;
import org.apache.impala.thrift.TAccessEvent;
import org.apache.impala.thrift.TCatalogObjectType;
import org.junit.Assert;
import org.junit.Test;

public class AuditingKuduTest
extends FrontendTestBase {
    @Test
    public void TestKuduStatements() throws AuthorizationException, AnalysisException {
        Set<TAccessEvent> accessEvents = this.AnalyzeAccessEvents("select * from functional_kudu.testtbl");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_kudu.testtbl", TCatalogObjectType.TABLE, "SELECT")}));
        accessEvents = this.AnalyzeAccessEvents("insert into functional_kudu.testtbl (id) select id from functional_kudu.alltypes");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_kudu.alltypes", TCatalogObjectType.TABLE, "SELECT"), new TAccessEvent("functional_kudu.testtbl", TCatalogObjectType.TABLE, "INSERT")}));
        accessEvents = this.AnalyzeAccessEvents("upsert into functional_kudu.testtbl (id) select id from functional_kudu.alltypes");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_kudu.alltypes", TCatalogObjectType.TABLE, "SELECT"), new TAccessEvent("functional_kudu.testtbl", TCatalogObjectType.TABLE, "ALL")}));
        accessEvents = this.AnalyzeAccessEvents("delete from functional_kudu.testtbl where id = 1");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_kudu.testtbl", TCatalogObjectType.TABLE, "SELECT"), new TAccessEvent("functional_kudu.testtbl", TCatalogObjectType.TABLE, "ALL")}));
        accessEvents = this.AnalyzeAccessEvents("delete c from functional_kudu.testtbl c, functional_kudu.alltypes s where c.id = s.id and s.int_col < 10");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_kudu.testtbl", TCatalogObjectType.TABLE, "SELECT"), new TAccessEvent("functional_kudu.alltypes", TCatalogObjectType.TABLE, "SELECT"), new TAccessEvent("functional_kudu.testtbl", TCatalogObjectType.TABLE, "ALL")}));
        accessEvents = this.AnalyzeAccessEvents("update functional_kudu.testtbl set name = 'test' where id < 10");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_kudu.testtbl", TCatalogObjectType.TABLE, "SELECT"), new TAccessEvent("functional_kudu.testtbl", TCatalogObjectType.TABLE, "ALL")}));
        accessEvents = this.AnalyzeAccessEvents("drop table functional_kudu.testtbl");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_kudu.testtbl", TCatalogObjectType.TABLE, "DROP")}));
        accessEvents = this.AnalyzeAccessEvents("drop table if exists functional_kudu.testtbl");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_kudu.testtbl", TCatalogObjectType.TABLE, "DROP")}));
        accessEvents = this.AnalyzeAccessEvents("show create table functional_kudu.testtbl");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_kudu.testtbl", TCatalogObjectType.TABLE, "VIEW_METADATA")}));
        accessEvents = this.AnalyzeAccessEvents("compute stats functional_kudu.testtbl");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_kudu.testtbl", TCatalogObjectType.TABLE, "ALTER"), new TAccessEvent("functional_kudu.testtbl", TCatalogObjectType.TABLE, "SELECT")}));
        accessEvents = this.AnalyzeAccessEvents("describe functional_kudu.testtbl");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_kudu.testtbl", TCatalogObjectType.TABLE, "ANY")}));
        accessEvents = this.AnalyzeAccessEvents("describe formatted functional_kudu.testtbl");
        Assert.assertEquals(accessEvents, (Object)Sets.newHashSet((Object[])new TAccessEvent[]{new TAccessEvent("functional_kudu.testtbl", TCatalogObjectType.TABLE, "ANY")}));
    }
}

