/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.impala.analysis.AggregateInfo;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.AnalyzerTest;
import org.apache.impala.analysis.BaseTableRef;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.CollectionTableRef;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.JoinOperator;
import org.apache.impala.analysis.PlanHint;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.SetOperationStmt;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.ValuesStmt;
import org.apache.impala.catalog.BuiltinsDb;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.FeSupport;
import org.apache.impala.thrift.TFunctionCategory;
import org.junit.Assert;
import org.junit.Test;

public class AnalyzeStmtsTest
extends AnalyzerTest {
    private void testCollectionTableRefs(String collectionTable, String collectionField) {
        TableName tbl = new TableName("functional", "allcomplextypes");
        this.TblsAnalyzeOk(String.format("select %s from $TBL, allcomplextypes.%s", collectionField, collectionTable), tbl);
        this.TblsAnalyzeOk(String.format("select %s from $TBL, functional.allcomplextypes.%s", collectionField, collectionTable), tbl);
        this.TblsAnalyzeOk(String.format("select %s from $TBL a, a.%s", collectionField, collectionTable), tbl);
        this.TblsAnalyzeOk(String.format("select b.%s from $TBL a, a.%s b, a.int_map_col c", collectionField, collectionTable), tbl);
        this.TblsAnalyzeOk(String.format("select c.%s from $TBL a, a.int_array_col b, a.%s c", collectionField, collectionTable), tbl);
        this.TblsAnalyzeOk(String.format("select 1 from $TBL, allcomplextypes.%s, functional.allcomplextypes.%s", collectionTable, collectionTable), tbl);
        for (JoinOperator joinOp : JoinOperator.values()) {
            if (joinOp.isNullAwareLeftAntiJoin() || joinOp.isIcebergDeleteJoin()) continue;
            this.TblsAnalyzeOk(String.format("select 1 from $TBL %s allcomplextypes.%s", joinOp, collectionTable), tbl);
            this.TblsAnalyzeOk(String.format("select 1 from $TBL a %s a.%s", joinOp, collectionTable), tbl);
        }
        this.TblsAnalyzeOk(String.format("select %s from $TBL a, functional.allcomplextypes.%s", collectionField, collectionTable), tbl);
        this.TblsAnalyzeOk(String.format("select %s from $TBL.%s, functional.allcomplextypes", collectionField, collectionTable), tbl);
        this.TblsAnalyzeOk(String.format("select %s from functional.allcomplextypes a, $TBL.%s", collectionField, collectionTable), tbl);
        this.TblsAnalyzeOk(String.format("select %s from functional.allcomplextypes.%s, $TBL", collectionField, collectionTable), tbl);
        for (JoinOperator joinOp : JoinOperator.values()) {
            if (joinOp.isNullAwareLeftAntiJoin() || joinOp.isCrossJoin() || joinOp.isInnerJoin() || joinOp.isIcebergDeleteJoin()) continue;
            this.AnalysisError(String.format("select 1 from functional.allcomplextypes.%s %s functional.allcomplextypes", collectionTable, joinOp), String.format("%s requires an ON or USING clause", joinOp));
        }
        this.TblsAnalysisError(String.format("select %s from $TBL a, a.%s a", collectionField, collectionTable), tbl, "Duplicate table alias: 'a'");
        this.TblsAnalysisError(String.format("select %s from $TBL a, a.%s b, a.%s b", collectionField, collectionTable, collectionTable), tbl, "Duplicate table alias: 'b'");
        this.TblsAnalysisError(String.format("select %s from $TBL a, a.%s, a.%s", collectionField, collectionTable, collectionTable), tbl, String.format("Duplicate table alias: '%s'", "a." + collectionTable));
        this.TblsAnalysisError(String.format("select %s from $TBL, functional.allcomplextypes.%s allcomplextypes", collectionField, collectionTable), tbl, "Duplicate table alias: 'allcomplextypes'");
        this.AnalysisError(String.format("select %s from allcomplextypes, %s", collectionField, collectionTable), this.createAnalysisCtx("functional"), String.format("Could not resolve table reference: '%s'", collectionTable));
        this.AnalysisError(String.format("select %s from functional.allcomplextypes, %s", collectionField, collectionTable), String.format("Could not resolve table reference: '%s'", collectionTable));
        this.AnalysisError(String.format("select %s from functional.allcomplextypes, functional_parquet.allcomplextypes, allcomplextypes.%s", collectionField, collectionTable), "Unqualified table alias is ambiguous: 'allcomplextypes'");
    }

    private boolean isCollectionTableRef(String tableName) {
        return tableName.split("\\.").length > 0;
    }

    private void testAllTableAliases(String[] tables, String[] columns) throws AnalysisException {
        for (String tbl : tables) {
            String[] tblName = new TableName("functional", tbl);
            String uqAlias = tbl.substring(tbl.lastIndexOf(".") + 1);
            String fqAlias = "functional." + tbl;
            boolean isCollectionTblRef = this.isCollectionTableRef(tbl);
            for (String col : columns) {
                this.TblsAnalyzeOk(String.format("select %s from $TBL", col), (TableName)tblName);
                this.TblsAnalyzeOk(String.format("select %s.%s from $TBL", uqAlias, col), (TableName)tblName);
                if (!isCollectionTblRef) {
                    this.TblsAnalyzeOk(String.format("select %s.%s from $TBL", fqAlias, col), (TableName)tblName);
                }
                this.TblsAnalyzeOk(String.format("select %s from $TBL a", col), (TableName)tblName);
                this.TblsAnalyzeOk(String.format("select a.%s from $TBL a", col), (TableName)tblName);
                String errRefStr = "column/field reference";
                if (col.endsWith("*")) {
                    errRefStr = "star expression";
                }
                this.TblsAnalysisError(String.format("select %s.%s from $TBL a", uqAlias, col, tbl), (TableName)tblName, String.format("Could not resolve %s: '%s.%s'", errRefStr, uqAlias, col));
                this.TblsAnalysisError(String.format("select %s.%s from $TBL a", fqAlias, col, tbl), (TableName)tblName, String.format("Could not resolve %s: '%s.%s'", errRefStr, fqAlias, col));
            }
        }
        for (String t1 : tables) {
            for (String t2 : tables) {
                if (t1.equals(t2) || this.isCollectionTableRef(t1) && this.isCollectionTableRef(t2)) continue;
                for (String col : columns) {
                    this.AnalyzesOk(String.format("select functional.%s.%s, functional.%s.%s from functional.%s, functional.%s", t1, col, t2, col, t1, t2));
                }
            }
        }
        String col = columns[0];
        for (String tbl : tables) {
            TableName tblName = new TableName("functional", tbl);
            this.TblsAnalysisError("select alltypessmall.int_col from $TBL", tblName, "Could not resolve column/field reference: 'alltypessmall.int_col'");
            this.TblsAnalysisError(String.format("select a.%s from $TBL a, functional.testtbl a", col), tblName, "Duplicate table alias");
            this.TblsAnalysisError(String.format("select %s from $TBL, $TBL", col), tblName, "Duplicate table alias");
            String uqAlias = tbl.substring(tbl.lastIndexOf(".") + 1);
            this.TblsAnalysisError(String.format("select %s.%s from $TBL, functional.testtbl %s", tbl, col, uqAlias), tblName, "Duplicate table alias");
        }
    }

    public void testDefaultHintApplied(AnalysisContext insertCtx) {
        String defaultHints = insertCtx.getQueryOptions().getDefault_hints_insert_statement();
        List planHints = insertCtx.getAnalysisResult().getInsertStmt().getPlanHints();
        String[] defaultHintsArray = defaultHints.trim().split(":");
        Assert.assertEquals((long)defaultHintsArray.length, (long)planHints.size());
        for (String hint : defaultHintsArray) {
            Assert.assertTrue((boolean)planHints.contains(new PlanHint(hint.trim())));
        }
    }

    public void testDefaultHintIgnored(String query, String defaultHints) {
        AnalysisContext insertCtx = this.createAnalysisCtx();
        this.AnalyzesOk(query, insertCtx);
        List planHints = insertCtx.getAnalysisResult().getInsertStmt().getPlanHints();
        insertCtx.getQueryOptions().setDefault_hints_insert_statement(defaultHints);
        this.AnalyzesOk(query, insertCtx);
        List planHintsWithDefaultHints = insertCtx.getAnalysisResult().getInsertStmt().getPlanHints();
        Assert.assertEquals((Object)planHints, (Object)planHintsWithDefaultHints);
    }

    @Test
    public void TestCollectionTableRefs() throws AnalysisException {
        this.testAllTableAliases(new String[]{"allcomplextypes.int_array_col"}, new String[]{"pos", "item", "*"});
        this.testAllTableAliases(new String[]{"allcomplextypes.struct_array_col"}, new String[]{"f1", "f2", "*"});
        this.testAllTableAliases(new String[]{"allcomplextypes.int_map_col"}, new String[]{"key", "value", "*"});
        this.testAllTableAliases(new String[]{"allcomplextypes.struct_map_col"}, new String[]{"key", "f1", "f2", "*"});
        this.testAllTableAliases(new String[]{"allcomplextypes.complex_nested_struct_col.f2.f12"}, new String[]{"key", "f21", "*"});
        this.testCollectionTableRefs("int_array_col", "pos");
        this.testCollectionTableRefs("int_array_col", "item");
        this.testCollectionTableRefs("int_map_col", "key");
        this.testCollectionTableRefs("complex_nested_struct_col.f2.f12", "f21");
        this.AnalysisError("select 1 from functional.allcomplextypes a, a", "Illegal table reference to non-collection type: 'a'");
        this.AnalysisError("select 1 from functional.allcomplextypes.int_struct_col", "Illegal table reference to non-collection type: 'functional.allcomplextypes.int_struct_col'\nPath resolved to type: STRUCT<f1:INT,f2:INT>");
        this.AnalysisError("select 1 from functional.allcomplextypes a, a.int_struct_col", "Illegal table reference to non-collection type: 'a.int_struct_col'\nPath resolved to type: STRUCT<f1:INT,f2:INT>");
        this.AnalysisError("select 1 from functional.allcomplextypes.int_array_col.item", "Illegal table reference to non-collection type: 'functional.allcomplextypes.int_array_col.item'\nPath resolved to type: INT");
        this.AnalysisError("select 1 from functional.allcomplextypes.int_array_col a, a.pos", "Illegal table reference to non-collection type: 'a.pos'\nPath resolved to type: BIGINT");
        this.AnalysisError("select 1 from functional.allcomplextypes.int_map_col.key", "Illegal table reference to non-collection type: 'functional.allcomplextypes.int_map_col.key'\nPath resolved to type: STRING");
        this.AnalysisError("select 1 from functional.allcomplextypes.int_map_col a, a.key", "Illegal table reference to non-collection type: 'a.key'\nPath resolved to type: STRING");
        for (JoinOperator joinOp : JoinOperator.values()) {
            if (joinOp.isNullAwareLeftAntiJoin() || joinOp.isIcebergDeleteJoin()) continue;
            this.AnalyzesOk(String.format("select 1 from functional.allcomplextypes a %s a.int_array_col b", joinOp));
            this.AnalyzesOk(String.format("select 1 from functional.allcomplextypes a %s a.struct_array_col b", joinOp));
            this.AnalyzesOk(String.format("select 1 from functional.allcomplextypes a %s a.int_map_col b", joinOp));
            this.AnalyzesOk(String.format("select 1 from functional.allcomplextypes a %s a.struct_map_col", joinOp));
        }
        this.AnalysisError("select pos from (select int_array_col from functional.allcomplextypes) v", "Could not resolve column/field reference: 'pos'");
        this.AnalyzesOk("select pos from (select int_array_col from functional.allcomplextypes) v, v.int_array_col");
    }

    @Test
    public void TestCatalogTableRefs() throws AnalysisException {
        String[] tables = new String[]{"alltypes", "alltypes_view"};
        String[] columns = new String[]{"int_col", "*"};
        this.testAllTableAliases(tables, columns);
        this.AnalyzesOk("select * from functional.alltypes cross join functional_parquet.alltypes");
        this.AnalysisError("select int_col from functional.alltypes cross join functional_parquet.alltypes", "Column/field reference is ambiguous: 'int_col'");
        this.AnalysisError("select alltypes.int_col from functional.alltypes cross join functional_parquet.alltypes", "Unqualified table alias is ambiguous: 'alltypes'");
        this.AnalysisError("select alltypes.* from functional.alltypes cross join functional_parquet.alltypes", "Unqualified table alias is ambiguous: 'alltypes'");
        this.AnalysisError("select alltypes.smallint_col, functional.alltypes.int_col from alltypes inner join functional.alltypes on (alltypes.id = functional.alltypes.id)", this.createAnalysisCtx("functional"), "Duplicate table alias: 'functional.alltypes'");
    }

    @Test
    public void TestTableSampleClause() {
        long[] bytesPercVals = new long[]{0L, 10L, 50L, 100L};
        long[] randomSeedVals = new long[]{0L, 10L, 100L, Integer.MAX_VALUE, Long.MAX_VALUE};
        for (long bytesPerc : bytesPercVals) {
            String tblSmpl = String.format("tablesample system (%s)", bytesPerc);
            this.AnalyzesOk("select * from functional.alltypes  " + tblSmpl);
            for (long randomSeed : randomSeedVals) {
                String repTblSmpl = String.format("%s repeatable (%s)", tblSmpl, randomSeed);
                this.AnalyzesOk("select * from functional.alltypes  " + repTblSmpl);
            }
        }
        this.AnalysisError("select * from functional.alltypes tablesample system (101)", "Invalid percent of bytes value '101'. The percent of bytes to sample must be between 0 and 100.");
        this.AnalysisError("select * from functional.alltypes tablesample system (1000)", "Invalid percent of bytes value '1000'. The percent of bytes to sample must be between 0 and 100.");
        this.AnalysisError("select * from functional_kudu.alltypes tablesample system (10)", "TABLESAMPLE is only supported on HDFS tables: functional_kudu.alltypes");
        this.AnalysisError("select * from functional_hbase.alltypes tablesample system (10)", "TABLESAMPLE is only supported on HDFS tables: functional_hbase.alltypes");
        this.AnalysisError("select * from functional.alltypes_datasource tablesample system (10)", "TABLESAMPLE is only supported on HDFS tables: functional.alltypes_datasource");
        this.AnalysisError("select * from (select * from functional.alltypes) v tablesample system (10)", "TABLESAMPLE is only supported on HDFS tables: v");
        this.AnalysisError("with v as (select * from functional.alltypes) select * from v tablesample system (10)", "TABLESAMPLE is only supported on HDFS tables: v");
        this.AnalysisError("select * from functional.alltypes_view tablesample system (10)", "TABLESAMPLE is only supported on HDFS tables: functional.alltypes_view");
        this.AnalysisError("select * from functional.allcomplextypes.int_array_col tablesample system (10)", "TABLESAMPLE is only supported on HDFS tables: functional.allcomplextypes.int_array_col");
        this.AnalysisError("select * from functional.allcomplextypes a, a.int_array_col tablesample system (10)", "TABLESAMPLE is only supported on HDFS tables: a.int_array_col");
    }

    private List<Integer> path(Integer ... p) {
        return Lists.newArrayList((Object[])p);
    }

    private void testSlotRefPath(String sql, List<Integer> expectedAbsPath) {
        AnalysisContext ctx = this.createAnalysisCtx();
        SelectStmt stmt = (SelectStmt)this.AnalyzesOk(sql, ctx);
        Expr e = (Expr)stmt.getResultExprs().get(stmt.getResultExprs().size() - 1);
        Preconditions.checkState((boolean)(e instanceof SlotRef));
        Preconditions.checkState((!e.getType().isCollectionType() ? 1 : 0) != 0);
        SlotRef slotRef = (SlotRef)e;
        List actualAbsPath = slotRef.getDesc().getPath().getAbsolutePath();
        Assert.assertEquals((String)"Mismatched absolute paths.", expectedAbsPath, (Object)actualAbsPath);
        List actualMatPath = slotRef.getDesc().getMaterializedPath();
        Assert.assertEquals((String)"Mismatched absolute/materialized paths.", (Object)actualAbsPath, (Object)actualMatPath);
    }

    private void testStarPath(String sql, List<Integer> ... expectedAbsPaths) {
        SelectStmt stmt = (SelectStmt)this.AnalyzesOk(sql);
        ArrayList<List> actualAbsPaths = new ArrayList<List>();
        for (int i = 0; i < stmt.getResultExprs().size(); ++i) {
            Expr e = (Expr)stmt.getResultExprs().get(i);
            Preconditions.checkState((boolean)(e instanceof SlotRef));
            SlotRef slotRef = (SlotRef)e;
            List actualAbsPath = slotRef.getDesc().getPath().getAbsolutePath();
            List actualMatPath = slotRef.getDesc().getMaterializedPath();
            Assert.assertEquals((String)"Mismatched paths.", (Object)actualAbsPath, (Object)actualMatPath);
            actualAbsPaths.add(actualAbsPath);
        }
        ArrayList expectedPaths = Lists.newArrayList((Object[])expectedAbsPaths);
        Assert.assertEquals((String)"Mismatched absolute paths.", (Object)expectedPaths, actualAbsPaths);
    }

    private void testTableRefPath(String sql, List<Integer> expectedAbsPath, List<Integer> expectedMatPath) {
        SelectStmt stmt = (SelectStmt)this.AnalyzesOk(sql);
        TableRef lastTblRef = (TableRef)stmt.getTableRefs().get(stmt.getTableRefs().size() - 1);
        List actualAbsPath = lastTblRef.getDesc().getPath().getAbsolutePath();
        Assert.assertEquals((String)"Mismatched absolute paths.", expectedAbsPath, (Object)actualAbsPath);
        if (!lastTblRef.isRelative()) {
            Assert.assertNull((String)"There is no materialized path for non-relative table refs.\nThe expected materialized path should be null.", expectedMatPath);
            return;
        }
        CollectionTableRef collectionTblRef = (CollectionTableRef)lastTblRef;
        Expr collectionExpr = collectionTblRef.getCollectionExpr();
        Preconditions.checkState((boolean)(collectionExpr instanceof SlotRef));
        SlotRef collectionSlotRef = (SlotRef)collectionExpr;
        SlotDescriptor collectionSlotDesc = collectionSlotRef.getDesc();
        Assert.assertEquals((String)"Mismatched paths.", (Object)actualAbsPath, (Object)collectionSlotDesc.getPath().getAbsolutePath());
        Assert.assertEquals((String)"Mismatched materialized paths.", expectedMatPath, (Object)collectionSlotDesc.getMaterializedPath());
    }

    @Test
    public void TestImplicitAndExplicitPaths() {
        String[] implicitFieldNames;
        for (String field : implicitFieldNames = new String[]{"pos", "item", "key", "value"}) {
            this.AnalysisError(String.format("select %s from functional.alltypes", field), String.format("Could not resolve column/field reference: '%s'", field));
        }
        this.addTestDb("d", null);
        this.addTestTable("create table d.t1 (c array<int>)");
        this.testSlotRefPath("select item from d.t1.c", this.path(0, 0));
        this.testSlotRefPath("select pos from d.t1.c", this.path(0, 1));
        this.AnalysisError("select item.item from d.t1.c", "Could not resolve column/field reference: 'item.item'");
        this.AnalysisError("select item.pos from d.t1.c", "Could not resolve column/field reference: 'item.pos'");
        this.testStarPath("select * from d.t1.c", this.path(0, 0));
        this.testStarPath("select c.* from d.t1.c", this.path(0, 0));
        this.addTestTable("create table d.t2 (c array<struct<f:int>>) stored as orc");
        this.testSlotRefPath("select f from d.t2.c", this.path(0, 0, 0));
        this.testSlotRefPath("select item.f from d.t2.c", this.path(0, 0, 0));
        this.testSlotRefPath("select pos from d.t2.c", this.path(0, 1));
        this.testSlotRefPath("select item from d.t2.c", this.path(0, 0));
        this.AnalysisError("select item.pos from d.t2.c", "Could not resolve column/field reference: 'item.pos'");
        this.testStarPath("select * from d.t2.c", this.path(0, 0, 0));
        this.testStarPath("select c.* from d.t2.c", this.path(0, 0, 0));
        this.addTestTable("create table d.t3 (c array<struct<f:int,item:int,pos:int>>) stored as orc");
        this.testSlotRefPath("select f from d.t3.c", this.path(0, 0, 0));
        this.testSlotRefPath("select item.f from d.t3.c", this.path(0, 0, 0));
        this.testSlotRefPath("select item.item from d.t3.c", this.path(0, 0, 1));
        this.testSlotRefPath("select item.pos from d.t3.c", this.path(0, 0, 2));
        this.testSlotRefPath("select pos from d.t3.c", this.path(0, 1));
        this.testSlotRefPath("select item from d.t3.c", this.path(0, 0));
        this.testStarPath("select * from d.t3.c", this.path(0, 0, 0), this.path(0, 0, 1), this.path(0, 0, 2));
        this.testStarPath("select c.* from d.t3.c", this.path(0, 0, 0), this.path(0, 0, 1), this.path(0, 0, 2));
        this.addTestTable("create table d.t4 (c map<int,string>)");
        this.testSlotRefPath("select key from d.t4.c", this.path(0, 0));
        this.testSlotRefPath("select value from d.t4.c", this.path(0, 1));
        this.AnalysisError("select value.value from d.t4.c", "Could not resolve column/field reference: 'value.value'");
        this.testStarPath("select * from d.t4.c", this.path(0, 0), this.path(0, 1));
        this.testStarPath("select c.* from d.t4.c", this.path(0, 0), this.path(0, 1));
        this.addTestTable("create table d.t5 (c map<int,struct<f:int>>) stored as orc");
        this.testSlotRefPath("select key from d.t5.c", this.path(0, 0));
        this.testSlotRefPath("select f from d.t5.c", this.path(0, 1, 0));
        this.testSlotRefPath("select value.f from d.t5.c", this.path(0, 1, 0));
        this.AnalysisError("select value.value from d.t5.c", "Could not resolve column/field reference: 'value.value'");
        this.testSlotRefPath("select value from d.t5.c", this.path(0, 1));
        this.testStarPath("select * from d.t5.c", this.path(0, 0), this.path(0, 1, 0));
        this.testStarPath("select c.* from d.t5.c", this.path(0, 0), this.path(0, 1, 0));
        this.addTestTable("create table d.t6 (c map<int,struct<f:int,key:int,value:int>>) stored as orc");
        this.testSlotRefPath("select key from d.t6.c", this.path(0, 0));
        this.testSlotRefPath("select f from d.t6.c", this.path(0, 1, 0));
        this.testSlotRefPath("select value.f from d.t6.c", this.path(0, 1, 0));
        this.testSlotRefPath("select value.key from d.t6.c", this.path(0, 1, 1));
        this.testSlotRefPath("select value.value from d.t6.c", this.path(0, 1, 2));
        this.testSlotRefPath("select value from d.t6.c", this.path(0, 1));
        this.testStarPath("select * from d.t6.c", this.path(0, 0), this.path(0, 1, 0), this.path(0, 1, 1), this.path(0, 1, 2));
        this.testStarPath("select c.* from d.t6.c", this.path(0, 0), this.path(0, 1, 0), this.path(0, 1, 1), this.path(0, 1, 2));
        this.addTestTable("create table d.t6_nested (c map<int,struct<f:int,key:int,value:int,s:struct<f:int,key:int,value:int>>>) stored as orc");
        this.testSlotRefPath("select key from d.t6_nested.c", this.path(0, 0));
        this.testSlotRefPath("select value from d.t6_nested.c", this.path(0, 1));
        this.testSlotRefPath("select f from d.t6_nested.c", this.path(0, 1, 0));
        this.testSlotRefPath("select value.key from d.t6_nested.c", this.path(0, 1, 1));
        this.testSlotRefPath("select value.value from d.t6_nested.c", this.path(0, 1, 2));
        this.testSlotRefPath("select value.s from d.t6_nested.c", this.path(0, 1, 3));
        this.testSlotRefPath("select value.s.f from d.t6_nested.c", this.path(0, 1, 3, 0));
        this.testSlotRefPath("select value.s.key from d.t6_nested.c", this.path(0, 1, 3, 1));
        this.testSlotRefPath("select value.s.value from d.t6_nested.c", this.path(0, 1, 3, 2));
        this.addTestTable("create table d.t7 (c1 int, c2 decimal(10, 4), c3 array<struct<a1:array<int>,a2:array<struct<x:int,y:int,a3:array<int>>>>>, c4 bigint, c5 map<int,struct<m1:map<int,string>,                  m2:map<int,struct<x:int,y:int,m3:map<int,int>>>>>) stored as orc");
        this.testTableRefPath("select 1 from d.t7.c3.a1", this.path(2, 0, 0), null);
        this.testTableRefPath("select 1 from d.t7.c3.item.a1", this.path(2, 0, 0), null);
        this.testSlotRefPath("select item from d.t7.c3.a1", this.path(2, 0, 0, 0));
        this.testSlotRefPath("select item from d.t7.c3.item.a1", this.path(2, 0, 0, 0));
        this.testTableRefPath("select 1 from d.t7.c3.a2", this.path(2, 0, 1), null);
        this.testTableRefPath("select 1 from d.t7.c3.item.a2", this.path(2, 0, 1), null);
        this.testSlotRefPath("select x from d.t7.c3.a2", this.path(2, 0, 1, 0, 0));
        this.testSlotRefPath("select x from d.t7.c3.item.a2", this.path(2, 0, 1, 0, 0));
        this.testTableRefPath("select 1 from d.t7.c3.a2.a3", this.path(2, 0, 1, 0, 2), null);
        this.testTableRefPath("select 1 from d.t7.c3.item.a2.item.a3", this.path(2, 0, 1, 0, 2), null);
        this.testSlotRefPath("select item from d.t7.c3.a2.a3", this.path(2, 0, 1, 0, 2, 0));
        this.testSlotRefPath("select item from d.t7.c3.item.a2.item.a3", this.path(2, 0, 1, 0, 2, 0));
        this.testSlotRefPath("select item from d.t7.c3", this.path(2, 0));
        this.testTableRefPath("select 1 from d.t7, t7.c3, c3.a2, a2.a3", this.path(2, 0, 1, 0, 2), this.path(2, 0, 1, 0, 2));
        this.testTableRefPath("select 1 from d.t7, t7.c3, c3.item.a2, a2.item.a3", this.path(2, 0, 1, 0, 2), this.path(2, 0, 1, 0, 2));
        this.testSlotRefPath("select y from d.t7, t7.c3, c3.a2, a2.a3", this.path(2, 0, 1, 0, 1));
        this.testSlotRefPath("select y, x from d.t7, t7.c3, c3.a2, a2.a3", this.path(2, 0, 1, 0, 0));
        this.testSlotRefPath("select x, y from d.t7, t7.c3.item.a2, a2.a3", this.path(2, 0, 1, 0, 1));
        this.testSlotRefPath("select a1.item from d.t7, t7.c3, c3.a1, c3.a2, a2.a3", this.path(2, 0, 0, 0));
        this.testTableRefPath("select 1 from d.t7, t7.c3.a1", this.path(2, 0, 0), this.path(2));
        this.testTableRefPath("select 1 from d.t7, t7.c3.a2", this.path(2, 0, 1), this.path(2));
        this.testTableRefPath("select 1 from d.t7, t7.c3.a2.a3", this.path(2, 0, 1, 0, 2), this.path(2));
        this.testTableRefPath("select 1 from d.t7, t7.c3, c3.a2.a3", this.path(2, 0, 1, 0, 2), this.path(2, 0, 1));
        this.testTableRefPath("select 1 from d.t7.c5.m1", this.path(4, 1, 0), null);
        this.testTableRefPath("select 1 from d.t7.c5.value.m1", this.path(4, 1, 0), null);
        this.testSlotRefPath("select key from d.t7.c5.m1", this.path(4, 1, 0, 0));
        this.testSlotRefPath("select key from d.t7.c5.value.m1", this.path(4, 1, 0, 0));
        this.testSlotRefPath("select value from d.t7.c5.m1", this.path(4, 1, 0, 1));
        this.testSlotRefPath("select value from d.t7.c5.value.m1", this.path(4, 1, 0, 1));
        this.testTableRefPath("select 1 from d.t7.c5.m2", this.path(4, 1, 1), null);
        this.testTableRefPath("select 1 from d.t7.c5.value.m2", this.path(4, 1, 1), null);
        this.testSlotRefPath("select key from d.t7.c5.m2", this.path(4, 1, 1, 0));
        this.testSlotRefPath("select key from d.t7.c5.value.m2", this.path(4, 1, 1, 0));
        this.testSlotRefPath("select x from d.t7.c5.m2", this.path(4, 1, 1, 1, 0));
        this.testSlotRefPath("select x from d.t7.c5.value.m2", this.path(4, 1, 1, 1, 0));
        this.testTableRefPath("select 1 from d.t7.c5.m2.m3", this.path(4, 1, 1, 1, 2), null);
        this.testTableRefPath("select 1 from d.t7.c5.value.m2.value.m3", this.path(4, 1, 1, 1, 2), null);
        this.testSlotRefPath("select key from d.t7.c5.m2.m3", this.path(4, 1, 1, 1, 2, 0));
        this.testSlotRefPath("select key from d.t7.c5.value.m2.value.m3", this.path(4, 1, 1, 1, 2, 0));
        this.testSlotRefPath("select value from d.t7.c5.m2.m3", this.path(4, 1, 1, 1, 2, 1));
        this.testSlotRefPath("select value from d.t7.c5.value.m2.value.m3", this.path(4, 1, 1, 1, 2, 1));
        this.testTableRefPath("select 1 from d.t7, t7.c5, c5.m2, m2.m3", this.path(4, 1, 1, 1, 2), this.path(4, 1, 1, 1, 2));
        this.testTableRefPath("select 1 from d.t7, t7.c5, c5.value.m2, m2.value.m3", this.path(4, 1, 1, 1, 2), this.path(4, 1, 1, 1, 2));
        this.testSlotRefPath("select y from d.t7, t7.c5, c5.m2, m2.m3", this.path(4, 1, 1, 1, 1));
        this.testSlotRefPath("select y, x from d.t7, t7.c5, c5.m2, m2.m3", this.path(4, 1, 1, 1, 0));
        this.testSlotRefPath("select x, y from d.t7, t7.c5.value.m2, m2.m3", this.path(4, 1, 1, 1, 1));
        this.testSlotRefPath("select m1.key from d.t7, t7.c5, c5.m1, c5.m2, m2.m3", this.path(4, 1, 0, 0));
        this.testTableRefPath("select 1 from d.t7, t7.c5.m1", this.path(4, 1, 0), this.path(4));
        this.testTableRefPath("select 1 from d.t7, t7.c5.m2", this.path(4, 1, 1), this.path(4));
        this.testTableRefPath("select 1 from d.t7, t7.c5.m2.m3", this.path(4, 1, 1, 1, 2), this.path(4));
        this.testTableRefPath("select 1 from d.t7, t7.c5, c5.m2.m3", this.path(4, 1, 1, 1, 2), this.path(4, 1, 1));
        this.addTestTable("create table d.t8 (c1 array<map<string, string>>,c2 map<string, array<struct<a:int>>>,c3 struct<s1:struct<a:array<array<struct<e:int, f:string>>>>>)");
        this.testImplicitPathFailure("d.t8", true, "c1", "key", "value");
        this.testImplicitPathFailure("d.t8", true, "c2", "pos");
        this.testImplicitPathFailure("d.t8.c3.s1", false, "a", "f");
    }

    private void testImplicitPathFailure(String parent, boolean parentIsCollection, String collection, String ... fields) {
        String[] parentElements = parent.split("\\.");
        String implicitAlias = parentElements[parentElements.length - 1];
        String explicitAlias = "x";
        for (String field : fields) {
            this.AnalysisError(String.format("select %s from %s.%s", field, parent, collection), String.format("Could not resolve column/field reference: '%s'", field));
            this.AnalysisError(String.format("select %s.%s from %s.%s %s", explicitAlias, field, parent, collection, explicitAlias), String.format("Could not resolve column/field reference: '%s.%s'", explicitAlias, field));
            if (parentIsCollection) {
                this.AnalysisError(String.format("select %s from %s join %s.%s", field, parent, implicitAlias, collection), String.format("Could not resolve column/field reference: '%s'", field));
                this.AnalysisError(String.format("select %s.%s from %s %s join %s.%s", explicitAlias, field, parent, explicitAlias, explicitAlias, collection), String.format("Could not resolve column/field reference: '%s.%s'", explicitAlias, field));
            }
            this.AnalysisError(String.format("select 1 from %s.%s join %s.%s", parent, collection, collection, field), String.format("Could not resolve table reference: '%s.%s'", collection, field));
            this.AnalysisError(String.format("select 1 from %s.%s %s join %s.%s", parent, collection, explicitAlias, explicitAlias, field), String.format("Could not resolve table reference: '%s.%s'", explicitAlias, field));
        }
    }

    @Test
    public void TestStructFields() throws AnalysisException {
        String[] tables = new String[]{"allcomplextypes"};
        String[] columns = new String[]{"id", "int_struct_col.f1", "nested_struct_col.f2.f12.f21"};
        this.testAllTableAliases(tables, columns);
        this.AnalysisError("select nested_struct_col.badfield from functional.allcomplextypes", "Could not resolve column/field reference: 'nested_struct_col.badfield'");
        this.AnalysisError("select nested_struct_col.f2.badfield from functional.allcomplextypes", "Could not resolve column/field reference: 'nested_struct_col.f2.badfield'");
        this.AnalysisError("select nested_struct_col.badfield.f2 from functional.allcomplextypes", "Could not resolve column/field reference: 'nested_struct_col.badfield.f2'");
        this.AnalysisError("select int_array_col.item from functional.allcomplextypes", "Illegal column/field reference 'int_array_col.item' with intermediate collection 'int_array_col' of type 'ARRAY<INT>'");
        this.AnalysisError("select struct_array_col.f1 from functional.allcomplextypes", "Illegal column/field reference 'struct_array_col.f1' with intermediate collection 'struct_array_col' of type 'ARRAY<STRUCT<f1:BIGINT,f2:STRING>>'");
        this.AnalysisError("select int_map_col.key from functional.allcomplextypes", "Illegal column/field reference 'int_map_col.key' with intermediate collection 'int_map_col' of type 'MAP<STRING,INT>'");
        this.AnalysisError("select struct_map_col.f1 from functional.allcomplextypes", "Illegal column/field reference 'struct_map_col.f1' with intermediate collection 'struct_map_col' of type 'MAP<STRING,STRUCT<f1:BIGINT,f2:STRING>>'");
        this.AnalysisError("select complex_nested_struct_col.f2.f11 from functional.allcomplextypes", "Illegal column/field reference 'complex_nested_struct_col.f2.f11' with intermediate collection 'f2' of type 'ARRAY<STRUCT<f11:BIGINT,f12:MAP<STRING,STRUCT<f21:BIGINT>>>>'");
        this.AnalysisError("select complex_nested_struct_col.f2.f11 from functional.allcomplextypes", "Illegal column/field reference 'complex_nested_struct_col.f2.f11' with intermediate collection 'f2' of type 'ARRAY<STRUCT<f11:BIGINT,f12:MAP<STRING,STRUCT<f21:BIGINT>>>>'");
        AnalysisContext ctx = this.createAnalysisCtx();
        this.AnalysisError("select int_struct_col from functional.allcomplextypes", ctx, "Querying STRUCT is only supported for ORC and Parquet file formats.");
        this.AnalyzesOk("select alltypes from functional_orc_def.complextypes_structs", ctx);
        this.addTestTable("create table nested_structs (s1 struct<s2:struct<i:int>>) stored as orc");
        this.addTestTable("create table nested_structs_with_list (s1 struct<s2:struct<a:array<int>>>) stored as orc");
        this.AnalyzesOk("select s1 from nested_structs", ctx);
        this.AnalyzesOk("select s1.s2 from nested_structs", ctx);
        this.AnalyzesOk("select s1 from nested_structs_with_list", ctx);
        this.AnalyzesOk("select s1.s2 from nested_structs_with_list", ctx);
    }

    @Test
    public void TestSlotRefPathAmbiguity() {
        this.addTestDb("a", null);
        this.addTestTable("create table a.a (a struct<a:struct<a:int>>) stored as orc");
        this.AnalyzesOk("select a.a.a.a.a from a.a");
        this.AnalyzesOk("select t.a.a.a from a.a t");
        AnalysisContext ctx = this.createAnalysisCtx();
        this.AnalyzesOk("select a from a.a", ctx);
        this.AnalyzesOk("select t.a from a.a t", ctx);
        this.AnalyzesOk("select t.a.a from a.a t", ctx);
        this.AnalysisError("select a.a from a.a", "Column/field reference is ambiguous: 'a.a'");
        this.AnalysisError("select a.a.a from a.a", "Column/field reference is ambiguous: 'a.a.a'");
        this.AnalysisError("select a.a.a.a from a.a", "Column/field reference is ambiguous: 'a.a.a.a'");
        this.AnalysisError("select a.a.a.a.a.a from a.a", "Could not resolve column/field reference: 'a.a.a.a.a.a'");
        this.AnalysisError("select t.a.a.a.a from a.a t", "Could not resolve column/field reference: 't.a.a.a.a'");
        this.addTestTable("create table a.array_test (a array<int>)");
        this.addTestTable("create table a.map_test (a map<int, int>)");
        this.AnalyzesOk("select a.item from a.array_test t, t.a");
        this.AnalyzesOk("select a.key, a.value from a.map_test t, t.a");
    }

    @Test
    public void TestStarPathAmbiguity() {
        this.addTestDb("a", null);
        this.addTestTable("create table a.a (a struct<a:struct<a:int>>)");
        this.AnalyzesOk("select a.a.a.a.* from a.a");
        this.AnalyzesOk("select t.a.a.* from a.a t");
        this.AnalysisError("select a.a.a.a.a.* from a.a", "Cannot expand star in 'a.a.a.a.a.*' because path 'a.a.a.a.a' resolved to type 'INT'.");
        this.AnalysisError("select t.a.a.a.* from a.a t", "Cannot expand star in 't.a.a.a.*' because path 't.a.a.a' resolved to type 'INT'.");
        this.AnalysisError("select t.* from a.a t", "The star exprs expanded to an empty select list because the referenced tables only have complex-typed columns.");
        this.AnalysisError("select a.* from a.a", "Star expression is ambiguous: 'a.*'");
        this.AnalysisError("select a.a.* from a.a", "Star expression is ambiguous: 'a.a.*'");
        this.AnalysisError("select a.a.a.* from a.a", "Star expression is ambiguous: 'a.a.a.*'");
        this.AnalysisError("select a.a.a.a.a.a.* from a.a", "Could not resolve star expression: 'a.a.a.a.a.a.*'");
        this.AnalysisError("select t.a.a.a.a.* from a.a t", "Could not resolve star expression: 't.a.a.a.a.*'");
        this.addTestTable("create table a.array_test (a array<int>)");
        this.addTestTable("create table a.map_test (a map<int, int>)");
        this.AnalyzesOk("select a.* from a.array_test t, t.a");
        this.AnalyzesOk("select a.* from a.map_test t, t.a");
    }

    @Test
    public void TestTableRefPathAmbiguity() {
        this.addTestDb("a", null);
        this.addTestTable("create table a.a (a array<struct<a:array<int>>>)");
        this.AnalyzesOk("select 1 from a.a");
        this.AnalyzesOk("select 1 from a.a.a");
        this.AnalyzesOk("select 1 from a.a.a.a");
        this.AnalyzesOk("select 1 from a", this.createAnalysisCtx("a"));
        this.AnalyzesOk("select 1 from a.a.a.a", this.createAnalysisCtx("a"));
        this.AnalysisError("select 1 from a.a", this.createAnalysisCtx("a"), "Table reference is ambiguous: 'a.a'");
        this.AnalysisError("select 1 from a.a.a", this.createAnalysisCtx("a"), "Table reference is ambiguous: 'a.a.a'");
        this.addTestTable("create table a.t1 (x array<struct<y:array<int>>>)");
        this.addTestTable("create table a.t2 (y array<int>)");
        this.AnalysisError("select 1 from a.t1 a, a.t2 `a.x`, a.x.y", "Table reference is ambiguous: 'a.x.y'");
    }

    @Test
    public void TestFromClause() throws AnalysisException {
        this.AnalyzesOk("select int_col from functional.alltypes");
        this.AnalysisError("select int_col from badtbl", "Could not resolve table reference: 'badtbl'");
        this.AnalyzesOk("SELECT INT_COL FROM FUNCTIONAL.ALLTYPES");
        this.AnalyzesOk("SELECT INT_COL FROM functional.alltypes");
        this.AnalyzesOk("SELECT INT_COL FROM functional.aLLTYPES");
        this.AnalyzesOk("SELECT INT_COL FROM Functional.ALLTYPES");
        this.AnalyzesOk("SELECT INT_COL FROM FUNCTIONAL.ALLtypes");
        this.AnalyzesOk("SELECT INT_COL FROM FUNCTIONAL.alltypes");
        this.AnalyzesOk("select functional.AllTypes.Int_Col from functional.alltypes");
    }

    @Test
    public void TestNoFromClause() throws AnalysisException {
        this.AnalyzesOk("select 'test'");
        this.AnalyzesOk("select 1 + 1, -128, 'two', 1.28");
        this.AnalyzesOk("select -1, 1 - 1, 10 - -1, 1 - - - 1");
        this.AnalyzesOk("select -1.0, 1.0 - 1.0, 10.0 - -1.0, 1.0 - - - 1.0");
        this.AnalysisError("select a + 1", "Could not resolve column/field reference: 'a'");
        this.AnalyzesOk("select true");
        this.AnalyzesOk("select false");
        this.AnalyzesOk("select true or false");
        this.AnalyzesOk("select true and false");
        this.AnalyzesOk("select null");
        this.AnalyzesOk("select null and null");
        this.AnalyzesOk("select null or null");
        this.AnalyzesOk("select null is null");
        this.AnalyzesOk("select null is not null");
        this.AnalyzesOk("select int_col is not null from functional.alltypes");
    }

    @Test
    public void TestStar() throws AnalysisException {
        SelectStmt stmt;
        this.AnalyzesOk("select * from functional.AllTypes");
        this.AnalyzesOk("select functional.alltypes.* from functional.AllTypes");
        this.AnalyzesOk("select functional_seq.alltypes.* from functional_seq.alltypes");
        this.AnalyzesOk("select functional.alltypes.*, functional_seq.alltypes.* from functional.alltypes, functional_seq.alltypes");
        this.AnalyzesOk("select * from functional.alltypes, functional_seq.alltypes");
        this.AnalyzesOk("select int_struct_col.* from functional.allcomplextypes");
        this.AnalyzesOk("select a.int_struct_col.* from functional.allcomplextypes a");
        this.AnalyzesOk("select allcomplextypes.int_struct_col.* from functional.allcomplextypes");
        this.AnalyzesOk("select functional.allcomplextypes.int_struct_col.* from functional.allcomplextypes");
        this.AnalysisError("select *", "'*' expression in select list requires FROM clause.");
        this.AnalysisError("select 1, *, 2+4", "'*' expression in select list requires FROM clause.");
        this.AnalysisError("select a.*", "Could not resolve star expression: 'a.*'");
        this.AnalysisError("select functional.* from functional.alltypes", "Could not resolve star expression: 'functional.*'");
        this.AnalysisError("select int_col.* from functional.alltypes", "Cannot expand star in 'int_col.*' because path 'int_col' resolved to type 'INT'.\nStar expansion is only valid for paths to a struct type.");
        this.AnalysisError("select complex_struct_col.f2.* from functional.allcomplextypes", "Cannot expand star in 'complex_struct_col.f2.*' because path 'complex_struct_col.f2' resolved to type 'ARRAY<INT>'.\nStar expansion is only valid for paths to a struct type.");
        for (String joinType : new String[]{"left semi join", "left anti join"}) {
            stmt = (SelectStmt)this.AnalyzesOk(String.format("select * from functional.alltypes a %s functional.testtbl b on (a.id = b.id)", joinType));
            Assert.assertEquals((long)13L, (long)stmt.getResultExprs().size());
            this.AnalysisError(String.format("select a.*, b.* from functional.alltypes a %s functional.alltypes b on (a.id = b.id)", joinType), "Illegal star expression 'b.*' of semi-/anti-joined table 'b'");
        }
        for (String joinType : new String[]{"right semi join", "right anti join"}) {
            stmt = (SelectStmt)this.AnalyzesOk(String.format("select * from functional.alltypes a %s functional.testtbl b on (a.id = b.id)", joinType));
            Assert.assertEquals((long)3L, (long)stmt.getResultExprs().size());
            this.AnalysisError(String.format("select a.*, b.* from functional.alltypes a %s functional.alltypes b on (a.id = b.id)", joinType), "Illegal star expression 'a.*' of semi-/anti-joined table 'a'");
        }
    }

    @Test
    public void TestComplexTypesInSelectList() {
        this.AnalyzesOk("select * from functional.allcomplextypes cross join functional_parquet.alltypes");
        this.AnalyzesOk("select complex_struct_col.* from functional.allcomplextypes");
        this.addTestTable("create table only_complex_types (a array<int>, b struct<x:int, y:int>, c map<string, int>)");
        this.AnalysisError("select * from only_complex_types", "The star exprs expanded to an empty select list because the referenced tables only have complex-typed columns.");
        this.AnalysisError("select a.* from only_complex_types a, functional.allcomplextypes b", "The star exprs expanded to an empty select list because the referenced tables only have complex-typed columns.");
        this.AnalyzesOk("select 1, * from only_complex_types");
        AnalysisContext ctx = this.createAnalysisCtx();
        this.AnalyzesOk("select alltypes from functional_orc_def.complextypes_structs", ctx);
        this.AnalyzesOk("select int_array_col from functional.allcomplextypes");
        this.AnalyzesOk("select int_array_col from functional.allcomplextypes union all select int_array_col from functional.allcomplextypes");
        this.AnalysisError("select int_array_col, item from functional.allcomplextypes", ctx, "Could not resolve column/field reference: 'item'");
        this.AnalysisError("select int_array_col, int_array_col.item from functional.allcomplextypes", ctx, "Illegal column/field reference 'int_array_col.item' with intermediate collection 'int_array_col' of type 'ARRAY<INT>'");
        this.AnalysisError("select tiny_struct from functional_orc_def.complextypes_structs union all select tiny_struct from functional_orc_def.complextypes_structs", ctx, "Set operations don't support STRUCT types or types containing STRUCT types. STRUCT<b:BOOLEAN> in tiny_struct");
        this.AnalysisError("select all_mix from functional_parquet.collection_struct_mix union all select all_mix from functional_parquet.collection_struct_mix", ctx, "Set operations don't support STRUCT types or types containing STRUCT types. MAP<INT,STRUCT<big:STRUCT<arr:ARRAY<STRUCT<inner_arr:ARRAY<ARRAY<INT>>,m:TIMESTAMP>>,n:INT>,small:STRUCT<str:STRING,i:INT>>> in all_mix.");
        this.AnalyzesOk("select 1 from (select int_array_col from functional.allcomplextypes) v");
        this.AnalyzesOk("select int_array_col from (select int_array_col from functional.allcomplextypes) v");
        this.AnalyzesOk("select v.ts from (select tiny_struct as ts from functional_orc_def.complextypes_structs) v;", ctx);
        this.AnalysisError("insert into functional.allcomplextypes select int_array_col from functional.allcomplextypes", "Unable to INSERT into target table (functional.allcomplextypes) because the column 'int_array_col' has a complex type 'ARRAY<INT>' and Impala doesn't support inserting into tables containing complex type columns");
        this.AnalysisError("create table new_tbl as select int_array_col from functional.allcomplextypes", "Unable to INSERT into target table (default.new_tbl) because the column 'int_array_col' has a complex type 'ARRAY<INT>' and Impala doesn't support inserting into tables containing complex type columns");
        this.AnalysisError("create table new_tbl as select tiny_struct from functional_orc_def.complextypes_structs", ctx, "Unable to INSERT into target table (default.new_tbl) because the column 'tiny_struct' has a complex type 'STRUCT<b:BOOLEAN>' and Impala doesn't support inserting into tables containing complex type columns");
        this.AnalyzesOk("select binary_item_col from functional_parquet.binary_in_complex_types");
        this.AnalyzesOk("select binary_member_col from functional_parquet.binary_in_complex_types");
        this.AnalyzesOk("select binary_key_col from functional_parquet.binary_in_complex_types");
        this.AnalyzesOk("select binary_value_col from functional_parquet.binary_in_complex_types");
        ctx.getQueryOptions().setExpand_complex_types(true);
        this.AnalyzesOk("select * from functional_parquet.complextypes_structs", ctx);
        this.AnalyzesOk("select * from functional_parquet.complextypes_nested_structs", ctx);
        this.AnalyzesOk("select * from functional_parquet.complextypes_maps_view", ctx);
        this.AnalyzesOk("select outer_struct.str, outer_struct.* from functional_parquet.complextypes_nested_structs", ctx);
        this.AnalyzesOk("select * from (select * from functional_parquet.complextypes_nested_structs) v", ctx);
        this.AnalyzesOk("select * from (select int_map, int_map_array from functional_parquet.complextypestbl) v", ctx);
        this.AnalyzesOk("select * from functional_parquet.complextypes_arrays", ctx);
        this.AnalyzesOk("select * from functional_parquet.complextypes_arrays_only_view", ctx);
        this.AnalyzesOk("select v.id, v.* from (select * from functional_parquet.complextypes_arrays) v", ctx);
        this.AnalyzesOk("select * from functional_parquet.allcomplextypes", ctx);
        this.AnalyzesOk("select * from functional_orc_def.complextypestbl", ctx);
        this.AnalyzesOk("select * from functional_parquet.binary_in_complex_types", ctx);
    }

    @Test
    public void TestGroupByAliases() throws AnalysisException {
        this.AnalyzesOk("select int_col / 2 as x from functional.alltypes group by x");
        this.AnalysisError("select int_col / 2 as x from functional.alltypes group by x / 2", "Could not resolve column/field reference: 'x'");
        this.AnalysisError("select count(*) a from functional.alltypes group by a", "GROUP BY expression must not contain aggregate functions: a");
        this.AnalysisError("select count(*) > 10 a from functional.alltypes group by a", "GROUP BY expression must not contain aggregate functions: a");
        this.AnalysisError("select sum(id) over(order by id) a from functional.alltypes group by a", "GROUP BY expression must not contain analytic expressions: sum(id) OVER (ORDER BY id ASC)");
        this.AnalyzesOk("with w_test as (select '1' as `one`, 2 as two, '3' as three) select `one` as `one`, substring(cast(two as string), 1, 1) as two, three as three, count(1) as cnt from w_test group by `one`, substring(cast(two as string), 1, 1), three");
    }

    @Test
    public void TestGroupByOrdinals() throws AnalysisException {
        this.AnalysisError("select * from functional.alltypes group by 1", "cannot combine '*' in select list with grouping or aggregation");
        this.AnalyzesOk("select int_col / 2 as x from functional.alltypes group by 1");
        this.AnalysisError("select count(*) from functional.alltypes group by 1", "GROUP BY expression must not contain aggregate functions: 1");
        this.AnalysisError("select count(*) > 10 from functional.alltypes group by 1", "GROUP BY expression must not contain aggregate functions: 1");
        this.AnalysisError("select sum(id) over(order by id) from functional.alltypes group by 1", "GROUP BY expression must not contain analytic expressions: sum(id) OVER (ORDER BY id ASC)");
        this.AnalyzesOk("select int_col, count(*) from functional.alltypes group by 1, 1 * 2");
        this.AnalyzesOk("select int_col, count(*) from functional.alltypes group by 1, if(true, 2, int_col)");
    }

    @Test
    public void TestOrderByAliases() throws AnalysisException {
        this.AnalyzesOk("select int_col / 2 as x from functional.alltypes order by x");
        this.AnalysisError("select int_col / 2 as x from functional.alltypes order by -x", "Could not resolve column/field reference: 'x'");
        this.AnalyzesOk("select count(*) a from functional.alltypes order by a");
        this.AnalyzesOk("select count(*) > 10 a from functional.alltypes order by a");
        this.AnalyzesOk("select sum(id) over(order by id) a from functional.alltypes order by a");
    }

    @Test
    public void TestOrderByOrdinals() throws AnalysisException {
        this.AnalysisError("select * from functional.alltypes order by 14", "ORDER BY: ordinal exceeds the number of items in the SELECT list: 14");
        this.AnalyzesOk("select t.* from functional.alltypes t order by 1");
        this.AnalyzesOk("select t2.* from functional.alltypes t1, functional.alltypes t2 order by 1");
        this.AnalyzesOk("select * from (select max(id) from functional.testtbl) t1 order by 1");
        this.AnalysisError("select * from (select max(id) from functional.testtbl) t1 order by 2", "ORDER BY: ordinal exceeds the number of items in the SELECT list: 2");
        this.AnalyzesOk("select int_col / 2 as x from functional.alltypes order by 1");
        this.AnalyzesOk("select count(*) from functional.alltypes order by 1");
        this.AnalyzesOk("select count(*) > 10 from functional.alltypes order by 1");
        this.AnalyzesOk("select sum(id) over(order by id) from functional.alltypes order by 1");
        this.AnalyzesOk("select int_col, bigint_col from functional.alltypes order by 1 + 4");
        this.AnalyzesOk("select int_col, bigint_col from functional.alltypes order by if(true, 7, int_col)");
    }

    @Test
    public void TestHavingAliases() throws AnalysisException {
        this.AnalysisError("select not bool_col m, min(smallint_col) m, max(bigint_col) m from functional.alltypes group by bool_col having m", "HAVING: ambiguous alias: 'm'");
        this.AnalyzesOk("select not bool_col as nb from functional.alltypes having nb");
        this.AnalysisError("select int_col / 2 as x from functional.alltypes having x > 0", "Could not resolve column/field reference: 'x'");
        this.AnalysisError("select count(*) a from functional.alltypes having a", "HAVING clause 'count(*)' requires return type 'BOOLEAN'. Actual type is 'BIGINT'.");
        this.AnalyzesOk("select count(*) > 10 a from functional.alltypes having a");
        this.AnalysisError("select sum(id) over(order by id) a from functional.alltypes having a", "HAVING clause must not contain analytic expressions: sum(id) OVER (ORDER BY id ASC)");
    }

    @Test
    public void TestHavingIntegers() {
        try {
            BackendConfig.INSTANCE.setAllowOrdinalsInHaving(true);
            this.AnalyzesOk("select not bool_col as nb from functional.alltypes having 1");
            this.AnalysisError("select count(*) from functional.alltypes having 1", "HAVING clause 'count(*)' requires return type 'BOOLEAN'. Actual type is 'BIGINT'.");
            this.AnalyzesOk("select count(*) > 10 from functional.alltypes having 1");
            this.AnalysisError("select sum(id) over(order by id) from functional.alltypes having 1", "HAVING clause must not contain analytic expressions: sum(id) OVER (ORDER BY id ASC)");
            this.AnalysisError("select sum(id) over(order by id) from functional.alltypes having -1", "HAVING: ordinal must be >= 1: -1");
            BackendConfig.INSTANCE.setAllowOrdinalsInHaving(false);
            this.AnalysisError("select not bool_col as nb from functional.alltypes having 1", "HAVING clause '1' requires return type 'BOOLEAN'. Actual type is 'TINYINT'.");
            this.AnalysisError("select not bool_col as nb from functional.alltypes having -1", "HAVING clause '-1' requires return type 'BOOLEAN'. Actual type is 'TINYINT'.");
            this.AnalysisError("select int_col, bool_col, count(*) from functional.alltypes group by 1, 2 having 1 + 1", "HAVING clause '1 + 1' requires return type 'BOOLEAN'. Actual type is 'SMALLINT'.");
            this.AnalysisError("select int_col, bool_col, count(*) from functional.alltypes group by 1, 2 having if(TRUE, 2, int_col)", "HAVING clause 'if(TRUE, 2, int_col)' requires return type 'BOOLEAN'. Actual type is 'INT'.");
        }
        finally {
            BackendConfig.INSTANCE.setAllowOrdinalsInHaving(false);
        }
    }

    @Test
    public void TestInlineView() throws AnalysisException {
        this.AnalyzesOk("select y x from (select id y from functional_hbase.alltypessmall) a");
        this.AnalyzesOk("select id from (select id from functional_hbase.alltypessmall) a");
        this.AnalyzesOk("select * from (select id+2 from functional_hbase.alltypessmall) a");
        this.AnalyzesOk("select t1 c from (select c t1 from (select id c from functional_hbase.alltypessmall) t1) a");
        this.AnalysisError("select id from (select id+2 from functional_hbase.alltypessmall) a", "Could not resolve column/field reference: 'id'");
        this.AnalyzesOk("select a.* from (select id+2 from functional_hbase.alltypessmall) a");
        this.AnalyzesOk("select * from (select id+2 id from functional_hbase.alltypessmall) a join (select * from functional.AllTypes where true) b");
        this.AnalyzesOk("select a.x from (select count(id) x from functional.AllTypes) a");
        this.AnalyzesOk("select a.* from (select count(id) from functional.AllTypes) a");
        this.AnalysisError("select a.id from (select id y from functional_hbase.alltypessmall) a", "Could not resolve column/field reference: 'a.id'");
        this.AnalyzesOk("select * from (select * from functional.AllTypes) a where year = 2009");
        this.AnalyzesOk("select * from (select * from functional.alltypesagg) a right outer join             (select * from functional.alltypessmall) b using (id, int_col)        where a.day >= 6 and b.month > 2 and a.tinyint_col = 15 and              b.string_col = '15' and a.tinyint_col + b.tinyint_col < 15");
        this.AnalyzesOk("select * from (select a.smallint_col+b.smallint_col  c1         from functional.alltypesagg a join functional.alltypessmall b          using (id, int_col)) x          where x.c1 > 100");
        this.AnalyzesOk("select a.* from (select * from (select id+2 from functional_hbase.alltypessmall) b) a");
        this.AnalysisError("select * from (select * from functional.alltypes a join functional.alltypes b on (a.int_col = b.int_col)) x", "duplicated inline view column alias: 'id' in inline view 'x'");
        this.AnalyzesOk("select x.float_col        from functional.alltypessmall c join           (select a.smallint_col smallint_col, a.tinyint_col tinyint_col,                    a.int_col int_col, b.float_col float_col          from (select * from functional.alltypesagg a where month=1) a join                   functional.alltypessmall b on (a.smallint_col = b.id)) x             on (x.tinyint_col = c.id)");
        this.AnalyzesOk("select count(*) from (select count(id) from functional.AllTypes group by id) a");
        this.AnalyzesOk("select count(a.x) from (select id+2 x from functional_hbase.alltypessmall) a");
        this.AnalyzesOk("select * from (select id, zip        from (select * from functional.testtbl) x        group by zip, id having count(*) > 0) x");
        this.AnalysisError("select zip + count(*) from functional.testtbl", "select list expression not produced by aggregation output (missing from GROUP BY clause?)");
        this.AnalyzesOk("select a.* from (select rank() over(order by string_col) from functional.alltypes  union all  select tinyint_col from functional.alltypessmall) a");
        this.AnalyzesOk("select a.* from (select int_col from functional.alltypes  union all  select tinyint_col from functional.alltypessmall) a union all select smallint_col from functional.alltypes");
        this.AnalyzesOk("select a.* from (select int_col from functional.alltypes  union all  select b.smallint_col from   (select smallint_col from functional.alltypessmall   union all   select tinyint_col from functional.alltypes) b) a");
        this.AnalysisError("select tinyint_col from (select int_col from functional.alltypes  union all  select tinyint_col from functional.alltypessmall) a", "Could not resolve column/field reference: 'tinyint_col'");
        this.AnalysisError("select * from (select id, zip from functional.testtbl group by id having count(*) > 0) x", "select list expression not produced by aggregation output (missing from GROUP BY clause?)");
        this.AnalysisError("select * from (select id from functional.testtbl group by id having zip + count(*) > 0) x", "HAVING clause not produced by aggregation output (missing from GROUP BY clause?)");
        this.AnalysisError("select * from (select zip, count(*) from functional.testtbl group by 3) x", "GROUP BY: ordinal exceeds the number of items in the SELECT list");
        this.AnalysisError("select * from (select * from functional.alltypes group by 1) x", "cannot combine '*' in select list with grouping or aggregation");
        this.AnalysisError("select * from (select zip, count(*) from functional.testtbl group by count(*)) x", "GROUP BY expression must not contain aggregate functions");
        this.AnalysisError("select * from (select zip, count(*) from functional.testtbl group by count(*) + min(zip)) x", "GROUP BY expression must not contain aggregate functions");
        this.AnalysisError("select * from (select zip, count(*) from functional.testtbl group by 2) x", "GROUP BY expression must not contain aggregate functions");
        this.AnalyzesOk("select * from (select zip, count(*)        from (select * from functional.testtbl) x        group by 1 order by count(*) + min(zip) limit 5) x");
        this.AnalyzesOk("select * from (select zip, count(*)        from (select * from functional.testtbl) x        group by 1 order by count(*) + min(zip)) x");
        this.AnalysisError("select * from (select zip, count(*)        from (select * from functional.testtbl) x        group by 1 offset 5) x", "OFFSET requires an ORDER BY clause: OFFSET 5");
        this.AnalysisError("select * from (select zip, count(*)        from (select * from functional.testtbl) x        group by 1 order by count(*) + min(zip) offset 5) x", "Order-by with offset without limit not supported in nested queries");
        this.AnalyzesOk("select c1, c2 from (select zip c1 , count(*) c2                      from (select * from functional.testtbl) x group by 1) x         order by 2, 1 limit 5");
        this.AnalyzesOk("select c1, c2 from (select zip c1 , count(*) c2                      from (select * from functional.testtbl) x group by 1) x         order by 2, 1");
        this.AnalyzesOk("select c1, c2 from (select zip c1 , count(*) c2                      from (select * from functional.testtbl) x group by 1) x         order by 2, 1 offset 5");
        this.AnalyzesOk("select * from (select NULL) a");
        this.AnalyzesOk("select `int_col * 1`, a, int_col, `NOT bool_col` from (select int_col * 1, int_col as a, int_col, !bool_col, concat(string_col) from functional.alltypes) t");
        this.AnalyzesOk("select _c0, a, int_col, _c3 from (select int_col * 1, int_col as a, int_col, !bool_col, concat(string_col) from functional.alltypes) t", this.createAnalysisCtxUsingHiveColLabels());
        this.AnalyzesOk("select _c0, count(a), count(int_col), _c3 from (select int_col * 1, int_col as a, int_col, !bool_col, concat(string_col) from functional.alltypes) t group by _c0, _c3 order by _c0 limit 10", this.createAnalysisCtxUsingHiveColLabels());
        this.AnalyzesOk("select x.front, x._c1, x._c2 from (select y.back as front, y._c0 * 10, y._c2 + 2 from (select int_col * 10, int_col as back, int_col + 2 from functional.alltypestiny) y) x", this.createAnalysisCtxUsingHiveColLabels());
        SelectStmt colLabelsStmt = (SelectStmt)this.AnalyzesOk("select avg(int_col) from functional.alltypes_view");
        Assert.assertEquals((Object)"avg(int_col)", colLabelsStmt.getColLabels().get(0));
        this.AnalyzesOk("select `max(int_col)` from (select max(int_col) from functional.alltypes_view) v");
        this.AnalysisError("select _c0 from (select int_col * 2, id from functional.alltypes) a inner join (select int_col + 6, id from functional.alltypes) b on (a.id = b.id)", this.createAnalysisCtxUsingHiveColLabels(), "Column/field reference is ambiguous: '_c0'");
        this.AnalysisError("select _c0, a, _c2, _c3 from (select int_col * 1, int_col as a, int_col, !bool_col, concat(string_col) from functional.alltypes) t", this.createAnalysisCtxUsingHiveColLabels(), "Could not resolve column/field reference: '_c2'");
        this.AnalyzesOk("SELECT 1 FROM functional.decimal_tbl AS t1 LEFT JOIN (SELECT SUM(t1.d2) - SUM(t1.d3) as double_col_3, SUM(t1.d2) IS NULL FROM functional.decimal_tbl AS t1) AS t3 ON t3.double_col_3 = t1.d3");
        this.AnalyzesOk("select 1 from functional.alltypes a left outer join (select id, upper(decode(string_col, NULL, date_string_col)) from functional.alltypes) v on (a.id = v.id)");
        this.AnalyzesOk("select y x from (select id y from functional.alltypestiny where id in (select id from functional.alltypessmall)) a");
    }

    @Test
    public void TestCorrelatedInlineViews() {
        this.AnalyzesOk("select cnt from functional.allcomplextypes t, (select count(*) cnt from t.int_array_col) v");
        this.AnalyzesOk("select cnt from functional.allcomplextypes t, (select cnt from (select count(*) cnt from t.int_array_col) v1) v2");
        this.AnalyzesOk("select item from functional.allcomplextypes t, (select item from t.array_map_col.value) v");
        this.AnalyzesOk("select item from functional.allcomplextypes t, (select * from (select * from (select item from t.int_array_col) v1) v2) v3");
        this.AnalyzesOk("select v.cnt from functional.allcomplextypes t1 join (select * from functional.alltypes) t2 on (t1.id = t2.id) cross join (select count(*) cnt from t1.int_map_col) v");
        this.AnalyzesOk("select avg from functional.allcomplextypes t, (select avg(a1.item) avg from t.int_array_col a1, t.int_array_col a2) v");
        this.AnalyzesOk("select item, key, value from functional.allcomplextypes t, (select * from t.int_array_col, t.int_map_col) v");
        this.AnalyzesOk("select cnt from functional.alltypes t1 inner join (select id, cnt from functional.allcomplextypes t2, (select count(1) cnt from t2.int_array_col) v1) v2");
        this.AnalyzesOk("select key, item from functional.allcomplextypes t, (select a1.key, a2.item from t.array_map_col a1, a1.value a2) v");
        this.AnalyzesOk("select key, av from functional.allcomplextypes t, (select a1.key, av from t.array_map_col a1, (select avg(item) av from a1.value a2) v1) v2");
        this.AnalyzesOk("select t1.id, t2.id, cnt, av from functional.allcomplextypes t1 left outer join functional.allcomplextypes t2 on (t1.id = t2.id), (select count(*) cnt from t1.array_map_col) v1, (select avg(item) av from t2.int_array_col) v2");
        this.AnalyzesOk("select item from functional.allcomplextypes t, (select * from t.int_array_col union all select * from t.int_array_col) v");
        this.AnalyzesOk("select item from functional.allcomplextypes t, (select item from t.int_array_col union distinct select value from t.int_map_col) v");
        this.AnalyzesOk("with w as (select item from functional.allcomplextypes t, (select item from t.int_array_col) v) select * from w");
        this.AnalyzesOk("with w as (select key, av from functional.allcomplextypes t, (select a1.key, av from t.array_map_col a1, (select avg(item) av from a1.value a2) v1) v2) select * from w");
        this.AnalyzesOk("select cnt from functional.allcomplextypes t, (select count(1) cnt from functional.allcomplextypes) v");
        this.AnalyzesOk("select cnt from functional.allcomplextypes, (select count(1) cnt from functional.allcomplextypes) v");
        this.AnalyzesOk("select cnt from functional.allcomplextypes, (select count(1) cnt from allcomplextypes) v", this.createAnalysisCtx("functional"));
        this.AnalysisError("select cnt from functional.allcomplextypes t, (select count(1) cnt from t) v", "Illegal table reference to non-collection type: 't'");
        this.AnalysisError("select cnt from functional.allcomplextypes, (select count(1) cnt from allcomplextypes) v", "Illegal table reference to non-collection type: 'allcomplextypes'");
        this.AnalysisError("select cnt from functional.allcomplextypes t, (select count(1) cnt from functional.alltypes, t.int_array_col) v", "Nested query is illegal because it contains a table reference 't.int_array_col' correlated with an outer block as well as an uncorrelated one 'functional.alltypes':\nSELECT count(1) cnt FROM functional.alltypes, t.int_array_col");
        this.AnalysisError("select cnt from functional.allcomplextypes t, (select count(1) cnt from t.int_array_col, functional.alltypes) v", "Nested query is illegal because it contains a table reference 't.int_array_col' correlated with an outer block as well as an uncorrelated one 'functional.alltypes':\nSELECT count(1) cnt FROM t.int_array_col, functional.alltypes");
        this.AnalysisError("select cnt from functional.allcomplextypes t, (select * from functional.alltypes, (select count(1) cnt from t.int_array_col) v1) v2", "Nested query is illegal because it contains a table reference 't.int_array_col' correlated with an outer block as well as an uncorrelated one 'functional.alltypes':\nSELECT * FROM functional.alltypes, (SELECT count(1) cnt FROM t.int_array_col) v1");
        this.AnalysisError("select cnt from functional.allcomplextypes t, (select bigint_col from functional.alltypes union select count(1) cnt from t.int_array_col) v1", "Nested query is illegal because it contains a table reference 't.int_array_col' correlated with an outer block as well as an uncorrelated one 'functional.alltypes':\nSELECT bigint_col FROM functional.alltypes UNION SELECT count(1) cnt FROM t.int_array_col");
        this.AnalysisError("with w as (select cnt from functional.allcomplextypes t, (select count(1) cnt from t.int_array_col, functional.alltypes) v) select * from w", "Nested query is illegal because it contains a table reference 't.int_array_col' correlated with an outer block as well as an uncorrelated one 'functional.alltypes':\nSELECT count(1) cnt FROM t.int_array_col, functional.alltypes");
        for (JoinOperator joinOp : JoinOperator.values()) {
            if (joinOp.isNullAwareLeftAntiJoin() || joinOp.isIcebergDeleteJoin()) continue;
            this.AnalyzesOk(String.format("select 1 from functional.allcomplextypes a %s (select item from a.int_array_col) v", joinOp));
            this.AnalyzesOk(String.format("select 1 from functional.allcomplextypes a %s (select * from a.struct_array_col) v", joinOp));
            this.AnalyzesOk(String.format("select 1 from functional.allcomplextypes a %s (select key, value from a.int_map_col) v", joinOp));
            this.AnalyzesOk(String.format("select 1 from functional.allcomplextypes a %s (select * from a.struct_map_col) v", joinOp));
        }
    }

    @Test
    public void TestOnClause() throws AnalysisException {
        this.AnalyzesOk("select a.int_col from functional.alltypes a join functional.alltypes b on (a.int_col = b.int_col)");
        this.AnalyzesOk("select a.int_col from functional.alltypes a join functional.alltypes b on (a.int_col = b.int_col and a.string_col = b.string_col)");
        this.AnalyzesOk("select a.int_col from functional.alltypes a join functional.alltypes b on (a.bool_col)");
        this.AnalyzesOk("select a.int_col from functional.alltypes a join functional.alltypes b on (NULL)");
        this.AnalyzesOk("select a.int_col from functional.alltypes a join functional.alltypes b");
        this.AnalysisError("select a.int_col from functional.alltypes a join functional.alltypes b on trim(a.string_col)", "ON clause 'trim(a.string_col)' requires return type 'BOOLEAN'. Actual type is 'STRING'.");
        this.AnalysisError("select a.int_col from functional.alltypes a join functional.alltypes b on a.int_col * b.float_col", "ON clause 'a.int_col * b.float_col' requires return type 'BOOLEAN'. Actual type is 'DOUBLE'.");
        this.AnalysisError("select a.int_col from functional.alltypes a join functional.alltypes b on (a.bigint_col = sum(b.int_col))", "aggregate function not allowed in ON clause");
        this.AnalysisError("select a.int_col from functional.alltypes a join functional.alltypes b on (a.bigint_col = lag(b.int_col) over(order by a.bigint_col))", "analytic expression not allowed in ON clause");
        this.AnalysisError("select a.int_col from functional.alltypes a join functional.alltypes b on (a.id = b.id) and a.int_col < (select min(id) from functional.alltypes c)", "Subquery is not allowed in ON clause");
        this.AnalysisError("select a.int_col from functional.alltypes a join functional.alltypes b on (a.int_col = b.badcol)", "Could not resolve column/field reference: 'b.badcol'");
        this.AnalysisError("select a.int_col from functional.alltypes a join functional.alltypes b on (int_col = int_col)", "Column/field reference is ambiguous: 'int_col'");
        this.AnalysisError("select a.int_col from functional.alltypes a join functional.alltypes b on (a.int_col = badalias.int_col)", "Could not resolve column/field reference: 'badalias.int_col'");
        this.AnalysisError("select a.int_col from functional.alltypes a join functional.alltypes b on a.bool_col = b.string_col", "operands of type BOOLEAN and STRING are not comparable: a.bool_col = b.string_col");
        this.AnalyzesOk("select a.int_col, b.int_col, c.int_col from functional.alltypes a join functional.alltypes b on (a.int_col = b.int_col and a.string_col = b.string_col)join functional.alltypes c on (b.int_col = c.int_col and b.string_col = c.string_col and b.bool_col = c.bool_col)");
        this.AnalysisError("select a.int_col, b.int_col, c.int_col from functional.alltypes a join functional.alltypes b on (c.int_col = b.int_col and a.string_col = b.string_col)join functional.alltypes c on (b.int_col = c.int_col and b.string_col = c.string_col and b.bool_col = c.bool_col)", "Could not resolve column/field reference: 'c.int_col'");
        this.AnalyzesOk("select * from functional.alltypes a left outer join functional.alltypes b on (a.id = b.id)");
        this.AnalyzesOk("select * from functional.alltypes a left outer join functional.alltypes b using (id)");
        this.AnalysisError("select * from functional.alltypes a left outer join functional.alltypes b", "LEFT OUTER JOIN requires an ON or USING clause");
        this.AnalyzesOk("select * from functional.alltypes a right outer join functional.alltypes b on (a.id = b.id)");
        this.AnalyzesOk("select * from functional.alltypes a right outer join functional.alltypes b using (id)");
        this.AnalysisError("select * from functional.alltypes a right outer join functional.alltypes b", "RIGHT OUTER JOIN requires an ON or USING clause");
        this.AnalyzesOk("select * from functional.alltypes a full outer join functional.alltypes b on (a.id = b.id)");
        this.AnalyzesOk("select * from functional.alltypes a full outer join functional.alltypes b using (id)");
        this.AnalysisError("select * from functional.alltypes a full outer join functional.alltypes b", "FULL OUTER JOIN requires an ON or USING clause");
        this.AnalyzesOk("select * from functional.binary_tbl a join functional.binary_tbl b on a.binary_col = b.binary_col");
        this.AnalyzesOk("select * from functional.binary_tbl a join functional.binary_tbl b using (binary_col)");
    }

    @Test
    public void TestUsingClause() throws AnalysisException {
        this.AnalyzesOk("select a.int_col, b.int_col from functional.alltypes a join functional.alltypes b using (int_col)");
        this.AnalyzesOk("select a.int_col, b.int_col from functional.alltypes a join functional.alltypes b using (int_col, string_col)");
        this.AnalyzesOk("select a.int_col, b.int_col, c.int_col from functional.alltypes a join functional.alltypes b using (int_col, string_col) join functional.alltypes c using (int_col, string_col, bool_col)");
        this.AnalysisError("select a.int_col from functional.alltypes a join functional.alltypes b using (badcol)", "unknown column badcol for alias a");
        this.AnalysisError("select a.int_col from functional.alltypes a join functional.alltypes b using (int_col, badcol)", "unknown column badcol for alias a ");
    }

    @Test
    public void TestSemiJoins() {
        for (String joinType : new String[]{"left semi join", "left anti join"}) {
            this.AnalyzesOk(String.format("select a.id from functional.alltypes a %s functional.alltypes b on (a.id = b.id)", joinType));
            this.AnalyzesOk(String.format("select a.id from functional.alltypes a %s functional.alltypes b on (a.id = b.id) %s functional.alltypes c on (a.id = c.id)", joinType, joinType));
            this.AnalyzesOk(String.format("select a.id from functional.alltypes a %s functional.alltypes b using (id)", joinType));
            this.AnalyzesOk(String.format("select int_col from functional.alltypes a %s functional.alltypes b on (a.id = b.id)", joinType));
            this.AnalysisError(String.format("select * from functional.alltypes a %s functional.alltypes b on (a.id = b.id and a.int_col = int_col)", joinType), "Column/field reference is ambiguous: 'int_col'");
            this.AnalyzesOk(String.format("select int_col from functional.alltypes b %s functional.alltypes a on (b.id = a.id)", joinType));
            this.AnalysisError(String.format("select * from functional.alltypes b %s functional.alltypes a on (b.id = a.id and b.int_col = int_col)", joinType), "Column/field reference is ambiguous: 'int_col'");
            this.AnalyzesOk(String.format("select int_col from functional.alltypes c %s functional.alltypes b on (c.id = b.id) %s functional.jointbl a on (test_id = c.id)", joinType, joinType));
            this.AnalyzesOk(String.format("select int_col from functional.alltypes c %s functional.alltypes b on (c.id = b.id) %s functional.jointbl a on (test_id = id)", joinType, joinType));
            this.AnalysisError(String.format("select int_col from functional.alltypes c %s functional.alltypes b on (c.id = b.id) %s functional.jointbl a on (test_id = b.id)", joinType, joinType), "Illegal column/field reference 'b.id' of semi-/anti-joined table 'b'");
            this.AnalysisError(String.format("select a.id, b.id from functional.alltypes a %s functional.alltypes b on (a.id = b.id)", joinType), "Illegal column/field reference 'b.id' of semi-/anti-joined table 'b'");
            this.AnalysisError(String.format("select a.id from functional.alltypes a %s (select * from functional.alltypes) b on (a.id = b.id) where b.int_col > 10", joinType), "Illegal column/field reference 'b.int_col' of semi-/anti-joined table 'b'");
            this.AnalysisError(String.format("select a.id from functional.alltypes a %s functional.alltypes b on (a.id = b.id) group by b.bool_col", joinType), "Illegal column/field reference 'b.bool_col' of semi-/anti-joined table 'b'");
            this.AnalysisError(String.format("select a.id from functional.alltypes a %s (select * from functional.alltypes) b on (a.id = b.id) order by b.string_col", joinType), "Illegal column/field reference 'b.string_col' of semi-/anti-joined table 'b'");
            this.AnalysisError(String.format("select a.id from functional.alltypes a %s functional.alltypes b on (a.id = b.id)left outer join functional.testtbl c on (b.id = c.id)", joinType), "Illegal column/field reference 'b.id' of semi-/anti-joined table 'b'");
            this.AnalysisError(String.format("select a.id from functional.alltypes a %s functional.alltypes b on (a.id = b.id)%s functional.testtbl c on (b.id = c.id)", joinType, joinType), "Illegal column/field reference 'b.id' of semi-/anti-joined table 'b'");
            this.AnalysisError(String.format("select a.id from functional.alltypes a %s functional.alltypes b using(id) %s functional.alltypes c using(int_col)", joinType, joinType), "Illegal column/field reference 'b.int_col' of semi-/anti-joined table 'b'");
            this.AnalysisError(String.format("select * from functional.alltypes a %s functional.alltypes b on (a.id = b.id and a.int_col = int_col)", joinType), "Column/field reference is ambiguous: 'int_col'");
            this.AnalysisError(String.format("select test_id from functional.alltypes a %s functional.jointbl b on (a.id = b.alltypes_id)", joinType), "Illegal column/field reference 'test_id' of semi-/anti-joined table 'b'");
            this.AnalysisError(String.format("select alltypes.int_col from functional.alltypes %s functional_parquet.alltypes on (functional.alltypes.id = functional_parquet.alltypes.id)", joinType), "Unqualified table alias is ambiguous: 'alltypes'");
            this.AnalysisError(String.format("select 1 from functional.allcomplextypes a %s functional.allcomplextypes b on (a.id = b.id) inner join b.int_array_col", joinType), "Illegal table reference 'b.int_array_col' of semi-/anti-joined table 'b'");
        }
        for (String joinType : new String[]{"right semi join", "right anti join"}) {
            this.AnalyzesOk(String.format("select b.id from functional.alltypes a %s functional.alltypes b on (a.id = b.id)", joinType));
            this.AnalyzesOk(String.format("select c.id from functional.alltypes a %s functional.alltypes b on (a.id = b.id) %s functional.alltypes c on (b.id = c.id)", joinType, joinType));
            this.AnalyzesOk(String.format("select b.id from functional.alltypes a %s functional.alltypes b using (id)", joinType));
            this.AnalyzesOk(String.format("select int_col from functional.alltypes a %s functional.alltypes b on (a.id = b.id)", joinType));
            this.AnalysisError(String.format("select * from functional.alltypes a %s functional.alltypes b on (a.id = b.id and a.int_col = int_col)", joinType), "Column/field reference is ambiguous: 'int_col'");
            this.AnalyzesOk(String.format("select int_col from functional.alltypes b %s functional.alltypes a on (b.id = a.id)", joinType));
            this.AnalysisError(String.format("select * from functional.alltypes b %s functional.alltypes a on (b.id = a.id and b.int_col = int_col)", joinType), "Column/field reference is ambiguous: 'int_col'");
            this.AnalyzesOk(String.format("select int_col from functional.jointbl c %s functional.alltypes b on (test_id = b.id) %s functional.alltypes a on (b.id = a.id)", joinType, joinType));
            this.AnalyzesOk(String.format("select int_col from functional.jointbl c %s functional.alltypes b on (test_id = id) %s functional.alltypes a on (b.id = a.id)", joinType, joinType));
            this.AnalysisError(String.format("select int_col from functional.jointbl c %s functional.alltypes b on (test_id = a.id) %s functional.alltypes a on (c.id = b.id)", joinType, joinType), "Could not resolve column/field reference: 'a.id'");
            this.AnalysisError(String.format("select a.id, b.id from functional.alltypes a %s functional.alltypes b on (a.id = b.id)", joinType), "Illegal column/field reference 'a.id' of semi-/anti-joined table 'a'");
            this.AnalysisError(String.format("select b.id from functional.alltypes a %s (select * from functional.alltypes) b on (a.id = b.id) where a.int_col > 10", joinType), "Illegal column/field reference 'a.int_col' of semi-/anti-joined table 'a'");
            this.AnalysisError(String.format("select b.id from functional.alltypes a %s functional.alltypes b on (a.id = b.id) group by a.bool_col", joinType), "Illegal column/field reference 'a.bool_col' of semi-/anti-joined table 'a'");
            this.AnalysisError(String.format("select b.id from functional.alltypes a %s (select * from functional.alltypes) b on (a.id = b.id) order by a.string_col", joinType), "Illegal column/field reference 'a.string_col' of semi-/anti-joined table 'a'");
            this.AnalysisError(String.format("select b.id from functional.alltypes a %s functional.alltypes b on (a.id = b.id)left outer join functional.testtbl c on (a.id = c.id)", joinType), "Illegal column/field reference 'a.id' of semi-/anti-joined table 'a'");
            this.AnalysisError(String.format("select b.id from functional.alltypes a %s functional.alltypes b on (a.id = b.id)%s functional.testtbl c on (a.id = c.id)", joinType, joinType), "Illegal column/field reference 'a.id' of semi-/anti-joined table 'a'");
            this.AnalysisError(String.format("select b.id from functional.alltypes a %s functional.alltypes b using(id) %s functional.alltypes c using(int_col)", joinType, joinType), "Illegal column/field reference 'b.id' of semi-/anti-joined table 'b'");
            this.AnalysisError(String.format("select * from functional.alltypes a %s functional.alltypes b on (a.id = b.id and a.int_col = int_col)", joinType), "Column/field reference is ambiguous: 'int_col'");
            this.AnalysisError(String.format("select test_id from functional.jointbl a %s functional.alltypes b on (a.alltypes_id = b.id)", joinType), "Illegal column/field reference 'test_id' of semi-/anti-joined table 'a'");
            this.AnalysisError(String.format("select alltypes.int_col from functional.alltypes %s functional_parquet.alltypes on (functional.alltypes.id = functional_parquet.alltypes.id)", joinType), "Unqualified table alias is ambiguous: 'alltypes'");
            this.AnalysisError(String.format("select 1 from functional.allcomplextypes a %s functional.allcomplextypes b on (a.id = b.id) inner join a.int_array_col", joinType), "Illegal table reference 'a.int_array_col' of semi-/anti-joined table 'a'");
        }
    }

    private String[][] getHintStyles() {
        return new String[][]{{"/* +", "*/"}, {"\n-- +", "\n"}, {"[", "]"}};
    }

    @Test
    public void TestJoinHints() throws AnalysisException {
        for (String[] hintStyle : this.getHintStyles()) {
            String prefix = hintStyle[0];
            String suffix = hintStyle[1];
            this.AnalyzesOk(String.format("select * from functional.alltypes a join %sbroadcast%s functional.alltypes b using (int_col)", prefix, suffix));
            this.AnalyzesOk(String.format("select * from functional.alltypes a join %sshuffle%s functional.alltypes b using (int_col)", prefix, suffix));
            this.AnalyzesOk(String.format("select * from functional.alltypes a cross join %sbroadcast%s functional.alltypes b", prefix, suffix));
            this.AnalyzesOk(String.format("select * from functional.alltypes a join %sbadhint%s functional.alltypes b using (int_col)", prefix, suffix), "JOIN hint not recognized: badhint");
            this.AnalysisError(String.format("select * from functional.alltypes a cross join %sshuffle%s functional.alltypes b", prefix, suffix), "CROSS JOIN does not support SHUFFLE.");
            this.AnalysisError(String.format("select * from functional.alltypes a right outer join %sbroadcast%s functional.alltypes b using (int_col)", prefix, suffix), "RIGHT OUTER JOIN does not support BROADCAST.");
            this.AnalysisError(String.format("select * from functional.alltypes a full outer join %sbroadcast%s functional.alltypes b using (int_col)", prefix, suffix), "FULL OUTER JOIN does not support BROADCAST.");
            this.AnalysisError(String.format("select * from functional.alltypes a right semi join %sbroadcast%s functional.alltypes b using (int_col)", prefix, suffix), "RIGHT SEMI JOIN does not support BROADCAST.");
            this.AnalysisError(String.format("select * from functional.alltypes a right anti join %sbroadcast%s functional.alltypes b using (int_col)", prefix, suffix), "RIGHT ANTI JOIN does not support BROADCAST.");
            this.AnalysisError(String.format("select * from functional.alltypes a join %sbroadcast,shuffle%s functional.alltypes b using (int_col)", prefix, suffix), "Conflicting JOIN hint: shuffle");
        }
    }

    @Test
    public void TestTableHints() throws AnalysisException {
        for (String[] hintStyle : this.getHintStyles()) {
            String prefix = hintStyle[0];
            String suffix = hintStyle[1];
            for (String alias : new String[]{"", "a"}) {
                this.AnalyzesOk(String.format("select * from functional.alltypes %s %sschedule_cache_local%s", alias, prefix, suffix));
                this.AnalyzesOk(String.format("select * from functional.alltypes %s %sschedule_disk_local%s", alias, prefix, suffix));
                this.AnalyzesOk(String.format("select * from functional.alltypes %s %sschedule_remote%s", alias, prefix, suffix));
                this.AnalyzesOk(String.format("select * from functional.alltypes %s %sschedule_remote,schedule_random_replica%s", alias, prefix, suffix));
                this.AnalyzesOk(String.format("select * from functional.alltypes %s %sschedule_random_replica,schedule_remote%s", alias, prefix, suffix));
                String name = alias.isEmpty() ? "functional.alltypes" : alias;
                this.AnalyzesOk(String.format("select * from functional.alltypes %s %sFOO%s", alias, prefix, suffix), String.format("Table hint not recognized for table %s: FOO", name));
                this.AnalyzesOk(String.format("select * from functional_hbase.alltypes %s %sschedule_random_replica%s", alias, prefix, suffix), "Table hints only supported for Hdfs/Kudu tables");
                this.AnalyzesOk(String.format("select * from functional.alltypes_view %s %sschedule_random_replica%s", alias, prefix, suffix), "Table hints not supported for inline view and collections");
                this.AnalyzesOk(String.format("with t as (select 1) select * from t %s %sschedule_random_replica%s", alias, prefix, suffix), "Table hints not supported for inline view and collections");
            }
            this.AnalyzesOk(String.format("select * from (select tinyint_col * 2 as c1 from functional.alltypes) as v1 %sschedule_random_replica%s", prefix, suffix), "Table hints not supported for inline view and collections");
            this.AnalyzesOk(String.format("select item from functional.allcomplextypes, allcomplextypes.int_array_col %sschedule_random_replica%s", prefix, suffix), "Table hints not supported for inline view and collections");
        }
    }

    private boolean hasStraightJoin(String stmt, String expectedWarning) {
        AnalysisContext ctx = this.createAnalysisCtx();
        if (expectedWarning == null) {
            this.AnalyzesOkWithoutWarnings(stmt, ctx);
        } else {
            this.AnalyzesOk(stmt, ctx, expectedWarning);
        }
        return ctx.getAnalyzer().isStraightJoin();
    }

    @Test
    public void TestSelectListHints() throws AnalysisException {
        for (String[] hintStyle : this.hintStyles_) {
            String prefix = hintStyle[0];
            String suffix = hintStyle[1];
            Assert.assertTrue((boolean)this.hasStraightJoin(String.format("select %sstraight_join%s * from functional.alltypes", prefix, suffix), null));
            Assert.assertTrue((boolean)this.hasStraightJoin(String.format("select %sStrAigHt_jOiN%s * from functional.alltypes", prefix, suffix), null));
            if (prefix.equals("")) continue;
            Assert.assertFalse((boolean)this.hasStraightJoin(String.format("select %sbadhint%s * from functional.alltypes", prefix, suffix), "PLAN hint not recognized: badhint"));
            Assert.assertTrue((boolean)this.hasStraightJoin(String.format("select %sstraight_join%s * from functional.alltypes", prefix, suffix), null));
            Assert.assertTrue((boolean)this.hasStraightJoin(String.format("select %sstraight_join,straight_join%s * from functional.alltypes", prefix, suffix), null));
        }
    }

    @Test
    public void TestInsertHints() throws AnalysisException {
        this.addTestDb("test_sort_by", "Test DB for SORT BY clause.");
        this.addTestTable("create table test_sort_by.alltypes (id int, int_col int, bool_col boolean) partitioned by (year int, month int) sort by (int_col, bool_col) location '/'");
        for (String[] hintStyle : this.getHintStyles()) {
            String prefix = hintStyle[0];
            String suffix = hintStyle[1];
            this.AnalyzesOk(String.format("insert into functional.alltypessmall partition (year, month) %sshuffle%s select * from functional.alltypes", prefix, suffix));
            this.AnalyzesOk(String.format("insert into table functional.alltypessmall partition (year, month) %snoshuffle%s select * from functional.alltypes", prefix, suffix));
            this.AnalyzesOk(String.format("insert into functional.alltypessmall partition (year, month) %sbadhint%s select * from functional.alltypes", prefix, suffix), "INSERT hint not recognized: badhint");
            this.AnalyzesOk(String.format("insert into table functional.alltypesnopart %sshuffle%s select * from functional.alltypesnopart", prefix, suffix));
            this.AnalyzesOk(String.format("insert into table functional_kudu.alltypes %sshuffle%s select * from functional_kudu.alltypes", prefix, suffix));
            this.AnalysisError(String.format("insert into table functional_hbase.alltypes %sshuffle%s select * from functional_hbase.alltypes", prefix, suffix), "INSERT hints are only supported for inserting into Hdfs and Kudu tables: functional_hbase.alltypes");
            this.AnalysisError("insert into table functional.alltypessmall partition (year, month) /* +shuffle,noshuffle */ select * from functional.alltypes", "Conflicting INSERT hints: shuffle and noshuffle");
            this.AnalyzesOk(String.format("insert into functional.alltypessmall partition (year, month) %sclustered%s select * from functional.alltypes", prefix, suffix));
            this.AnalyzesOk(String.format("insert into table functional.alltypesnopart %sclustered%s select * from functional.alltypesnopart", prefix, suffix));
            this.AnalyzesOk(String.format("insert into table functional.alltypesnopart %snoclustered%s select * from functional.alltypesnopart", prefix, suffix));
            this.AnalysisError(String.format("insert into table functional.alltypessmall partition (year, month) /* +clustered,noclustered */ select * from functional.alltypes", prefix, suffix), "Conflicting INSERT hints: clustered and noclustered");
            this.AnalyzesOk(String.format("insert into test_sort_by.alltypes partition (year, month) %snoclustered%s select id, int_col, bool_col, year, month from functional.alltypes", prefix, suffix), "Insert statement has 'noclustered' hint, but table has 'sort.columns' property. The 'noclustered' hint will be ignored.");
            this.testDefaultHintIgnored(String.format("insert into functional.alltypes partition (year, month) %snoclustered,shuffle%s select * from functional.alltypes", prefix, suffix), "CLUSTERED");
            this.testDefaultHintIgnored(String.format("insert into functional_kudu.alltypes %snoclustered,shuffle%s select * from functional.alltypes", prefix, suffix), "CLUSTERED : NOSHUFFLE ");
        }
        this.AnalyzesOk("insert into table functional.alltypessmall partition (year, month) /* +shuffle, ShUfFlE */ select * from functional.alltypes");
        this.AnalyzesOk("insert into table functional.alltypessmall partition (year, month) [shuffle, ShUfFlE] select * from functional.alltypes");
        AnalysisContext insertCtx = this.createAnalysisCtx();
        insertCtx.getQueryOptions().setDefault_hints_insert_statement("badhint");
        this.AnalyzesOk("insert into functional.alltypessmall partition (year, month) select * from functional.alltypes", insertCtx, "INSERT hint not recognized: badhint");
        insertCtx.getQueryOptions().setDefault_hints_insert_statement("clustered:noshuffle:badhint");
        this.AnalyzesOk("insert into functional.alltypessmall partition (year, month) select * from functional.alltypes", insertCtx, "INSERT hint not recognized: badhint");
        insertCtx.getQueryOptions().setDefault_hints_insert_statement("clustered:noclustered");
        this.AnalysisError("insert into functional.alltypessmall partition (year, month) select * from functional.alltypes", insertCtx, "Conflicting INSERT hints: clustered and noclustered");
        insertCtx.getQueryOptions().setDefault_hints_insert_statement("shuffle:noshuffle");
        this.AnalysisError("insert into functional.alltypessmall partition (year, month) select * from functional.alltypes", insertCtx, "Conflicting INSERT hints: shuffle and noshuffle");
        insertCtx.getQueryOptions().setDefault_hints_insert_statement("noclustered");
        this.AnalyzesOk("insert into table functional_hbase.alltypes select * from functional_hbase.alltypes", insertCtx);
        insertCtx.getQueryOptions().setDefault_hints_insert_statement("clustered:noshuffle");
        this.AnalyzesOk(String.format("insert into table functional_kudu.alltypes select * from functional_kudu.alltypes", new Object[0]), insertCtx);
        this.testDefaultHintApplied(insertCtx);
        insertCtx.getQueryOptions().setDefault_hints_insert_statement("NOCLUSTERED:noshuffle");
        this.AnalyzesOk("insert into functional.alltypessmall partition (year, month) select * from functional.alltypes", insertCtx);
        this.testDefaultHintApplied(insertCtx);
        insertCtx.getQueryOptions().setDefault_hints_insert_statement("CLUSTERED:SHUFFLE");
        this.AnalyzesOk("insert into functional.alltypesnopart select * from functional.alltypesnopart", insertCtx);
        this.testDefaultHintApplied(insertCtx);
    }

    @Test
    public void TestWhereClause() throws AnalysisException {
        this.AnalyzesOk("select zip, name from functional.testtbl where id > 15");
        this.AnalysisError("select zip, name from functional.testtbl where badcol > 15", "Could not resolve column/field reference: 'badcol'");
        this.AnalyzesOk("select * from functional.testtbl where true");
        this.AnalysisError("select * from functional.testtbl where count(*) > 0", "aggregate function not allowed in WHERE clause");
        for (BinaryPredicate.Operator op : BinaryPredicate.Operator.values()) {
            this.AnalyzesOk("select id from functional.testtbl where id " + op.toString() + " true");
            this.AnalyzesOk("select id from functional.testtbl where id " + op.toString() + " false");
            this.AnalyzesOk("select id from functional.testtbl where id " + op.toString() + " NULL");
        }
        this.AnalyzesOk("select id from functional.alltypes where bool_col");
        this.AnalysisError("select id from functional.alltypes where int_col", "WHERE clause requires return type 'BOOLEAN'. Actual type is 'INT'.");
        this.AnalysisError("select id from functional.alltypes where trim('abc')", "WHERE clause requires return type 'BOOLEAN'. Actual type is 'STRING'.");
        this.AnalysisError("select id from functional.alltypes where (int_col + float_col) * 10", "WHERE clause requires return type 'BOOLEAN'. Actual type is 'DOUBLE'.");
    }

    @Test
    public void TestFunctions() throws AnalysisException {
        this.AnalyzesOk("select year(timestamp_col), count(*) from functional.alltypes group by 1");
        this.AnalyzesOk("select year(timestamp_col), count(*) from functional.alltypes group by year(timestamp_col)");
        this.AnalyzesOk("select now() + interval abs(cast(1 as int)) days");
        this.AnalyzesOk("select now() + interval abs(cast(1 as smallint)) days");
        this.AnalyzesOk("select now() + interval abs(cast(1 as tinyint)) days");
        this.AnalyzesOk("select round(c1) from functional.decimal_tiny");
        this.AnalyzesOk("select round(c1, 2) from functional.decimal_tiny");
        this.AnalysisError("select round(c1, cast(c3 as int)) from functional.decimal_tiny", "round() must be called with a constant second argument.");
        this.AnalysisError("select truncate(c1, cast(c3 as int)) from functional.decimal_tiny", "truncate() must be called with a constant second argument.");
    }

    @Test
    public void TestAggregates() throws AnalysisException {
        this.addTestUda("AggFn", (Type)Type.BIGINT, new Type[]{Type.INT});
        this.addTestUda("AggFn", (Type)Type.BIGINT, new Type[]{Type.BIGINT});
        this.addTestUda("AggFn", (Type)Type.BIGINT, new Type[]{Type.DOUBLE});
        this.addTestUda("AggFn", (Type)Type.STRING, new Type[]{Type.STRING, Type.STRING});
        this.AnalyzesOk("select aggfn(int_col) from functional.alltypesagg");
        this.AnalysisError("select default.AggFn(1)", "aggregation without a FROM clause is not allowed");
        this.AnalysisError("select aggfn(int_col) over (partition by int_col) from functional.alltypesagg", "Aggregate function 'default.aggfn(int_col) /* NATIVE UDF */' not supported with OVER clause.");
        this.AnalysisError("select aggfn(distinct int_col) from functional.alltypesagg", "User defined aggregates do not support DISTINCT.");
        this.AnalyzesOk("select default.aggfn(int_col) from functional.alltypes");
        this.AnalyzesOk("select count(*) from functional.testtbl");
        this.AnalyzesOk("select min(id), max(id), sum(id) from functional.testtbl");
        this.AnalyzesOk("select avg(id) from functional.testtbl");
        this.AnalyzesOk("select count(*), min(id), max(id), sum(id), avg(id), aggfn(id) from functional.testtbl");
        this.AnalyzesOk("select AggFn(tinyint_col), AggFn(int_col), AggFn(bigint_col), AggFn(double_col) from functional.alltypes");
        this.AnalysisError("select AggFn(string_col) from functional.alltypes", "No matching function with signature: default.aggfn(STRING)");
        this.AnalyzesOk("select AggFn(string_col, string_col) from functional.alltypes");
        this.AnalyzesOk("select count(NULL), min(NULL), max(NULL), sum(NULL), avg(NULL), group_concat(NULL), group_concat(name, NULL) from functional.testtbl");
        this.AnalysisError("select id, zip from functional.testtbl where count(*) > 0", "aggregate function not allowed in WHERE clause");
        this.AnalysisError("select 1 from functional.alltypes where aggfn(1)", "aggregate function not allowed in WHERE clause");
        this.AnalysisError("select count() from functional.alltypes", "count() is not allowed.");
        this.AnalysisError("select min() from functional.alltypes", "No matching function with signature: min().");
        this.AnalysisError("select int_col from functional.alltypes order by count(*)", "select list expression not produced by aggregation output (missing from GROUP BY clause?): int_col");
        this.AnalysisError("select functional.alltypes.*, max(string_col) from functional.alltypes", "cannot combine '*' in select list with grouping or aggregation");
        this.AnalysisError("select * from functional.alltypes order by count(*)", "select list expression not produced by aggregation output (missing from GROUP BY clause?): *");
        this.AnalysisError("select avg(*) from functional.testtbl", "'*' can only be used in conjunction with COUNT");
        this.AnalysisError("select min(*) from functional.testtbl", "'*' can only be used in conjunction with COUNT");
        this.AnalysisError("select max(*) from functional.testtbl", "'*' can only be used in conjunction with COUNT");
        this.AnalysisError("select count(id, zip) from functional.testtbl", "COUNT must have DISTINCT for multiple arguments: count(id, zip)");
        this.AnalysisError("select min(id, zip) from functional.testtbl", "No matching function with signature: min(BIGINT, INT).");
        this.AnalysisError("select sum(count(*)) from functional.testtbl", "aggregate function must not contain aggregate parameters");
        this.AnalysisError("select sum(rank() over (order by id)) from functional.testtbl", "aggregate function must not contain analytic parameters");
        this.AnalysisError("select min(aggfn(int_col)) from functional.alltypes", "aggregate function must not contain aggregate parameters: min(default.aggfn(int_col) /* NATIVE UDF */)");
        this.AnalysisError("select sum(timestamp_col) from functional.alltypes", "SUM requires a numeric parameter: sum(timestamp_col)");
        this.AnalysisError("select sum(date_col) from functional.date_tbl", "SUM requires a numeric parameter: sum(date_col)");
        this.AnalysisError("select sum(string_col) from functional.alltypes", "SUM requires a numeric parameter: sum(string_col)");
        this.AnalysisError("select avg(string_col) from functional.alltypes", "AVG requires a numeric or timestamp parameter: avg(string_col)");
        this.AnalysisError("select avg(binary_col) from functional.binary_tbl", "AVG requires a numeric or timestamp parameter: avg(binary_col)");
        this.AnalysisError("select count(*)", "aggregation without a FROM clause is not allowed");
        this.AnalysisError("select min(1)", "aggregation without a FROM clause is not allowed");
        for (Type type : typeToLiteralValue_.keySet()) {
            this.AnalyzesOk(String.format("select ndv(%s) from functional.alltypes", typeToLiteralValue_.get(type)));
        }
        this.AnalyzesOk("select min(d1), max(d2), count(d3), sum(d4) from functional.decimal_tbl");
        this.AnalyzesOk("select ndv(d1), distinctpc(d2), distinctpcsa(d3), count(distinct d4) from functional.decimal_tbl");
        this.AnalyzesOk("select avg(d5) from functional.decimal_tbl");
        this.AnalyzesOk("select min(date_col), max(date_col), count(date_col) from functional.date_tbl");
        this.AnalyzesOk("select ndv(date_col), distinctpc(date_col), distinctpcsa(date_col), count(distinct date_col) from functional.date_tbl");
        this.AnalyzesOk("select min(binary_col), max(binary_col), count(binary_col), max(length(binary_col)) from functional.binary_tbl");
        this.AnalysisError("select ndv(binary_col) from functional.binary_tbl", "No matching function with signature: ndv(BINARY).");
        this.AnalyzesOk("select cast(avg(c1) as decimal(10,4)) as c from functional.decimal_tiny group by c3 having cast(avg(c1) as decimal(10,4)) = 5.1106 order by 1");
        this.checkExprType("select min(cast('foo' as char(5))) from functional.chars_tiny", (Type)ScalarType.STRING);
        this.checkExprType("select max(cast('foo' as varchar(5))) from functional.chars_tiny", (Type)ScalarType.STRING);
        this.checkExprType("select max(vc) from functional.chars_tiny", (Type)ScalarType.STRING);
        this.checkExprType("select max(cs) from functional.chars_tiny", (Type)ScalarType.STRING);
        this.checkExprType("select max(lower(cs)) from functional.chars_tiny", (Type)ScalarType.STRING);
    }

    @Test
    public void TestGroupingSets() throws AnalysisException {
        this.AnalyzesOk("select count(*) from functional.alltypes group by rollup(int_col, string_col)");
        this.AnalyzesOk("select count(*) from functional.alltypes group by int_col, string_col with rollup");
        this.AnalyzesOk("select count(*) from functional.alltypes group by int_col, string_col with cube");
        this.AnalyzesOk("select count(*) from functional.alltypes group by GROUPING SETS((int_col), (string_col))");
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= 25; ++i) {
            sb.append("bool_col" + i + ", tinyint_col" + i + ", smallint_col" + i + ", int_col" + i + ", bigint_col" + i + ", float_col" + i + ", double_col" + i + ", string_col" + i);
            if (i == 25) continue;
            sb.append(",");
        }
        String longColList = sb.toString();
        this.AnalysisError("select count(*) from functional.widetable_250_cols group by rollup(" + longColList + ")", "Number of grouping columns (200) exceeds GROUP BY with ROLLUP limit of 63");
        this.AnalysisError("select count(*) from functional.widetable_250_cols group by cube(" + longColList + ")", "Number of grouping columns (200) exceeds GROUP BY with CUBE limit of 63");
        this.AnalysisError("select count(*) from functional.widetable_250_cols group by grouping sets((" + longColList + "))", "Number of grouping columns (200) exceeds GROUP BY with SETS limit of 63");
        this.AnalysisError("select count(*) from functional.widetable_250_cols group by grouping sets((" + longColList + ", string_col1), (bool_col1, int_col1))", "Number of grouping columns (200) exceeds GROUP BY with SETS limit of 63");
        this.AnalyzesOk("select count(*) from functional.widetable_250_cols group by grouping sets((   bool_col1, tinyint_col1, smallint_col1, int_col1, bigint_col1,   float_col1, double_col1, string_col1,   bool_col2, tinyint_col2, smallint_col2, int_col2, bigint_col2,   float_col2, double_col2, string_col2,   bool_col3, tinyint_col3, smallint_col3, int_col3, bigint_col3,   float_col3, double_col3, string_col3,   bool_col4, tinyint_col4, smallint_col4, int_col4, bigint_col4,   float_col4, double_col4, string_col4,   bool_col5, tinyint_col5, smallint_col5, int_col5, bigint_col5,   float_col5, double_col5, string_col5,   bool_col6, tinyint_col6, smallint_col6, int_col6, bigint_col6,   float_col6, double_col6, string_col6,   bool_col7, tinyint_col7, smallint_col7, int_col7, bigint_col7,   float_col7, double_col7, string_col7),   (bool_col1, tinyint_col1, smallint_col1, int_col1, bigint_col1,   float_col1, double_col1, string_col1,   bool_col2, tinyint_col2, smallint_col2, int_col2, bigint_col2,   float_col2, double_col2, string_col2)); ");
        this.AnalyzesOk("select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, count(*) from functional.alltypes group by rollup(id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col)");
        this.AnalyzesOk("select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, count(*) from functional.alltypes group by cube(id, bool_col, tinyint_col, smallint_col, int_col, bigint_col)");
        this.AnalysisError("select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, count(*) from functional.alltypes group by cube(id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col)", "Limit of 64 grouping sets exceeded");
        this.AnalyzesOk("select int_col, count(*) from functional.alltypes group by rollup(int_col, string_col)");
        this.AnalyzesOk("select int_col, string_col, count(*) from functional.alltypes group by rollup(int_col, string_col)");
        this.AnalysisError("select int_col, bool_col, string_col, count(*) from functional.alltypes group by rollup(int_col, string_col)", "select list expression not produced by aggregation output (missing from GROUP BY clause?): bool_col");
        this.AnalyzesOk("select int_col, count(*) from functional.alltypes group by cube(int_col, string_col)");
        this.AnalyzesOk("select int_col, string_col, count(*) from functional.alltypes group by cube(int_col, string_col)");
        this.AnalysisError("select int_col, bool_col, string_col, count(*) from functional.alltypes group by cube(int_col, string_col)", "select list expression not produced by aggregation output (missing from GROUP BY clause?): bool_col");
        this.AnalyzesOk("select int_col, count(*) from functional.alltypes group by grouping sets((int_col, string_col), (int_col))");
        this.AnalyzesOk("select int_col, string_col, count(*) from functional.alltypes group by grouping sets((int_col, string_col), (int_col))");
        this.AnalysisError("select int_col, bool_col, string_col, count(*) from functional.alltypes group by grouping sets((int_col, string_col), (int_col))", "select list expression not produced by aggregation output (missing from GROUP BY clause?): bool_col");
        this.AnalyzesOk("select int_col, string_col, count(*) from functional.alltypes group by rollup(1, 2)");
        this.AnalyzesOk("select int_col, string_col, count(*) from functional.alltypes group by cube(1, 2)");
        this.AnalyzesOk("select int_col, string_col, count(*) from functional.alltypes group by grouping sets((1, 2), (1))");
        this.AnalysisError("select int_col, string_col, count(*) from functional.alltypes group by rollup(1, 3)", "GROUP BY expression must not contain aggregate functions: 3");
        this.AnalysisError("select int_col, string_col, count(*) from functional.alltypes group by cube(1, 3)", "GROUP BY expression must not contain aggregate functions: 3");
        this.AnalysisError("select int_col, string_col, count(*) from functional.alltypes group by grouping sets((1, 3), (1))", "GROUP BY expression must not contain aggregate functions: 3");
        this.AnalyzesOk("select int_col, string_col, count(*) from functional.alltypes group by grouping sets((1, 2), (int_col))");
        this.AnalyzesOk("select count(*) from functional.alltypes group by rollup(int_col, substring(string_col, 1, 2))");
        this.AnalyzesOk("select int_col, count(*) from functional.alltypes group by cube(int_col, substring(string_col, 1, 2))");
        this.AnalyzesOk("select int_col, count(*) from functional.alltypes group by grouping sets((int_col), (int_col, substring(string_col, 1, 2)))");
        this.AnalyzesOk("select int_col, substring(string_col, 1, 2) str, count(*) from functional.alltypes group by rollup(int_col, substring(string_col, 1, 2))");
        this.AnalyzesOk("select int_col, substring(string_col, 1, 2) str, count(*) from functional.alltypes group by cube(int_col, str)");
        this.AnalyzesOk("select int_col, substring(string_col, 1, 2) str, count(*) from functional.alltypes group by grouping sets((int_col, str), (substring(string_col, 1, 2)))");
        this.AnalysisError("select int_col, substring(string_col, 1, 3) str, count(*) from functional.alltypes group by rollup(int_col, substring(string_col, 1, 2))", "select list expression not produced by aggregation output (missing from GROUP BY clause?): substring(string_col, 1, 3)");
        this.AnalyzesOk("select int_col, substring(string_col, 1, 2) str, count(*) from functional.alltypes group by rollup(int_col, str, substring(string_col, 1, 2))");
        this.AnalyzesOk("select int_col, count(*) from functional.alltypes group by rollup(int_col, 'constant')");
        this.AnalyzesOk("select int_col, count(*) from functional.alltypes group by cube(int_col, 'constant')");
        this.AnalyzesOk("select int_col, count(*) from functional.alltypes group by grouping sets((false), (int_col, 'constant'))");
        this.AnalyzesOk("select g.int_col, count(*) from functional.alltypesagg g left outer join functional.alltypes a on g.id = a.id where g.int_col < 100 and g.tinyint_col < (   select count(*) from functional.alltypes t   where t.id = g.id and g.string_col = t.string_col and t.bool_col = true) group by rollup(g.int_col, g.string_col) having count(*) < 100");
        this.AnalysisError("select g.int_col, count(*) from functional.alltypesagg g where g.int_col < 100 and g.tinyint_col < (   select count(*) from functional.alltypes t   where t.id = g.id and g.string_col = t.string_col and t.bool_col = true   group by rollup(t.string_col, t.bool_col))   group by g.int_col", "Unsupported correlated subquery with grouping and/or aggregation");
        this.AnalysisError("select count(distinct id) from functional.alltypes group by rollup(int_col, bool_col)", "Distinct aggregate functions and grouping sets are not supported in the same query block.");
        this.AnalysisError("select count(distinct id), count(distinct string_col) from functional.alltypes group by rollup(int_col, bool_col)", "Distinct aggregate functions and grouping sets are not supported in the same query block.");
        this.AnalysisError("select distinct int_col, bool_col, count(*) from functional.alltypes group by rollup(int_col, bool_col)", "cannot combine SELECT DISTINCT with aggregate functions or GROUP BY");
        this.AnalyzesOk("select int_col, string_col, grouping_id(), grouping(int_col), grouping(string_col) from functional.alltypes group by rollup(int_col, string_col)");
        this.AnalyzesOk("select int_col, string_col, grouping_id(), grouping(int_col), grouping(string_col) from functional.alltypes group by cube(int_col, string_col)");
        this.AnalyzesOk("select int_col, string_col, grouping_id(), grouping(int_col), grouping(string_col) from functional.alltypes group by grouping sets((), (int_col, string_col))");
        this.AnalyzesOk("select int_col, string_col, grouping_id(int_col, string_col), grouping(string_col) from functional.alltypes group by rollup(int_col, string_col)");
        this.AnalyzesOk("select bitand(grouping_id(), 1), cast(grouping(int_col) as string) from functional.alltypes group by rollup(int_col, string_col)");
        this.AnalyzesOk("select int_col * 2, string_col, grouping(int_col * 2),  count(*) from functional.alltypes group by rollup(1, 2)");
        this.AnalyzesOk("select int_col, string_col, grouping_id() from functional.alltypes group by int_col, string_col");
        this.AnalyzesOk("select int_col, string_col, grouping(int_col) from functional.alltypes group by int_col, string_col");
        this.AnalyzesOk("select int_col, string_col, grouping_id(), grouping(int_col) from functional.alltypes group by grouping sets((int_col, string_col))");
        this.AnalysisError("select int_col, string_col, grouping(int_col, string_col) from functional.alltypes group by grouping sets((), (int_col, string_col))", "No matching function with signature: grouping(INT, STRING).");
        this.AnalysisError("select int_col, string_col, grouping() from functional.alltypes group by grouping sets((), (int_col, string_col))", "No matching function with signature: grouping().");
        this.AnalysisError("select int_col, grouping('test') from functional.alltypes group by rollup(int_col, string_col)", "'test' is not a grouping expression");
        this.AnalysisError("select int_col, grouping(1) from functional.alltypes group by rollup(int_col, string_col)", "1 is not a grouping expression");
        this.AnalysisError("select grouping(tinyint_col) from functional.alltypes group by rollup(int_col, string_col)", "tinyint_col is not a grouping expression");
        this.AnalysisError("select count(*), grouping(count(*)) from functional.alltypes group by rollup(int_col, string_col)", "aggregate function must not contain aggregate parameters: grouping(count(*))");
        this.AnalysisError("select int_col, grouping_id(int_col, 'test') from functional.alltypes group by rollup(int_col, string_col)", "'test' is not a grouping expression");
        this.AnalysisError("select int_col, grouping_id(1) from functional.alltypes group by rollup(int_col, string_col)", "1 is not a grouping expression");
        this.AnalysisError("select grouping_id(int_col, tinyint_col) from functional.alltypes group by rollup(int_col, string_col)", "tinyint_col is not a grouping expression");
        this.AnalysisError("select count(*), grouping_id(count(*)) from functional.alltypes group by rollup(int_col, string_col)", "count(*) is not a grouping expression");
        this.AnalysisError("select int_col, grouping(int_col) from functional.alltypes", "grouping() or grouping_id() function requires a GROUP BY clause: 'grouping(int_col)'");
        this.AnalysisError("select int_col, grouping_id() from functional.alltypes", "grouping() or grouping_id() function requires a GROUP BY clause: 'grouping_id()'");
    }

    @Test
    public void TestDistinct() throws AnalysisException {
        this.AnalyzesOk("select count(distinct id) as sum_id from functional.testtbl");
        this.AnalyzesOk("select count(distinct id) as sum_id from functional.testtbl order by sum_id");
        this.AnalyzesOk("select count(distinct id) as sum_id from functional.testtbl order by max(id)");
        this.AnalyzesOk("select distinct id, zip from functional.testtbl");
        this.AnalyzesOk("select distinct * from functional.testtbl");
        this.AnalysisError("select distinct count(*) from functional.testtbl", "cannot combine SELECT DISTINCT with aggregate functions or GROUP BY");
        this.AnalysisError("select distinct id, zip from functional.testtbl group by 1, 2", "cannot combine SELECT DISTINCT with aggregate functions or GROUP BY");
        this.AnalysisError("select distinct id, zip, count(*) from functional.testtbl group by 1, 2", "cannot combine SELECT DISTINCT with aggregate functions or GROUP BY");
        this.AnalyzesOk("select distinct id from functional.testtbl having id > 0");
        this.AnalysisError("select distinct id from functional.testtbl having max(id) > 0", "cannot combine SELECT DISTINCT with aggregate functions or GROUP BY");
        this.AnalyzesOk("select count(distinct id, zip) from functional.testtbl");
        this.AnalyzesOk("select tinyint_col, count(distinct int_col, bigint_col) from functional.alltypesagg group by 1");
        this.AnalyzesOk("select tinyint_col, count(distinct int_col),sum(distinct int_col) from functional.alltypesagg group by 1");
        this.AnalyzesOk("select avg(DISTINCT(tinyint_col)) from functional.alltypesagg");
        this.AnalyzesOk("select sum(distinct t1.bigint_col), avg(distinct t1.bigint_col) from functional.alltypes t1 group by t1.int_col, t1.int_col");
        this.AnalyzesOk("select tinyint_col, count(distinct int_col),min(distinct smallint_col), max(distinct string_col) from functional.alltypesagg group by 1");
        Table alltypesTbl = catalog_.getOrLoadTable("functional", "alltypes");
        ArrayList<String> distinctFns = new ArrayList<String>();
        for (Column col : alltypesTbl.getColumns()) {
            distinctFns.add(String.format("count(distinct %s)", col.getName()));
        }
        this.AnalyzesOk(String.format("select %s from functional.alltypes", Joiner.on((String)",").join(distinctFns)));
        HashSet testAggExprs = Sets.newHashSet((Object[])new String[]{"count(tinyint_col)", "count(string_col)", "avg(float_col)", "max(string_col)", "count(distinct tinyint_col)", "count(distinct tinyint_col, smallint_col, int_col)", "avg(distinct double_col)", "count(distinct string_col)", "sum(distinct smallint_col)"});
        ArrayList testGroupByExprs = Lists.newArrayList((Object[])new String[]{"int_col", "bigint_col", "string_col", "string_col, date_string_col", "id, double_col, date_string_col"});
        for (Set aggExprs : Sets.powerSet((Set)testAggExprs)) {
            if (aggExprs.isEmpty()) continue;
            String selectList = Joiner.on((String)",").join((Iterable)aggExprs);
            this.AnalyzesOk(String.format("select %s from functional.alltypes", selectList));
            for (String groupByExprs : testGroupByExprs) {
                this.AnalyzesOk(String.format("select %s from functional.alltypes group by %s", selectList, groupByExprs));
            }
        }
        this.AnalyzesOk("select distinct cast(0 as decimal(14)), 0 from functional.alltypes");
    }

    @Test
    public void TestSampledNdv() throws AnalysisException {
        String[] invalidSamplePercs;
        double[] validSamplePercs;
        Table allScalarTypes = this.addAllScalarTypesTestTable();
        String tblName = allScalarTypes.getFullName();
        for (double perc : validSamplePercs = new double[]{0.0, 0.1, 0.2, 0.5, 0.8, 1.0}) {
            ArrayList<String> allAggFnCalls = new ArrayList<String>();
            for (Column col : allScalarTypes.getColumns()) {
                String aggFnCall = String.format("sampled_ndv(%s, %s)", col.getName(), perc);
                allAggFnCalls.add(aggFnCall);
                String stmtSql = String.format("select %s from %s", aggFnCall, tblName);
                SelectStmt stmt = (SelectStmt)this.AnalyzesOk(stmtSql);
                AggregateInfo aggInfo = stmt.getMultiAggInfo().getAggClass(0);
                Type[] args = ((FunctionCallExpr)aggInfo.getAggregateExprs().get(0)).getFn().getArgs();
                Assert.assertEquals((long)args.length, (long)2L);
                Assert.assertTrue((col.getType().matchesType(args[0]) || col.getType().isStringType() && args[0].equals((Object)Type.STRING) ? 1 : 0) != 0);
                Assert.assertEquals((Object)Type.DOUBLE, (Object)args[1]);
            }
            this.AnalyzesOk(String.format("select %s from %s", Joiner.on((String)",").join(allAggFnCalls), tblName));
        }
        this.AnalysisError(String.format("select sampled_ndv() from %s", tblName), "No matching function with signature: sampled_ndv().");
        this.AnalysisError(String.format("select sampled_ndv(int_col) from %s", tblName), "No matching function with signature: sampled_ndv(INT).");
        this.AnalysisError(String.format("select sampled_ndv(int_col, 0.1, 10) from %s", tblName), "No matching function with signature: sampled_ndv(INT, DECIMAL(1,1), TINYINT).");
        for (String invalidPerc : invalidSamplePercs = new String[]{"int_col", "double_col", "100 / 10", "-0.1", "1.1", "100", "50", "-50", "NULL"}) {
            this.AnalysisError(String.format("select sampled_ndv(int_col, %s) from %s", invalidPerc, tblName), "Second parameter of SAMPLED_NDV() must be a numeric literal in [0,1]: " + invalidPerc);
        }
    }

    @Test
    public void TestGroupConcat() throws AnalysisException {
        String[] keywords;
        this.AnalyzesOk("select group_concat(distinct name) from functional.testtbl");
        this.AnalysisError("select group_concat(distinct name, name) from functional.testtbl", "Second parameter in GROUP_CONCAT(DISTINCT) must be a constant expression that returns a string.");
        this.AnalyzesOk("select group_concat(distinct name, cast(123 as string)) from functional.testtbl");
        this.AnalysisError("select group_concat(distinct name, cast(id as string)) from functional.testtbl", "Second parameter in GROUP_CONCAT(DISTINCT) must be a constant expression that returns a string.");
        this.AnalyzesOk("select group_concat(distinct string_col, concat('-', '?')) from functional.alltypesagg");
        this.AnalysisError("select group_concat(*) from functional.testtbl", "'*' can only be used in conjunction with COUNT");
        this.AnalyzesOk("select group_concat(string_col, string_col) from functional.alltypes");
        for (String keyword : keywords = new String[]{"distinct", ""}) {
            this.AnalysisError(String.format("select group_concat(%s '')", keyword), "aggregation without a FROM clause is not allowed");
            this.AnalysisError(String.format("select group_concat(%s name, '-', ',') from functional.testtbl", keyword), "No matching function with signature: group_concat(STRING, STRING, STRING)");
            for (Type type : typeToLiteralValue_.keySet()) {
                String literal = (String)typeToLiteralValue_.get(type);
                String query1 = String.format("select group_concat(%s %s) from functional.alltypes", keyword, literal);
                String query2 = String.format("select group_concat(%s %s, '---') from functional.alltypes", keyword, literal);
                if (type.getPrimitiveType() == PrimitiveType.STRING || type.isNull()) {
                    this.AnalyzesOk(query1);
                    this.AnalyzesOk(query2);
                    continue;
                }
                this.AnalysisError(query1, "No matching function with signature: group_concat(");
                this.AnalysisError(query2, "No matching function with signature: group_concat(");
            }
        }
    }

    @Test
    public void TestDistinctInlineView() throws AnalysisException {
        this.AnalyzesOk("select distinct id from (select distinct id, zip from (select * from functional.testtbl) x) y");
        this.AnalyzesOk("select distinct * from (select distinct * from (Select * from functional.testtbl) x) y");
        this.AnalyzesOk("select distinct * from (select count(*) from functional.testtbl) x");
        this.AnalyzesOk("select count(distinct id, zip) from (select * from functional.testtbl) x");
        this.AnalyzesOk("select * from (select tinyint_col, count(distinct int_col, bigint_col) from (select * from functional.alltypesagg) x group by 1) y");
        this.AnalyzesOk("select tinyint_col, count(distinct int_col),sum(distinct int_col) from (select * from functional.alltypesagg) x group by 1");
        this.AnalyzesOk("select * from (select count(distinct id, zip), count(distinct zip) from functional.testtbl) x");
        this.AnalyzesOk("select * from (select tinyint_col, count(distinct int_col),sum(distinct bigint_col) from functional.alltypesagg group by 1) x");
        this.AnalyzesOk("select count(distinct id, zip) from (select * from functional.testtbl) x");
        this.AnalyzesOk("select tinyint_col, count(distinct int_col, bigint_col) from (select * from functional.alltypesagg) x group by 1");
        this.AnalyzesOk("select tinyint_col, count(distinct int_col),sum(distinct int_col) from (select * from functional.alltypesagg) x group by 1");
        this.AnalyzesOk("select count(distinct id, zip), count(distinct zip)  from (select * from functional.testtbl) x");
        this.AnalyzesOk("select tinyint_col, count(distinct int_col),sum(distinct bigint_col) from (select * from functional.alltypesagg) x group by 1");
        this.AnalysisError("select * from (select distinct count(*) from functional.testtbl) x", "cannot combine SELECT DISTINCT with aggregate functions or GROUP BY");
        this.AnalysisError("select * from (select distinct id, zip from functional.testtbl group by 1, 2) x", "cannot combine SELECT DISTINCT with aggregate functions or GROUP BY");
        this.AnalysisError("select * from (select distinct id, zip, count(*) from functional.testtbl group by 1, 2) x", "cannot combine SELECT DISTINCT with aggregate functions or GROUP BY");
        this.AnalysisError("select distinct count(*) from (select * from functional.testtbl) x", "cannot combine SELECT DISTINCT with aggregate functions or GROUP BY");
        this.AnalysisError("select distinct id, zip from (select * from functional.testtbl) x group by 1, 2", "cannot combine SELECT DISTINCT with aggregate functions or GROUP BY");
        this.AnalysisError("select distinct id, zip, count(*) from (select * from functional.testtbl) x group by 1, 2", "cannot combine SELECT DISTINCT with aggregate functions or GROUP BY");
    }

    @Test
    public void TestGroupBy() throws AnalysisException {
        this.AnalyzesOk("select zip, count(*) from functional.testtbl group by zip");
        this.AnalyzesOk("select zip + count(*) from functional.testtbl group by zip");
        this.AnalyzesOk("select count(*) from functional.testtbl group by 2*3+4");
        this.AnalyzesOk("select count(*) from functional.testtbl group by true, false, NULL");
        this.AnalyzesOk("select true, NULL, 1*2+5 as a, zip, count(*) from functional.testtbl group by zip");
        this.AnalyzesOk("select d1, d2, count(*) from functional.decimal_tbl group by 1, 2");
        this.AnalyzesOk("select date_part, date_col, count(*) from functional.date_tbl group by 1, 2");
        this.AnalyzesOk("select binary_col, count(*) from functional.binary_tbl group by binary_col");
        this.AnalysisError("select zip, count(*) from functional.testtbl", "select list expression not produced by aggregation output (missing from GROUP BY clause?)");
        this.AnalysisError("select zip + count(*) from functional.testtbl", "select list expression not produced by aggregation output (missing from GROUP BY clause?)");
        this.AnalyzesOk("select id, zip from functional.testtbl group by zip, id having count(*) > 0");
        this.AnalyzesOk("select count(*) from functional.alltypes group by bool_col having bool_col");
        this.AnalysisError("select count(*) from functional.alltypes group by bool_col having 5 + 10 * 5.6", "HAVING clause '5 + 10 * 5.6' requires return type 'BOOLEAN'. Actual type is 'DECIMAL(7,1)'.");
        this.AnalysisError("select count(*) from functional.alltypes group by bool_col having int_col", "HAVING clause 'int_col' requires return type 'BOOLEAN'. Actual type is 'INT'.");
        this.AnalysisError("select id, zip from functional.testtbl group by id having count(*) > 0", "select list expression not produced by aggregation output (missing from GROUP BY clause?)");
        this.AnalysisError("select id from functional.testtbl group by id having zip + count(*) > 0", "HAVING clause not produced by aggregation output (missing from GROUP BY clause?)");
        this.AnalyzesOk("select zip, count(*) from functional.testtbl group by 1");
        this.AnalyzesOk("select count(*), zip from functional.testtbl group by 2");
        this.AnalysisError("select zip, count(*) from functional.testtbl group by 3", "GROUP BY: ordinal exceeds the number of items in the SELECT list: 3");
        this.AnalysisError("select * from functional.alltypes group by 1", "cannot combine '*' in select list with grouping or aggregation");
        this.AnalyzesOk("select zip z, id iD1, id ID2, count(*) from functional.testtbl group by z, ID1, id2");
        this.AnalyzesOk("select int_col, INT_COL from functional.alltypes group by int_col");
        this.AnalyzesOk("select bool_col a, bool_col A from functional.alltypes group by a");
        this.AnalyzesOk("select int_col A, bool_col b, int_col a, bool_col B from functional.alltypes group by a, b");
        this.AnalysisError("select zip a, id a, count(*) from functional.testtbl group by a", "GROUP BY: ambiguous alias: 'a'");
        this.AnalysisError("select zip id, id, count(*) from functional.testtbl group by id", "GROUP BY: ambiguous alias: 'id'");
        this.AnalysisError("select zip, count(*) from functional.testtbl group by count(*)", "GROUP BY expression must not contain aggregate functions");
        this.AnalysisError("select zip, count(*) from functional.testtbl group by count(*) + min(zip)", "GROUP BY expression must not contain aggregate functions");
        this.AnalysisError("select zip, count(*) from functional.testtbl group by 2", "GROUP BY expression must not contain aggregate functions");
        this.AnalyzesOk("select int_col, string_col, bigint_col, count(*) from functional.alltypes group by string_col, int_col, bigint_col");
        this.AnalyzesOk("select int_col, string_col, bigint_col, count(*) from functional.alltypes group by 2, 1, 3");
        this.AnalysisError("select int_col, string_col, bigint_col, count(*) from functional.alltypes group by 2, 1, 4", "GROUP BY expression must not contain aggregate functions");
        this.AnalyzesOk("select float_col, double_col, count(*) from functional.alltypes group by 1, 2");
        this.AnalyzesOk("select int_col + 0.5, count(*) from functional.alltypes group by 1");
        this.AnalyzesOk("select cast(int_col as double), count(*)from functional.alltypes group by 1");
        this.AnalyzesOk("select bigint_col + 0 AS bigint_col, sum(smallint_col) FROM functional.alltypes GROUP BY 1");
        this.AnalyzesOk("select extract(timestamp_col, 'hour') AS timestamp_col, string_col, sum(double_col) AS double_total FROM functional.alltypes GROUP BY 1, 2");
    }

    @Test
    public void TestOrderBy() throws AnalysisException {
        this.AnalyzesOk("select zip, id from functional.testtbl order by zip");
        this.AnalyzesOk("select zip, id from functional.testtbl order by zip asc");
        this.AnalyzesOk("select zip, id from functional.testtbl order by zip desc");
        this.AnalyzesOk("select zip, id from functional.testtbl order by true asc, false desc, NULL asc");
        this.AnalyzesOk("select d1, d2 from functional.decimal_tbl order by d1");
        this.AnalyzesOk("select date_col, date_part from functional.date_tbl order by date_col");
        this.AnalyzesOk("select string_col from functional.binary_tbl order by binary_col");
        this.AnalyzesOk("select zip, id from functional.testtbl order by 1");
        this.AnalyzesOk("select zip, id from functional.testtbl order by 2 desc, 1 asc");
        this.AnalysisError("select zip, id from functional.testtbl order by 0", "ORDER BY: ordinal must be >= 1");
        this.AnalysisError("select zip, id from functional.testtbl order by 3", "ORDER BY: ordinal exceeds the number of items in the SELECT list: 3");
        this.AnalyzesOk("select * from functional.alltypes order by 1");
        this.AnalyzesOk("select zip z, id C, id D from functional.testtbl order by z, C, d");
        this.AnalyzesOk("select zip, count(*) from functional.testtbl group by 1  order by count(*)");
        this.AnalyzesOk("select zip, count(*) from functional.testtbl group by 1 order by count(*) + min(zip)");
        this.AnalysisError("select zip, count(*) from functional.testtbl group by 1 order by id", "ORDER BY expression not produced by aggregation output (missing from GROUP BY clause?)");
        this.AnalyzesOk("select int_col, string_col, bigint_col from functional.alltypes order by string_col, 15.7 * float_col, int_col + bigint_col");
        this.AnalyzesOk("select int_col, string_col, bigint_col from functional.alltypes order by 2, 1, 3");
        this.AnalyzesOk("select float_col, int_col + 0.5 from functional.alltypes order by 1, 2");
        this.AnalyzesOk("select float_col, int_col + 0.5 from functional.alltypes order by 2, 1");
        this.AnalyzesOk("select t1.int_col from functional.alltypes t1, functional.alltypes t2 where t1.id = t2.id order by int_col");
        this.AnalyzesOk("select int_col, INT_COL from functional.alltypes order by int_col");
        this.AnalyzesOk("select bool_col a, bool_col A from functional.alltypes order by a");
        this.AnalyzesOk("select int_col A, bool_col b, int_col a, bool_col B from functional.alltypes order by a, b");
        this.AnalysisError("select string_col a, int_col a from functional.alltypessmall order by a limit 1", "ORDER BY: ambiguous alias: 'a'");
        this.AnalysisError("select string_col a, int_col A from functional.alltypessmall order by a limit 1", "ORDER BY: ambiguous alias: 'a'");
        this.AnalyzesOk("select * from (select * from functional.alltypes order by int_col) A", "Ignoring ORDER BY clause without LIMIT or OFFSET: ORDER BY int_col ASC");
        this.AnalyzesOk("select * from functional.alltypes order by int_col desc union all select * from functional.alltypes", "Ignoring ORDER BY clause without LIMIT or OFFSET: ORDER BY int_col DESC");
        this.AnalyzesOk("insert into functional.alltypes partition (year, month) select * from functional.alltypes order by int_col", "Ignoring ORDER BY clause without LIMIT or OFFSET: ORDER BY int_col ASC");
        this.AnalyzesOk("create table functional.alltypescopy as select * from functional.alltypes order by int_col", "Ignoring ORDER BY clause without LIMIT or OFFSET: ORDER BY int_col ASC");
        this.AnalyzesOk("select extract(timestamp_col, 'hour') AS timestamp_col FROM functional.alltypes ORDER BY timestamp_col");
        this.AnalysisError("select * from functional_orc_def.complextypes_structs order by tiny_struct", "ORDER BY expression 'tiny_struct' with complex type 'STRUCT<b:BOOLEAN>' is not supported.");
        this.AnalysisError("select * from functional_parquet.allcomplextypes order by int_array_col", "ORDER BY expression 'int_array_col' with complex type 'ARRAY<INT>' is not supported.");
    }

    @Test
    public void TestSetOperations() {
        this.AnalyzesOk("select rank() over (order by int_col) from functional.alltypes intersect select int_col from functional.alltypessmall");
        this.AnalyzesOk("select int_col from functional.alltypes intersect select int_col from functional.alltypes");
        this.AnalyzesOk("select int_col from functional.alltypes union select int_col from functional.alltypes intersect select int_col from functional.alltypes except select int_col from functional.alltypes");
        this.AnalyzesOk("(select int_col from functional.alltypes intersect (select tinyint_col from functional.alltypessmall union  select tinyint_col from functional.alltypessmall) except  select tinyint_col from functional.alltypestiny where id = 1) union (select tinyint_col from functional.alltypessmall) ");
        this.AnalyzesOk("select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, year,month from functional.alltypes union select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, year,month from functional.alltypes");
        this.AnalyzesOk("select a.smallint_col from functional.alltypes a union select a.int_col from functional.alltypessmall a");
        this.AnalyzesOk("select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, year,month from functional.alltypes union select NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,NULL from functional.alltypes");
        this.AnalyzesOk("select 1, 2, 3 union select NULL, NULL, NULL union select 1.0, NULL, 3 union select NULL, 10, NULL");
        this.AnalyzesOk("select tinyint_col from functional.alltypes union select smallint_col from functional.alltypes union select int_col from functional.alltypes union select bigint_col from functional.alltypes");
        this.AnalyzesOk("select float_col from functional.alltypes union select double_col from functional.alltypes");
        this.AnalyzesOk("select tinyint_col, double_col from functional.alltypes union select smallint_col, float_col from functional.alltypes union select int_col, bigint_col from functional.alltypes union select bigint_col, int_col from functional.alltypes union select float_col, smallint_col from functional.alltypes union select double_col, tinyint_col from functional.alltypes");
        this.AnalyzesOk("(select int_col from functional.alltypes) union (select tinyint_col from functional.alltypessmall) order by int_col limit 1");
        this.AnalyzesOk("(select int_col from functional.alltypes) union (select tinyint_col from functional.alltypessmall) order by int_col");
        this.AnalyzesOk("(select int_col from functional.alltypes) union (select tinyint_col from functional.alltypessmall) order by int_col offset 5");
        this.AnalyzesOk("select int_col from functional.alltypes order by int_col union (select tinyint_col from functional.alltypessmall) ");
        this.AnalysisError("select int_col from functional.alltypes order by int_col offset 5 union (select tinyint_col from functional.alltypessmall) ", "Order-by with offset without limit not supported in nested queries");
        this.AnalysisError("select int_col from functional.alltypes offset 5 union (select tinyint_col from functional.alltypessmall) ", "OFFSET requires an ORDER BY clause: OFFSET 5");
        this.AnalyzesOk("select int_col from functional.alltypes union (select tinyint_col from functional.alltypessmall order by tinyint_col) ");
        this.AnalysisError("select int_col from functional.alltypes union (select tinyint_col from functional.alltypessmall order by tinyint_col offset 5) ", "Order-by with offset without limit not supported in nested queries");
        this.AnalysisError("select int_col from functional.alltypes union (select tinyint_col from functional.alltypessmall offset 5) ", "OFFSET requires an ORDER BY clause: OFFSET 5");
        this.AnalyzesOk("(select tinyint_col, double_col from functional.alltypes) union (select smallint_col, float_col from functional.alltypes) union (select int_col, bigint_col from functional.alltypes) union (select bigint_col, int_col from functional.alltypes) order by double_col, tinyint_col");
        this.AnalyzesOk("select int_col from functional.alltypes order by int_col union select int_col from functional.alltypes order by int_col limit 10 union (select int_col from functional.alltypes order by int_col limit 10 offset 5) order by int_col offset 5");
        this.AnalyzesOk("(select tinyint_col, double_col from functional.alltypes) union (select smallint_col, float_col from functional.alltypes) union (select int_col, bigint_col from functional.alltypes) union (select bigint_col, int_col from functional.alltypes) order by 2, 1");
        this.AnalysisError("select int_col from functional.alltypes union select int_col, float_col from functional.alltypes", "Operands have unequal number of columns:\n'SELECT int_col FROM functional.alltypes' has 1 column(s)\n'SELECT int_col, float_col FROM functional.alltypes' has 2 column(s)");
        this.AnalysisError("select int_col from functional.alltypes union select tinyint_col from functional.alltypes union select smallint_col from functional.alltypes union select smallint_col, bigint_col from functional.alltypes", "Operands have unequal number of columns:\n'SELECT int_col FROM functional.alltypes' has 1 column(s)\n'SELECT smallint_col, bigint_col FROM functional.alltypes' has 2 column(s)");
        this.AnalysisError("select bool_col from functional.alltypes union select lag(string_col) over(order by int_col) from functional.alltypes", "Incompatible return types 'BOOLEAN' and 'STRING' of exprs 'bool_col' and 'lag(string_col, 1, NULL)'.");
        this.AnalysisError("select int_col, string_col from functional.alltypes union select tinyint_col, bool_col from functional.alltypes union select smallint_col, int_col from functional.alltypes union select smallint_col, bool_col from functional.alltypes", "Incompatible return types 'STRING' and 'BOOLEAN' of exprs 'string_col' and 'bool_col'.");
        this.AnalysisError("(select int_col from functional.alltypes) union (select int_col from functional.alltypessmall) order by 2", "ORDER BY: ordinal exceeds the number of items in the SELECT list: 2");
        this.AnalysisError("(select int_col a, string_col a from functional.alltypes) union (select int_col a, string_col a from functional.alltypessmall) order by a", "ORDER BY: ambiguous alias: 'a'");
        this.AnalyzesOk("(select int_col a, string_col b from functional.alltypes) union (select int_col a, string_col a from functional.alltypessmall) order by a");
        this.AnalysisError("select int_col a, int_col a from functional.alltypes union all (select 1, bigint_col from functional.alltypessmall) order by a", "ORDER BY: ambiguous alias: 'a'");
        this.AnalysisError("(select smallint_col from functional.alltypes) union (select int_col from functional.alltypessmall) order by int_col", "Could not resolve column/field reference: 'int_col'");
        this.AnalysisError("select a.smallint_col from functional.alltypes a union select a.int_col from functional.alltypessmall", "Could not resolve column/field reference: 'a.int_col'");
        this.AnalyzesOk("select cast(1 as bigint) union select cast(1 as decimal(19, 0))");
        AnalysisContext decimalV1Ctx = this.createAnalysisCtx();
        decimalV1Ctx.getQueryOptions().setDecimal_v2(false);
        AnalysisContext decimalV2Ctx = this.createAnalysisCtx();
        decimalV2Ctx.getQueryOptions().setDecimal_v2(true);
        String query = "select cast(123 as decimal(38, 0)) union all select cast(0.789 as decimal(38, 38))";
        this.AnalyzesOk(query, decimalV1Ctx);
        this.AnalysisError(query, decimalV2Ctx, "Incompatible return types 'DECIMAL(38,0)' and 'DECIMAL(38,38)' of exprs 'CAST(123 AS DECIMAL(38,0))' and 'CAST(0.789 AS DECIMAL(38,38))'.");
        query = "select cast(123 as double) union all select cast(0.456 as float)union all select cast(0.789 as decimal(38, 38))";
        this.AnalyzesOk(query, decimalV1Ctx);
        this.AnalyzesOk(query, decimalV2Ctx);
    }

    @Test
    public void TestUnion() {
        this.AnalyzesOk("select rank() over (order by int_col) from functional.alltypes union select int_col from functional.alltypessmall");
        this.AnalyzesOk("select int_col from functional.alltypes union select int_col from functional.alltypes");
        this.AnalyzesOk("select int_col from functional.alltypes union select int_col from functional.alltypes union select int_col from functional.alltypes union select int_col from functional.alltypes");
        this.AnalyzesOk("select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, year,month from functional.alltypes union select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, year,month from functional.alltypes");
        this.AnalyzesOk("select a.smallint_col from functional.alltypes a union select a.int_col from functional.alltypessmall a");
        this.AnalyzesOk("select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, year,month from functional.alltypes union select NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,NULL from functional.alltypes");
        this.AnalyzesOk("select 1, 2, 3 union select NULL, NULL, NULL union select 1.0, NULL, 3 union select NULL, 10, NULL");
        this.AnalyzesOk("select tinyint_col from functional.alltypes union select smallint_col from functional.alltypes union select int_col from functional.alltypes union select bigint_col from functional.alltypes");
        this.AnalyzesOk("select float_col from functional.alltypes union select double_col from functional.alltypes");
        this.AnalyzesOk("select tinyint_col, double_col from functional.alltypes union select smallint_col, float_col from functional.alltypes union select int_col, bigint_col from functional.alltypes union select bigint_col, int_col from functional.alltypes union select float_col, smallint_col from functional.alltypes union select double_col, tinyint_col from functional.alltypes");
        this.AnalyzesOk("(select int_col from functional.alltypes) union (select tinyint_col from functional.alltypessmall) order by int_col limit 1");
        this.AnalyzesOk("(select int_col from functional.alltypes) union (select tinyint_col from functional.alltypessmall) order by int_col");
        this.AnalyzesOk("(select int_col from functional.alltypes) union (select tinyint_col from functional.alltypessmall) order by int_col offset 5");
        this.AnalyzesOk("select int_col from functional.alltypes order by int_col union (select tinyint_col from functional.alltypessmall) ");
        this.AnalysisError("select int_col from functional.alltypes order by int_col offset 5 union (select tinyint_col from functional.alltypessmall) ", "Order-by with offset without limit not supported in nested queries");
        this.AnalysisError("select int_col from functional.alltypes offset 5 union (select tinyint_col from functional.alltypessmall) ", "OFFSET requires an ORDER BY clause: OFFSET 5");
        this.AnalyzesOk("select int_col from functional.alltypes union (select tinyint_col from functional.alltypessmall order by tinyint_col) ");
        this.AnalysisError("select int_col from functional.alltypes union (select tinyint_col from functional.alltypessmall order by tinyint_col offset 5) ", "Order-by with offset without limit not supported in nested queries");
        this.AnalysisError("select int_col from functional.alltypes union (select tinyint_col from functional.alltypessmall offset 5) ", "OFFSET requires an ORDER BY clause: OFFSET 5");
        this.AnalyzesOk("(select tinyint_col, double_col from functional.alltypes) union (select smallint_col, float_col from functional.alltypes) union (select int_col, bigint_col from functional.alltypes) union (select bigint_col, int_col from functional.alltypes) order by double_col, tinyint_col");
        this.AnalyzesOk("select int_col from functional.alltypes order by int_col union select int_col from functional.alltypes order by int_col limit 10 union (select int_col from functional.alltypes order by int_col limit 10 offset 5) order by int_col offset 5");
        this.AnalyzesOk("(select tinyint_col, double_col from functional.alltypes) union (select smallint_col, float_col from functional.alltypes) union (select int_col, bigint_col from functional.alltypes) union (select bigint_col, int_col from functional.alltypes) order by 2, 1");
        this.AnalysisError("select int_col from functional.alltypes union select int_col, float_col from functional.alltypes", "Operands have unequal number of columns:\n'SELECT int_col FROM functional.alltypes' has 1 column(s)\n'SELECT int_col, float_col FROM functional.alltypes' has 2 column(s)");
        this.AnalysisError("select int_col from functional.alltypes union select tinyint_col from functional.alltypes union select smallint_col from functional.alltypes union select smallint_col, bigint_col from functional.alltypes", "Operands have unequal number of columns:\n'SELECT int_col FROM functional.alltypes' has 1 column(s)\n'SELECT smallint_col, bigint_col FROM functional.alltypes' has 2 column(s)");
        this.AnalysisError("select bool_col from functional.alltypes union select lag(string_col) over(order by int_col) from functional.alltypes", "Incompatible return types 'BOOLEAN' and 'STRING' of exprs 'bool_col' and 'lag(string_col, 1, NULL)'.");
        this.AnalysisError("select int_col, string_col from functional.alltypes union select tinyint_col, bool_col from functional.alltypes union select smallint_col, int_col from functional.alltypes union select smallint_col, bool_col from functional.alltypes", "Incompatible return types 'STRING' and 'BOOLEAN' of exprs 'string_col' and 'bool_col'.");
        this.AnalysisError("(select int_col from functional.alltypes) union (select int_col from functional.alltypessmall) order by 2", "ORDER BY: ordinal exceeds the number of items in the SELECT list: 2");
        this.AnalysisError("(select int_col a, string_col a from functional.alltypes) union (select int_col a, string_col a from functional.alltypessmall) order by a", "ORDER BY: ambiguous alias: 'a'");
        this.AnalyzesOk("(select int_col a, string_col b from functional.alltypes) union (select int_col a, string_col a from functional.alltypessmall) order by a");
        this.AnalysisError("select int_col a, int_col a from functional.alltypes union all (select 1, bigint_col from functional.alltypessmall) order by a", "ORDER BY: ambiguous alias: 'a'");
        this.AnalysisError("(select smallint_col from functional.alltypes) union (select int_col from functional.alltypessmall) order by int_col", "Could not resolve column/field reference: 'int_col'");
        this.AnalysisError("select a.smallint_col from functional.alltypes a union select a.int_col from functional.alltypessmall", "Could not resolve column/field reference: 'a.int_col'");
        this.AnalyzesOk("select cast(1 as bigint) union select cast(1 as decimal(19, 0))");
        AnalysisContext decimalV1Ctx = this.createAnalysisCtx();
        decimalV1Ctx.getQueryOptions().setDecimal_v2(false);
        AnalysisContext decimalV2Ctx = this.createAnalysisCtx();
        decimalV2Ctx.getQueryOptions().setDecimal_v2(true);
        String query = "select cast(123 as decimal(38, 0)) union all select cast(0.789 as decimal(38, 38))";
        this.AnalyzesOk(query, decimalV1Ctx);
        this.AnalysisError(query, decimalV2Ctx, "Incompatible return types 'DECIMAL(38,0)' and 'DECIMAL(38,38)' of exprs 'CAST(123 AS DECIMAL(38,0))' and 'CAST(0.789 AS DECIMAL(38,38))'.");
        query = "select cast(123 as double) union all select cast(0.456 as float)union all select cast(0.789 as decimal(38, 38))";
        this.AnalyzesOk(query, decimalV1Ctx);
        this.AnalyzesOk(query, decimalV2Ctx);
    }

    @Test
    public void TestValuesStmt() throws AnalysisException {
        this.AnalyzesOk("values(1, 2, 3)");
        this.AnalyzesOk("select * from (values('a', NULL, 'c')) as t");
        this.AnalyzesOk("values(1.0, 2, NULL) union all values(1, 2.0, 3)");
        this.AnalyzesOk("insert overwrite table functional.alltypes partition (year=2009, month=10)values(1, true, 1, 1, 1, 1, cast(1.0 as float), cast(1.0 as double), 'a', 'a', cast(0 as timestamp))");
        this.AnalyzesOk("insert overwrite table functional.alltypes partition (year, month) values(1, true, 1, 1, 1, 1, cast(1.0 as float), cast(1.0 as double), 'a', 'a', cast(0 as timestamp), 2009, 10)");
        Assert.assertEquals((Object)"SELECT 1", (Object)this.AnalyzesOk("values (1)").toSql(ToSqlOptions.REWRITTEN));
        this.AnalyzesOk("values((1, 2, 3), (4, 5, 6))");
        this.AnalyzesOk("select * from (values('a', 'b', 'c')) as t");
        this.AnalyzesOk("select * from (values(('a', 'b', 'c'), ('d', 'e', 'f'))) as t");
        this.AnalyzesOk("values((1.0, 2, NULL), (2.0, 3, 4)) union all values(1, 2.0, 3)");
        this.AnalyzesOk("insert overwrite table functional.alltypes partition (year=2009, month=10) values((1, true, 1, 1, 1, 1, cast(1.0 as float), cast(1.0 as double), 'a', 'a', cast(0 as timestamp)),(2, false, 2, 2, NULL, 2, cast(2.0 as float), cast(2.0 as double), 'b', 'b', cast(0 as timestamp)),(3, true, 3, 3, 3, 3, cast(3.0 as float), cast(3.0 as double), 'c', 'c', cast(0 as timestamp)))");
        this.AnalyzesOk("insert overwrite table functional.alltypes partition (year, month) values((1, true, 1, 1, 1, 1, cast(1.0 as float), cast(1.0 as double), 'a', 'a', cast(0 as timestamp), 2009, 10),(2, false, 2, 2, NULL, 2, cast(2.0 as float), cast(2.0 as double), 'b', 'b', cast(0 as timestamp), 2009, 2),(3, true, 3, 3, 3, 3, cast(3.0 as float), cast(3.0 as double), 'c', 'c', cast(0 as timestamp), 2009, 3))");
        Assert.assertEquals((Object)"SELECT 1 UNION ALL SELECT 2", (Object)this.AnalyzesOk("values (1), (2)").toSql(ToSqlOptions.REWRITTEN));
        this.AnalyzesOk("values((1 as x, 'a' as y), (2 as k, 'b' as j))");
        this.AnalyzesOk("values(1 as x, 'a') order by 2 limit 10");
        this.AnalyzesOk("values(1 as x, 'a' as y), (2, 'b') order by y limit 10");
        this.AnalyzesOk("values((1, 'a'), (2, 'b')) order by 1 limit 10");
        this.AnalyzesOk("values((1, 'a'), (2, 'b')) order by 2");
        this.AnalyzesOk("values((1, 'a'), (2, 'b')) order by 1 offset 5");
        this.AnalysisError("values((1, 'a'), (2, 'b')) offset 5", "OFFSET requires an ORDER BY clause: OFFSET 5");
        this.AnalysisError("values(1, 'a', 1.0, *)", "'*' expression in select list requires FROM clause.");
        this.AnalysisError("values(sum(1), 'a', 1.0)", "aggregation without a FROM clause is not allowed");
        this.AnalysisError("values(1, id, 2)", "Could not resolve column/field reference: 'id'");
        this.AnalysisError("values((1 as x, 'a' as y), (2, 'b')) order by c limit 1", "Could not resolve column/field reference: 'c'");
        this.AnalysisError("values((1, 2), (3, 4, 5))", "Operands have unequal number of columns:\n'(1, 2)' has 2 column(s)\n'(3, 4, 5)' has 3 column(s)");
        this.AnalysisError("values((1, 'a'), (3, 4))", "Incompatible return types 'STRING' and 'TINYINT' of exprs ''a'' and '4'");
        this.AnalysisError("insert overwrite table functional.alltypes partition (year, month) values(1, true, 'a', 1, 1, 1, 1.0, 1.0, 'a', 'a', cast(0 as timestamp),2009, 10)", "Target table 'functional.alltypes' is incompatible with source expressions.\nExpression ''a'' (type: STRING) is not compatible with column 'tinyint_col' (type: TINYINT)");
        this.AnalysisError("values (true), (123), (111.0)", "Incompatible return types 'BOOLEAN' and 'DECIMAL(4,1)' of exprs 'TRUE' and '111.0'");
    }

    @Test
    public void TestWithClause() throws AnalysisException {
        this.AnalyzesOk("with t as (select int_col x, bigint_col y from functional.alltypes) select x, y from t");
        this.AnalyzesOk("with t(c1, c2) as (select int_col x, bigint_col y from functional.alltypes) select c1, c2 from t");
        this.AnalyzesOk("with t(c1) as (select int_col, bigint_col y from functional.alltypes) select c1, y from t");
        this.AnalyzesOk("with t1 as (select int_col x, bigint_col y from functional.alltypes), t2 as (select 1 x, 10 y), t3 as (values(2 x, 20 y), (3, 30)), t4 as (select 4 x, 40 y union all select 5, 50), t5 as (select * from (values(6 x, 60 y)) as a) select x, y from t3");
        this.AnalyzesOk("with t1(c1, c2) as (select int_col, bigint_col from functional.alltypes), t2(c1, c2) as (select 1, 10), t3(a, b) as (values(2, 5), (3, 30)), t4(c1, c2) as (select 4, 40 union all select 5, 50), t5 as (select * from (values(6, 60)) as a) select a, b from t3");
        this.AnalyzesOk("with t1 as (select int_col x, bigint_col y from functional.alltypes), t2 as (select 1 x , 10 y), t3 as (values(2 x , 20 y), (3, 30)), t4 as (select 4 x, 40 y union all select 5, 50), t5 as (select * from (values(6 x, 60 y)) as a) select * from t1 union all select * from t2 union all select * from t3 union all select * from t4 union all select * from t5");
        this.AnalyzesOk("with t1 as (select int_col x, bigint_col y from functional.alltypes), t2 as (select 1 x , 10 y), t3 as (values(2 x , 20 y), (3, 30)), t4 as (select 4 x, 40 y union all select 5, 50), t5 as (select * from (values(6 x, 60 y)) as a) select t1.y, t2.y, t3.y, t4.y, t5.y from t1, t2, t3, t4, t5 where t1.y = t2.y and t2.y = t3.y and t3.y = t4.y and t4.y = t5.y");
        this.AnalyzesOk("with t1(c1, c2) as (select int_col x, bigint_col y from functional.alltypes), t2(c1, c2) as (select 1 x , 10 y), t3 as (values(2 x , 20 y), (3, 30)), t4 as (select 4 x, 40 y union all select 5, 50), t5 as (select * from (values(6 x, 60 y)) as a) select t1.c2, t2.c2, t3.y, t4.y, t5.y from t1, t2, t3, t4, t5 where t1.c2 = t2.c2 and t2.c2 = t3.y and t3.y = t4.y and t4.y = t5.y");
        this.AnalyzesOk("with t1 as (select * from functional.alltypestiny)insert into functional.alltypes partition(year, month) select * from t1");
        this.AnalyzesOk("with t1(c1, c2) as (select * from functional.alltypestiny)insert into functional.alltypes partition(year, month) select * from t1");
        this.AnalyzesOk("with test_ctas_1 as (select * from functional.alltypestiny) insert into functional.alltypes partition (year, month) with with_1 as (select t1.* from test_ctas_1 as t1 right join (select 1 as int_col from functional.alltypestiny as t1) as t2 ON t2.int_col = t1.int_col) select * from with_1 limit 10");
        this.AnalyzesOk("insert into functional.alltypes partition (year, month) with with_1 as (select t1.* from functional.alltypes as t1 right join (select * from functional.alltypestiny as t1) t2 on t1.int_col = t2.int_col) select * from with_1 limit 10");
        this.AnalyzesOk("with t1 as (select id from functional.alltypestiny) insert into functional.alltypes partition(year, month) with t1 as (select * from functional.alltypessmall) select * from t1");
        this.AnalyzesOk("with t(c1, c2) as (select * from functional.alltypes) select a.c1, a.c2 from t a");
        this.AnalyzesOk("with t1 as (select 'a') select * from (select * from t1) as t2");
        this.AnalyzesOk("with t1 as (select 'a') select * from (select * from (select * from t1) as t2) as t3");
        this.AnalyzesOk("select * from (with t1 as (values(1 x, 10 y)) select * from t1) as t2");
        this.AnalyzesOk("with T1 as (select int_col x, bigint_col y from functional.alltypes),t2 as (select 1 x , 10 y), T3 as (values(2 x , 20 y), (3, 30)), t4 as (select 4 x, 40 y union all select 5, 50), T5 as (select * from (values(6 x, 60 y)) as a) select * from t1 union all select * from T2 union all select * from t3 union all select * from T4 union all select * from t5");
        this.AnalyzesOk("with t1 as (values('a', 'b')) (with t2 as (values('c', 'd')) select * from t2) union all(with t3 as (values('e', 'f')) select * from t3) order by 1 limit 1");
        this.AnalyzesOk("with t1 as (select * from functional.alltypestiny) insert into functional.alltypes partition(year, month) with t2 as (select * from functional.alltypessmall) select * from t1");
        this.AnalyzesOk("with t1 as (select 'a') select t2.* from (with t1 as (select 'b') select * from t1) as t2");
        this.AnalyzesOk("with t1(c1) as (select 'a') select c1 from (with t1(c1) as (select 'b') select c1 from t1) as t2");
        this.AnalyzesOk("with t1 as (select 1), t2 as (select 2)select * from functional.alltypes as t1");
        this.AnalyzesOk("with t1 as (select 1), t2 as (select 2) select * from t2 as t1");
        this.AnalyzesOk("with t1 as (select 1) select * from (select 2) as t1");
        this.AnalyzesOk("with alltypes as (select * from functional.alltypes) select * from functional.alltypes union all select * from alltypes");
        this.AnalyzesOk("with t(c1) as (select id from functional.alltypes) select a.c1 from t a");
        this.AnalyzesOk("with t1 as (select int_col x, bigint_col y from alltypes), alltypes as (select x a, y b from t1)select a, b from alltypes", this.createAnalysisCtx("functional"));
        this.AnalyzesOk("with t1 as (select abc x, xyz y from complex_view), complex_view as (select x a, y b from t1)select a, b from complex_view", this.createAnalysisCtx("functional"));
        this.AnalyzesOk("with t1 as (with t1 as (select int_col x, bigint_col y from alltypes) select x, y from t1), alltypes as (select x a, y b from t1) select a, b from alltypes", this.createAnalysisCtx("functional"));
        this.AnalyzesOk("with t1 as (select * from (with t2 as (select * from functional.alltypes) select * from t2) t3) select * from t1");
        this.AnalyzesOk("with t1 as (with t2 as (values('a', 'b')) select * from t2 union all select * from t2) select * from t1");
        this.AnalyzesOk("with t1 as (select 'x', 'y' union all (with t2 as (values('a', 'b')) select * from t2)) select * from t1");
        this.AnalyzesOk("with t as (select 1 x)select x from t union all select x from t");
        this.AnalyzesOk("with t as (select 'a' x)select t1.x, t2.x, t.x from t as t1, t as t2, t where t1.x = t2.x and t2.x = t.x");
        this.AnalyzesOk("with t as (select int_col + 2, !bool_col from functional.alltypes) select `int_col + 2`, `NOT bool_col` from t");
        this.AnalyzesOk("select 1 from (with w as (select 1 from functional.alltypes where exists (select 1 from functional.alltypes)) select 1 from w) tt");
        this.AnalyzesOk("create table test_with as select 1 from (with w as (select 1 from functional.alltypes where exists (select 1 from functional.alltypes)) select 1 from w) tt");
        this.AnalyzesOk("insert into functional.alltypesnopart (id) select 1 from (with w as (select 1 from functional.alltypes where exists (select 1 from functional.alltypes)) select 1 from w) tt");
        this.AnalysisError("with t1 as (select 1), t1 as (select 2) select * from t1", "Duplicate table alias: 't1'");
        this.AnalysisError("with t1 as (select 1 x), t2 as (select 2 y)select * from functional.alltypes as t1 inner join t1", "Duplicate table alias: 't1'");
        this.AnalysisError("with t1 as (select 1), t2 as (select 2) select * from t2 as t1 inner join t1", "Duplicate table alias: 't1'");
        this.AnalysisError("with t1 as (select 1) select * from (select 2) as t1 inner join t1", "Duplicate table alias: 't1'");
        this.AnalysisError("with t1(c1) as (select id cnt from functional.alltypes) select cnt from t1", "Could not resolve column/field reference: 'cnt'");
        this.AnalysisError("with t(c1, c2) as (select id from functional.alltypes) select * from t", "WITH-clause view 't' returns 1 columns, but 2 labels were specified. The number of column labels must be smaller or equal to the number of returned columns.");
        this.AnalysisError("with t1 as (select 'a' x) select * from t1 inner join t1", "Duplicate table alias: 't1'");
        this.AnalysisError("with t1 as (select 'a' x) select t1.x from t1 as t2", "Could not resolve column/field reference: 't1.x'");
        this.AnalysisError("with t1 as (select 'a' x) insert into t1 values('b' x)", "Table does not exist: default.t1");
        this.AnalyzesOk("with alltypes_view as (select int_col x from alltypes_view) select x from alltypes_view", this.createAnalysisCtx("functional"));
        this.AnalysisError("with t as (select int_col x, bigint_col y from t1) select x, y from t", "Could not resolve table reference: 't1'");
        this.AnalysisError("with t as (select 1 as x, 2 as y union all select * from t) select x, y from t", "Could not resolve table reference: 't'");
        this.AnalysisError("with t as (select a.* from (select * from t) as a) select x, y from t", "Could not resolve table reference: 't'");
        this.AnalysisError("with t1 as (with t2 as (select * from t1) select * from t2) select * from t1 ", "Could not resolve table reference: 't1'");
        this.AnalysisError("with t1 as (select * from (with t2 as (select * from t1) select * from t2) t3) select * from t1", "Could not resolve table reference: 't1'");
        this.AnalysisError("with t1 as (with t2 as (select * from t1) select * from t2 union all select * from t2)select * from t1", "Could not resolve table reference: 't1'");
        this.AnalysisError("with t1 as (select 'x', 'y' union all (with t2 as (select * from t1) select * from t2))select * from t1", "Could not resolve table reference: 't1'");
        this.AnalysisError("with t1 as (select int_col x, bigint_col y from t2), t2 as (select int_col x, bigint_col y from t1) select x, y from t1", "Could not resolve table reference: 't2'");
        this.AnalyzesOk("with t as (select * from functional.alltypesagg where id in (select id from functional.alltypes)) select int_col from t");
        this.AnalyzesOk("with t as (select * from functional.alltypes) select * from functional.alltypesagg a where exists (select id from t where t.id = a.id)");
        this.AnalyzesOk("with t as (select * from functional.alltypes) select * from functional.alltypesagg where 10 > (select count(*) from t) and 100 < (select max(int_col) from t)");
        this.AnalyzesOk("with t as (select * from functional.alltypes a where exists (select * from functional.alltypesagg t where t.id = 1 and a.id = t.id) and not exists (select * from functional.alltypesagg b where b.id = 1 and b.int_col = a.int_col)) select * from t");
        this.AnalyzesOk("with w as (select t.id, a.item from functional.allcomplextypes t, t.int_array_col a) select * from w");
        this.AnalyzesOk("with with_1 as (select 1 as int_col_1), with_2 as (select 1 as int_col_1 from (with with_3 as (select 1 as int_col_1 from with_1) select 1 as int_col_1 from with_3) as t1) select 1 as int_col_1 from with_2");
        this.AnalyzesOk("with with_1 as (select 1 as int_col_1), with_2 as (select 1 as int_col_1 from (with with_3 as (select 1 as int_col_1 from with_1) select 1 as int_col_1 from with_3) as t1), with_4 as (select 1 as int_col_1 from with_2) select 1 as int_col_1 from with_4");
        this.AnalyzesOk("with with_1 as (select 1 as int_col_1), with_2 as (with with_3 as (select 1 as int_col_1 from (with with_4 as (select 1 as int_col_1 from with_1) select 1 as int_col_1 from with_4) as t1) select 1 as int_col_1 from with_3) select 1 as int_col_1 from with_2");
        this.AnalyzesOk("with with_1 as (select int_col from functional.alltypestiny where int_col between 0 and 10) select * from with_1");
        this.AnalyzesOk("with with_1 as (select int_col between 0 and 10 from functional.alltypestiny) select * from with_1");
        this.AnalyzesOk("with with_1 as (select timestamp_col between cast('2001-01-01' as timestamp) and (cast('2001-01-01' as timestamp) + interval 10 days) from functional.alltypestiny) select * from with_1");
        this.AnalyzesOk("with with_1 as (select * from functional.alltypestiny where timestamp_col between cast('2001-01-01' as timestamp) and (cast('2001-01-01' as timestamp) + interval 10 days)) select * from with_1");
        this.AnalyzesOk("with with_1 as (select 1 as col_name), with_2 as (select 1 as col_name) select a.tinyint_col from functional.alltypes a where not exists (select 1 from with_1) ");
    }

    @Test
    public void TestViews() throws AnalysisException {
        this.AnalyzesOk("select * from functional.alltypes_view");
        this.AnalyzesOk("select x, y, z from functional.alltypes_view_sub");
        this.AnalyzesOk("select abc, xyz from functional.complex_view");
        this.AnalyzesOk("select * from functional.view_view");
        this.AnalyzesOk("select t.x, t.y, t.z from functional.alltypes_view_sub t");
        this.AnalyzesOk("select * from functional.alltypes_view_sub union all select * from functional.alltypes_view_sub");
        this.AnalyzesOk("select t.* from (select * from functional.alltypes_view_sub) t");
        this.AnalyzesOk("with t as (select * from functional.complex_view) select abc, xyz from t");
        this.AnalyzesOk("select sum(t1.abc), t2.xyz from functional.complex_view t1 inner join functional.complex_view t2 on (t1.abc = t2.abc) group by t2.xyz");
        this.AnalysisError("insert into functional.alltypes_view partition(year, month) select * from functional.alltypes", "Impala does not support INSERTing into views: functional.alltypes_view");
        this.AnalysisError("load data inpath '/test-warehouse/tpch.lineitem/lineitem.tbl' into table functional.alltypes_view", "LOAD DATA only supported for HDFS tables: functional.alltypes_view");
        this.AnalysisError("select * from functional.alltypes_view_sub inner join functional.alltypes_view_sub", "Duplicate table alias: 'functional.alltypes_view_sub'");
        this.AnalysisError("select int_col from functional.alltypes_view_sub", "Could not resolve column/field reference: 'int_col'");
    }

    @Test
    public void TestLoadData() throws AnalysisException {
        for (String overwrite : Lists.newArrayList((Object[])new String[]{"", "overwrite"})) {
            this.AnalyzesOk(String.format("load data inpath '%s' %s into table tpch.lineitem", "/test-warehouse/tpch.lineitem/lineitem.tbl", overwrite));
            this.AnalyzesOk(String.format("load data inpath '%s' %s into table tpch.lineitem", "/test-warehouse/tpch.lineitem/", overwrite));
            this.AnalyzesOk(String.format("load data inpath '%s' %s into table functional.alltypes partition(year=2009, month=12)", "/test-warehouse/tpch.lineitem/", overwrite));
            this.AnalysisError(String.format("load data inpath '%s' %s into table tpch.lineitem", "/test-warehouse/", overwrite), "INPATH location 'hdfs://localhost:20500/test-warehouse' cannot contain non-hidden subdirectories.");
            this.AnalysisError(String.format("load data inpath '%s' %s into table tpch.lineitem", "/test-warehouse/emptytable", overwrite), "INPATH location 'hdfs://localhost:20500/test-warehouse/emptytable' contains no visible files.");
            this.AnalysisError(String.format("load data inpath '%s' %s into table tpch.lineitem", "/test-warehouse/alltypessmall/year=2009/month=1/.hidden", overwrite), "INPATH location 'hdfs://localhost:20500/test-warehouse/alltypessmall/year=2009/month=1/.hidden' points to a hidden file.");
            this.AnalysisError(String.format("load data inpath '%s' %s into table tpch.lineitem", "/test-warehouse/alltypessmall/year=2009/month=1/_hidden", overwrite), "INPATH location 'hdfs://localhost:20500/test-warehouse/alltypessmall/year=2009/month=1/_hidden' points to a hidden file.");
            this.AnalysisError(String.format("load data inpath '%s' %s into table tpch.lineitem", "/test-warehouse/does_not_exist", overwrite), "INPATH location 'hdfs://localhost:20500/test-warehouse/does_not_exist' does not exist.");
            this.AnalysisError(String.format("load data inpath '%s' %s into table tpch.lineitem", "", overwrite), "URI path cannot be empty.");
            this.AnalysisError(String.format("load data inpath '%s' %s into table functional.alltypes partition(year=123, month=10)", "/test-warehouse/tpch.lineitem/", overwrite), "Partition spec does not exist: (year=123, month=10)");
            this.AnalysisError(String.format("load data inpath '%s' %s into table functional_hbase.alltypessmall", "/test-warehouse/tpch.lineitem/", overwrite), "LOAD DATA only supported for HDFS tables: functional_hbase.alltypessmall");
            this.AnalysisError(String.format("load data inpath '%s' %s into table functional.alltypes", "/test-warehouse/tpch.lineitem/", overwrite), "Table is partitioned but no partition spec was specified: functional.alltypes");
            this.AnalysisError(String.format("load data inpath '%s' %s into table nodb.alltypes", "/test-warehouse/tpch.lineitem/", overwrite), "Database does not exist: nodb");
            this.AnalysisError(String.format("load data inpath '%s' %s into table functional.notbl", "/test-warehouse/tpch.lineitem/", overwrite), "Table does not exist: functional.notbl");
            this.AnalysisError(String.format("load data inpath '%s' %s into table tpch.lineitem", "file:///test-warehouse/test.out", overwrite), "INPATH location 'file:/test-warehouse/test.out' must point to one of the supported filesystem URI scheme (" + FileSystemUtil.getValidLoadDataInpathSchemes() + ").");
            this.AnalyzesOk(String.format("load data inpath '%s' %s into table tpch.lineitem", "/test-warehouse/alltypes_text_gzip/year=2009/month=4", overwrite));
            this.AnalyzesOk(String.format("load data inpath '%s' %s into table functional_text_gzip.alltypes partition(year=2009, month=4)", "/test-warehouse/alltypes_text_gzip/year=2009/month=4", overwrite));
            this.AnalyzesOk(String.format("load data inpath '%s' %s into table functional_text_gzip.jointbl", "/test-warehouse/alltypes_text_gzip/year=2009/month=4", overwrite));
            this.AnalysisError(String.format("load data inpath '%s' into table functional_seq.alltypes partition(year=2009, month=3)", "/test-warehouse/alltypes_seq/year=2009/month=5", overwrite), "Unable to LOAD DATA into target table (functional_seq.alltypes) because Impala does not have WRITE access to HDFS location: hdfs://localhost:20500/test-warehouse/alltypes_seq/year=2009/month=3");
        }
    }

    @Test
    public void TestIcebergLoadData() throws AnalysisException {
        this.AnalyzesOk("load data inpath '/test-warehouse/iceberg_test/iceberg_non_partitioned/data' into table functional_parquet.iceberg_non_partitioned");
        this.AnalyzesOk("load data inpath '/test-warehouse/iceberg_test/iceberg_non_partitioned/data' overwrite into table functional_parquet.iceberg_non_partitioned");
        this.AnalysisError("load data inpath '/test-warehouse/iceberg_test/iceberg_partitioned/data/event_time_hour=2020-01-01-08/action=view/' into table functional_parquet.iceberg_partitioned partition (event_time_hour='2020-01-01-08', action='view');", "PARTITION clause is not supported for Iceberg tables.");
    }

    @Test
    public void TestInsert() throws AnalysisException {
        for (String qualifier : ImmutableList.of((Object)"INTO", (Object)"OVERWRITE")) {
            this.testInsertStatic(qualifier);
            this.testInsertDynamic(qualifier);
            this.testInsertUnpartitioned(qualifier);
            this.testInsertWithPermutation(qualifier);
        }
        this.AnalysisError("insert into functional_seq.alltypes partition(year, month)select * from functional.alltypes", "Unable to INSERT into target table (functional_seq.alltypes) because Impala does not have WRITE access to HDFS location: hdfs://localhost:20500/test-warehouse/alltypes_seq");
        this.AnalyzesOk("insert into table functional.alltypessmall partition (year, month)select a.id, bool_col, tinyint_col, smallint_col, item, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, a.year, b.month from functional.alltypes a, functional.allcomplextypes b, (select item from b.int_array_col) v1 where a.id = b.id");
        this.AnalysisError("insert into table functional.alltypessmall partition (year, month)select a.id, a.bool_col, a.tinyint_col, a.smallint_col, item, a.bigint_col, a.float_col, a.double_col, a.date_string_col, a.string_col, a.timestamp_col, a.year, b.month from functional.alltypes a, functional.allcomplextypes b, (select item from b.int_array_col, functional.alltypestiny) v1 where a.id = b.id", "Nested query is illegal because it contains a table reference 'b.int_array_col' correlated with an outer block as well as an uncorrelated one 'functional.alltypestiny':\nSELECT item FROM b.int_array_col, functional.alltypestiny");
        this.AnalysisError("insert into functional_kudu.testtbl(zip) values(1)", "All primary key columns must be specified for INSERTing into Kudu tables. Missing columns are: id");
        this.AnalyzesOk("insert into functional_kudu.alltypes (ID, BOOL_COL) values (0, true)");
        this.addTestDb("d", null);
        this.addTestTable("create table d.dec1 (c decimal(38,37)) location '/'");
        this.addTestTable("create table d.dec2 (c decimal(38,1)) location '/'");
        this.addTestTable("create table d.dbl (c double) location '/'");
        this.addTestTable("create table d.flt (c float) location '/'");
        AnalysisContext decimalV1Ctx = this.createAnalysisCtx("d");
        decimalV1Ctx.getQueryOptions().setDecimal_v2(false);
        AnalysisContext decimalV2Ctx = this.createAnalysisCtx("d");
        decimalV2Ctx.getQueryOptions().setDecimal_v2(true);
        this.AnalyzesOk("insert into d.dec1 select cast(1 as decimal(38, 0))", decimalV1Ctx);
        this.AnalysisError("insert into d.dec1 select cast(1 as decimal(38, 0))", decimalV2Ctx, "Target table 'd.dec1' is incompatible with source expressions.\nExpression 'CAST(1 AS DECIMAL(38,0))' (type: DECIMAL(38,0)) is not compatible with column 'c' (type: DECIMAL(38,37))");
        this.AnalysisError("insert into d.dec2 select cast(11.1 as decimal(38, 20));", decimalV1Ctx, "Possible loss of precision for target table 'd.dec2'.\nExpression 'CAST(11.1 AS DECIMAL(38,20))' (type: DECIMAL(38,20)) would need to be cast to DECIMAL(38,1) for column 'c'");
        this.AnalysisError("insert into d.dec2 select cast(11.1 as decimal(38, 20));", decimalV2Ctx, "Target table 'd.dec2' is incompatible with source expressions.\nExpression 'CAST(11.1 AS DECIMAL(38,20))' (type: DECIMAL(38,20)) is not compatible with column 'c' (type: DECIMAL(38,1))");
        this.AnalysisError("insert into d.dec1 select cast(1 as double)", decimalV1Ctx, "Possible loss of precision for target table 'd.dec1'.\nExpression 'CAST(1 AS DOUBLE)' (type: DOUBLE) would need to be cast to DECIMAL(38,37) for column 'c'");
        this.AnalysisError("insert into d.dec1 select cast(1 as double)", decimalV2Ctx, "Possible loss of precision for target table 'd.dec1'.\nExpression 'CAST(1 AS DOUBLE)' (type: DOUBLE) would need to be cast to DECIMAL(38,37) for column 'c'");
        this.AnalysisError("insert into d.dec1 select cast(1 as float)", decimalV1Ctx, "Possible loss of precision for target table 'd.dec1'.\nExpression 'CAST(1 AS FLOAT)' (type: FLOAT) would need to be cast to DECIMAL(38,37) for column 'c'");
        this.AnalysisError("insert into d.dec1 select cast(1 as float)", decimalV2Ctx, "Possible loss of precision for target table 'd.dec1'.\nExpression 'CAST(1 AS FLOAT)' (type: FLOAT) would need to be cast to DECIMAL(38,37) for column 'c'");
        this.AnalyzesOk("insert into d.dbl select cast(1 as decimal(20, 10))", decimalV1Ctx);
        this.AnalyzesOk("insert into d.dbl select cast(1 as decimal(20, 10))", decimalV2Ctx);
        this.AnalyzesOk("insert into d.flt select cast(1 as decimal(20, 10))", decimalV1Ctx);
        this.AnalyzesOk("insert into d.flt select cast(1 as decimal(20, 10))", decimalV2Ctx);
        String query = "insert into functional.testtbl (id) values (10), (cast(1 as float)), (cast(3 as double))";
        this.AnalysisError(query, "Possible loss of precision for target table 'functional.testtbl'.\nExpression 'CAST(3 AS DOUBLE)' (type: DOUBLE) would need to be cast to BIGINT for column 'id'");
        query = "insert into functional.testtbl (id) values (cast(1 as float)), (cast(2 as float)), (cast(3 as float))";
        this.AnalysisError(query, "Possible loss of precision for target table 'functional.testtbl'.\nExpression 'CAST(1 AS FLOAT)' (type: FLOAT) would need to be cast to BIGINT for column 'id'");
        query = "insert into functional.alltypes (int_col, float_col) partition(year=2019, month=4) (select int_col, float_col from functional.alltypes union select float_col, double_col from functional.alltypes union select double_col, int_col from functional.alltypes)";
        this.AnalysisError(query, "Possible loss of precision for target table 'functional.alltypes'.\nExpression 'double_col' (type: DOUBLE) would need to be cast to INT for column 'int_col'");
    }

    private void testInsertDynamic(String qualifier) throws AnalysisException {
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year, month)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, year, month from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year, month)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, NULL, NULL from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year, month)select NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year, month)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, month, year from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year=2009, month)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, month from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year=NULL, month)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, year from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year, month=4)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, year from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year, month=NULL)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, year from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year=2009, month)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, NULL from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year, month=4)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, NULL from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall Partition (year=2009, month=NULL)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year=NULL, month=4)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year, month)select * from functional.alltypes");
        this.AnalysisError("insert " + qualifier + " table functional.alltypessmall partition (year, month)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes", "Target table 'functional.alltypessmall' has more columns (13) than the SELECT / VALUES clause and PARTITION clause return (11)");
        this.AnalysisError("insert " + qualifier + " table functional.alltypessmall partition (year=2009, month)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes", "Target table 'functional.alltypessmall' has more columns (13) than the SELECT / VALUES clause and PARTITION clause return (12)");
        this.AnalysisError("insert " + qualifier + " table functional.alltypessmall partition (year=rank() over(order by int_col), month)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, month from functional.alltypes", "Non-constant expressions are not supported as static partition-key values in 'year=rank() OVER (ORDER BY int_col ASC)'");
        this.AnalysisError("insert " + qualifier + " table functional.alltypessmall partition (year, month=4)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes", "Target table 'functional.alltypessmall' has more columns (13) than the SELECT / VALUES clause and PARTITION clause return (12)");
        this.AnalysisError("insert " + qualifier + " table functional.alltypessmall partition (year=2009, month=4)select * from functional.alltypes", "Target table 'functional.alltypessmall' has fewer columns (13) than the SELECT / VALUES clause and PARTITION clause return (15)");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (YEAR, month)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, year, month from functional.alltypes");
        this.AnalysisError("insert into table functional.multipartformat partition (p) select 'parquet', 1", "Destination table 'functional.multipartformat' contains partition format(s) that are not supported to write: 'ORC', dynamic partition clauses are forbidden.");
    }

    private void testInsertUnpartitioned(String qualifier) throws AnalysisException {
        this.AnalysisError("insert " + qualifier + " table functional.alltypesnopart select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col from functional.alltypes", "Target table 'functional.alltypesnopart' has more columns (11) than the SELECT / VALUES clause returns (10)");
        if (!qualifier.contains("OVERWRITE")) {
            this.AnalysisError("INSERT " + qualifier + " TABLE functional_hbase.alltypes SELECT * FROM functional.alltypesagg", "Target table 'functional_hbase.alltypes' has fewer columns (13) than the SELECT / VALUES clause returns (14)");
        }
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypesnopart select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypesnopart select NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL from functional.alltypes");
        String hbaseQuery = "INSERT " + qualifier + " TABLE functional_hbase.insertalltypesagg select id, bigint_col, cast(string_col as binary), bool_col, date_string_col, day, double_col, float_col, int_col, month, smallint_col, string_col, timestamp_col, tinyint_col, year from functional.alltypesagg";
        if (!qualifier.contains("OVERWRITE")) {
            this.AnalyzesOk(hbaseQuery);
        } else {
            this.AnalysisError(hbaseQuery, "HBase doesn't have a way to perform INSERT OVERWRITE");
        }
        this.AnalysisError("INSERT " + qualifier + " TABLE functional.alltypesnopart PARTITION(year=2009) SELECT * FROM functional.alltypes", "PARTITION clause is only valid for INSERT into partitioned table. 'functional.alltypesnopart' is not partitioned");
        this.AnalysisError("INSERT " + qualifier + " table UNKNOWNDB.alltypesnopart SELECT * from functional.alltypesnopart", "Database does not exist: UNKNOWNDB");
    }

    private void testInsertStatic(String qualifier) throws AnalysisException {
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year=2009, month=4)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year=NULL, month=NULL)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year=NULL, month=NULL)select NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year=NULL, month=NULL)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year=2009, month=NULL)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year=NULL, month=4)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year=-1, month=cast(100*20+10 as INT))select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year=2009, month=4)select id, bool_col, tinyint_col, smallint_col, int_col, int_col, float_col, float_col, date_string_col, string_col, timestamp_col from functional.alltypes");
        this.AnalysisError("insert " + qualifier + " table functional.alltypessmall select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes", "Not enough partition columns mentioned in query. Missing columns are: year, month");
        this.AnalysisError("insert " + qualifier + " table functional.alltypessmall partition (year=2009, month=4)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, timestamp_col from functional.alltypes", "Target table 'functional.alltypessmall' has more columns (13) than the SELECT / VALUES clause and PARTITION clause return (12)");
        this.AnalysisError("insert " + qualifier + " table functional.alltypessmall partition (year=2009, month=4)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, bool_col, timestamp_col from functional.alltypes", "Target table 'functional.alltypessmall' is incompatible with source expressions.\nExpression 'bool_col' (type: BOOLEAN) is not compatible with column 'string_col' (type: STRING)");
        this.AnalysisError("insert " + qualifier + " table functional.alltypessmall partition (year=2009, month=4, year=10)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes", "Duplicate column 'year' in partition clause");
        this.AnalysisError("insert " + qualifier + " table functional.alltypessmall partition (year=2009)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes", "Not enough partition columns mentioned in query. Missing columns are: month");
        this.AnalysisError("insert " + qualifier + " table functional.alltypessmall partition (year=2009, bigint_col=10)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes", "Column 'bigint_col' is not a partition column");
        this.AnalysisError("insert " + qualifier + " table functional.alltypessmall partition (year=2009, month=4)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, double_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes", "Possible loss of precision for target table 'functional.alltypessmall'.\nExpression 'double_col' (type: DOUBLE) would need to be cast to FLOAT for column 'float_col'");
        this.AnalysisError("insert " + qualifier + " table functional.alltypessmall partition (year=2009, month=4)select * from functional.alltypes", "Target table 'functional.alltypessmall' has fewer columns (13) than the SELECT / VALUES clause and PARTITION clause return (15)");
        this.AnalysisError("insert " + qualifier + " table functional.alltypessmall partition (year=\"should be an int\", month=4)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes", "Target table 'functional.alltypessmall' is incompatible with source expressions.\nExpression ''should be an int'' (type: STRING) is not compatible with column 'year' (type: INT)");
        this.AnalysisError("insert " + qualifier + " table functional.alltypessmall partition (year=-1, month=int_col)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes", "Non-constant expressions are not supported as static partition-key values in 'month=int_col'.");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypessmall partition (year=2009, MONTH=4)select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypes");
        this.AnalysisError("insert into table functional.multipartformat partition (p='orc') select 1", "Writing the destination partition format 'ORC' is not supported.");
        if (qualifier.contains("OVERWRITE")) {
            this.AnalysisError("insert " + qualifier + " table functional_hbase.alltypessmall partition(year, month) select * from functional.alltypessmall", "PARTITION clause is not valid for INSERT into HBase tables. 'functional_hbase.alltypessmall' is an HBase table");
        }
    }

    private void testInsertWithPermutation(String qualifier) throws AnalysisException {
        this.AnalysisError("insert " + qualifier + " table functional.tinytable(a, a, b)values(1, 2, 3)", "Duplicate column 'a' in column permutation");
        this.AnalysisError("insert " + qualifier + " table functional.tinytable(a, c) values(1, 2)", "Unknown column 'c' in column permutation");
        this.AnalyzesOk("insert " + qualifier + " table functional.tinytable(a) values('hello')");
        this.AnalysisError("insert " + qualifier + " table functional.tinytable(a, b) select 'a', 'b', 'c' from functional.alltypes", "Column permutation mentions fewer columns (2) than the SELECT / VALUES clause returns (3)");
        this.AnalysisError("insert " + qualifier + " table functional.tinytable(a, b) select 'a' from functional.alltypes", "Column permutation mentions more columns (2) than the SELECT / VALUES clause returns (1)");
        this.AnalysisError("insert " + qualifier + " table functional.alltypesnopart(id, bool_col, string_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, tinyint_col, timestamp_col) select * from functional.alltypesnopart", "Target table 'functional.alltypesnopart' is incompatible with source expressions.\nExpression 'functional.alltypesnopart.tinyint_col' (type: TINYINT) is not compatible with column 'string_col' (type: STRING)");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypesnopart(id, bool_col, string_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, tinyint_col, timestamp_col) select id, bool_col, string_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, tinyint_col, timestamp_col from functional.alltypesnopart");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypes(id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, year, month) select * from functional.alltypes");
        this.AnalysisError("insert " + qualifier + " table functional.alltypes(id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, year, month) PARTITION(year) select * from functional.alltypes", "Duplicate column 'year' in partition clause");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypes(id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col, year) PARTITION(month) select * from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypes(id, year)PARTITION(month=2009) select 1, 2 from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypesnopart(id, bool_col) select id, bool_col from functional.alltypesnopart");
        this.AnalysisError("insert " + qualifier + " table functional.alltypes(id) select id from functional.alltypes", "Not enough partition columns mentioned in query. Missing columns are: year, month");
        this.AnalysisError("insert " + qualifier + " table functional.alltypes(year) partition(year=2012, month=3) select 1 from functional.alltypes", "Duplicate column 'year' in partition clause");
        this.AnalysisError("insert " + qualifier + " table functional.alltypes(id, bool_col, string_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, tinyint_col, timestamp_col) PARTITION (year, month) select id, bool_col, month, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, tinyint_col, timestamp_col, year, string_col from functional.alltypes", "Target table 'functional.alltypes' is incompatible with source expressions.\nExpression '`month`' (type: INT) is not compatible with column 'string_col' (type: STRING)");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypesnopart()");
        this.AnalysisError("insert " + qualifier + " table functional.alltypesnopart() select 1", "Column permutation mentions fewer columns (0) than the SELECT / VALUES clause returns (1)");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypes() partition(year=2012, month=1)");
        this.AnalysisError("insert " + qualifier + " table functional.alltypes() partition(year=2012, month=1) select 1", "Column permutation and PARTITION clause mention fewer columns (0) than the SELECT / VALUES clause and PARTITION clause return (1)");
        this.AnalysisError("insert " + qualifier + " table functional.alltypes() partition(year, month)", "Column permutation and PARTITION clause mention more columns (2) than the SELECT / VALUES clause and PARTITION clause return (0)");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypes() partition(year, month) select 1,2 from functional.alltypes");
        this.AnalyzesOk("insert " + qualifier + " table functional.alltypes (ID, YEAR, month)values (0, 0, 0)");
        if (!qualifier.contains("OVERWRITE")) {
            this.AnalyzesOk("insert " + qualifier + " table functional_hbase.alltypesagg(id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col) select * from functional.alltypesnopart");
            this.AnalysisError("insert " + qualifier + " table functional_hbase.alltypesagg(id, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col) select * from functional.alltypesnopart", "Column permutation mentions fewer columns (9) than the SELECT / VALUES clause returns (11)");
            this.AnalysisError("insert " + qualifier + " table functional_hbase.alltypesagg(bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col) select bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col from functional.alltypesnopart", "Row-key column 'id' must be explicitly mentioned in column permutation.");
            this.AnalyzesOk("insert " + qualifier + " table functional_hbase.alltypesagg(ID, bool_col, tinyint_col, smallint_col, INT_COL, bigint_col, float_col, double_col, date_string_col, string_col, timestamp_col) select * from functional.alltypesnopart");
        }
        this.AnalysisError("insert " + qualifier + " table functional.allcomplextypes(id, year, month) values (57, 2019, 11)", "Unable to INSERT into target table (functional.allcomplextypes) because the column 'int_array_col' has a complex type 'ARRAY<INT>' and Impala doesn't support inserting into tables containing complex type columns");
        this.AnalysisError("insert " + qualifier + " table functional.allcomplextypes select * from functional.allcomplextypes", "Unable to INSERT into target table (functional.allcomplextypes) because the column 'int_array_col' has a complex type 'ARRAY<INT>' and Impala doesn't support inserting into tables containing complex type columns");
    }

    @Test
    public void TestClone() {
        this.testNumberOfMembers(QueryStmt.class, 11);
        this.testNumberOfMembers(SetOperationStmt.class, 13);
        this.testNumberOfMembers(ValuesStmt.class, 0);
        this.testNumberOfMembers(TableRef.class, 30);
        this.testNumberOfMembers(BaseTableRef.class, 0);
        this.testNumberOfMembers(InlineViewRef.class, 10);
    }

    private void testNumberOfMembers(Class cl, int expectedNumMembers) {
        int actualNumMembers = 0;
        for (Field f : cl.getDeclaredFields()) {
            if (f.isSynthetic()) continue;
            ++actualNumMembers;
        }
        if (actualNumMembers != expectedNumMembers) {
            Assert.fail((String)String.format("The number of members in %s have changed.\nExpected %s but found %s. Please modify clone() accordingly and change the expected number of members in this test.", cl.getSimpleName(), expectedNumMembers, actualNumMembers));
        }
    }

    @Test
    public void TestSetQueryOption() {
        this.AnalyzesOk("set foo=true");
        this.AnalyzesOk("set");
        this.AnalyzesOk("unset all");
    }

    @Test
    public void TestFunctionPaths() throws ImpalaException {
        Analyzer dummyAnalyzer = ((StatementBase)this.AnalyzesOk("select 1")).getAnalyzer();
        FunctionName fnName = new FunctionName(null, "sin");
        fnName.analyze(dummyAnalyzer, false);
        Assert.assertFalse((boolean)fnName.isBuiltin());
        fnName = new FunctionName(null, "f");
        fnName.analyze(dummyAnalyzer, false);
        Assert.assertFalse((boolean)fnName.isBuiltin());
        fnName = new FunctionName("db", "sin");
        fnName.analyze(dummyAnalyzer, false);
        Assert.assertFalse((boolean)fnName.isBuiltin());
        fnName = new FunctionName("db", "f");
        fnName.analyze(dummyAnalyzer, false);
        Assert.assertFalse((boolean)fnName.isBuiltin());
        fnName = new FunctionName("_impala_builtins", "sin");
        fnName.analyze(dummyAnalyzer, false);
        Assert.assertTrue((boolean)fnName.isBuiltin());
        fnName = new FunctionName("_impala_builtins", "f");
        fnName.analyze(dummyAnalyzer, false);
        Assert.assertFalse((boolean)fnName.isBuiltin());
        fnName = new FunctionName(null, "sin");
        fnName.analyze(dummyAnalyzer, true);
        Assert.assertTrue((boolean)fnName.isBuiltin());
        fnName = new FunctionName(null, "f");
        fnName.analyze(dummyAnalyzer, true);
        Assert.assertFalse((boolean)fnName.isBuiltin());
        fnName = new FunctionName("db", "sin");
        fnName.analyze(dummyAnalyzer, false);
        Assert.assertFalse((boolean)fnName.isBuiltin());
        fnName = new FunctionName("db", "f");
        fnName.analyze(dummyAnalyzer, true);
        Assert.assertFalse((boolean)fnName.isBuiltin());
        fnName = new FunctionName("_impala_builtins", "sin");
        fnName.analyze(dummyAnalyzer, false);
        Assert.assertTrue((boolean)fnName.isBuiltin());
        fnName = new FunctionName("_impala_builtins", "f");
        fnName.analyze(dummyAnalyzer, false);
        Assert.assertFalse((boolean)fnName.isBuiltin());
    }

    @Test
    public void TestAdminFns() throws ImpalaException {
        this.AnalyzesOk(": shutdown()");
        this.AnalyzesOk(":sHuTdoWn()");
        this.AnalyzesOk(":   SHUTDOWN()");
        this.AnalyzesOk(": sHuTdoWn('hostname')");
        this.AnalyzesOk(": sHuTdoWn(\"hostname\")");
        this.AnalyzesOk(": sHuTdoWn(\"hostname:1234\")");
        this.AnalyzesOk(": shutdown(10)");
        this.AnalyzesOk(": shutdown('hostname', 10)");
        this.AnalyzesOk(": shutdown('hostname:11', 10)");
        this.AnalyzesOk(": shutdown('hostname:11', 10 * 60)");
        this.AnalyzesOk(": shutdown(10 * 60)");
        this.AnalyzesOk(": shutdown(0)");
        this.AnalysisError(": foobar()", "Unknown admin function: foobar");
        this.AnalysisError(": 1a()", "Unknown admin function: 1a");
        this.AnalysisError(": foobar(1,2,3)", "Unknown admin function: foobar");
        this.AnalysisError(": shutdown('a', 'b', 'c', 'd')", "Shutdown takes 0, 1 or 2 arguments: :shutdown('a', 'b', 'c', 'd')");
        this.AnalysisError(": shutdown(1, 2, 3)", "Shutdown takes 0, 1 or 2 arguments: :shutdown(1, 2, 3)");
        this.AnalysisError(": shutdown(a)", "Could not resolve column/field reference: 'a'");
        this.AnalysisError(": shutdown(1, 2)", "Invalid backend, must be a string literal: 1");
        this.AnalysisError(": shutdown(concat('host:', '1234'), 2)", "Invalid backend, must be a string literal: concat('host:', '1234')");
        this.AnalysisError(": shutdown('backend:1234', '...')", "deadline expression must be an integer type but is 'STRING': '...'");
        this.AnalysisError(": shutdown(true)", "deadline expression must be an integer type but is 'BOOLEAN': TRUE");
        this.AnalysisError(": shutdown('foo:bar')", "Invalid port number in backend address: foo:bar");
        this.AnalysisError(": shutdown('foo:bar:1234')", "Invalid backend address: foo:bar:1234");
        this.AnalysisError(": shutdown(-1)", "deadline must be a non-negative integer: -1 = -1");
        this.AnalysisError(": shutdown(1.234)", "deadline expression must be an integer type but is 'DECIMAL(4,3)': 1.234");
    }

    @Test
    public void TestImpalaBuiltinCastFunctions() throws ImpalaException {
        this.AnalyzesOk("select random(1000)");
        String expectedErrorSuffix = " is reserved for internal use only. Use 'cast(expr AS type)' instead.";
        List fns = BuiltinsDb.getInstance().getFunctions(TFunctionCategory.SCALAR, "castto");
        for (Function fn : fns) {
            String fn_sql_str = fn.getName() + "(\"foo\")";
            this.AnalysisError("select " + fn_sql_str, fn_sql_str + expectedErrorSuffix);
            this.AnalysisError("select _impala_builtins." + fn_sql_str, fn_sql_str + expectedErrorSuffix);
        }
        this.AnalysisError("select casttobar(\"foo\")", "default.casttobar() unknown");
    }

    @Test
    public void testCompoundVerticalBarExprAnalysis() throws ImpalaException {
        this.AnalyzesOk("SELECT bool_col || bool_col FROM functional.alltypessmall");
        this.AnalyzesOk("SELECT TRUE || bool_col FROM functional.alltypessmall");
        this.AnalyzesOk("SELECT bool_col || FALSE FROM functional.alltypessmall");
        this.AnalyzesOk("SELECT TRUE || FALSE FROM functional.alltypessmall");
        this.AnalyzesOk("SELECT NULL || bool_col FROM functional.alltypessmall");
        this.AnalyzesOk("SELECT NULL || NULL FROM functional.alltypessmall");
        this.AnalyzesOk("SELECT string_col || string_col FROM functional.alltypessmall");
        this.AnalyzesOk("SELECT 'literal' || string_col FROM functional.alltypessmall");
        this.AnalyzesOk("SELECT string_col || 'literal' FROM functional.alltypessmall");
        this.AnalyzesOk("SELECT 'literal1' || 'literal2' FROM functional.alltypessmall");
        this.AnalyzesOk("SELECT 'literal' || cs FROM functional.chars_tiny");
        this.AnalyzesOk("SELECT cl || 'literal' FROM functional.chars_tiny");
        this.AnalyzesOk("SELECT vc || cs FROM functional.chars_tiny");
        this.AnalysisError("SELECT string_col || bool_col FROM functional.alltypessmall", "Operands of CompoundVerticalBarExpr 'string_col || bool_col' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'STRING' and 'BOOLEAN'.");
        this.AnalysisError("SELECT bool_col || string_col FROM functional.alltypessmall", "Operands of CompoundVerticalBarExpr 'bool_col || string_col' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'BOOLEAN' and 'STRING'.");
        this.AnalysisError("SELECT string_col || FALSE FROM functional.alltypessmall", "Operands of CompoundVerticalBarExpr 'string_col || FALSE' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'STRING' and 'BOOLEAN'.");
        this.AnalysisError("SELECT TRUE || string_col FROM functional.alltypessmall", "Operands of CompoundVerticalBarExpr 'TRUE || string_col' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'BOOLEAN' and 'STRING'.");
        this.AnalysisError("SELECT 'literal1' || bool_col FROM functional.alltypessmall", "Operands of CompoundVerticalBarExpr ''literal1' || bool_col' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'STRING' and 'BOOLEAN'.");
        this.AnalysisError("SELECT bool_col || 'literal2' FROM functional.alltypessmall", "Operands of CompoundVerticalBarExpr 'bool_col || 'literal2'' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'BOOLEAN' and 'STRING'.");
        this.AnalysisError("SELECT vc || TRUE FROM functional.chars_tiny", "Operands of CompoundVerticalBarExpr 'vc || TRUE' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'VARCHAR(32)' and 'BOOLEAN'.");
        this.AnalysisError("SELECT FALSE || cl FROM functional.chars_tiny", "Operands of CompoundVerticalBarExpr 'FALSE || cl' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'BOOLEAN' and 'CHAR(140)'.");
        this.AnalysisError("SELECT bool_col || 'literal2' FROM functional.alltypessmall", "Operands of CompoundVerticalBarExpr 'bool_col || 'literal2'' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'BOOLEAN' and 'STRING'.");
        this.AnalysisError("SELECT string_col || int_col FROM functional.alltypessmall", "Operands of CompoundVerticalBarExpr 'string_col || int_col' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'STRING' and 'INT'.");
        this.AnalysisError("SELECT int_col || string_col FROM functional.alltypessmall", "Operands of CompoundVerticalBarExpr 'int_col || string_col' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'INT' and 'STRING'.");
        this.AnalysisError("SELECT bool_col || int_col FROM functional.alltypessmall", "Operands of CompoundVerticalBarExpr 'bool_col || int_col' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'BOOLEAN' and 'INT'.");
        this.AnalysisError("SELECT int_col || bool_col FROM functional.alltypessmall", "Operands of CompoundVerticalBarExpr 'int_col || bool_col' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'INT' and 'BOOLEAN'.");
        this.AnalysisError("SELECT string_col || timestamp_col FROM functional.alltypessmall", "Operands of CompoundVerticalBarExpr 'string_col || timestamp_col' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'STRING' and 'TIMESTAMP'.");
        this.AnalysisError("SELECT timestamp_col || string_col FROM functional.alltypessmall", "Operands of CompoundVerticalBarExpr 'timestamp_col || string_col' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'TIMESTAMP' and 'STRING'.");
        this.AnalysisError("SELECT bool_col || timestamp_col FROM functional.alltypessmall", "Operands of CompoundVerticalBarExpr 'bool_col || timestamp_col' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'BOOLEAN' and 'TIMESTAMP'.");
        this.AnalysisError("SELECT timestamp_col || bool_col FROM functional.alltypessmall", "Operands of CompoundVerticalBarExpr 'timestamp_col || bool_col' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'TIMESTAMP' and 'BOOLEAN'.");
        this.AnalysisError("SELECT bool_col || double_col FROM functional.alltypessmall", "Operands of CompoundVerticalBarExpr 'bool_col || double_col' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'BOOLEAN' and 'DOUBLE'.");
        this.AnalysisError("SELECT double_col || string_col FROM functional.alltypessmall", "Operands of CompoundVerticalBarExpr 'double_col || string_col' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'DOUBLE' and 'STRING'.");
        this.AnalysisError("SELECT string_col || NULL FROM functional.alltypessmall", "Operands of CompoundVerticalBarExpr 'string_col || NULL' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'STRING' and 'NULL_TYPE'.");
        this.AnalysisError("SELECT NULL || string_col FROM functional.alltypessmall", "Operands of CompoundVerticalBarExpr 'NULL || string_col' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types 'NULL_TYPE' and 'STRING'.");
    }

    @Test
    public void testIcebergTimeTravel() throws ImpalaException {
        TableName iceT = new TableName("functional_parquet", "iceberg_non_partitioned");
        TableName nonIceT = new TableName("functional", "allcomplextypes");
        this.TblsAnalyzeOk("select * from $TBL for system_time as of now()", iceT);
        this.TblsAnalyzeOk("select * from $TBL for system_time as of '2021-08-09 15:52:45'", iceT);
        this.TblsAnalyzeOk("select * from $TBL for system_time as of cast('2021-08-09 15:52:45' as timestamp) - interval 2 days + interval 3 hours", iceT);
        this.TblsAnalyzeOk("select * from $TBL for system_time as of now() + interval 3 days", iceT);
        this.TblsAnalyzeOk("select * from $TBL for system_version as of 93996984692289973", iceT);
        this.TblsAnalysisError("select * from $TBL for system_time as of 42", iceT, "FOR SYSTEM_TIME AS OF <expression> must be a timestamp type");
        this.TblsAnalysisError("select * from $TBL for system_time as of id", iceT, "FOR SYSTEM_TIME AS OF <expression> must be a constant expression");
        this.TblsAnalysisError("select * from $TBL for system_time as of '2021-02-32 15:52:45'", iceT, "Invalid TIMESTAMP expression");
        this.TblsAnalysisError("select * from $TBL for system_version as of 3.14", iceT, "FOR SYSTEM_VERSION AS OF <expression> must be an integer type but is");
        this.TblsAnalysisError("select * from $TBL for system_time as of now()", nonIceT, "FOR SYSTEM_TIME AS OF clause is only supported for Iceberg tables.");
        this.TblsAnalysisError("select * from $TBL for system_version as of 123", nonIceT, "FOR SYSTEM_VERSION AS OF clause is only supported for Iceberg tables.");
    }

    @Test
    public void testIcebergDescribeHistory() throws ImpalaException {
        TableName iceT = new TableName("functional_parquet", "iceberg_non_partitioned");
        TableName nonIceT = new TableName("functional", "allcomplextypes");
        this.TblsAnalyzeOk("DESCRIBE HISTORY $TBL", iceT);
        this.TblsAnalyzeOk("DESCRIBE HISTORY $TBL FROM \"2022-02-14 13:31:09.819\"", iceT);
        this.TblsAnalyzeOk("DESCRIBE HISTORY $TBL FROM cast('2021-08-09 15:52:45' as timestamp) - interval 2 days + interval 3 days", iceT);
        this.TblsAnalyzeOk("DESCRIBE HISTORY $TBL FROM now() + interval 3 days", iceT);
        this.TblsAnalyzeOk("DESCRIBE HISTORY $TBL BETWEEN '2021-02-22' AND '2021-02-22'", iceT);
        this.TblsAnalysisError("DESCRIBE HISTORY $TBL FROM 42 ", iceT, "FROM <expression> must be a timestamp type");
        this.TblsAnalysisError("DESCRIBE HISTORY $TBL FROM id", iceT, "Unsupported expression: 'id'");
        this.TblsAnalysisError("DESCRIBE HISTORY $TBL FROM '2021-02-32 15:52:45'", iceT, "Invalid TIMESTAMP expression");
        this.TblsAnalysisError("DESCRIBE HISTORY $TBL", nonIceT, "DESCRIBE HISTORY must specify an Iceberg table:");
    }

    @Test
    public void testCreatePartitionedIcebergTable() throws ImpalaException {
        String tblProperties = " TBLPROPERTIES ('iceberg.catalog'='hadoop.tables')";
        this.AnalyzesOk("CREATE TABLE tbl1 (i int, p1 int, p2 timestamp) PARTITIONED BY SPEC (BUCKET(10, p1), TRUNCATE(5, p1), DAY(p2)) STORED AS ICEBERG" + tblProperties);
        this.AnalyzesOk("CREATE TABLE tbl1 (ts timestamp) PARTITIONED BY SPEC (YEAR(ts), MONTH(ts), DAY(ts), HOUR(ts)) STORED AS ICEBERG" + tblProperties);
        this.AnalyzesOk("CREATE TABLE tbl1 (ts timestamp) PARTITIONED BY SPEC (YEARS(ts), MONTHS(ts), DAYS(ts), HOURS(ts)) STORED AS ICEBERG" + tblProperties);
        this.AnalysisError("CREATE TABLE tbl1 (i int, p1 int, p2 timestamp) PARTITIONED BY SPEC (BUCKET(p1), DAY(p2)) STORED AS ICEBERG" + tblProperties, "BUCKET and TRUNCATE partition transforms should have a parameter.");
        this.AnalysisError("CREATE TABLE tbl1 (i int, p1 int) PARTITIONED BY SPEC (TRUNCATE(p1)) STORED AS ICEBERG", "BUCKET and TRUNCATE partition transforms should have a parameter.");
        this.AnalysisError("CREATE TABLE tbl1 (i int, p1 int, p2 timestamp) PARTITIONED BY SPEC (BUCKET(0, p1), DAY(p2)) STORED AS ICEBERG" + tblProperties, "The parameter of a partition transform should be greater than zero.");
        this.AnalysisError("CREATE TABLE tbl1 (i int, p1 int, p2 timestamp) PARTITIONED BY SPEC (TRUNCATE(0, p1), DAY(p2)) STORED AS ICEBERG" + tblProperties, "The parameter of a partition transform should be greater than zero.");
        this.AnalysisError("CREATE TABLE tbl1 (i int, p1 int, p2 timestamp) PARTITIONED BY SPEC (BUCKET(10, p1), DAY(10, p2)) STORED AS ICEBERG" + tblProperties, "Only BUCKET and TRUNCATE partition transforms accept a parameter.");
    }

    @Test
    public void testPredicateHint() {
        this.AnalyzesOk("select * from tpch.lineitem where /* +ALWAYS_TRUE */ l_shipdate <= (select '1998-09-02')");
        this.AnalyzesOk("select * from tpch.lineitem where /* +ALWAYS_TRUE_TEST */ l_shipdate <= (select '1998-09-02')", "Predicate hint not recognized: ALWAYS_TRUE_TEST");
        this.AnalyzesOk("select * from tpch.lineitem where /* +ILLEGAL_HINT_TEST */ l_shipdate <= (select '1998-09-02')", "Predicate hint not recognized: ILLEGAL_HINT_TEST");
        this.AnalyzesOk("select * from tpch.lineitem where /* +ALWAYS_TRUE,ILLEGAL_HINT_TEST */ l_shipdate <= (select '1998-09-02')", "Predicate hint not recognized: ILLEGAL_HINT_TEST");
        this.AnalyzesOk("select * from tpch.lineitem where /* +ILLEGAL_HINT_TEST1,ILLEGAL_HINT_TEST2,ILLEGAL_HINT_TEST3 */ l_shipdate <= (select '1998-09-02')", "Predicate hint not recognized: ILLEGAL_HINT_TEST1");
        this.AnalyzesOk("select * from tpch.lineitem where /* +ILLEGAL_HINT_TEST1,ILLEGAL_HINT_TEST2,ILLEGAL_HINT_TEST3 */ l_shipdate <= (select '1998-09-02')", "Predicate hint not recognized: ILLEGAL_HINT_TEST2");
        this.AnalyzesOk("select * from tpch.lineitem where /* +ILLEGAL_HINT_TEST1,ILLEGAL_HINT_TEST2,ILLEGAL_HINT_TEST3 */ l_shipdate <= (select '1998-09-02')", "Predicate hint not recognized: ILLEGAL_HINT_TEST3");
    }

    @Test
    public void testTableCardinalityHintNegative() {
        this.AnalysisError("select * from functional.alltypes /* +TABLE_NUM_ROWS(aa) */", "For input string: \"aa\"");
        this.AnalysisError("select * from functional.alltypes /* +TABLE_NUM_ROWS(-1) */", "Syntax error in line 1");
        this.AnalysisError("select * from functional.alltypes /* +TABLE_NUM_ROWS(1.0) */", "Syntax error in line 1");
        this.AnalysisError("select * from functional.alltypes /* +TABLE_NUM_ROWS(10, 20) */", "Syntax error in line 1");
    }

    @Test
    public void testTableCardinalityHintPositive() {
        this.AnalyzesOk("select * from functional.alltypes /* +TABLE_NUM_ROWS */", "Table hint not recognized for table functional.alltypes: TABLE_NUM_ROWS");
        this.AnalyzesOk("select * from functional.alltypes /* +TABLE_NUM_ROWS(100) */");
        this.AnalyzesOk("select * from functional_kudu.alltypes /* +TABLE_NUM_ROWS(100) */");
        this.AnalyzesOk("select * from functional_kudu.alltypes /* +SCHEDULE_CACHE_LOCAL */", "Kudu table only support 'TABLE_NUM_ROWS' hint.");
        this.AnalyzesOk("select * from functional_hbase.alltypes /* +TABLE_NUM_ROWS(100) */", "Table hint not recognized for table functional_hbase.alltypes: TABLE_NUM_ROWS(100)");
    }

    @Test
    public void testSelectivityHintNegative() {
        this.AnalysisError("select * from t1 where a > 1 and b > 2 /* +SELECTIVITY(0.1) */", "Syntax error in line 1");
        this.AnalysisError("select * from t1 where a > 1 /* +SELECTIVITY(0.1) */", "Syntax error in line 1");
        this.AnalysisError("select * from t1 where exists (select x from t2) /* +SELECTIVITY(0.1) */", "Syntax error in line 1");
        this.AnalysisError("select * from t1 where (a > 1) /* +SELECTIVITY('0.1') */", "Syntax error in line 1");
        this.AnalysisError("select * from t1 where (a > 1) /* +SELECTIVITY(0) */", "Syntax error in line 1");
        this.AnalysisError("select * from t1 where (a > 1) /* +SELECTIVITY(-1.0) */", "Syntax error in line 1");
        this.AnalysisError("select * from t1 where (a > 1) /* +SELECTIVITY(0.1, 0.2) */", "Syntax error in line 1");
        this.AnalysisError("select * from t1 where (a > 1) /* +SELECTIVITY(1/3) */", "Syntax error in line 1");
    }

    @Test
    public void testSelectivityHintPositive() {
        this.AnalyzesOk("select * from tpch.lineitem where (l_shipdate <= '1998-09-02') /* +SELECTIVITY(1.1) */", "Invalid selectivity hint value: 1.1, allowed value should be a double value in (0, 1].");
        this.AnalyzesOk("select * from tpch.lineitem where (l_shipdate <= '1998-09-02') /* +SELECTIVITY(0.0) */", "Invalid selectivity hint value: 0.0, allowed value should be a double value in (0, 1].");
        this.AnalyzesOk("select * from functional.alltypes where (id > 1000)/* +SELECTIVITY(0.3333333333333333333333333333333333) */");
        this.AnalyzesOk("select * from functional.alltypes where (id > 1000 and int_col = 1)/* +SELECTIVITY(0.1) */");
        this.AnalyzesOk("select * from functional.alltypes where (id > 1000 or int_col = 1)/* +SELECTIVITY(0.1) */");
        this.AnalyzesOk("select * from tpch.lineitem where (l_shipdate <= '1998-09-02' and l_shipdate >= '1997-09-02')/* +SELECTIVITY(0.5) */", "Selectivity hints are ignored for 'AND' compound predicates, either in the SQL query or internally generated.");
    }

    @Test
    public void TestConvertTable() {
        this.AnalyzesOk("alter table functional_parquet.tinytable convert to iceberg");
        this.AnalyzesOk("alter table functional_parquet.tinytable convert to iceberg tblproperties('iceberg.catalog'='hadoop.tables')");
        this.AnalyzesOk("alter table functional_parquet.tinytable convert to iceberg tblproperties('iceberg.catalog'='hive.catalog')");
        this.AnalysisError("alter table functional_parquet.alltypes convert to iceberg", "Incompatible column type in source table. Unsupported Hive type: BYTE");
        this.AnalysisError("alter table functional_parquet.tinytable convert to iceberg tblproperties('iceberg.catalog'='hadoop.catalog')", "The Hadoop Catalog is not supported because the location may change");
        this.AnalysisError("alter table functional_kudu.tinytable convert to iceberg", "CONVERT TO ICEBERG is not supported for KuduTable");
        this.AnalysisError("alter table functional.tinytable convert to iceberg", "CONVERT TO ICEBERG is not supported for org.apache.hadoop.mapred.TextInputFormat");
        this.AnalysisError("alter table functional_parquet.tinytable convert to iceberg tblproperties('metadata.generator.threads'='a1')", "CONVERT TO ICEBERG only accepts 'iceberg.catalog' as TBLPROPERTY.");
    }

    static {
        FeSupport.loadLibrary();
    }
}

