/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.impala.analysis.AggregateInfo;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.AnalyzerTest;
import org.apache.impala.analysis.ArithmeticExpr;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.CaseExpr;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.MultiAggregateInfo;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.TimestampArithmeticExpr;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.catalog.AggregateFunction;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.TestSchemaUtils;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.Pair;
import org.apache.impala.thrift.TExpr;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TFunction;
import org.apache.impala.thrift.TFunctionBinaryType;
import org.apache.impala.thrift.TQueryOptions;
import org.junit.Assert;
import org.junit.Test;

public class AnalyzeExprsTest
extends AnalyzerTest {
    @Test
    public void TestNumericLiteralMinMaxValues() {
        this.testNumericLiteral(Byte.toString((byte)-128), (Type)Type.TINYINT);
        this.testNumericLiteral(Byte.toString((byte)127), (Type)Type.TINYINT);
        this.testNumericLiteral("- " + Byte.toString((byte)-128), (Type)Type.SMALLINT);
        this.testNumericLiteral("- " + Byte.toString((byte)127), (Type)Type.TINYINT);
        this.testNumericLiteral(Short.toString((short)Short.MIN_VALUE), (Type)Type.SMALLINT);
        this.testNumericLiteral(Short.toString((short)Short.MAX_VALUE), (Type)Type.SMALLINT);
        this.testNumericLiteral("- " + Short.toString((short)Short.MIN_VALUE), (Type)Type.INT);
        this.testNumericLiteral("- " + Short.toString((short)Short.MAX_VALUE), (Type)Type.SMALLINT);
        this.testNumericLiteral(Integer.toString(Integer.MIN_VALUE), (Type)Type.INT);
        this.testNumericLiteral(Integer.toString(Integer.MAX_VALUE), (Type)Type.INT);
        this.testNumericLiteral("- " + Integer.toString(Integer.MIN_VALUE), (Type)Type.BIGINT);
        this.testNumericLiteral("- " + Integer.toString(Integer.MAX_VALUE), (Type)Type.INT);
        this.testNumericLiteral(Long.toString(Long.MIN_VALUE), (Type)Type.BIGINT);
        this.testNumericLiteral(Long.toString(Long.MAX_VALUE), (Type)Type.BIGINT);
        this.testNumericLiteral(Long.toString(Long.MIN_VALUE), (Type)Type.BIGINT);
        this.testNumericLiteral("- " + Long.toString(Long.MAX_VALUE), (Type)Type.BIGINT);
        this.testNumericLiteral(Long.toString(Long.MIN_VALUE) + "1", (Type)ScalarType.createDecimalType((int)20, (int)0));
        this.testNumericLiteral(Long.toString(Long.MIN_VALUE) + "1", (Type)ScalarType.createDecimalType((int)20, (int)0));
        BigInteger minMinusOne = BigInteger.valueOf(Long.MIN_VALUE);
        minMinusOne = minMinusOne.subtract(BigInteger.ONE);
        this.testNumericLiteral(minMinusOne.toString(), (Type)ScalarType.createDecimalType((int)19, (int)0));
        BigInteger maxPlusOne = BigInteger.valueOf(Long.MAX_VALUE);
        maxPlusOne = maxPlusOne.add(BigInteger.ONE);
        this.testNumericLiteral(maxPlusOne.toString(), (Type)ScalarType.createDecimalType((int)19, (int)0));
        this.testNumericLiteral(Float.toString(Float.MIN_VALUE), (Type)Type.DOUBLE);
        this.testNumericLiteral(Float.toString(Float.MAX_VALUE), (Type)Type.DOUBLE);
        this.testNumericLiteral("-" + Float.toString(Float.MIN_VALUE), (Type)Type.DOUBLE);
        this.testNumericLiteral("-" + Float.toString(Float.MAX_VALUE), (Type)Type.DOUBLE);
        this.testNumericLiteral(Double.toString(Double.MIN_VALUE), (Type)Type.DOUBLE);
        this.testNumericLiteral(Double.toString(Double.MAX_VALUE), (Type)Type.DOUBLE);
        this.testNumericLiteral("-" + Double.toString(Double.MIN_VALUE), (Type)Type.DOUBLE);
        this.testNumericLiteral("-" + Double.toString(Double.MAX_VALUE), (Type)Type.DOUBLE);
        this.AnalysisError(String.format("select %s1", Double.toString(Double.MAX_VALUE)), "Numeric literal '1.7976931348623157E+3081' exceeds maximum range of DOUBLE.");
        this.AnalysisError(String.format("select %s1", Double.toString(Double.MIN_VALUE)), "Numeric literal '4.9E-3241' underflows minimum resolution of DOUBLE.");
        this.checkDecimalReturnType("select 12345678901234567890123456789012345678", (Type)ScalarType.createDecimalType((int)38, (int)0));
        this.testNumericLiteral("0.99999999999999999999999999999999999999", (Type)ScalarType.createDecimalType((int)38, (int)38));
        this.testNumericLiteral("99999999999999999999999999999999999999.", (Type)ScalarType.createDecimalType((int)38, (int)0));
        this.testNumericLiteral("-0.99999999999999999999999999999999999999", (Type)ScalarType.createDecimalType((int)38, (int)38));
        this.testNumericLiteral("-99999999999999999999999999999999999999.", (Type)ScalarType.createDecimalType((int)38, (int)0));
        this.testNumericLiteral("999999999999999999999.99999999999999999", (Type)ScalarType.createDecimalType((int)38, (int)17));
        this.testNumericLiteral("-999999999999999999.99999999999999999999", (Type)ScalarType.createDecimalType((int)38, (int)20));
        this.testNumericLiteral("123456789012345678901234567890123456789", (Type)Type.DOUBLE);
        this.testNumericLiteral("123456789012345678901234567890123456789.", (Type)Type.DOUBLE);
        this.testNumericLiteral("1234567890123.45678901234567890123456789", (Type)Type.DOUBLE);
        this.testNumericLiteral(".123456789012345678901234567890123456789", (Type)Type.DOUBLE);
        this.testNumericLiteral("1234567890123456789012345678901234567812345555555555555555555555559999999999999999999999999999999999999999999999999999999", (Type)Type.DOUBLE);
        this.testNumericLiteral("1234567890123456789012345678901234567812.345555555555555555555555559999999999999999999999999999999999999999999999999999999", (Type)Type.DOUBLE);
        this.testNumericLiteral(".1234567890123456789012345678901234567812345555555555555555555555559999999999999999999999999999999999999999999999999999999", (Type)Type.DOUBLE);
    }

    @Test
    public void TestScientificNumericLiterals() {
        this.checkDecimalReturnType("select 1e9", (Type)Type.INT);
        this.checkDecimalReturnType("select 1.123456789e9", (Type)Type.INT);
        this.checkDecimalReturnType("select 1.1234567891e9", (Type)ScalarType.createDecimalType((int)11, (int)1));
        this.checkDecimalReturnType("select 1.1234567891e6", (Type)ScalarType.createDecimalType((int)11, (int)4));
        this.checkDecimalReturnType("select 9e9", (Type)Type.BIGINT);
        this.checkDecimalReturnType("select 1e-2", (Type)ScalarType.createDecimalType((int)2, (int)2));
        this.checkDecimalReturnType("select 1.123e-2", (Type)ScalarType.createDecimalType((int)5, (int)5));
        this.checkDecimalReturnType("select 1e37", (Type)ScalarType.createDecimalType((int)38, (int)0));
        this.checkDecimalReturnType("select 1.23456e37", (Type)ScalarType.createDecimalType((int)38, (int)0));
        this.checkDecimalReturnType("select 1e38", (Type)Type.DOUBLE);
        this.checkDecimalReturnType("select 1.23456e38", (Type)Type.DOUBLE);
    }

    private void testNumericLiteral(String literal, Type expectedType) {
        SelectStmt selectStmt = (SelectStmt)this.AnalyzesOk("select " + literal);
        Type actualType = ((Expr)selectStmt.resultExprs_.get(0)).getType();
        Assert.assertTrue((String)("Expected Type: " + expectedType + " Actual type: " + actualType), (boolean)expectedType.equals((Object)actualType));
    }

    @Test
    public void TestTimestampValueExprs() throws AnalysisException {
        this.AnalyzesOk("select cast (0 as timestamp)");
        this.AnalyzesOk("select cast (0.1 as timestamp)");
        this.AnalyzesOk("select cast ('1970-10-10 10:00:00.123' as timestamp)");
        this.AnalyzesOk("select cast (cast ('1970-10-10' as date) as timestamp)");
        this.AnalyzesOk("select cast (date '1970-10-10' as timestamp)");
    }

    @Test
    public void testDateValueExprs() throws AnalysisException {
        this.AnalyzesOk("select DATE '1970-10-10'");
        this.AnalyzesOk("select cast ('1970-10-10' as date)");
        this.AnalyzesOk("select cast (cast ('1970-10-10 10:00:00.123' as timestamp) as date)");
    }

    @Test
    public void TestBooleanValueExprs() throws AnalysisException {
        this.AnalyzesOk("select * from functional.AllTypes where true");
        this.AnalyzesOk("select * from functional.AllTypes where false");
        this.AnalyzesOk("select * from functional.AllTypes where NULL");
        this.AnalyzesOk("select * from functional.AllTypes where bool_col = true");
        this.AnalyzesOk("select * from functional.AllTypes where bool_col = false");
        this.AnalyzesOk("select * from functional.AllTypes where bool_col = NULL");
        this.AnalyzesOk("select * from functional.AllTypes where NULL = NULL");
        this.AnalyzesOk("select * from functional.AllTypes where NULL and NULL or NULL");
        this.AnalyzesOk("select * from functional.AllTypes where true or false");
        this.AnalyzesOk("select * from functional.AllTypes where true and false");
        this.AnalyzesOk("select * from functional.AllTypes where true or false and bool_col = false");
        this.AnalyzesOk("select * from functional.AllTypes where true and false or bool_col = false");
        this.AnalyzesOk("select bool_col = true from functional.AllTypes");
        this.AnalyzesOk("select bool_col = false from functional.AllTypes");
        this.AnalyzesOk("select bool_col = NULL from functional.AllTypes");
        this.AnalyzesOk("select true or false and bool_col = false from functional.AllTypes");
        this.AnalyzesOk("select true and false or bool_col = false from functional.AllTypes");
        this.AnalyzesOk("select NULL or NULL and NULL from functional.AllTypes");
    }

    @Test
    public void TestBinaryPredicates() throws AnalysisException {
        for (String operator : new String[]{"<=>", "IS DISTINCT FROM", "IS NOT DISTINCT FROM", "<", ">", ">=", "<=", "!=", "=", "<>"}) {
            String[] decimalColumns;
            ArrayList<String> numericValues = new ArrayList<String>(Arrays.asList("0", "1", "1.1", "-7", "-7.7", "1.2e99", "false", "1234567890123456789012345678901234567890", "tinyint_col", "smallint_col", "int_col", "bigint_col", "float_col", "double_col"));
            String[] numericTypes = new String[]{"TINYINT", "SMALLINT", "INT", "BIGINT", "FLOAT", "DOUBLE", "DECIMAL"};
            for (String numericType : numericTypes) {
                numericValues.add("cast(NULL as " + numericType + ")");
            }
            for (String lhs : numericValues) {
                for (String rhs : numericValues) {
                    this.AnalyzesOk("select * from functional.alltypes where " + lhs + " " + operator + " " + rhs);
                }
            }
            for (String operand : new String[]{"bool_col", "string_col", "timestamp_col", "NULL"}) {
                this.AnalyzesOk("select * from functional.alltypes where " + (String)operand + " " + operator + " " + (String)operand);
                this.AnalyzesOk("select * from functional.alltypes where " + (String)operand + " " + operator + " NULL");
                this.AnalyzesOk("select * from functional.alltypes where NULL " + operator + " " + (String)operand);
            }
            this.AnalyzesOk("select * from functional.date_tbl where date_col " + operator + " date_col");
            this.AnalyzesOk("select * from functional.date_tbl where date_col " + operator + " NULL");
            this.AnalyzesOk("select * from functional.date_tbl where NULL " + operator + " date_col");
            this.AnalyzesOk("select * from functional.date_tbl, functional.alltypes where date_col " + operator + " timestamp_col");
            this.AnalyzesOk("select * from functional.date_tbl, functional.alltypes where timestamp_col " + operator + " date_col");
            this.AnalyzesOk("select * from functional.date_tbl where date_col " + operator + " '1993-01-21'");
            this.AnalyzesOk("select * from functional.alltypes where string_col " + operator + " 'hi'");
            this.AnalyzesOk("select * from functional.alltypes where timestamp_col " + operator + " '1993-01-21 02:00:00'");
            this.AnalyzesOk("select * from functional.alltypes where bool_col " + operator + " true");
            this.AnalyzesOk("select * from functional.binary_tbl where binary_col " + operator + " cast('hi' as binary)");
            for (String operand1 : decimalColumns = new String[]{"d1", "d2", "d3", "d4", "d5", "NULL"}) {
                for (String operand2 : decimalColumns) {
                    this.AnalyzesOk("select * from functional.decimal_tbl where " + operand1 + " " + operator + " " + operand2);
                }
            }
            this.AnalyzesOk("select cast(1 as decimal(38,37)) " + operator + " cast(2 as bigint)");
            this.AnalyzesOk("select cast(1 as bigint) " + operator + " cast(2 as decimal(38,37))");
            this.AnalyzesOk("select cast(1 as decimal(38,1)) " + operator + " cast(2 as bigint)");
            this.AnalyzesOk("select cast(1 as decimal(38,37)) " + operator + " cast(2 as tinyint)");
            this.AnalyzesOk("select cast(1 as decimal(38,37)) " + operator + " cast(2 as double)");
            for (int i = 1; i < 16; ++i) {
                this.AnalyzesOk("select cast('hi' as char(" + i + ")) " + operator + " 'hi'");
                this.AnalyzesOk("select cast('hi' as char(" + i + ")) " + operator + " NULL");
                for (int j = 1; j < 16; ++j) {
                    this.AnalyzesOk("select cast('hi' as char(" + i + ")) " + operator + " cast('hi' as char(" + j + "))");
                }
            }
            for (String numeric_type : new String[]{"BOOLEAN", "TINYINT", "SMALLINT", "INT", "BIGINT", "FLOAT", "DOUBLE", "DECIMAL(9,0)"}) {
                for (String string_type : new String[]{"STRING", "BINARY", "TIMESTAMP", "DATE"}) {
                    this.AnalysisError("select cast(NULL as " + numeric_type + ") " + operator + " cast(NULL as " + string_type + ")", "operands of type " + numeric_type + " and " + string_type + " are not comparable:");
                    this.AnalysisError("select cast(NULL as " + string_type + ") " + operator + " cast(NULL as " + numeric_type + ")", "operands of type " + string_type + " and " + numeric_type + " are not comparable:");
                }
            }
        }
        this.AnalysisError("select * from functional.alltypes where bool_col = '15'", "operands of type BOOLEAN and STRING are not comparable: bool_col = '15'");
        this.AnalysisError("select 1 from functional.allcomplextypes where int_array_col = 1", "operands of type ARRAY<INT> and TINYINT are not comparable: int_array_col = 1");
        this.AnalysisError("select 1 from functional.allcomplextypes where int_map_col = 1", "operands of type MAP<STRING,INT> and TINYINT are not comparable: int_map_col = 1");
        this.AnalysisError("select 1 from functional_orc_def.complextypes_structs where tiny_struct = true", "operands of type STRUCT<b:BOOLEAN> and BOOLEAN are not comparable: tiny_struct = TRUE");
        this.AnalysisError("select 1 from functional.allcomplextypes where int_map_col = int_map_col", "operands of type MAP<STRING,INT> and MAP<STRING,INT> are not comparable: int_map_col = int_map_col");
        this.AnalysisError("select * from functional.date_tbl where date_col = 15", "operands of type DATE and TINYINT are not comparable: date_col = 15");
    }

    @Test
    public void TestDecimalCasts() throws AnalysisException {
        this.AnalyzesOk("select cast(1.1 as boolean)");
        this.AnalyzesOk("select cast(1.1 as timestamp)");
        this.AnalysisError("select cast(1.1 as date)", "Invalid type cast of 1.1 from DECIMAL(2,1) to DATE");
        this.AnalysisError("select cast(true as decimal)", "Invalid type cast of TRUE from BOOLEAN to DECIMAL(9,0)");
        this.AnalysisError("select cast(cast(1 as timestamp) as decimal)", "Invalid type cast of CAST(1 AS TIMESTAMP) from TIMESTAMP to DECIMAL(9,0)");
        this.AnalysisError("select cast(date '1970-01-01' as decimal)", "Invalid type cast of DATE '1970-01-01' from DATE to DECIMAL(9,0)");
        this.AnalysisError("select cast(cast(\"1.1\" as binary) as decimal)", "Invalid type cast of CAST('1.1' AS BINARY) from BINARY to DECIMAL(9,0)");
        for (Type type : Type.getSupportedTypes()) {
            if (type.isNull() || type.isDecimal() || type.isBoolean() || type.isDateOrTimeType() || type.getPrimitiveType() == PrimitiveType.VARCHAR || type.getPrimitiveType() == PrimitiveType.CHAR || type.getPrimitiveType() == PrimitiveType.BINARY) continue;
            this.AnalyzesOk("select cast(1.1 as " + type + ")");
            this.AnalyzesOk("select cast(cast(1 as " + type + ") as decimal)");
        }
        for (int precision = 1; precision <= 38; ++precision) {
            for (int scale = 0; scale < precision; ++scale) {
                ScalarType t = ScalarType.createDecimalType((int)precision, (int)scale);
                this.AnalyzesOk("select cast(1.1 as " + t.toSql() + ")");
                this.AnalyzesOk("select cast(cast(1 as " + t.toSql() + ") as decimal)");
            }
        }
        this.AnalysisError("select cast(1 as decimal(0, 1))", "Decimal precision must be > 0: 0");
        this.checkDecimalReturnType("select CAST(999 AS DECIMAL(3,0))", (Type)ScalarType.createDecimalType((int)3, (int)0));
        this.AnalysisError("insert into functional.alltypesinsert (tinyint_col, year, month) values(CAST(999 AS DECIMAL(3,0)), 1, 1)", "Possible loss of precision for target table 'functional.alltypesinsert'.\nExpression 'CAST(999 AS DECIMAL(3,0))' (type: DECIMAL(3,0)) would need to be cast to TINYINT for column 'tinyint_col'");
    }

    private void testExprCast(String literal, Type expectedType) {
        SelectStmt selectStmt = (SelectStmt)this.AnalyzesOk("select cast(" + literal + " as " + expectedType.toSql() + ")");
        Type actualType = ((Expr)selectStmt.resultExprs_.get(0)).getType();
        Assert.assertTrue((String)("Expected Type: " + expectedType + " Actual type: " + actualType), (boolean)expectedType.equals((Object)actualType));
    }

    @Test
    public void TestStringCasts() throws AnalysisException {
        this.AnalysisError("select * from functional.alltypes where tinyint_col = '1'", "operands of type TINYINT and STRING are not comparable: tinyint_col = '1'");
        this.AnalysisError("select * from functional.alltypes where bool_col = '0'", "operands of type BOOLEAN and STRING are not comparable: bool_col = '0'");
        this.AnalysisError("select cast('false' as boolean) from functional.alltypes", "Invalid type cast of 'false' from STRING to BOOLEAN");
        this.AnalyzesOk("select * from functional.alltypes where tinyint_col = cast('0.5' as float)");
        this.AnalyzesOk("select * from functional.alltypes where smallint_col = cast('0.5' as float)");
        this.AnalyzesOk("select * from functional.alltypes where int_col = cast('0.5' as float)");
        this.AnalyzesOk("select * from functional.alltypes where bigint_col = cast('0.5' as float)");
        this.AnalyzesOk("select 1.0 = cast('" + Double.toString(Double.MIN_VALUE) + "' as double)");
        this.AnalyzesOk("select 1.0 = cast('-" + Double.toString(Double.MIN_VALUE) + "' as double)");
        this.AnalyzesOk("select 1.0 = cast('" + Double.toString(Double.MAX_VALUE) + "' as double)");
        this.AnalyzesOk("select 1.0 = cast('-" + Double.toString(Double.MAX_VALUE) + "' as double)");
        this.AnalyzesOk("select * from functional.alltypes where tinyint_col = cast('-1' as tinyint)");
        this.AnalyzesOk("select * from functional.alltypes where tinyint_col = cast('- -1' as tinyint)");
        this.AnalyzesOk("select * from functional.alltypes where tinyint_col = cast('- - -1' as tinyint)");
        this.AnalyzesOk("select * from functional.alltypes where tinyint_col = cast('- - - -1' as tinyint)");
        this.AnalyzesOk("select 1 | cast('" + Byte.toString((byte)-128) + "' as int)");
        this.AnalyzesOk("select 1 | cast('" + Byte.toString((byte)127) + "' as int)");
        this.AnalyzesOk("select 1 | cast('" + Short.toString((short)Short.MIN_VALUE) + "' as int)");
        this.AnalyzesOk("select 1 | cast('" + Short.toString((short)Short.MAX_VALUE) + "' as int)");
        this.AnalyzesOk("select 1 | cast('" + Integer.toString(Integer.MIN_VALUE) + "' as int)");
        this.AnalyzesOk("select 1 | cast('" + Integer.toString(Integer.MAX_VALUE) + "' as int)");
        this.AnalyzesOk("select 1 | cast('" + Long.toString(-9223372036854775807L) + "' as bigint)");
        this.AnalyzesOk("select 1 | cast('" + Long.toString(Long.MAX_VALUE) + "' as bigint)");
        this.AnalyzesOk("select * from functional.alltypes where tinyint_col = cast('" + Long.toString(Long.MIN_VALUE) + "1' as tinyint)");
        this.AnalyzesOk("select * from functional.alltypes where tinyint_col = cast('" + Long.toString(Long.MAX_VALUE) + "1' as tinyint)");
        this.AnalyzesOk("select * from functional.alltypes where tinyint_col = cast('" + Double.toString(Double.MAX_VALUE) + "1' as tinyint)");
        this.AnalyzesOk("select * from functional.alltypes where tinyint_col = cast('" + Double.toString(Double.MIN_VALUE) + "1' as tinyint)");
        this.AnalyzesOk("select * from functional.alltypes where tinyint_col = cast('--1' as tinyint)");
        this.AnalyzesOk("select cast('abc' as string)");
        this.AnalyzesOk("select cast(cast('1.234' as decimal) as string)");
        this.AnalyzesOk("select cast('helloworld' as VARCHAR(3))");
        this.AnalyzesOk("select cast(cast('helloworld' as VARCHAR(3)) as string)");
        this.AnalyzesOk("select cast(cast('3.0' as VARCHAR(5)) as float)");
        this.AnalyzesOk("select NULL = cast('123' as CHAR(3))");
        this.AnalyzesOk("select * from functional.chars_tiny where cs = vc");
        this.AnalyzesOk("select * from functional.chars_tiny where vc = cs");
        this.AnalyzesOk("insert into functional.chars_tiny(vc) VALUES (cast('aaabbb' as varchar(6))), (cast('cccddd' as char(6)))");
        this.AnalyzesOk("insert into functional.chars_tiny(vc) VALUES (cast('aaabbb' as varchar(32))), (cast('cccddd' as char(32)))");
        this.AnalysisError("select now() = cast('hi' as CHAR(3))", "operands of type TIMESTAMP and CHAR(3) are not comparable: now() = CAST('hi' AS CHAR(3))");
        this.AnalysisError("select cast(now() as DATE) = cast('hi' as CHAR(3))", "operands of type DATE and CHAR(3) are not comparable: CAST(now() AS DATE) = CAST('hi' AS CHAR(3))");
        this.testExprCast("cast('Hello' as VARCHAR(5))", (Type)ScalarType.createVarcharType((int)7));
        this.testExprCast("cast('Hello' as VARCHAR(5))", (Type)ScalarType.createVarcharType((int)3));
        this.AnalysisError("select cast('foo' as varchar(0))", "Varchar size must be > 0: 0");
        this.AnalysisError("select cast('foo' as varchar(65536))", "Varchar size must be <= 65535: 65536");
        this.AnalysisError("select cast('foo' as char(0))", "Char size must be > 0: 0");
        this.AnalysisError("select cast('foo' as char(256))", "Char size must be <= 255: 256");
        this.testExprCast("'Hello'", (Type)ScalarType.createCharType((int)5));
        this.testExprCast("cast('Hello' as CHAR(5))", (Type)ScalarType.STRING);
        this.testExprCast("cast('Hello' as CHAR(5))", (Type)ScalarType.createVarcharType((int)7));
        this.testExprCast("cast('Hello' as VARCHAR(5))", (Type)ScalarType.createCharType((int)7));
        this.testExprCast("cast('Hello' as CHAR(7))", (Type)ScalarType.createVarcharType((int)5));
        this.testExprCast("cast('Hello' as VARCHAR(7))", (Type)ScalarType.createCharType((int)5));
        this.testExprCast("cast('Hello' as CHAR(5))", (Type)ScalarType.createVarcharType((int)5));
        this.testExprCast("cast('Hello' as VARCHAR(5))", (Type)ScalarType.createCharType((int)5));
        this.testExprCast("1", (Type)ScalarType.createCharType((int)5));
        this.testExprCast("cast('abcde' as char(10)) IN (cast('abcde' as CHAR(20)), cast('abcde' as VARCHAR(10)), 'abcde')", (Type)ScalarType.createCharType((int)10));
        this.testExprCast("'abcde' IN (cast('abcde' as CHAR(20)), cast('abcde' as VARCHAR(10)), 'abcde')", (Type)ScalarType.STRING);
        this.testExprCast("cast('abcde' as varchar(10)) IN (cast('abcde' as CHAR(20)), cast('abcde' as VARCHAR(10)), 'abcde')", (Type)ScalarType.createVarcharType((int)10));
    }

    @Test
    public void TestNullCasts() throws AnalysisException {
        for (Type type : Type.getSupportedTypes()) {
            if (type.isNull()) continue;
            if (type.isDecimal()) {
                type = Type.DEFAULT_DECIMAL;
            }
            if (type.getPrimitiveType() == PrimitiveType.VARCHAR) {
                type = ScalarType.createVarcharType((int)1);
            }
            if (type.getPrimitiveType() == PrimitiveType.CHAR) {
                type = ScalarType.createCharType((int)1);
            }
            this.checkExprType("select cast(null as " + type + ")", type);
        }
    }

    @Test
    public void TestComplexTypeCasts() throws AnalysisException {
        this.AnalysisError("select cast(1 as array<int>)", "Unsupported cast to complex type: ARRAY<INT>");
        this.AnalysisError("select cast(1 as map<int, int>)", "Unsupported cast to complex type: MAP<INT,INT>");
        this.AnalysisError("select cast(1 as struct<a:int,b:char(20)>)", "Unsupported cast to complex type: STRUCT<a:INT,b:CHAR(20)>");
    }

    @Test
    public void TestLikePredicates() throws AnalysisException {
        String[] likePreds;
        this.AnalyzesOk("select * from functional.alltypes where string_col like  'test%'");
        this.AnalyzesOk("select * from functional.alltypes where string_col like string_col");
        this.AnalyzesOk("select * from functional.alltypes where string_col ilike  'test%'");
        this.AnalyzesOk("select * from functional.alltypes where string_col ilike string_col");
        this.AnalyzesOk("select * from functional.alltypes where 'test' like string_col");
        this.AnalyzesOk("select * from functional.alltypes where string_col rlike 'test%'");
        this.AnalyzesOk("select * from functional.alltypes where string_col regexp 'test.*'");
        this.AnalyzesOk("select * from functional.alltypes where string_col iregexp 'test.*'");
        this.AnalysisError("select * from functional.alltypes where string_col like 5", "right operand of LIKE must be of type STRING");
        this.AnalysisError("select * from functional.alltypes where string_col ilike 5", "right operand of ILIKE must be of type STRING");
        this.AnalysisError("select * from functional.alltypes where 'test' like 5", "right operand of LIKE must be of type STRING");
        this.AnalysisError("select * from functional.alltypes where 'test' ilike 5", "right operand of ILIKE must be of type STRING");
        this.AnalysisError("select * from functional.alltypes where string_col like cast('test%' as binary)", "right operand of LIKE must be of type STRING");
        this.AnalysisError("select * from functional.alltypes where int_col like 'test%'", "left operand of LIKE must be of type STRING");
        this.AnalysisError("select * from functional.alltypes where int_col ilike 'test%'", "left operand of ILIKE must be of type STRING");
        this.AnalysisError("select * from functional.binary_tbl where binary_col like 'test%'", "left operand of LIKE must be of type STRING");
        this.AnalysisError("select * from functional.alltypes where string_col regexp 'test]['", "invalid regular expression in 'string_col REGEXP 'test][''");
        this.AnalysisError("select * from functional.alltypes where string_col iregexp 'test]['", "invalid regular expression in 'string_col IREGEXP 'test][''");
        for (String likePred : likePreds = new String[]{"LIKE", "RLIKE", "REGEXP", "ILIKE", "IREGEXP"}) {
            this.AnalyzesOk(String.format("select * from functional.alltypes where string_col %s NULL", likePred));
            this.AnalyzesOk(String.format("select * from functional.alltypes where NULL %s string_col", likePred));
            this.AnalyzesOk(String.format("select * from functional.alltypes where NULL %s NULL", likePred));
        }
    }

    @Test
    public void TestCompoundPredicates() throws AnalysisException {
        String[] operands;
        this.AnalyzesOk("select * from functional.alltypes where string_col = '5' and int_col = 5");
        this.AnalyzesOk("select * from functional.alltypes where string_col = '5' or int_col = 5");
        this.AnalyzesOk("select * from functional.alltypes where (string_col = '5' or int_col = 5) and string_col > '1'");
        this.AnalyzesOk("select * from functional.alltypes where not string_col = '5'");
        this.AnalyzesOk("select * from functional.alltypes where int_col = cast('5' as int)");
        for (String lop : operands = new String[]{"true", "false", "NULL", "bool_col"}) {
            for (String rop : operands) {
                for (CompoundPredicate.Operator op : CompoundPredicate.Operator.values()) {
                    if (op == CompoundPredicate.Operator.NOT) continue;
                    String expr = String.format("%s %s %s", lop, op, rop);
                    this.AnalyzesOk(String.format("select %s from functional.alltypes where %s", expr, expr));
                }
            }
            String notExpr = String.format("%s %s", CompoundPredicate.Operator.NOT, lop);
            this.AnalyzesOk(String.format("select %s from functional.alltypes where %s", notExpr, notExpr));
        }
        this.AnalysisError("select * from functional.alltypes where 1 + 2 and false", "Operand '1 + 2' part of predicate '1 + 2 AND FALSE' should return type 'BOOLEAN' but returns type 'SMALLINT'.");
        this.AnalysisError("select * from functional.alltypes where 1 + 2 or true", "Operand '1 + 2' part of predicate '1 + 2 OR TRUE' should return type 'BOOLEAN' but returns type 'SMALLINT'.");
        this.AnalysisError("select * from functional.alltypes where not 1 + 2", "Operand '1 + 2' part of predicate 'NOT 1 + 2' should return type 'BOOLEAN' but returns type 'SMALLINT'.");
        this.AnalysisError("select * from functional.alltypes where 1 + 2 and true", "Operand '1 + 2' part of predicate '1 + 2 AND TRUE' should return type 'BOOLEAN' but returns type 'SMALLINT'.");
        this.AnalysisError("select * from functional.alltypes where false and trim('abc')", "Operand 'trim('abc')' part of predicate 'FALSE AND trim('abc')' should return type 'BOOLEAN' but returns type 'STRING'.");
        this.AnalysisError("select * from functional.alltypes where bool_col or double_col", "Operand 'double_col' part of predicate 'bool_col OR double_col' should return type 'BOOLEAN' but returns type 'DOUBLE'.");
        this.AnalysisError("select int_array_col or true from functional.allcomplextypes", "Operand 'int_array_col' part of predicate 'int_array_col OR TRUE' should return type 'BOOLEAN' but returns type 'ARRAY<INT>'");
        this.AnalysisError("select false and tiny_struct from functional_orc_def.complextypes_structs", "Operand 'tiny_struct' part of predicate 'FALSE AND tiny_struct' should return type 'BOOLEAN' but returns type 'STRUCT<b:BOOLEAN>'.");
        this.AnalysisError("select not int_map_col from functional.allcomplextypes", "Operand 'int_map_col' part of predicate 'NOT int_map_col' should return type 'BOOLEAN' but returns type 'MAP<STRING,INT>'.");
    }

    @Test
    public void TestIsNullPredicates() throws AnalysisException {
        this.AnalyzesOk("select * from functional.alltypes where int_col is null");
        this.AnalyzesOk("select * from functional.alltypes where string_col is not null");
        this.AnalyzesOk("select * from functional.binary_tbl where binary_col is null");
        this.AnalyzesOk("select * from functional.alltypes where null is not null");
        this.AnalysisError("select 1 from functional.allcomplextypes where int_map_col is null", "IS NULL predicate does not support complex types: int_map_col IS NULL");
        this.AnalysisError("select * from functional_orc_def.complextypes_structs where tiny_struct is null", "IS NULL predicate does not support complex types: tiny_struct IS NULL");
        this.AnalysisError("select * from functional_orc_def.complextypes_structs where tiny_struct is not null", "IS NOT NULL predicate does not support complex types: tiny_struct IS NOT NULL");
    }

    @Test
    public void TestBoolTestExpression() throws AnalysisException {
        String[] rhsOptions = new String[]{"true", "false", "unknown"};
        String[] lhsOptions = new String[]{"bool_col", "1>1", "istrue(false)", "(1>1 is true)"};
        for (String rhsVal : rhsOptions) {
            String template = "select (%s is %s) from functional.alltypes where (%s is %s)";
            String lhsVal = rhsVal == "unknown" ? "null" : rhsVal;
            String negatedRhsVal = "not " + rhsVal;
            this.AnalyzesOk(String.format(template, lhsVal, rhsVal, lhsVal, rhsVal));
            this.AnalyzesOk(String.format(template, lhsVal, negatedRhsVal, lhsVal, negatedRhsVal));
            for (String lhs : lhsOptions) {
                this.AnalyzesOk(String.format(template, lhs, rhsVal, lhs, rhsVal));
                this.AnalyzesOk(String.format(template, lhs, negatedRhsVal, lhs, negatedRhsVal));
            }
        }
        this.AnalysisError("select ('foo' is true)", "No matching function with signature: istrue(STRING).");
        this.AnalysisError("select (10 is true)", "No matching function with signature: istrue(TINYINT).");
        this.AnalysisError("select (10 is not true)", "No matching function with signature: isnottrue(TINYINT).");
        this.AnalysisError("select (10 is false)", "No matching function with signature: isfalse(TINYINT).");
        this.AnalysisError("select (10 is not false)", "No matching function with signature: isnotfalse(TINYINT).");
    }

    @Test
    public void TestBetweenPredicates() throws AnalysisException {
        this.AnalyzesOk("select * from functional.alltypes where tinyint_col between smallint_col and int_col");
        this.AnalyzesOk("select * from functional.alltypes where tinyint_col not between smallint_col and int_col");
        this.AnalyzesOk("select * from functional.alltypes where 'abc' between string_col and date_string_col");
        this.AnalyzesOk("select * from functional.alltypes where 'abc' not between string_col and date_string_col");
        this.AnalyzesOk("select * from functional.binary_tbl where cast('abc' as binary) not between cast(string_col as binary) and binary_col");
        this.AnalyzesOk("select * from functional.alltypes where string_col = 'abc' and tinyint_col between 10 and 20");
        this.AnalyzesOk("select * from functional.alltypes where tinyint_col between 10 and 20 and string_col = 'abc'");
        this.AnalyzesOk("select * from functional.alltypes where bool_col and tinyint_col between 10 and 20 and string_col = 'abc'");
        this.AnalyzesOk("select * from functional.alltypes where true between false and true and 'b' between 'a' and 'c'");
        this.AnalyzesOk("select * from functional.alltypes where true between 'b' between 'a' and 'c' and 'bb' between 'aa' and 'cc'");
        this.AnalyzesOk("select 5 + 1 between 4 and 10");
        this.AnalyzesOk("select 'abc' like '%a' between true and false");
        this.AnalyzesOk("select false between (true and true) and (false and true)");
        this.AnalyzesOk("select * from functional.alltypes where double_col between smallint_col and int_col");
        this.AnalyzesOk("select * from functional.alltypes, functional.date_tbl where timestamp_col between date_part and date_col");
        this.AnalyzesOk("select * from functional.alltypes where smallint_col between float_col and double_col");
        this.AnalyzesOk("select * from functional.date_tbl, functional.alltypes where date_col between timestamp_col and timestamp_col + interval 1 day");
        this.AnalyzesOk("select * from functional.alltypes where NULL between float_col and double_col");
        this.AnalyzesOk("select * from functional.alltypes where smallint_col between NULL and double_col");
        this.AnalyzesOk("select * from functional.alltypes where smallint_col between float_col and NULL");
        this.AnalyzesOk("select * from functional.alltypes where NULL between NULL and NULL");
        this.AnalysisError("select * from functional.alltypes where string_col between bool_col and double_col", "Incompatible return types 'STRING' and 'BOOLEAN' of exprs 'string_col' and 'bool_col'.");
        this.AnalysisError("select * from functional.alltypes where timestamp_col between int_col and double_col", "Incompatible return types 'TIMESTAMP' and 'INT' of exprs 'timestamp_col' and 'int_col'.");
        this.AnalysisError("select * from functional.date_tbl, functional.alltypes where date_col between int_col and double_col", "Incompatible return types 'DATE' and 'INT' of exprs 'date_col' and 'int_col'.");
        this.AnalysisError("select 1 from functional_orc_def.complextypes_structs where tiny_struct between 10 and 20", "Incompatible return types 'STRUCT<b:BOOLEAN>' and 'TINYINT' of exprs 'tiny_struct' and '10'.");
        this.AnalysisError("select * from functional.binary_tbl where string_col between binary_col and 'a'", "Incompatible return types 'STRING' and 'BINARY' of exprs 'string_col' and 'binary_col'.");
        this.AnalyzesOk("select cast(1 as decimal(38,2)) between 0.9 * cast(1 as decimal(38,3)) and 3");
        this.AnalyzesOk("select cast(2 as decimal(38,37)) between cast(1 as decimal(38,1)) and cast(3 as decimal(38,15))");
        this.AnalyzesOk("select cast(2 as decimal(38,37)) between cast(1 as double) and cast(3 as decimal(38,1))");
        this.AnalyzesOk("select cast(2 as decimal(38,37)) between cast(1 as decimal(38,1)) and cast(3 as double)");
        this.AnalyzesOk("select cast(2 as decimal(38,37)) between cast(1 as decimal(38,1)) and cast(3 as bigint)");
        this.AnalyzesOk("select cast(2 as decimal(38,37)) between cast(1 as bigint) and cast(3 as bigint)");
        this.AnalyzesOk("select cast(2 as decimal(38,37)) between cast(1 as bigint) and cast(3 as decimal(38,1))");
        this.AnalyzesOk("select cast(2 as decimal(38,37)) between cast(1 as decimal(38,1)) and cast(3 as int)");
        this.AnalyzesOk("select cast(2 as decimal(38,37)) between cast(1 as int) and cast(3 as decimal(38,1))");
    }

    @Test
    public void TestInPredicates() throws AnalysisException {
        this.AnalyzesOk("select * from functional.alltypes where int_col in (1, 2, 3, 4)");
        this.AnalyzesOk("select * from functional.alltypes where int_col not in (1, 2, 3, 4)");
        this.AnalyzesOk("select * from functional.alltypes where string_col in ('a', 'b', 'c', 'd')");
        this.AnalyzesOk("select * from functional.alltypes where string_col not in ('a', 'b', 'c', 'd')");
        this.AnalyzesOk("select * from functional.alltypes where true in (bool_col, true and false)");
        this.AnalyzesOk("select * from functional.alltypes where true not in (bool_col, true and false)");
        this.AnalyzesOk("select * from functional.alltypes where double_col in (int_col, bigint_col)");
        this.AnalyzesOk("select * from functional.alltypes, functional.date_tbl where timestamp_col in (date_col, date_part)");
        this.AnalyzesOk("select * from functional.alltypes where int_col in (double_col, bigint_col)");
        this.AnalyzesOk("select * from functional.alltypes, functional.date_tbl where date_col in (timestamp_col, timestamp_col + interval 1 day)");
        this.AnalyzesOk("select * from functional.alltypes where !true in (false or true, true and false)");
        this.AnalyzesOk("select * from functional.alltypes where NULL in (NULL, NULL)");
        this.AnalyzesOk("select bool_col = (int_col in (1,2)), case when tinyint_col in (10, NULL) then tinyint_col else NULL end from functional.alltypestiny where int_col > (bool_col in (false)) and (int_col in (1,2)) = (select min(bool_col) from functional.alltypes) and (int_col in (3,4)) = (tinyint_col in (4,5))");
        this.AnalysisError("select * from functional.alltypes where string_col in (bool_col, double_col)", "Incompatible return types 'STRING' and 'BOOLEAN' of exprs 'string_col' and 'bool_col'.");
        this.AnalysisError("select * from functional.alltypes where timestamp_col in (int_col, double_col)", "Incompatible return types 'TIMESTAMP' and 'INT' of exprs 'timestamp_col' and 'int_col'.");
        this.AnalysisError("select * from functional.alltypes where timestamp_col in (NULL, int_col)", "Incompatible return types 'TIMESTAMP' and 'INT' of exprs 'timestamp_col' and 'int_col'.");
        this.AnalysisError("select * from functional.date_tbl, functional.alltypes where date_col in (int_col, double_col)", "Incompatible return types 'DATE' and 'INT' of exprs 'date_col' and 'int_col'.");
        this.AnalysisError("select * from functional.date_tbl, functional.alltypes where date_col in (NULL, int_col)", "Incompatible return types 'DATE' and 'INT' of exprs 'date_col' and 'int_col'.");
        this.AnalysisError("select 1 from functional.allcomplextypes where int_array_col in (id, NULL)", "Incompatible return types 'ARRAY<INT>' and 'INT' of exprs 'int_array_col' and 'id'.");
    }

    @Test
    public void TestAnalyticExprs() throws AnalysisException {
        this.AnalyzesOk("select int_col from functional.alltypessmall order by count(*) over () limit 10");
        this.AnalyzesOk("select sum(int_col) over () from functional.alltypes");
        this.AnalyzesOk("select avg(bigint_col) over (partition by id) from functional.alltypes");
        this.AnalyzesOk("select count(smallint_col) over (partition by id order by tinyint_col) from functional.alltypes");
        this.AnalyzesOk("select min(int_col) over (partition by id order by tinyint_col rows between unbounded preceding and current row) from functional.alltypes");
        this.AnalyzesOk("select sum(int_col) over (partition by id order by tinyint_col rows 2 preceding) from functional.alltypes");
        this.AnalyzesOk("select sum(int_col) over (partition by id order by tinyint_col rows between 2 preceding and unbounded following) from functional.alltypes");
        this.AnalyzesOk("select min(int_col) over (partition by id order by tinyint_col rows between unbounded preceding and 2 preceding) from functional.alltypes");
        this.AnalyzesOk("select sum(int_col) over (partition by id order by tinyint_col rows between 2 following and unbounded following) from functional.alltypes");
        this.AnalyzesOk("select sum(int_col) over (partition by id order by tinyint_col rows between 2 preceding and 6 following) from functional.alltypes");
        this.AnalyzesOk("select sum(int_col) over (partition by id order by tinyint_col rows between 2 preceding and unbounded following) from functional.alltypes");
        this.AnalyzesOk("select lead(int_col, 1, null) over (partition by id order by tinyint_col) from functional.alltypes");
        this.AnalyzesOk("select rank() over (partition by id order by tinyint_col) from functional.alltypes");
        this.AnalyzesOk("select id from functional.alltypes order by rank() over (order by tinyint_col)");
        this.AnalyzesOk("select first_value(tinyint_col) over (order by id) from functional.alltypesagg");
        this.AnalyzesOk("select last_value(tinyint_col) over (order by id) from functional.alltypesagg");
        this.AnalyzesOk("select first_value(tinyint_col ignore nulls) over (order by id) from functional.alltypesagg");
        this.AnalyzesOk("select last_value(tinyint_col ignore nulls) over (order by id) from functional.alltypesagg");
        this.AnalyzesOk("select first_value(tinyint_col ignore nulls) over (order by id),last_value(tinyint_col ignore nulls) over (order by id)from functional.alltypesagg a where exists (select 1 from functional.alltypes b where a.id = b.id)");
        this.AnalyzesOk("select first_value(tinyint_col) over () from functional.alltypesagg");
        this.AnalyzesOk("select last_value(tinyint_col) over () from functional.alltypesagg");
        this.AnalyzesOk("select first_value(tinyint_col ignore nulls) over () from functional.alltypesagg");
        this.AnalyzesOk("select last_value(tinyint_col ignore nulls) over () from functional.alltypesagg");
        this.AnalyzesOk("select first_value(tinyint_col ignore nulls) over (),last_value(tinyint_col ignore nulls) over () from functional.alltypesagg a where exists (select 1 from functional.alltypes b where a.id = b.id)");
        this.AnalyzesOk("select sum(count(id)) over (partition by min(int_col) order by max(bigint_col)) from functional.alltypes group by id, tinyint_col order by rank() over (order by max(bool_col), tinyint_col)");
        this.AnalyzesOk("select lead(count(id)) over (order by tinyint_col) from functional.alltypes group by id, tinyint_col order by rank() over (order by tinyint_col)");
        this.AnalyzesOk("select min(count(id)) over (order by tinyint_col) from functional.alltypes group by id, tinyint_col order by rank() over (order by tinyint_col)");
        this.AnalyzesOk("select t1.int_col, COUNT(t1.int_col) OVER (ORDER BY t1.int_col) FROM functional.alltypes t1 GROUP BY t1.int_col HAVING COUNT(t1.int_col) > 1");
        this.AnalyzesOk("select sum(int_col) over (partition by id order by tinyint_col, int_col rows between 2 following and 4 following) from functional.alltypes");
        this.AnalyzesOk("select max(int_col) over (partition by id order by tinyint_col, int_col range between unbounded preceding and current row) from functional.alltypes");
        this.AnalyzesOk("select sum(int_col) over (partition by id order by tinyint_col, int_col range between current row and unbounded following) from functional.alltypes");
        this.AnalyzesOk("select max(int_col) over (partition by id order by tinyint_col, int_col range between unbounded preceding and unbounded following) from functional.alltypes");
        this.AnalyzesOk("select sum(int_col) over (partition by id order by tinyint_col rows between 4 preceding and 2 preceding) from functional.alltypes");
        this.AnalyzesOk("select sum(int_col) over (partition by id order by tinyint_col rows between 2 following and 4 following) from functional.alltypes");
        this.AnalyzesOk("select 2 * min(tinyint_col) over (partition by id order by tinyint_col   rows between unbounded preceding and current row), concat(max(string_col) over (partition by timestamp_col, int_col   order by tinyint_col, smallint_col   rows between unbounded preceding and current row), min(string_col) over (partition by timestamp_col, int_col   order by tinyint_col, smallint_col   rows between unbounded preceding and current row)) from functional.alltypes");
        this.AnalyzesOk("select sum(int_col) over (partition by id order by tinyint_col, int_col rows between current row and current row) from functional.alltypes");
        this.AnalysisError("select sum(int_col) over (partition by id order by tinyint_col, int_col range between current row and current row) from functional.alltypes", "RANGE is only supported with both the lower and upper bounds UNBOUNDED or one UNBOUNDED and the other CURRENT ROW.");
        this.AnalysisError("select sum(int_col) over (partition by id order by tinyint_col range between 2 following and 2 following) from functional.alltypes", "RANGE is only supported with both the lower and upper bounds UNBOUNDED or one UNBOUNDED and the other CURRENT ROW.");
        this.AnalysisError("select max(int_col) over (partition by id order by tinyint_col rows 2 preceding) from functional.alltypes", "'max(int_col)' is only supported with an UNBOUNDED PRECEDING start bound.");
        this.AnalyzesOk("select max(id) over (order by id rows between current row and unbounded following) from functional.alltypes");
        this.AnalyzesOk("select min(int_col) over (partition by id order by tinyint_col rows between 2 preceding and unbounded following) from functional.alltypes");
        this.AnalysisError("select lead(count(bigint_col)) over (order by tinyint_col) from functional.alltypes group by id, tinyint_col order by rank() over (order by smallint_col)", "ORDER BY expression not produced by aggregation output (missing from GROUP BY clause?): rank() OVER (ORDER BY smallint_col ASC)");
        this.AnalysisError("select 1, lag(int_col) from functional.alltypes", "Analytic function requires an OVER clause: lag(int_col)");
        this.AnalysisError("select 1, count(*) over()", "Analytic expressions require FROM clause");
        this.AnalysisError("select distinct int_col, sum(double_col) over () from functional.alltypes", "cannot combine SELECT DISTINCT with analytic functions");
        this.AnalysisError("select id, count(*) from functional.alltypes group by 1, rank() over(order by int_col)", "GROUP BY expression must not contain analytic expressions: rank() OVER (ORDER BY int_col ASC)");
        this.AnalysisError("select id, rank() over(order by int_col), count(*) from functional.alltypes group by 1, 2", "GROUP BY expression must not contain analytic expressions: rank() OVER (ORDER BY int_col ASC)");
        this.AnalysisError("select id, count(*) from functional.alltypes group by 1 having rank() over(order by int_col) > 1", "HAVING clause must not contain analytic expressions: rank() OVER (ORDER BY int_col ASC)");
        this.AnalysisError("select id, tinyint_col from functional.alltypes where row_number() over(order by id) > 1", "WHERE clause must not contain analytic expressions: row_number() OVER (ORDER BY id ASC)");
        this.AnalysisError("select id, tinyint_col, sum(distinct tinyint_col) over(order by id) from functional.alltypes", "DISTINCT not allowed in analytic function");
        this.AnalysisError("select sum(id ignore nulls) over (order by id) from functional.alltypes", "Function SUM does not accept the keyword IGNORE NULLS.");
        this.AnalyzesOk("with t as (select * from (select sum(t1.year) over (  order by max(t1.id), t1.year   rows between unbounded preceding and 5 preceding) from functional.alltypes t1 group by t1.year) t1) select * from t");
        this.AnalyzesOk("with t as (select sum(t1.smallint_col) over () from functional.alltypes t1) select * from t");
        this.AnalyzesOk("with t as (select 1 as int_col_1 from functional.alltypesagg t1) select count(t1.int_col_1) as int_col_1 from t t1 where t1.int_col_1 is null group by t1.int_col_1 union all select min(t1.day) over () from functional.alltypesagg t1");
        this.AnalyzesOk("select 1 in (first_value(cast(int_col AS DECIMAL))  over (order by int_col rows between 2 preceding and 1 preceding)) from functional.alltypestiny");
        this.AnalyzesOk("select rank() over (order by 1) from functional.alltypestiny");
        this.AnalyzesOk("select count() over (partition by 2) from functional.alltypestiny");
        this.AnalyzesOk("select rank() over (partition by 2 order by 1) from functional.alltypestiny");
        this.AnalysisError("select sum(int_col) over (partition by id, rank() over (order by int_col) order by tinyint_col, int_col rows between 2 following and 4 following) from functional.alltypes", "Nesting of analytic expressions is not allowed");
        this.AnalysisError("select lead(rank() over (order by int_col)) over (partition by id order by tinyint_col, int_col) from functional.alltypes", "Nesting of analytic expressions is not allowed");
        this.AnalysisError("select max(int_col) over (partition by id order by rank() over (order by tinyint_col), int_col) from functional.alltypes", "Nesting of analytic expressions is not allowed");
        this.AnalyzesOk("select lag(int_col, 10, 5 + 1) over (partition by id, bool_col order by tinyint_col, int_col) from functional.alltypes");
        this.AnalyzesOk("select lead(string_col, 1, 'default') over (order by tinyint_col, int_col) from functional.alltypes");
        this.AnalyzesOk("select lag(bool_col, 3) over (order by id, int_col) from functional.alltypes");
        this.AnalyzesOk("select lead(float_col, 2) over (partition by string_col, timestamp_col order by tinyint_col, int_col) from functional.alltypes");
        this.AnalyzesOk("select lag(double_col) over (order by string_col, int_col) from functional.alltypes");
        this.AnalyzesOk("select lead(timestamp_col) over (partition by id order by tinyint_col, int_col) from functional.alltypes");
        this.AnalysisError("select lag(string_col, 'x') over (partition by id order by tinyint_col, int_col) from functional.alltypes", "No matching function with signature: lag(STRING, STRING)");
        this.AnalysisError("select lead(int_col, 1, 'x') over (order by tinyint_col, int_col) from functional.alltypes", "No matching function with signature: lead(INT, TINYINT, STRING)");
        this.AnalysisError("select lag() over (partition by id order by tinyint_col, int_col) from functional.alltypes", "No matching function with signature: lag()");
        this.AnalysisError("select lead(int_col, -1) over (order by tinyint_col, int_col) from functional.alltypes", "The offset parameter of LEAD/LAG must be a constant positive integer");
        this.AnalysisError("select lag(int_col, tinyint_col * 2, 5) over (order by tinyint_col, int_col) from functional.alltypes", "The offset parameter of LEAD/LAG must be a constant positive integer");
        this.AnalysisError("select lag(int_col, 1, int_col) over (order by tinyint_col, int_col) from functional.alltypes", "The default parameter (parameter 3) of LEAD/LAG must be a constant");
        this.AnalysisError("select abs(float_col) over (partition by id order by tinyint_col rows between unbounded preceding and current row) from functional.alltypes", "OVER clause requires aggregate or analytic function: abs(float_col)");
        this.AnalysisError("select group_concat(string_col) over (order by tinyint_col rows between unbounded preceding and current row) from functional.alltypes", "Aggregate function 'group_concat(string_col)' not supported with OVER clause.");
        this.AnalysisError("select sum(int_col) over (partition by id rows between unbounded preceding and current row) from functional.alltypes", "Windowing clause requires ORDER BY clause");
        this.AnalysisError("select dense_rank() over (partition by id) from functional.alltypes", "'dense_rank()' requires an ORDER BY clause");
        this.AnalysisError("select lag(tinyint_col, 1, null) over (partition by id) from functional.alltypes", "'lag(tinyint_col, 1, NULL)' requires an ORDER BY clause");
        this.AnalysisError("select row_number() over (partition by id order by tinyint_col rows between unbounded preceding and current row) from functional.alltypes", "Windowing clause not allowed with 'row_number()'");
        this.AnalysisError("select lead(tinyint_col, 1, null) over (partition by id order by tinyint_col rows between unbounded preceding and current row) from functional.alltypes", "Windowing clause not allowed with 'lead(tinyint_col, 1, NULL)'");
        this.AnalysisError("select sum(tinyint_col) over (partition by id order by tinyint_col rows between unbounded following and current row) from functional.alltypes", "UNBOUNDED FOLLOWING is only allowed for upper bound of BETWEEN");
        this.AnalysisError("select sum(tinyint_col) over (partition by id order by tinyint_col rows unbounded following) from functional.alltypes", "UNBOUNDED FOLLOWING is only allowed for upper bound of BETWEEN");
        this.AnalysisError("select sum(tinyint_col) over (partition by id order by tinyint_col rows between current row and unbounded preceding) from functional.alltypes", "UNBOUNDED PRECEDING is only allowed for lower bound of BETWEEN");
        this.AnalysisError("select sum(tinyint_col) over (partition by id order by tinyint_col rows 2 following) from functional.alltypes", "FOLLOWING requires a BETWEEN clause");
        this.AnalysisError("select sum(tinyint_col) over (partition by id order by tinyint_col rows between 2 following and current row) from functional.alltypes", "A lower window bound of FOLLOWING requires that the upper bound also be FOLLOWING");
        this.AnalysisError("select sum(tinyint_col) over (partition by id order by tinyint_col rows between current row and 2 preceding) from functional.alltypes", "An upper window bound of PRECEDING requires that the lower bound also be PRECEDING");
        this.AnalysisError("select min(int_col) over (partition by id order by tinyint_col rows between tinyint_col preceding and current row) from functional.alltypes", "For ROWS window, the value of a PRECEDING/FOLLOWING offset must be a constant positive integer: tinyint_col PRECEDING");
        this.AnalysisError("select min(int_col) over (partition by id order by tinyint_col rows between current row and '2' following) from functional.alltypes", "For ROWS window, the value of a PRECEDING/FOLLOWING offset must be a constant positive integer: '2' FOLLOWING");
        this.AnalysisError("select min(int_col) over (partition by id order by tinyint_col rows between -2 preceding and current row) from functional.alltypes", "For ROWS window, the value of a PRECEDING/FOLLOWING offset must be a constant positive integer: -2 PRECEDING");
        this.AnalysisError("select min(int_col) over (partition by id order by tinyint_col rows between 2 preceding and 3 preceding) from functional.alltypes", "Offset boundaries are in the wrong order: ROWS BETWEEN 2 PRECEDING AND 3 PRECEDING");
        this.AnalysisError("select min(int_col) over (partition by id order by tinyint_col rows between count(*) preceding and current row) from functional.alltypes", "For ROWS window, the value of a PRECEDING/FOLLOWING offset must be a constant positive integer: count(*) PRECEDING");
        this.AnalyzesOk("select percent_rank() over(order by id) from functional.alltypes");
        this.AnalyzesOk("select cume_dist() over(order by id) from functional.alltypes");
        this.AnalyzesOk("select ntile(3) over(order by id) from functional.alltypes");
        this.AnalyzesOk("select ntile(3000) over(order by id) from functional.alltypes");
        this.AnalyzesOk("select ntile(3000000000) over(order by id) from functional.alltypes");
        this.AnalyzesOk("select percent_rank() over(partition by tinyint_col, bool_col order by id), ntile(3) over(partition by int_col, bool_col order by smallint_col, id), cume_dist() over(partition by int_col, bool_col order by month) from functional.alltypes");
        this.AnalysisError("select ntile(-1) over(order by int_col) from functional.alltypestiny", "NTILE() requires a positive argument: -1");
        this.AnalysisError("select percent_rank() over(partition by int_col) from functional.alltypestiny", "'percent_rank()' requires an ORDER BY clause");
        this.AnalysisError("select cume_dist() over(partition by int_col) from functional.alltypestiny", "'cume_dist()' requires an ORDER BY clause");
        this.AnalysisError("select ntile(2) over(partition by int_col) from functional.alltypestiny", "'ntile(2)' requires an ORDER BY clause");
        this.AnalysisError("select ntile(int_col) over(order by tinyint_col) from functional.alltypestiny", "NTILE() requires a constant argument");
        this.AnalysisError("select id, row_number() over (order by int_array_col) from functional_parquet.allcomplextypes", "ORDER BY expression 'int_array_col' with complex type 'ARRAY<INT>' is not supported.");
        this.AnalysisError("select id, count() over (partition by tiny_struct) from functional_orc_def.complextypes_structs", "PARTITION BY expression 'tiny_struct' with complex type 'STRUCT<b:BOOLEAN>' is not supported.");
    }

    @Test
    public void TestArithmeticTypeCasts() throws AnalysisException {
        Type[] numericTypes;
        for (Type type1 : numericTypes = new Type[]{Type.TINYINT, Type.SMALLINT, Type.INT, Type.BIGINT, Type.FLOAT, Type.DOUBLE, Type.NULL}) {
            for (Type type2 : numericTypes) {
                Type t = Type.getAssignmentCompatibleType((Type)type1, (Type)type2, (TypeCompatibility)TypeCompatibility.DEFAULT);
                Assert.assertTrue((boolean)t.isScalarType());
                ScalarType compatibleType = (ScalarType)t;
                ScalarType promotedType = compatibleType.getNextResolutionType();
                boolean inputsNull = false;
                if (type1.isNull() && type2.isNull()) {
                    inputsNull = true;
                    promotedType = Type.DOUBLE;
                    compatibleType = Type.INT;
                }
                this.typeCastTest(type1, type2, false, ArithmeticExpr.Operator.ADD, null, (Type)promotedType);
                this.typeCastTest(type1, type2, true, ArithmeticExpr.Operator.ADD, null, (Type)promotedType);
                this.typeCastTest(type1, type2, false, ArithmeticExpr.Operator.SUBTRACT, null, (Type)promotedType);
                this.typeCastTest(type1, type2, true, ArithmeticExpr.Operator.SUBTRACT, null, (Type)promotedType);
                this.typeCastTest(type1, type2, false, ArithmeticExpr.Operator.MULTIPLY, null, (Type)promotedType);
                this.typeCastTest(type1, type2, true, ArithmeticExpr.Operator.MULTIPLY, null, (Type)promotedType);
                this.typeCastTest(type1, type2, false, ArithmeticExpr.Operator.MOD, null, (Type)(inputsNull ? Type.DOUBLE : compatibleType));
                this.typeCastTest(type1, type2, true, ArithmeticExpr.Operator.MOD, null, (Type)(inputsNull ? Type.DOUBLE : compatibleType));
                this.typeCastTest(type1, type2, false, ArithmeticExpr.Operator.DIVIDE, null, (Type)Type.DOUBLE);
                this.typeCastTest(type1, type2, true, ArithmeticExpr.Operator.DIVIDE, null, (Type)Type.DOUBLE);
                if (!type1.isFixedPointType() && !type1.isNull() || !type2.isFixedPointType() && !type2.isNull()) continue;
                this.typeCastTest(type1, type2, false, ArithmeticExpr.Operator.INT_DIVIDE, null, (Type)compatibleType);
                this.typeCastTest(type1, type2, true, ArithmeticExpr.Operator.INT_DIVIDE, null, (Type)compatibleType);
                this.typeCastTest(type1, type2, false, ArithmeticExpr.Operator.BITAND, null, (Type)compatibleType);
                this.typeCastTest(type1, type2, true, ArithmeticExpr.Operator.BITAND, null, (Type)compatibleType);
                this.typeCastTest(type1, type2, false, ArithmeticExpr.Operator.BITOR, null, (Type)compatibleType);
                this.typeCastTest(type1, type2, true, ArithmeticExpr.Operator.BITOR, null, (Type)compatibleType);
                this.typeCastTest(type1, type2, false, ArithmeticExpr.Operator.BITXOR, null, (Type)compatibleType);
                this.typeCastTest(type1, type2, true, ArithmeticExpr.Operator.BITXOR, null, (Type)compatibleType);
            }
        }
        ArrayList<ScalarType> fixedPointTypes = new ArrayList<ScalarType>(Type.getIntegerTypes());
        fixedPointTypes.add(Type.NULL);
        Iterator iterator = fixedPointTypes.iterator();
        while (iterator.hasNext()) {
            Type type;
            this.typeCastTest(null, type, false, ArithmeticExpr.Operator.BITNOT, null, (Type)((type = (Type)iterator.next()).isNull() ? Type.INT : type));
        }
    }

    @Test
    public void TestComparisonTypeCasts() throws AnalysisException {
        Type[] types = new Type[]{Type.TINYINT, Type.SMALLINT, Type.INT, Type.BIGINT, Type.FLOAT, Type.DOUBLE, Type.NULL};
        for (BinaryPredicate.Operator cmpOp : BinaryPredicate.Operator.values()) {
            for (Type type1 : types) {
                for (Type type2 : types) {
                    Type compatibleType = Type.getAssignmentCompatibleType((Type)type1, (Type)type2, (TypeCompatibility)TypeCompatibility.ALL_STRICT);
                    if (compatibleType.isInvalid()) {
                        compatibleType = Type.getAssignmentCompatibleType((Type)type1, (Type)type2, (TypeCompatibility)TypeCompatibility.DEFAULT);
                    }
                    this.typeCastTest(type1, type2, false, null, cmpOp, compatibleType);
                    this.typeCastTest(type1, type2, true, null, cmpOp, compatibleType);
                }
            }
        }
    }

    private void typeCastTest(Type type1, Type type2, boolean op1IsLiteral, ArithmeticExpr.Operator arithmeticOp, BinaryPredicate.Operator cmpOp, Type opType) throws AnalysisException {
        Preconditions.checkState((arithmeticOp == null != (cmpOp == null) ? 1 : 0) != 0);
        boolean arithmeticMode = arithmeticOp != null;
        String op1 = "";
        if (type1 != null) {
            op1 = op1IsLiteral ? (String)typeToLiteralValue_.get(type1) : TestSchemaUtils.getAllTypesColumn(type1);
        }
        String op2 = TestSchemaUtils.getAllTypesColumn(type2);
        String queryStr = null;
        queryStr = arithmeticMode ? "select " + op1 + " " + arithmeticOp.toString() + " " + op2 + " AS a from functional.alltypes" : "select int_col from functional.alltypes where " + op1 + " " + cmpOp.toString() + " " + op2;
        SelectStmt select = (SelectStmt)this.AnalyzesOk(queryStr);
        Expr expr = null;
        if (arithmeticMode) {
            List selectListExprs = select.getResultExprs();
            Assert.assertNotNull((Object)selectListExprs);
            Assert.assertEquals((long)selectListExprs.size(), (long)1L);
            expr = (Expr)selectListExprs.get(0);
            Assert.assertEquals((String)("opType= " + opType + " exprType=" + expr.getType()), (Object)opType, (Object)expr.getType());
        } else {
            expr = select.getWhereClause();
            if (!expr.getType().isNull()) {
                Assert.assertEquals((Object)Type.BOOLEAN, (Object)expr.getType());
            }
        }
        this.checkCasts(expr);
        Type child1Type = ((Expr)expr.getChild(0)).getType();
        Type child2Type = type1 == null ? null : ((Expr)expr.getChild(1)).getType();
        Assert.assertTrue((String)("opType= " + opType + " child1Type=" + child1Type), (opType.equals((Object)child1Type) || opType.isNull() || child1Type.isNull() ? 1 : 0) != 0);
        if (type1 != null) {
            Assert.assertTrue((String)("opType= " + opType + " child2Type=" + child2Type), (opType.equals((Object)child2Type) || opType.isNull() || child2Type.isNull() ? 1 : 0) != 0);
        }
    }

    Type getReturnType(String stmt, AnalysisContext ctx) {
        SelectStmt select = (SelectStmt)this.AnalyzesOk(stmt, ctx);
        List selectListExprs = select.getResultExprs();
        Assert.assertNotNull((Object)selectListExprs);
        Assert.assertEquals((long)selectListExprs.size(), (long)1L);
        Expr expr = (Expr)selectListExprs.get(0);
        return expr.getType();
    }

    private void checkReturnType(String stmt, Type resultType, AnalysisContext ctx) {
        Type exprType = this.getReturnType(stmt, ctx);
        Assert.assertEquals((String)("Expected: " + resultType + " != " + exprType), (Object)resultType, (Object)exprType);
    }

    private void checkReturnType(String stmt, Type resultType) {
        this.checkReturnType(stmt, resultType, this.createAnalysisCtx("default"));
    }

    private void checkDecimalReturnType(String stmt, Type decimalV1ResultType, Type decimalV2ResultType) {
        AnalysisContext ctx = this.createAnalysisCtx("default");
        ctx.getQueryOptions().setDecimal_v2(false);
        this.checkReturnType(stmt, decimalV1ResultType, ctx);
        ctx = this.createAnalysisCtx("default");
        ctx.getQueryOptions().setDecimal_v2(true);
        this.checkReturnType(stmt, decimalV2ResultType, ctx);
    }

    private void checkDecimalReturnType(String stmt, Type resultType) {
        this.checkDecimalReturnType(stmt, resultType, resultType);
    }

    @Test
    public void TestNumericLiteralTypeResolution() throws AnalysisException {
        this.checkReturnType("select 1", (Type)Type.TINYINT);
        this.checkDecimalReturnType("select 1.1", (Type)ScalarType.createDecimalType((int)2, (int)1));
        this.checkDecimalReturnType("select 01.1", (Type)ScalarType.createDecimalType((int)2, (int)1));
        this.checkDecimalReturnType("select 1 + 1.1", (Type)Type.DOUBLE, (Type)ScalarType.createDecimalType((int)5, (int)1));
        this.checkDecimalReturnType("select 0.23 + 1.1", (Type)ScalarType.createDecimalType((int)4, (int)2));
        this.checkReturnType("select float_col + float_col from functional.alltypestiny", (Type)Type.DOUBLE);
        this.checkReturnType("select int_col + int_col from functional.alltypestiny", (Type)Type.BIGINT);
        this.checkDecimalReturnType("select float_col + 1.1 from functional.alltypestiny", (Type)Type.DOUBLE, (Type)ScalarType.createDecimalType((int)38, (int)8));
        this.checkDecimalReturnType("select float_col - 1.1 from functional.alltypestiny", (Type)Type.DOUBLE, (Type)ScalarType.createDecimalType((int)38, (int)8));
        this.checkDecimalReturnType("select float_col / 1.1 from functional.alltypestiny", (Type)Type.DOUBLE, (Type)ScalarType.createDecimalType((int)38, (int)8));
        this.checkDecimalReturnType("select float_col % 1.1 from functional.alltypestiny", (Type)Type.FLOAT, (Type)ScalarType.createDecimalType((int)10, (int)9));
        this.checkDecimalReturnType("select d1 + 1.1 from functional.decimal_tbl", (Type)ScalarType.createDecimalType((int)11, (int)1));
        this.checkDecimalReturnType("select d1 - 1.1 from functional.decimal_tbl", (Type)ScalarType.createDecimalType((int)11, (int)1));
        this.checkDecimalReturnType("select d1 * 1.1 from functional.decimal_tbl", (Type)ScalarType.createDecimalType((int)11, (int)1), (Type)ScalarType.createDecimalType((int)12, (int)1));
        this.checkDecimalReturnType("select d1 / 1.1 from functional.decimal_tbl", (Type)ScalarType.createDecimalType((int)14, (int)4), (Type)ScalarType.createDecimalType((int)16, (int)6));
        this.checkDecimalReturnType("select d1 % 1.1 from functional.decimal_tbl", (Type)ScalarType.createDecimalType((int)2, (int)1));
        this.checkDecimalReturnType("select d1 + 2 from functional.decimal_tbl", (Type)ScalarType.createDecimalType((int)10, (int)0));
        this.checkDecimalReturnType("select d1 - 2 from functional.decimal_tbl", (Type)ScalarType.createDecimalType((int)10, (int)0));
        this.checkDecimalReturnType("select d1 * 2 from functional.decimal_tbl", (Type)ScalarType.createDecimalType((int)12, (int)0), (Type)ScalarType.createDecimalType((int)13, (int)0));
        this.checkDecimalReturnType("select d1 / 2 from functional.decimal_tbl", (Type)ScalarType.createDecimalType((int)13, (int)4), (Type)ScalarType.createDecimalType((int)15, (int)6));
        this.checkDecimalReturnType("select d1 % 2 from functional.decimal_tbl", (Type)ScalarType.createDecimalType((int)3, (int)0));
        this.checkDecimalReturnType("select int_col + 1.1 from functional.alltypestiny", (Type)Type.DOUBLE, (Type)ScalarType.createDecimalType((int)12, (int)1));
        this.checkDecimalReturnType("select int_col - 1.1 from functional.alltypestiny", (Type)Type.DOUBLE, (Type)ScalarType.createDecimalType((int)12, (int)1));
        this.checkDecimalReturnType("select int_col * 1.1 from functional.alltypestiny", (Type)Type.DOUBLE, (Type)ScalarType.createDecimalType((int)13, (int)1));
        this.checkDecimalReturnType("select int_col / 1.1 from functional.alltypestiny", (Type)Type.DOUBLE, (Type)ScalarType.createDecimalType((int)17, (int)6));
        this.checkDecimalReturnType("select int_col % 1.1 from functional.alltypestiny", (Type)Type.DOUBLE, (Type)ScalarType.createDecimalType((int)2, (int)1));
        this.checkDecimalReturnType("select float_col * d1 from functional.alltypestiny join functional.decimal_tbl", (Type)Type.DOUBLE);
        this.checkDecimalReturnType("select d1 * float_col from functional.alltypestiny join functional.decimal_tbl", (Type)Type.DOUBLE);
        this.checkDecimalReturnType("select double_col * d1 from functional.alltypestiny join functional.decimal_tbl", (Type)Type.DOUBLE);
        this.checkDecimalReturnType("select float_col * 10 from functional.alltypestiny", (Type)Type.DOUBLE);
        this.checkDecimalReturnType("select 10 * float_col from functional.alltypestiny", (Type)Type.DOUBLE);
        this.checkDecimalReturnType("select double_col * 10 from functional.alltypestiny", (Type)Type.DOUBLE);
        this.checkDecimalReturnType("select float_col * 10.0 from functional.alltypestiny", (Type)Type.DOUBLE);
        this.checkDecimalReturnType("select 10.0 * float_col from functional.alltypestiny", (Type)Type.DOUBLE);
        this.checkDecimalReturnType("select double_col * 10.0 from functional.alltypestiny", (Type)Type.DOUBLE);
        this.checkDecimalReturnType("select round(1.2345, 2) * pow(10, 10)", (Type)Type.DOUBLE);
        this.checkDecimalReturnType("select round(1.2345, 2) + pow(10, 10)", (Type)Type.DOUBLE, (Type)ScalarType.createDecimalType((int)38, (int)16));
        this.checkDecimalReturnType("select int_col + cast(1.1 as decimal(2,1)) from  functional.alltypestiny", (Type)ScalarType.createDecimalType((int)12, (int)1));
        this.checkDecimalReturnType("select float_col + cast(1.1 as decimal(2,1)) from  functional.alltypestiny", (Type)ScalarType.createDecimalType((int)38, (int)9), (Type)ScalarType.createDecimalType((int)38, (int)8));
        this.checkDecimalReturnType("select float_col + cast(1.1*1.2+1.3 as decimal(2,1)) from  functional.alltypestiny", (Type)ScalarType.createDecimalType((int)38, (int)9), (Type)ScalarType.createDecimalType((int)38, (int)8));
        this.checkDecimalReturnType("select float_col + cast(1.1 as float) from  functional.alltypestiny", (Type)Type.DOUBLE);
        this.checkDecimalReturnType("select float_col + cast(1.1 as float) from  functional.alltypestiny", (Type)Type.DOUBLE);
        this.checkDecimalReturnType("select float_col + cast(1.1 as double) from  functional.alltypestiny", (Type)Type.DOUBLE);
        this.checkDecimalReturnType("select 1.0 + float_col + 1.1 from functional.alltypestiny", (Type)Type.DOUBLE, (Type)ScalarType.createDecimalType((int)38, (int)7));
        this.checkDecimalReturnType("select 1.0 + 2.0 + float_col from functional.alltypestiny", (Type)Type.DOUBLE, (Type)ScalarType.createDecimalType((int)38, (int)8));
        this.checkDecimalReturnType("select 1.0 + 2.0 + pi() * float_col from functional.alltypestiny", (Type)Type.DOUBLE, (Type)ScalarType.createDecimalType((int)38, (int)16));
        this.checkDecimalReturnType("select 1.0 + d1 + 1.1 from functional.decimal_tbl", (Type)ScalarType.createDecimalType((int)12, (int)1));
        this.checkDecimalReturnType("select 1.0 + 2.0 + d1 from functional.decimal_tbl", (Type)ScalarType.createDecimalType((int)11, (int)1));
        this.checkDecimalReturnType("select 1.0 + 2.0 + pi() * d1 from functional.decimal_tbl", (Type)Type.DOUBLE, (Type)ScalarType.createDecimalType((int)38, (int)16));
        this.checkDecimalReturnType("select double_col + 1.23 + float_col + 1.0  from functional.alltypestiny", (Type)Type.DOUBLE, (Type)ScalarType.createDecimalType((int)38, (int)7));
        this.checkDecimalReturnType("select double_col + 1.23 + float_col + 1.0 + int_col  + bigint_col from functional.alltypestiny", (Type)Type.DOUBLE, (Type)ScalarType.createDecimalType((int)38, (int)6));
        this.checkDecimalReturnType("select d1 + 1.23 + d2 + 1.0  from functional.decimal_tbl", (Type)ScalarType.createDecimalType((int)14, (int)2));
        this.checkDecimalReturnType("select t1.int_col + t2.c1 from functional.alltypestiny t1  cross join functional.decimal_tiny t2", (Type)ScalarType.createDecimalType((int)15, (int)4));
        this.checkDecimalReturnType("select 1.1 + t1.int_col + t2.c1 from functional.alltypestiny t1  cross join functional.decimal_tiny t2", (Type)ScalarType.createDecimalType((int)38, (int)17), (Type)ScalarType.createDecimalType((int)16, (int)4));
    }

    private void checkCasts(Expr expr) {
        CastExpr cast;
        if (expr instanceof CastExpr && (cast = (CastExpr)expr).isImplicit()) {
            Assert.assertFalse((String)(expr.getType() + " == " + ((Expr)expr.getChild(0)).getType()), (boolean)expr.getType().equals((Object)((Expr)expr.getChild(0)).getType()));
            Assert.assertFalse((String)expr.debugString(), (boolean)(expr.getChild(0) instanceof LiteralExpr));
        }
        for (Expr child : expr.getChildren()) {
            this.checkCasts(child);
        }
    }

    public void DoNotTestStringLiteralToDateCasts() throws AnalysisException {
        this.AnalysisError("select int_col from functional.alltypes where date_col = 'ABCD'", "Unable to parse string 'ABCD' to date");
        this.AnalysisError("select int_col from functional.alltypes where date_col = 'ABCD-EF-GH'", "Unable to parse string 'ABCD-EF-GH' to date");
        this.AnalysisError("select int_col from functional.alltypes where date_col = '2006'", "Unable to parse string '2006' to date");
        this.AnalysisError("select int_col from functional.alltypes where date_col = '0.5'", "Unable to parse string '0.5' to date");
        this.AnalysisError("select int_col from functional.alltypes where date_col = '2006-10-10 ABCD'", "Unable to parse string '2006-10-10 ABCD' to date");
        this.AnalysisError("select int_col from functional.alltypes where date_col = '2006-10-10 12:11:05.ABC'", "Unable to parse string '2006-10-10 12:11:05.ABC' to date");
    }

    @Test
    public void TestFixedPointArithmeticOps() throws AnalysisException {
        this.AnalysisError("select ~float_col from functional.alltypes", "'~' operation only allowed on integer types");
        this.AnalysisError("select float_col! from functional.alltypes", "'!' operation only allowed on integer types");
        this.AnalysisError("select float_col ^ int_col from functional.alltypes", "Invalid non-integer argument to operation '^'");
        this.AnalysisError("select float_col & int_col from functional.alltypes", "Invalid non-integer argument to operation '&'");
        this.AnalysisError("select double_col | bigint_col from functional.alltypes", "Invalid non-integer argument to operation '|'");
        this.AnalysisError("select int_col from functional.alltypes where float_col & bool_col > 5", "Arithmetic operation requires numeric operands");
    }

    @Test
    public void TestTimestampArithmeticExpressions() {
        String[] valueTypeCols = new String[]{"tinyint_col", "smallint_col", "int_col", "bigint_col", "NULL"};
        for (TimestampArithmeticExpr.TimeUnit timeUnit : TimestampArithmeticExpr.TimeUnit.values()) {
            for (String col : valueTypeCols) {
                this.AnalyzesOk("select timestamp_col + interval " + col + " " + timeUnit.toString() + " from functional.alltypes");
                this.AnalyzesOk("select timestamp_col - interval " + col + " " + timeUnit.toString() + " from functional.alltypes");
                this.AnalyzesOk("select NULL - interval " + col + " " + timeUnit.toString() + " from functional.alltypes");
                this.AnalyzesOk("select interval " + col + " " + timeUnit.toString() + " + timestamp_col from functional.alltypes");
                this.AnalyzesOk("select date_add(timestamp_col, interval " + col + " " + timeUnit.toString() + ") from functional.alltypes");
                this.AnalyzesOk("select date_sub(timestamp_col, interval " + col + " " + timeUnit.toString() + ") from functional.alltypes");
                this.AnalyzesOk("select date_add(NULL, interval " + col + " " + timeUnit.toString() + ") from functional.alltypes");
                this.AnalyzesOk("select date_sub(NULL, interval " + col + " " + timeUnit.toString() + ") from functional.alltypes");
            }
        }
        this.AnalysisError("select float_col + interval 10 years from functional.alltypes", "Operand 'float_col' of timestamp/date arithmetic expression 'float_col + INTERVAL 10 years' returns type 'FLOAT'. Expected type 'TIMESTAMP' or 'DATE'.");
        this.AnalysisError("select string_col + interval 10 years from functional.alltypes", "Operand 'string_col' of timestamp/date arithmetic expression 'string_col + INTERVAL 10 years' returns type 'STRING'. Expected type 'TIMESTAMP' or 'DATE'.");
        this.AnalysisError("select tiny_struct + interval 10 years from functional_orc_def.complextypes_structs", "Operand 'tiny_struct' of timestamp/date arithmetic expression 'tiny_struct + INTERVAL 10 years' returns type 'STRUCT<b:BOOLEAN>'. Expected type 'TIMESTAMP' or 'DATE'.");
        this.AnalysisError("select interval 10 years + float_col from functional.alltypes", "Operand 'float_col' of timestamp/date arithmetic expression 'INTERVAL 10 years + float_col' returns type 'FLOAT'. Expected type 'TIMESTAMP' or 'DATE'");
        this.AnalysisError("select interval 10 years + string_col from functional.alltypes", "Operand 'string_col' of timestamp/date arithmetic expression 'INTERVAL 10 years + string_col' returns type 'STRING'. Expected type 'TIMESTAMP' or 'DATE'");
        this.AnalysisError("select interval 10 years + int_array_col from functional.allcomplextypes", "Operand 'int_array_col' of timestamp/date arithmetic expression 'INTERVAL 10 years + int_array_col' returns type 'ARRAY<INT>'. Expected type 'TIMESTAMP' or 'DATE'.");
        this.AnalysisError("select date_add(float_col, interval 10 years) from functional.alltypes", "Operand 'float_col' of timestamp/date arithmetic expression 'DATE_ADD(float_col, INTERVAL 10 years)' returns type 'FLOAT'. Expected type 'TIMESTAMP' or 'DATE'.");
        this.AnalysisError("select date_add(string_col, interval 10 years) from functional.alltypes", "Operand 'string_col' of timestamp/date arithmetic expression 'DATE_ADD(string_col, INTERVAL 10 years)' returns type 'STRING'. Expected type 'TIMESTAMP' or 'DATE'.");
        this.AnalysisError("select date_add(int_map_col, interval 10 years) from functional.allcomplextypes", "Operand 'int_map_col' of timestamp/date arithmetic expression 'DATE_ADD(int_map_col, INTERVAL 10 years)' returns type 'MAP<STRING,INT>'. Expected type 'TIMESTAMP' or 'DATE'.");
        this.AnalysisError("select timestamp_col + interval 5.2 years from functional.alltypes", "Operand '5.2' of timestamp/date arithmetic expression 'timestamp_col + INTERVAL 5.2 years' returns type 'DECIMAL(2,1)'. Expected an integer type.");
        this.AnalysisError("select cast(0 as timestamp) + interval int_array_col years from functional.allcomplextypes", "Operand 'int_array_col' of timestamp/date arithmetic expression 'CAST(0 AS TIMESTAMP) + INTERVAL int_array_col years' returns type 'ARRAY<INT>'. Expected an integer type.");
        this.AnalysisError("select timestamp_col + interval '10' years from functional.alltypes", "Operand ''10'' of timestamp/date arithmetic expression 'timestamp_col + INTERVAL '10' years' returns type 'STRING'. Expected an integer type.");
        this.AnalysisError("select date_add(timestamp_col, interval '10' years) from functional.alltypes", "Operand ''10'' of timestamp/date arithmetic expression 'DATE_ADD(timestamp_col, INTERVAL '10' years)' returns type 'STRING'. Expected an integer type.");
        this.AnalyzesOk("select timestamp_col + interval cast('10' as int) years from functional.alltypes");
        this.AnalysisError("select interval 5.2 years + timestamp_col from functional.alltypes", "Operand '5.2' of timestamp/date arithmetic expression 'INTERVAL 5.2 years + timestamp_col' returns type 'DECIMAL(2,1)'. Expected an integer type.");
        this.AnalyzesOk("select interval cast('10' as int) years + timestamp_col from functional.alltypes");
        this.AnalysisError("select date_add(timestamp_col, interval 5.2 years) from functional.alltypes", "Operand '5.2' of timestamp/date arithmetic expression 'DATE_ADD(timestamp_col, INTERVAL 5.2 years)' returns type 'DECIMAL(2,1)'. Expected an integer type.");
        this.AnalyzesOk("select date_add(timestamp_col, interval cast('10' as int) years)  from functional.alltypes");
        this.AnalysisError("select timestamp_col + interval 10 error from functional.alltypes", "Invalid time unit 'error' in timestamp/date arithmetic expression 'timestamp_col + INTERVAL 10 error'.");
        this.AnalysisError("select timestamp_col - interval 10 error from functional.alltypes", "Invalid time unit 'error' in timestamp/date arithmetic expression 'timestamp_col - INTERVAL 10 error'.");
        this.AnalysisError("select interval 10 error + timestamp_col from functional.alltypes", "Invalid time unit 'error' in timestamp/date arithmetic expression 'INTERVAL 10 error + timestamp_col'.");
        this.AnalysisError("select date_add(timestamp_col, interval 10 error) from functional.alltypes", "Invalid time unit 'error' in timestamp/date arithmetic expression 'DATE_ADD(timestamp_col, INTERVAL 10 error)'.");
        this.AnalysisError("select date_sub(timestamp_col, interval 10 error) from functional.alltypes", "Invalid time unit 'error' in timestamp/date arithmetic expression 'DATE_SUB(timestamp_col, INTERVAL 10 error)'.");
    }

    @Test
    public void TestFunctionCallExpr() throws AnalysisException {
        this.AnalyzesOk("select pi()");
        this.AnalyzesOk("select _impala_builtins.pi()");
        this.AnalyzesOk("select _impala_builtins.decode(1, 2, 3)");
        this.AnalyzesOk("select _impala_builtins.DECODE(1, 2, 3)");
        this.AnalyzesOk("select sin(pi())");
        this.AnalyzesOk("select sin(cos(pi()))");
        this.AnalyzesOk("select sin(cos(tan(e())))");
        this.AnalysisError("select pi(*)", "Cannot pass '*' to scalar function.");
        this.AnalysisError("select sin(DISTINCT 1)", "Cannot pass 'DISTINCT' to scalar function.");
        this.AnalysisError("select * from functional.alltypes where pi(*) = 5", "Cannot pass '*' to scalar function.");
        this.AnalysisError("select a.b.sin()", "Invalid function name: 'a.b.sin'. Expected [dbname].funcname");
        this.AnalyzesOk("select precision(1)");
        this.AnalyzesOk("select precision(cast('1.1' as decimal))");
        this.AnalyzesOk("select scale(1.1)");
        this.AnalysisError("select scale('1.1')", "No matching function with signature: scale(STRING).");
        this.AnalyzesOk("select round(cast('1.1' as decimal), cast(1 as int))");
        this.AnalyzesOk("select round(cast('1.1' as decimal), 1)");
        this.AnalysisError("select lower(tiny_struct) from functional_orc_def.complextypes_structs", "No matching function with signature: lower(STRUCT<b:BOOLEAN>).");
        this.AnalyzesOk("select extract(year from now())");
        this.AnalyzesOk("select extract(year from cast(now() as date))");
        this.AnalyzesOk("select extract(year from date_col) from functional.date_tbl");
        this.AnalyzesOk("select extract(hour from now())");
        this.AnalysisError("select extract(hour from cast(now() as date))", "Time unit 'hour' in expression 'EXTRACT(hour FROM CAST(now() AS DATE))' is invalid. Expected one of YEAR, QUARTER, MONTH, DAY.");
        this.AnalysisError("select extract(foo from now())", "Time unit 'foo' in expression 'EXTRACT(foo FROM now())' is invalid. Expected one of YEAR, QUARTER, MONTH, DAY, HOUR, MINUTE, SECOND, MILLISECOND, EPOCH.");
        this.AnalysisError("select extract(foo from date_col) from functional.date_tbl", "Time unit 'foo' in expression 'EXTRACT(foo FROM date_col)' is invalid. Expected one of YEAR, QUARTER, MONTH, DAY.");
        this.AnalysisError("select extract(year from 0)", "Expression '0' in 'EXTRACT(year FROM 0)' has a return type of TINYINT but a TIMESTAMP or DATE is required.");
        this.AnalysisError("select functional.extract(year from now())", "Function functional.extract conflicts with the EXTRACT builtin");
        this.AnalysisError("select date_part(year from now())", "Function DATE_PART does not accept the keyword FROM");
        this.AnalysisError("select lower('FOO' ignore nulls)", "Function LOWER does not accept the keyword IGNORE NULLS.");
        this.AnalyzesOk("select nvl2(1, 'not null', 'null')");
        this.AnalyzesOk("select nvl2(null, 'not null', 'null')");
        this.AnalyzesOk("select nvl2('null', 'not null', 'null')");
        this.AnalyzesOk("select nvl2(int_col, 'not null', 'null') from functional.alltypesagg");
        this.AnalyzesOk("select nvl2(int_col, extract (year from now()), extract (month from now())) from functional.alltypesagg");
        this.AnalyzesOk("select nvl2(nvl2(null, 1, 2), 'not null', 'null')");
        this.AnalyzesOk("select nvl2(nvl2(null, null, null), nvl2(null, 'not null', 'null'), nvl2(2, 'not null', 'null'))");
        this.AnalyzesOk("select int_col from functional.alltypesagg where nvl2(int_col, true, false)");
        this.AnalysisError("select nvl2('null', true, '4')", "No matching function with signature: if(BOOLEAN, BOOLEAN, STRING).");
        this.AnalysisError("select nvl2(now(), true)", "No matching function with signature: if(BOOLEAN, BOOLEAN).");
        this.AnalysisError("select nvl2()", "No matching function with signature: if().");
        this.AnalyzesOk("select nullif(1, 1)");
        this.AnalyzesOk("select nullif(NULL, 'not null')");
        this.AnalyzesOk("select nullif('not null', null)");
        this.AnalyzesOk("select nullif(int_col, int_col) from functional.alltypesagg");
        this.AnalysisError("select nullif(1,2,3)", "default.nullif() unknown");
        this.AnalysisError("select nullif('x', 1)", "operands of type STRING and TINYINT are not comparable: 'x' IS DISTINCT FROM 1");
        this.AnalyzesOk("select length(cast('a' as binary))");
        this.AnalysisError("select lower(cast('a' as binary))", "No matching function with signature: lower(BINARY).");
    }

    @Test
    public void TestVarArgFunctions() throws AnalysisException {
        this.AnalyzesOk("select concat('a')");
        this.AnalyzesOk("select concat('a', 'b')");
        this.AnalyzesOk("select concat('a', 'b', 'c')");
        this.AnalyzesOk("select concat('a', 'b', 'c', 'd')");
        this.AnalyzesOk("select concat('a', 'b', 'c', 'd', 'e')");
        this.AnalyzesOk("select coalesce(true)");
        this.AnalyzesOk("select coalesce(true, false, true)");
        this.AnalyzesOk("select coalesce(5)");
        this.AnalyzesOk("select coalesce(5, 6, 7)");
        this.AnalyzesOk("select coalesce('a')");
        this.AnalyzesOk("select coalesce('a', 'b', 'c')");
        this.AnalysisError("select concat()", "No matching function with signature: concat().");
        this.AnalysisError("select coalesce()", "No matching function with signature: coalesce().");
    }

    @Test
    public void TestNullFunctionArguments() {
        this.AnalyzesOk("select substring(NULL, 1, 2)");
        this.AnalyzesOk("select substring('a', NULL, 2)");
        this.AnalyzesOk("select substring('a', 1, NULL)");
        this.AnalyzesOk("select substring(NULL, NULL, NULL)");
        this.AnalysisError("select substring(1, NULL, NULL)", "No matching function with signature: substring(TINYINT, NULL_TYPE, NULL_TYPE).");
        this.AnalysisError("select substring(NULL, 'a', NULL)", "No matching function with signature: substring(NULL_TYPE, STRING, NULL_TYPE).");
        this.AnalyzesOk("select concat(NULL, 'a', 'b')");
        this.AnalyzesOk("select concat('a', NULL, 'b')");
        this.AnalyzesOk("select concat('a', 'b', NULL)");
        this.AnalyzesOk("select concat(NULL, NULL, NULL)");
        this.AnalysisError("select concat(NULL, 1, 'b')", "No matching function with signature: concat(NULL_TYPE, TINYINT, STRING).");
        this.AnalysisError("select concat('a', NULL, 1)", "No matching function with signature: concat(STRING, NULL_TYPE, TINYINT).");
        this.AnalysisError("select concat(1, 'b', NULL)", "No matching function with signature: concat(TINYINT, STRING, NULL_TYPE).");
    }

    @Test
    public void TestCaseExpr() throws AnalysisException {
        this.AnalyzesOk("select case when 20 > 10 then 20 else 15 end");
        this.AnalyzesOk("select case when 20 > 10 then 20 end");
        this.AnalyzesOk("select case when bool_col then 20 else 15 end from functional.alltypes");
        this.AnalyzesOk("select case when 20 > 10 then 20 when 1 > 2 then 1.0 else 15 end");
        this.AnalyzesOk("select case when 20 > 10 then 20 when 1 > 2 then 1.0 when 4 < 5 then 2 else 15 end");
        this.AnalyzesOk("select case when 20 > 10 then date '2001-01-01' else cast('2001-01-01' as timestamp) end");
        this.AnalysisError("select case when 20 then 20 when 1 > 2 then timestamp_col when 4 < 5 then 2 else 15 end from functional.alltypes", "When expr '20' is not of type boolean and not castable to type boolean.");
        this.AnalysisError("select case when int_array_col then 20 when 1 > 2 then id end from functional.allcomplextypes", "When expr 'int_array_col' is not of type boolean and not castable to type boolean.");
        this.AnalysisError("select case when 20 > 10 then 20 when 1 > 2 then timestamp_col when 4 < 5 then 2 else 15 end from functional.alltypes", "Incompatible return types 'TINYINT' and 'TIMESTAMP' of exprs '20' and 'timestamp_col'.");
        this.AnalysisError("select case when 20 > 10 then 20 when 1 > 2 then date_col when 4 < 5 then 2 else 15 end from functional.date_tbl", "Incompatible return types 'TINYINT' and 'DATE' of exprs '20' and 'date_col'.");
        this.AnalysisError("select case when 20 > 10 then 20 when 1 > 2 then int_map_col else 15 end from functional.allcomplextypes", "Incompatible return types 'TINYINT' and 'MAP<STRING,INT>' of exprs '20' and 'int_map_col'.");
        this.AnalyzesOk("select case int_col when 20 then 30 else 15 end from functional.alltypes");
        this.AnalyzesOk("select case int_col when 20 then 30 end from functional.alltypes");
        this.AnalyzesOk("select case int_col when bigint_col then 30 else 15 end from functional.alltypes");
        this.AnalyzesOk("select case date_col when timestamp_col then 30 else 15 end from functional.date_tbl, functional.alltypes");
        this.AnalyzesOk("select case bigint_col when int_col then 30 else 15 end from functional.alltypes");
        this.AnalyzesOk("select case timestamp_col when date_col then 30 else 15 end from functional.alltypes, functional.date_tbl");
        this.AnalyzesOk("select case bigint_col when int_col then 30 when double_col then 1.0 else 15 end from functional.alltypes");
        this.AnalysisError("select case bigint_col when timestamp_col then 30 when double_col then 1.0 else 15 end from functional.alltypes", "Incompatible return types 'BIGINT' and 'TIMESTAMP' of exprs 'bigint_col' and 'timestamp_col'.");
        this.AnalysisError("select case bigint_col when date_col then 30 when double_col then 1.0 else 15 end from functional.alltypes, functional.date_tbl", "Incompatible return types 'BIGINT' and 'DATE' of exprs 'bigint_col' and 'date_col'.");
        this.AnalysisError("select case bigint_col when int_col then 30 when double_col then timestamp_col else 15 end from functional.alltypes", "Incompatible return types 'TINYINT' and 'TIMESTAMP' of exprs '30' and 'timestamp_col'.");
        this.AnalysisError("select case bigint_col when int_col then 30 when double_col then date_col else 15 end from functional.alltypes, functional.date_tbl", "Incompatible return types 'TINYINT' and 'DATE' of exprs '30' and 'date_col'.");
        this.AnalyzesOk("select case when true then 1 end");
        this.AnalyzesOk("select case when true then 1.0 end");
        this.AnalyzesOk("select case when true then 'abc' end");
        this.AnalyzesOk("select case when true then cast('2011-01-01 09:01:01' as timestamp) end");
        this.AnalyzesOk("select case when true then date '2011-01-01' end");
        this.AnalyzesOk("select case NULL when 1 then 2 else 3 end");
        this.AnalyzesOk("select case 1 when NULL then 2 else 3 end");
        this.AnalyzesOk("select case 1 when 2 then NULL else 3 end");
        this.AnalyzesOk("select case 1 when 2 then 3 else NULL end");
        this.AnalyzesOk("select case NULL when NULL then NULL else NULL end");
        this.checkReturnType("select case when 5 < 3 then cast('L'  as char(1)) else cast('M'  as char(1)) end", (Type)ScalarType.createCharType((int)1));
        this.checkReturnType("select case when 5 < 3 then cast('L'  as string) else cast('M'  as char(1)) end", (Type)ScalarType.STRING);
    }

    @Test
    public void TestDecodeExpr() throws AnalysisException {
        this.AnalyzesOk("select decode(1, 1, 1)");
        this.AnalyzesOk("select decode(1, 1, 'foo')");
        this.AnalyzesOk("select decode(1, 2, true, false)");
        this.AnalyzesOk("select decode(null, null, null, null, null, null)");
        this.assertCaseEquivalence("CASE WHEN 1 = 2 THEN NULL ELSE 'foo' END", "decode(1, 2, NULL, 'foo')");
        this.assertCaseEquivalence("CASE WHEN 1 = 2 THEN NULL ELSE 4 END", "decode(1, 2, NULL, 4)");
        this.assertCaseEquivalence("CASE WHEN string_col = 'a' THEN 1 WHEN string_col = 'b' THEN 2 ELSE 3 END", "decode(string_col, 'a', 1, 'b', 2, 3)");
        this.assertCaseEquivalence("CASE WHEN int_col IS NULL AND bigint_col IS NULL OR int_col = bigint_col THEN tinyint_col ELSE smallint_col END", "decode(int_col, bigint_col, tinyint_col, smallint_col)");
        this.assertCaseEquivalence("CASE WHEN int_col = 1 THEN 1 WHEN int_col IS NULL AND bigint_col IS NULL OR int_col = bigint_col THEN 2 WHEN int_col IS NULL THEN 3 ELSE 4 END", "decode(int_col, 1, 1, bigint_col, 2, NULL, 3, 4)");
        this.assertCaseEquivalence("CASE WHEN NULL IS NULL THEN NULL ELSE NULL END", "decode(null, null, null, null)");
        this.AnalysisError("select decode()", "DECODE in 'decode()' requires at least 3 arguments");
        this.AnalysisError("select decode(1)", "DECODE in 'decode(1)' requires at least 3 arguments");
        this.AnalysisError("select decode(1, 2)", "DECODE in 'decode(1, 2)' requires at least 3 arguments");
        this.AnalysisError("select decode(*)", "Cannot pass '*'");
        this.AnalysisError("select decode(distinct 1, 2, 3)", "Cannot pass 'DISTINCT'");
        this.AnalysisError("select decode(true, 'foo', 1)", "operands of type BOOLEAN and STRING are not comparable: TRUE = 'foo'");
        this.AnalysisError("select functional.decode(1, 1, 1)", "functional.decode() unknown");
    }

    void assertCaseEquivalence(String caseSql, String decodeSql) throws AnalysisException {
        String sqlTemplate = "select %s from functional.alltypes";
        SelectStmt stmt = (SelectStmt)this.AnalyzesOk(String.format(sqlTemplate, caseSql));
        CaseExpr caseExpr = (CaseExpr)((SelectListItem)stmt.getSelectList().getItems().get(0)).getExpr();
        this.makeExprExecutable((Expr)caseExpr, stmt.getAnalyzer());
        TExpr caseThrift = caseExpr.treeToThrift();
        stmt = (SelectStmt)this.AnalyzesOk(String.format(sqlTemplate, decodeSql));
        CaseExpr decodeExpr = (CaseExpr)((SelectListItem)stmt.getSelectList().getItems().get(0)).getExpr();
        Assert.assertEquals((Object)caseSql, (Object)decodeExpr.toCaseSql());
        this.makeExprExecutable((Expr)caseExpr, stmt.getAnalyzer());
        Assert.assertEquals((Object)caseThrift, (Object)decodeExpr.treeToThrift());
    }

    private void makeExprExecutable(Expr e, Analyzer analyzer) {
        ArrayList tids = new ArrayList();
        ArrayList sids = new ArrayList();
        e.getIds(tids, sids);
        for (SlotId sid : sids) {
            SlotDescriptor slotDesc = analyzer.getDescTbl().getSlotDesc(sid);
            slotDesc.setIsMaterialized(true);
        }
        for (TupleId tid : tids) {
            TupleDescriptor tupleDesc = analyzer.getTupleDesc(tid);
            tupleDesc.setIsMaterialized(true);
            tupleDesc.computeMemLayout();
        }
    }

    @Test
    public void TestConditionalExprs() {
        this.AnalyzesOk("select if(true, false, false)");
        this.AnalyzesOk("select if(1 != 2, false, false)");
        this.AnalyzesOk("select if(bool_col, false, true) from functional.alltypes");
        this.AnalyzesOk("select if(bool_col, int_col, double_col) from functional.alltypes");
        this.AnalyzesOk("select if(NULL, false, true) from functional.alltypes");
        this.AnalyzesOk("select if(bool_col, NULL, true) from functional.alltypes");
        this.AnalyzesOk("select if(bool_col, false, NULL) from functional.alltypes");
        this.AnalyzesOk("select if(NULL, NULL, NULL) from functional.alltypes");
        this.AnalysisError("select if(true, tiny_struct, tiny_struct) from functional_orc_def.complextypes_structs", "No matching function with signature: if(BOOLEAN, STRUCT<b:BOOLEAN>, STRUCT<b:BOOLEAN>).");
        this.AnalysisError("select if(true, false, true, true)", "No matching function with signature: if(BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN).");
        this.AnalysisError("select if(true, false)", "No matching function with signature: if(BOOLEAN, BOOLEAN).");
        this.AnalysisError("select if(false)", "No matching function with signature: if(BOOLEAN).");
        for (String literal : typeToLiteralValue_.values()) {
            this.AnalyzesOk(String.format("select isnull(%s, %s)", literal, literal));
            this.AnalyzesOk(String.format("select isnull(%s, NULL)", literal));
            this.AnalyzesOk(String.format("select isnull(NULL, %s)", literal));
        }
        this.AnalysisError("select isnull(1)", "No matching function with signature: isnull(TINYINT).");
        this.AnalysisError("select isnull(1, 2, 3)", "No matching function with signature: isnull(TINYINT, TINYINT, TINYINT).");
        this.AnalysisError("select isnull('a', true)", "No matching function with signature: isnull(STRING, BOOLEAN).");
        this.AnalysisError("select isnull(1, int_array_col) from functional.allcomplextypes", "No matching function with signature: isnull(TINYINT, ARRAY<INT>).");
    }

    @Test
    public void TestUdfs() {
        this.AnalysisError("select udf()", "default.udf() unknown");
        this.AnalysisError("select functional.udf()", "functional.udf() unknown");
        this.AnalysisError("select udf(1)", "default.udf() unknown");
        catalog_.addFunction((Function)ScalarFunction.createForTesting((String)"default", (String)"udf", new ArrayList(), (Type)Type.INT, (String)"/dummy", (String)"dummy.class", null, null, (TFunctionBinaryType)TFunctionBinaryType.NATIVE));
        catalog_.addFunction((Function)ScalarFunction.createForTesting((String)"default", (String)"udf", (List)Lists.newArrayList((Object[])new Type[]{Type.INT}), (Type)Type.INT, (String)"/dummy", (String)"dummy.class", null, null, (TFunctionBinaryType)TFunctionBinaryType.NATIVE));
        ScalarFunction varArgsUdf1 = ScalarFunction.createForTesting((String)"default", (String)"udf", (List)Lists.newArrayList((Object[])new Type[]{Type.STRING}), (Type)Type.INT, (String)"/dummy", (String)"dummy.class", null, null, (TFunctionBinaryType)TFunctionBinaryType.NATIVE);
        varArgsUdf1.setHasVarArgs(true);
        catalog_.addFunction((Function)varArgsUdf1);
        ScalarFunction varArgsUdf2 = ScalarFunction.createForTesting((String)"default", (String)"udf", (List)Lists.newArrayList((Object[])new Type[]{Type.INT, Type.STRING}), (Type)Type.INT, (String)"/dummy", (String)"dummy.class", null, null, (TFunctionBinaryType)TFunctionBinaryType.NATIVE);
        varArgsUdf2.setHasVarArgs(true);
        catalog_.addFunction((Function)varArgsUdf2);
        ScalarFunction udf = ScalarFunction.createForTesting((String)"functional", (String)"udf", (List)Lists.newArrayList((Object[])new Type[]{Type.DOUBLE}), (Type)Type.INT, (String)"/dummy", (String)"dummy.class", null, null, (TFunctionBinaryType)TFunctionBinaryType.NATIVE);
        catalog_.addFunction((Function)udf);
        this.AnalyzesOk("select udf()");
        this.AnalyzesOk("select default.udf()");
        this.AnalyzesOk("select udf(1)");
        this.AnalyzesOk("select udf(cast (1.1 as INT))");
        this.AnalyzesOk("select udf(cast(1.1 as TINYINT))");
        this.AnalyzesOk("select udf('a')");
        this.AnalyzesOk("select udf('a', 'b')");
        this.AnalyzesOk("select udf('a', 'b', 'c')");
        this.AnalysisError("select udf(1, 1)", "No matching function with signature: default.udf(TINYINT, TINYINT).");
        this.AnalyzesOk("select udf(1, 'a')");
        this.AnalyzesOk("select udf(1, 'a', 'b')");
        this.AnalyzesOk("select udf(1, 'a', 'b', 'c')");
        this.AnalysisError("select udf(1, 'a', 2)", "No matching function with signature: default.udf(TINYINT, STRING, TINYINT).");
        this.AnalysisError("select udf(1.1)", "No matching function with signature: default.udf(DECIMAL(2,1))");
        this.AnalyzesOk("select functional.udf(1.1)");
        this.AnalysisError("select functional.udf('Hello')", "No matching function with signature: functional.udf(STRING).");
        this.AnalysisError("select udf(1, 2)", "No matching function with signature: default.udf(TINYINT, TINYINT).");
        catalog_.removeFunction((Function)udf);
    }

    private void checkSerializedMTime(Expr expr, boolean expectMTime) {
        Preconditions.checkNotNull((Object)expr.getFn());
        TExpr thriftExpr = expr.treeToThrift();
        Preconditions.checkState((thriftExpr.getNodesSize() > 0 ? 1 : 0) != 0);
        Preconditions.checkState((boolean)((TExprNode)thriftExpr.getNodes().get(0)).isSetFn());
        TFunction thriftFn = ((TExprNode)thriftExpr.getNodes().get(0)).getFn();
        if (expectMTime) {
            Assert.assertTrue((thriftFn.getLast_modified_time() >= 0L ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)thriftFn.getLast_modified_time(), (long)-1L);
        }
    }

    private void testMTime(String expr, boolean expectMTime) {
        SelectStmt stmt = (SelectStmt)this.AnalyzesOk("select " + expr + " from functional.alltypes");
        Preconditions.checkState((stmt.getSelectList().getItems().size() == 1 ? 1 : 0) != 0);
        TupleDescriptor tblRefDesc = stmt.fromClause_.get(0).getDesc();
        tblRefDesc.materializeSlots();
        tblRefDesc.computeMemLayout();
        if (stmt.hasMultiAggInfo()) {
            Preconditions.checkState((stmt.getMultiAggInfo().getAggClasses().size() == 1 ? 1 : 0) != 0);
            AggregateInfo aggInfo = stmt.getMultiAggInfo().getAggClass(0);
            TupleDescriptor intDesc = aggInfo.intermediateTupleDesc_;
            intDesc.materializeSlots();
            intDesc.computeMemLayout();
            this.checkSerializedMTime((Expr)aggInfo.getAggregateExprs().get(0), expectMTime);
            this.checkSerializedMTime((Expr)aggInfo.getMergeAggInfo().getAggregateExprs().get(0), expectMTime);
        } else {
            this.checkSerializedMTime(((SelectListItem)stmt.getSelectList().getItems().get(0)).getExpr(), expectMTime);
        }
    }

    @Test
    public void TestFunctionMTime() {
        this.testMTime("sleep(1)", false);
        this.testMTime("concat('a', 'b')", false);
        this.testMTime("3 is null", false);
        this.testMTime("1 < 3", false);
        this.testMTime("1 + 1", false);
        this.testMTime("avg(int_col)", false);
        String nativeSymbol = "'_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'";
        String nativeUdfPath = "/test-warehouse/libTestUdfs.so";
        String javaSymbol = "SYMBOL='org.apache.impala.TestUdf";
        String javaPath = "/test-warehouse/impala-hive-udfs.jar";
        String nativeUdaPath = "hdfs://localhost:20500/test-warehouse/libTestUdas.so";
        catalog_.addFunction((Function)ScalarFunction.createForTesting((String)"default", (String)"udf_builtin_bug", new ArrayList(), (Type)Type.INT, (String)"/dummy", (String)"dummy.class", null, null, (TFunctionBinaryType)TFunctionBinaryType.BUILTIN));
        catalog_.addFunction((Function)ScalarFunction.createForTesting((String)"default", (String)"udf_jar", (List)Lists.newArrayList((Object[])new Type[]{Type.INT}), (Type)Type.INT, (String)"/test-warehouse/impala-hive-udfs.jar", (String)"SYMBOL='org.apache.impala.TestUdf", null, null, (TFunctionBinaryType)TFunctionBinaryType.JAVA));
        catalog_.addFunction((Function)ScalarFunction.createForTesting((String)"default", (String)"udf_native", new ArrayList(), (Type)Type.INT, (String)"/test-warehouse/libTestUdfs.so", (String)"'_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", null, null, (TFunctionBinaryType)TFunctionBinaryType.NATIVE));
        catalog_.addFunction((Function)AggregateFunction.createForTesting((FunctionName)new FunctionName("default", "uda"), (List)Lists.newArrayList((Object[])new Type[]{Type.INT}), (Type)Type.INT, (Type)Type.INT, (HdfsUri)new HdfsUri("hdfs://localhost:20500/test-warehouse/libTestUdas.so"), (String)"init_fn_symbol", (String)"update_fn_symbol", null, null, null, null, null, (TFunctionBinaryType)TFunctionBinaryType.NATIVE));
        this.testMTime("udf_builtin_bug()", false);
        this.testMTime("udf_jar(3)", true);
        this.testMTime("udf_native()", true);
        this.testMTime("uda(int_col)", true);
    }

    @Test
    public void TestExprChildLimit() {
        StringBuilder inPredStr = new StringBuilder("select 1 IN(");
        for (int i = 0; i < 9999; ++i) {
            inPredStr.append(i);
            if (i + 1 == 9999) continue;
            inPredStr.append(", ");
        }
        this.AnalyzesOk(inPredStr.toString() + ")");
        inPredStr.append(", 1234");
        this.AnalysisError(inPredStr.toString() + ")", String.format("Exceeded the maximum number of child expressions (%d).\nExpression has %s children", 10000, 10001));
        StringBuilder caseExprStr = new StringBuilder("select case");
        for (int i = 0; i < 5000; ++i) {
            caseExprStr.append(" when true then 1");
        }
        this.AnalyzesOk(caseExprStr.toString() + " end");
        caseExprStr.append(" when true then 1");
        this.AnalysisError(caseExprStr.toString() + " end", String.format("Exceeded the maximum number of child expressions (%d).\nExpression has %s children", 10000, 10002));
    }

    @Test
    public void TestExprDepthLimit() {
        this.testInfixExprDepthLimit("select true", " and false");
        this.testInfixExprDepthLimit("select true", " or false");
        this.testInfixExprDepthLimit("select " + String.valueOf(Long.MAX_VALUE), " + " + String.valueOf(Long.MAX_VALUE));
        this.testFuncExprDepthLimit("lower(", "'abc'", ")");
        ScalarFunction udf = ScalarFunction.createForTesting((String)"default", (String)"udf", (List)Lists.newArrayList((Object[])new Type[]{Type.INT}), (Type)Type.INT, (String)"/dummy", (String)"dummy.class", null, null, (TFunctionBinaryType)TFunctionBinaryType.NATIVE);
        catalog_.addFunction((Function)udf);
        try {
            this.testFuncExprDepthLimit("udf(", "1", ")");
        }
        finally {
            catalog_.removeFunction((Function)udf);
        }
        this.testFuncExprDepthLimit("date_add(", "now()", ", interval 1 day)");
        this.testFuncExprDepthLimit("cast(", "1", " as int)");
    }

    String getRepeatedColumnReference(String col_name, int num_copies, boolean use_alias) {
        StringBuilder repColRef = new StringBuilder();
        for (int i = 0; i < num_copies; ++i) {
            if (i != 0) {
                repColRef.append(", ");
            }
            repColRef.append(col_name);
            if (!use_alias) continue;
            repColRef.append(String.format(" alias%d", i));
        }
        return repColRef.toString();
    }

    String getExpressionLimitErrorStr(int actual_num_expressions, int limit) {
        return String.format("Exceeded the statement expression limit (%d)\nStatement has %d expressions", limit, actual_num_expressions);
    }

    @Test
    public void TestStatementExprLimit() {
        TQueryOptions queryOpts = new TQueryOptions();
        queryOpts.setStatement_expression_limit(20);
        queryOpts.setEnable_expr_rewrites(false);
        AnalysisContext ctx = this.createAnalysisCtx(queryOpts);
        String repCols20 = this.getRepeatedColumnReference("int_col", 20, true);
        String repCols21 = this.getRepeatedColumnReference("int_col", 21, true);
        this.AnalyzesOk(String.format("select %s from functional.alltypes", repCols20), ctx);
        Assert.assertEquals((long)ctx.getAnalyzer().getNumStmtExprs(), (long)20L);
        this.AnalysisError(String.format("select %s from functional.alltypes", repCols21), ctx, this.getExpressionLimitErrorStr(21, 20));
        this.AnalysisError(String.format("select %s from functional.alltypes where bool_col", repCols20), ctx, this.getExpressionLimitErrorStr(21, 20));
        this.AnalyzesOk(String.format("create table exprlimit1 as select %s from functional.alltypes", repCols20), ctx);
        Assert.assertEquals((long)ctx.getAnalyzer().getNumStmtExprs(), (long)20L);
        this.AnalysisError(String.format("create table exprlimit1 as select %s from functional.alltypes", repCols21), ctx, this.getExpressionLimitErrorStr(21, 20));
        this.AnalyzesOk(String.format("create view exprlimit1 as select %s from functional.alltypes", repCols20), ctx);
        Assert.assertEquals((long)ctx.getAnalyzer().getNumStmtExprs(), (long)20L);
        this.AnalysisError(String.format("create view exprlimit1 as select %s from functional.alltypes", repCols21), ctx, this.getExpressionLimitErrorStr(21, 20));
        this.AnalyzesOk(String.format("select * from (select %s from functional.alltypes) x", repCols20), ctx);
        Assert.assertEquals((long)ctx.getAnalyzer().getNumStmtExprs(), (long)20L);
        this.AnalysisError(String.format("select * from (select %s from functional.alltypes) x", repCols21), ctx, this.getExpressionLimitErrorStr(21, 20));
        this.AnalyzesOk(String.format("with v as (select %s from functional.alltypes) select * from v", repCols20), ctx);
        Assert.assertEquals((long)ctx.getAnalyzer().getNumStmtExprs(), (long)20L);
        this.AnalysisError(String.format("with v as (select %s from functional.alltypes) select * from v", repCols21), ctx, this.getExpressionLimitErrorStr(21, 20));
        this.AnalysisError(String.format("select %s from functional.alltypes_parens", repCols20), ctx, this.getExpressionLimitErrorStr(32, 20));
        this.AnalysisError(String.format("with v as (select %s from functional.alltypes) select * from v v1,v v2", repCols20), ctx, this.getExpressionLimitErrorStr(40, 20));
        this.AnalyzesOk(String.format("with v as (select %s from functional.alltypes) select 1", repCols21), ctx);
        Assert.assertEquals((long)ctx.getAnalyzer().getNumStmtExprs(), (long)0L);
        this.AnalysisError(String.format("explain select %s from functional.alltypes", repCols21), ctx, this.getExpressionLimitErrorStr(21, 20));
        this.AnalyzesOk("select * from functional.widetable_1000_cols", ctx);
        StringBuilder literalList = new StringBuilder();
        for (int i = 0; i < 200; ++i) {
            if (i != 0) {
                literalList.append(", ");
            }
            literalList.append(i);
        }
        this.AnalyzesOk(String.format("select %s", literalList.toString()), ctx);
        Assert.assertEquals((long)ctx.getAnalyzer().getNumStmtExprs(), (long)0L);
        this.AnalyzesOk(String.format("select int_col IN (%s) from functional.alltypes", literalList.toString()), ctx);
        StringBuilder valuesList = new StringBuilder();
        for (int i = 0; i < 200; ++i) {
            if (i != 0) {
                valuesList.append(", ");
            }
            valuesList.append("(" + i + ")");
        }
        this.AnalyzesOk("insert into functional.insert_overwrite_nopart (col1) VALUES " + valuesList.toString(), ctx);
        Assert.assertEquals((long)ctx.getAnalyzer().getNumStmtExprs(), (long)0L);
        StringBuilder constantExpr = new StringBuilder();
        for (int i = 0; i < 21; ++i) {
            if (i != 0) {
                constantExpr.append(" * ");
            }
            constantExpr.append(i);
        }
        this.AnalyzesOk(String.format("select %s", constantExpr.toString()), ctx);
        Assert.assertEquals((long)ctx.getAnalyzer().getNumStmtExprs(), (long)20L);
        constantExpr.append(" * 100");
        this.AnalysisError(String.format("select %s", constantExpr.toString()), ctx, this.getExpressionLimitErrorStr(21, 20));
        StringBuilder inListExpr = new StringBuilder();
        for (int i = 0; i < 19; ++i) {
            if (i != 0) {
                inListExpr.append(" * ");
            }
            inListExpr.append(i);
        }
        this.AnalyzesOk(String.format("select int_col IN (%s) from functional.alltypes", inListExpr.toString()), ctx);
        Assert.assertEquals((long)ctx.getAnalyzer().getNumStmtExprs(), (long)20L);
        inListExpr.append(" * 100");
        this.AnalysisError(String.format("select int_col IN (%s) from functional.alltypes", inListExpr.toString()), ctx, this.getExpressionLimitErrorStr(21, 20));
    }

    private void testDecimalExpr(String expr, Type decimalExpectedType, boolean isV2) {
        TQueryOptions queryOpts = new TQueryOptions();
        queryOpts.setDecimal_v2(isV2);
        SelectStmt selectStmt = (SelectStmt)this.AnalyzesOk("select " + expr, this.createAnalysisCtx(queryOpts));
        Expr root = (Expr)selectStmt.resultExprs_.get(0);
        Type actualType = root.getType();
        Assert.assertTrue((String)("Expr: " + expr + " Decimal Version: " + (isV2 ? "2" : "1") + " Expected: " + decimalExpectedType + " Actual: " + actualType), (boolean)decimalExpectedType.equals((Object)actualType));
    }

    private void testDecimalExprV1(String expr, Type decimalExpectedType) {
        this.testDecimalExpr(expr, decimalExpectedType, false);
    }

    private void testDecimalExprV2(String expr, Type decimalExpectedType) {
        this.testDecimalExpr(expr, decimalExpectedType, true);
    }

    private void testDecimalExpr(String expr, Type decimalV1ExpectedType, Type decimalV2ExpectedType) {
        this.testDecimalExprV1(expr, decimalV1ExpectedType);
        this.testDecimalExprV2(expr, decimalV2ExpectedType);
    }

    private void testDecimalExpr(String expr, Type expectedType) {
        this.testDecimalExpr(expr, expectedType, expectedType);
    }

    @Test
    public void TestModReturnType() {
        this.testDecimalExprV2("mod(9.8, 3)", (Type)ScalarType.createDecimalType((int)2, (int)1));
        this.testDecimalExprV2("9.7 % 3", (Type)ScalarType.createDecimalType((int)2, (int)1));
        this.testDecimalExprV2("mod(109.8, 3)", (Type)ScalarType.createDecimalType((int)4, (int)1));
        this.testDecimalExprV2("109.7 % 3", (Type)ScalarType.createDecimalType((int)4, (int)1));
        this.testDecimalExprV2("mod(109.8, 3.45)", (Type)ScalarType.createDecimalType((int)3, (int)2));
        this.testDecimalExprV2("109.7 % 3.45", (Type)ScalarType.createDecimalType((int)3, (int)2));
        this.testDecimalExprV1("mod(9.6, 3)", (Type)ScalarType.createDecimalType((int)4, (int)1));
        this.testDecimalExprV1("9.5 % 3", (Type)Type.DOUBLE);
    }

    @Test
    public void TestDecimalArithmetic() {
        String decimal_10_0 = "cast(1 as decimal(10,0))";
        String decimal_5_5 = "cast(1 as decimal(5, 5))";
        String decimal_38_34 = "cast(1 as decimal(38, 34))";
        this.testDecimalExpr(decimal_10_0, (Type)ScalarType.createDecimalType((int)10, (int)0));
        this.testDecimalExpr(decimal_5_5, (Type)ScalarType.createDecimalType((int)5, (int)5));
        this.testDecimalExpr(decimal_38_34, (Type)ScalarType.createDecimalType((int)38, (int)34));
        this.testDecimalExpr(decimal_10_0 + " + " + decimal_10_0, (Type)ScalarType.createDecimalType((int)11, (int)0));
        this.testDecimalExpr(decimal_10_0 + " - " + decimal_10_0, (Type)ScalarType.createDecimalType((int)11, (int)0));
        this.testDecimalExpr(decimal_10_0 + " * " + decimal_10_0, (Type)ScalarType.createDecimalType((int)20, (int)0), (Type)ScalarType.createDecimalType((int)21, (int)0));
        this.testDecimalExpr(decimal_10_0 + " / " + decimal_10_0, (Type)ScalarType.createDecimalType((int)21, (int)11));
        this.testDecimalExpr(decimal_10_0 + " % " + decimal_10_0, (Type)ScalarType.createDecimalType((int)10, (int)0));
        this.testDecimalExpr(decimal_10_0 + " + " + decimal_5_5, (Type)ScalarType.createDecimalType((int)16, (int)5));
        this.testDecimalExpr(decimal_10_0 + " - " + decimal_5_5, (Type)ScalarType.createDecimalType((int)16, (int)5));
        this.testDecimalExpr(decimal_10_0 + " * " + decimal_5_5, (Type)ScalarType.createDecimalType((int)15, (int)5), (Type)ScalarType.createDecimalType((int)16, (int)5));
        this.testDecimalExpr(decimal_10_0 + " / " + decimal_5_5, (Type)ScalarType.createDecimalType((int)21, (int)6));
        this.testDecimalExpr(decimal_10_0 + " % " + decimal_5_5, (Type)ScalarType.createDecimalType((int)5, (int)5));
        this.testDecimalExpr(decimal_5_5 + " + " + decimal_10_0, (Type)ScalarType.createDecimalType((int)16, (int)5));
        this.testDecimalExpr(decimal_5_5 + " - " + decimal_10_0, (Type)ScalarType.createDecimalType((int)16, (int)5));
        this.testDecimalExpr(decimal_5_5 + " * " + decimal_10_0, (Type)ScalarType.createDecimalType((int)15, (int)5), (Type)ScalarType.createDecimalType((int)16, (int)5));
        this.testDecimalExpr(decimal_5_5 + " / " + decimal_10_0, (Type)ScalarType.createDecimalType((int)16, (int)16));
        this.testDecimalExpr(decimal_5_5 + " % " + decimal_10_0, (Type)ScalarType.createDecimalType((int)5, (int)5));
        this.testDecimalExpr(decimal_10_0 + " + " + decimal_38_34, (Type)ScalarType.createDecimalType((int)38, (int)34), (Type)ScalarType.createDecimalType((int)38, (int)27));
        this.testDecimalExpr(decimal_10_0 + " - " + decimal_38_34, (Type)ScalarType.createDecimalType((int)38, (int)34), (Type)ScalarType.createDecimalType((int)38, (int)27));
        this.testDecimalExpr(decimal_10_0 + " * " + decimal_38_34, (Type)ScalarType.createDecimalType((int)38, (int)34), (Type)ScalarType.createDecimalType((int)38, (int)23));
        this.testDecimalExpr(decimal_10_0 + " / " + decimal_38_34, (Type)ScalarType.createDecimalType((int)38, (int)34), (Type)ScalarType.createDecimalType((int)38, (int)6));
        this.testDecimalExpr(decimal_10_0 + " % " + decimal_38_34, (Type)ScalarType.createDecimalType((int)38, (int)34));
        this.testDecimalExpr(decimal_38_34 + " + " + decimal_5_5, (Type)ScalarType.createDecimalType((int)38, (int)34), (Type)ScalarType.createDecimalType((int)38, (int)33));
        this.testDecimalExpr(decimal_38_34 + " - " + decimal_5_5, (Type)ScalarType.createDecimalType((int)38, (int)34), (Type)ScalarType.createDecimalType((int)38, (int)33));
        this.testDecimalExpr(decimal_38_34 + " * " + decimal_5_5, (Type)ScalarType.createDecimalType((int)38, (int)38), (Type)ScalarType.createDecimalType((int)38, (int)33));
        this.testDecimalExpr(decimal_38_34 + " / " + decimal_5_5, (Type)ScalarType.createDecimalType((int)38, (int)34), (Type)ScalarType.createDecimalType((int)38, (int)29));
        this.testDecimalExpr(decimal_38_34 + " % " + decimal_5_5, (Type)ScalarType.createDecimalType((int)34, (int)34));
        this.testDecimalExpr(decimal_10_0 + " + " + decimal_10_0 + " + " + decimal_10_0, (Type)ScalarType.createDecimalType((int)12, (int)0));
        this.testDecimalExpr(decimal_10_0 + " - " + decimal_10_0 + " * " + decimal_10_0, (Type)ScalarType.createDecimalType((int)21, (int)0), (Type)ScalarType.createDecimalType((int)22, (int)0));
        this.testDecimalExpr(decimal_10_0 + " / " + decimal_10_0 + " / " + decimal_10_0, (Type)ScalarType.createDecimalType((int)32, (int)22));
        this.testDecimalExpr(decimal_10_0 + " % " + decimal_10_0 + " + " + decimal_10_0, (Type)ScalarType.createDecimalType((int)11, (int)0));
        this.testDecimalExpr(decimal_10_0 + " + cast(1 as tinyint)", (Type)ScalarType.createDecimalType((int)11, (int)0));
        this.testDecimalExpr(decimal_10_0 + " + cast(1 as smallint)", (Type)ScalarType.createDecimalType((int)11, (int)0));
        this.testDecimalExpr(decimal_10_0 + " + cast(1 as int)", (Type)ScalarType.createDecimalType((int)11, (int)0));
        this.testDecimalExpr(decimal_10_0 + " + cast(1 as bigint)", (Type)ScalarType.createDecimalType((int)20, (int)0));
        this.testDecimalExpr(decimal_10_0 + " + cast(1 as float)", (Type)ScalarType.createDecimalType((int)38, (int)9), (Type)ScalarType.createDecimalType((int)38, (int)8));
        this.testDecimalExpr(decimal_10_0 + " + cast(1 as double)", (Type)ScalarType.createDecimalType((int)38, (int)17), (Type)ScalarType.createDecimalType((int)38, (int)16));
        this.testDecimalExpr(decimal_5_5 + " + cast(1 as tinyint)", (Type)ScalarType.createDecimalType((int)9, (int)5));
        this.testDecimalExpr(decimal_5_5 + " - cast(1 as smallint)", (Type)ScalarType.createDecimalType((int)11, (int)5));
        this.testDecimalExpr(decimal_5_5 + " * cast(1 as int)", (Type)ScalarType.createDecimalType((int)15, (int)5), (Type)ScalarType.createDecimalType((int)16, (int)5));
        this.testDecimalExpr(decimal_5_5 + " % cast(1 as bigint)", (Type)ScalarType.createDecimalType((int)5, (int)5));
        this.testDecimalExpr(decimal_5_5 + " / cast(1 as float)", (Type)ScalarType.createDecimalType((int)38, (int)9), (Type)ScalarType.createDecimalType((int)38, (int)29));
        this.testDecimalExpr(decimal_5_5 + " + cast(1 as double)", (Type)ScalarType.createDecimalType((int)38, (int)17), (Type)ScalarType.createDecimalType((int)38, (int)16));
        this.AnalyzesOk("select " + decimal_5_5 + " = cast(1 as tinyint)");
        this.AnalyzesOk("select " + decimal_5_5 + " != cast(1 as smallint)");
        this.AnalyzesOk("select " + decimal_5_5 + " > cast(1 as int)");
        this.AnalyzesOk("select " + decimal_5_5 + " < cast(1 as bigint)");
        this.AnalyzesOk("select " + decimal_5_5 + " >= cast(1 as float)");
        this.AnalyzesOk("select " + decimal_5_5 + " <= cast(1 as double)");
        this.AnalysisError("select " + decimal_5_5 + " + 'abcd'", "Arithmetic operation requires numeric operands: CAST(1 AS DECIMAL(5,5)) + 'abcd'");
        this.AnalysisError("select " + decimal_5_5 + " + 'cast(1 as timestamp)'", "Arithmetic operation requires numeric operands: CAST(1 AS DECIMAL(5,5)) + 'cast(1 as timestamp)'");
        this.AnalysisError("select " + decimal_5_5 + " + \"DATE '1970-01-01'\"", "Arithmetic operation requires numeric operands: CAST(1 AS DECIMAL(5,5)) + 'DATE \\'1970-01-01\\''");
        this.AnalysisError("select " + decimal_5_5 + " = 'abcd'", "operands of type DECIMAL(5,5) and STRING are not comparable: CAST(1 AS DECIMAL(5,5)) = 'abcd'");
        this.AnalysisError("select " + decimal_5_5 + " > 'cast(1 as timestamp)'", "operands of type DECIMAL(5,5) and STRING are not comparable: CAST(1 AS DECIMAL(5,5)) > 'cast(1 as timestamp)'");
        this.AnalysisError("select " + decimal_5_5 + " > date '1899-12-23'", "operands of type DECIMAL(5,5) and DATE are not comparable: CAST(1 AS DECIMAL(5,5)) > DATE '1899-12-23'");
        this.AnalyzesOk("select cast(2 as double) in (cast(2 as decimal(38, 37)), cast(3 as decimal(38, 37)))");
        this.AnalyzesOk("select cast(2 as decimal(38, 37)) in (cast(2 as double), cast(3 as decimal(38, 37)))");
        this.AnalyzesOk("select cast(2 as decimal(38, 37)) in (cast(2 as decimal(38, 37)), cast(3 as double))");
        this.AnalyzesOk("select cast(2 as double) in (cast(2 as decimal(5, 3)), cast(3 as decimal(10, 5)))");
        this.AnalyzesOk("select cast(2 as decimal(5, 3)) in (cast(2 as double), cast(3 as decimal(10, 5)))");
        this.AnalyzesOk("select cast(2 as decimal(5, 3)) in (cast(2 as decimal(10, 5)), cast(3 as double))");
        this.AnalysisError("select cast(2 as decimal(38, 37)) in (cast(2 as decimal(38, 1)))", "Incompatible return types 'DECIMAL(38,37)' and 'DECIMAL(38,1)' of exprs 'CAST(2 AS DECIMAL(38,37))' and 'CAST(2 AS DECIMAL(38,1))'");
        this.AnalyzesOk("select cast(2 as double) in (cast(2 as decimal(38, 37)), cast(3 as decimal(38, 1)))");
        this.AnalyzesOk("select cast(2 as decimal(38, 37)) in (cast(2 as double), cast(3 as decimal(38, 1)))");
        this.AnalyzesOk("select cast(2 as decimal(38, 37)) in (cast(2 as decimal(38, 1)), cast(3 as double))");
    }

    @Test
    public void TestDecimalOperators() throws AnalysisException {
        this.AnalyzesOk("select d2 % d5 from functional.decimal_tbl");
        this.AnalyzesOk("select d1 from functional.decimal_tbl");
        this.AnalyzesOk("select cast(d2 as decimal(1)) from functional.decimal_tbl");
        this.AnalyzesOk("select d3 + d4 from functional.decimal_tbl");
        this.AnalyzesOk("select d5 - d1 from functional.decimal_tbl");
        this.AnalyzesOk("select d2 * d2 from functional.decimal_tbl");
        this.AnalyzesOk("select d4 / d1 from functional.decimal_tbl");
        this.AnalyzesOk("select d2 % d5 from functional.decimal_tbl");
        this.AnalysisError("select d1 & d1 from functional.decimal_tbl", "Invalid non-integer argument to operation '&': d1 & d1");
        this.AnalysisError("select d1 | d1 from functional.decimal_tbl", "Invalid non-integer argument to operation '|': d1 | d1");
        this.AnalysisError("select d1 ^ d1 from functional.decimal_tbl", "Invalid non-integer argument to operation '^': d1 ^ d1");
        this.AnalysisError("select ~d1 from functional.decimal_tbl", "'~' operation only allowed on integer types: ~d1");
        this.AnalysisError("select d1! from functional.decimal_tbl", "'!' operation only allowed on integer types: d1!");
    }

    @Test
    public void TestDecimalCast() throws AnalysisException {
        this.AnalyzesOk("select cast(1 as decimal)");
        this.AnalyzesOk("select cast(1 as decimal(1))");
        this.AnalyzesOk("select cast(1 as decimal(38))");
        this.AnalyzesOk("select cast(1 as decimal(1, 0))");
        this.AnalyzesOk("select cast(1 as decimal(10, 5))");
        this.AnalyzesOk("select cast(1 as decimal(38, 0))");
        this.AnalyzesOk("select cast(1 as decimal(38, 38))");
        this.AnalysisError("select cast(1 as decimal(0))", "Decimal precision must be > 0: 0");
        this.AnalysisError("select cast(1 as decimal(39))", "Decimal precision must be <= 38: 39");
        this.AnalysisError("select cast(1 as decimal(1, 2))", "Decimal scale (2) must be <= precision (1)");
    }

    @Test
    public void TestDecimalFunctions() throws AnalysisException {
        String[] aliasesOfTruncate = new String[]{"truncate", "dtrunc", "trunc"};
        this.AnalyzesOk("select abs(cast(1 as decimal))");
        this.AnalyzesOk("select abs(cast(-1.1 as decimal(10,3)))");
        this.AnalyzesOk("select floor(cast(-1.1 as decimal(10,3)))");
        this.AnalyzesOk("select ceil(cast(1.123 as decimal(10,3)))");
        this.AnalyzesOk("select round(cast(1.123 as decimal(10,3)))");
        this.AnalyzesOk("select round(cast(1.123 as decimal(10,3)), 0)");
        this.AnalyzesOk("select round(cast(1.123 as decimal(10,3)), 2)");
        this.AnalyzesOk("select round(cast(1.123 as decimal(10,3)), 5)");
        this.AnalyzesOk("select round(cast(1.123 as decimal(10,3)), -2)");
        for (String alias : aliasesOfTruncate) {
            this.AnalyzesOk(String.format("select %s(cast(1.123 as decimal(10,3)))", alias));
            this.AnalyzesOk(String.format("select %s(cast(1.123 as decimal(10,3)), 0)", alias));
            this.AnalyzesOk(String.format("select %s(cast(1.123 as decimal(10,3)), 2)", alias));
            this.AnalyzesOk(String.format("select %s(cast(1.123 as decimal(10,3)), 5)", alias));
            this.AnalyzesOk(String.format("select %s(cast(1.123 as decimal(10,3)), -1)", alias));
        }
        this.AnalysisError("select round(cast(1.123 as decimal(10,3)), 5.1)", "No matching function with signature: round(DECIMAL(10,3), DECIMAL(2,1))");
        this.AnalyzesOk("select round(cast(1.123 as decimal(30,20)), 40)");
        for (String alias : aliasesOfTruncate) {
            this.AnalyzesOk(String.format("select %s(cast(1.123 as decimal(10,3)), 40)", alias));
            this.AnalyzesOk(String.format("select %s(NULL)", alias));
            this.AnalysisError(String.format("select %s(NULL, 1)", alias), String.format("Cannot resolve DECIMAL precision and scale from NULL type in %s function.", alias));
        }
        this.AnalysisError("select round(cast(1.123 as decimal(10,3)), NULL)", "round() cannot be called with a NULL second argument.");
        this.AnalysisError("select precision(999999999999999999999999999999999999999.)", "No matching function with signature: precision(DOUBLE).");
        this.AnalysisError("select precision(cast(1 as float))", "No matching function with signature: precision(FLOAT)");
        this.AnalysisError("select precision(NULL)", "Cannot resolve DECIMAL precision and scale from NULL type in precision function");
        this.AnalysisError("select scale(NULL)", "Cannot resolve DECIMAL precision and scale from NULL type in scale function.");
        this.testDecimalExpr("round(1.23)", (Type)ScalarType.createDecimalType((int)2, (int)0));
        this.testDecimalExpr("round(1.23, 1)", (Type)ScalarType.createDecimalType((int)3, (int)1));
        this.testDecimalExpr("round(1.23, 0)", (Type)ScalarType.createDecimalType((int)2, (int)0));
        this.testDecimalExpr("round(1.23, 3)", (Type)ScalarType.createDecimalType((int)3, (int)2));
        this.testDecimalExpr("round(1.23, -1)", (Type)ScalarType.createDecimalType((int)2, (int)0));
        this.testDecimalExpr("round(1.23, -2)", (Type)ScalarType.createDecimalType((int)2, (int)0));
        this.testDecimalExpr("round(cast(1.23 as decimal(3,2)), -2)", (Type)ScalarType.createDecimalType((int)2, (int)0));
        this.testDecimalExpr("round(cast(1.23 as decimal(30, 20)), 40)", (Type)ScalarType.createDecimalType((int)30, (int)20));
        this.testDecimalExpr("ceil(123.45)", (Type)ScalarType.createDecimalType((int)4, (int)0));
        this.testDecimalExpr("floor(12.345)", (Type)ScalarType.createDecimalType((int)3, (int)0));
        for (String alias : aliasesOfTruncate) {
            this.testDecimalExpr(String.format("%s(1.23)", alias), (Type)ScalarType.createDecimalType((int)1, (int)0));
            this.testDecimalExpr(String.format("%s(1.23, 1)", alias), (Type)ScalarType.createDecimalType((int)2, (int)1));
            this.testDecimalExpr(String.format("%s(1.23, 0)", alias), (Type)ScalarType.createDecimalType((int)1, (int)0));
            this.testDecimalExpr(String.format("%s(1.23, 3)", alias), (Type)ScalarType.createDecimalType((int)3, (int)2));
            this.testDecimalExpr(String.format("%s(1.23, -1)", alias), (Type)ScalarType.createDecimalType((int)1, (int)0));
            this.testDecimalExpr(String.format("%s(1.23, -2)", alias), (Type)ScalarType.createDecimalType((int)1, (int)0));
            this.testDecimalExpr(String.format("%s(cast(1.23 as decimal(30, 20)), 40)", alias), (Type)ScalarType.createDecimalType((int)30, (int)20));
        }
        AnalysisContext decimalV1Ctx = this.createAnalysisCtx();
        decimalV1Ctx.getQueryOptions().setDecimal_v2(false);
        AnalysisContext decimalV2Ctx = this.createAnalysisCtx();
        decimalV2Ctx.getQueryOptions().setDecimal_v2(true);
        this.testDecimalExpr("coalesce(cast(0.789 as decimal(19, 19)), cast(123 as decimal(19, 0)))", (Type)ScalarType.createDecimalType((int)38, (int)19));
        this.AnalyzesOk("select coalesce(cast(0.789 as decimal(20, 20)), cast(123 as decimal(19, 0)))", decimalV1Ctx);
        this.AnalysisError("select coalesce(cast(0.789 as decimal(20, 20)), cast(123 as decimal(19, 0)))", decimalV2Ctx, "Cannot resolve DECIMAL types of the coalesce(DECIMAL(20,20), DECIMAL(19,0)) function arguments. You need to wrap the arguments in a CAST.");
        this.testDecimalExpr("if(true, cast(0.789 as decimal(19, 19)), cast(123 as decimal(19, 0)))", (Type)ScalarType.createDecimalType((int)38, (int)19));
        this.AnalyzesOk("select if(true, cast(0.789 as decimal(20, 20)), cast(123 as decimal(19, 0)))", decimalV1Ctx);
        this.AnalysisError("select if(true, cast(0.789 as decimal(20, 20)), cast(123 as decimal(19, 0)))", decimalV2Ctx, "Cannot resolve DECIMAL types of the if(BOOLEAN, DECIMAL(20,20), DECIMAL(19,0)) function arguments. You need to wrap the arguments in a CAST.");
        this.testDecimalExpr("isnull(cast(0.789 as decimal(19, 19)), cast(123 as decimal(19, 0)))", (Type)ScalarType.createDecimalType((int)38, (int)19));
        this.AnalyzesOk("select isnull(cast(0.789 as decimal(20, 20)), cast(123 as decimal(19, 0)))", decimalV1Ctx);
        this.AnalysisError("select isnull(cast(0.789 as decimal(20, 20)), cast(123 as decimal(19, 0)))", decimalV2Ctx, "Cannot resolve DECIMAL types of the isnull(DECIMAL(20,20), DECIMAL(19,0)) function arguments. You need to wrap the arguments in a CAST.");
        this.testDecimalExpr("case 1 when 0 then cast(0.789 as decimal(19, 19)) else cast(123 as decimal(19, 0)) end", (Type)ScalarType.createDecimalType((int)38, (int)19));
        this.AnalyzesOk("select case 1 when 0 then cast(0.789 as decimal(19, 19)) else cast(123 as decimal(20, 0)) end", decimalV1Ctx);
        this.AnalysisError("select case 1 when 0 then cast(0.789 as decimal(19, 19)) else cast(123 as decimal(20, 0)) end", decimalV2Ctx, "Incompatible return types 'DECIMAL(19,19)' and 'DECIMAL(20,0)' of exprs 'CAST(0.789 AS DECIMAL(19,19))' and 'CAST(123 AS DECIMAL(20,0))'.");
    }

    private void testInfixExprDepthLimit(String prefix, String repeatSuffix) {
        int i;
        StringBuilder exprStr = new StringBuilder(prefix);
        for (i = 0; i < 999; ++i) {
            exprStr.append(repeatSuffix);
        }
        this.AnalyzesOk(exprStr.toString());
        exprStr.append(repeatSuffix);
        exprStr.append(repeatSuffix);
        this.AnalysisError(exprStr.toString(), String.format("Exceeded the maximum depth of an expression tree (%s).", 1000));
        for (i = 0; i < 9000; ++i) {
            exprStr.append(repeatSuffix);
        }
        this.AnalysisError(exprStr.toString(), String.format("Exceeded the maximum depth of an expression tree (%s).", 1000));
    }

    private void testFuncExprDepthLimit(String openFunc, String baseArg, String closeFunc) {
        this.AnalyzesOk("select " + this.getNestedFuncExpr(openFunc, baseArg, closeFunc, 999));
        this.AnalysisError("select " + this.getNestedFuncExpr(openFunc, baseArg, closeFunc, 1001), String.format("Exceeded the maximum depth of an expression tree (%s).", 1000));
        this.AnalysisError("select " + this.getNestedFuncExpr(openFunc, baseArg, closeFunc, 10000), String.format("Exceeded the maximum depth of an expression tree (%s).", 1000));
    }

    private String getNestedFuncExpr(String openFunc, String baseArg, String closeFunc, int numFuncs) {
        int i;
        StringBuilder exprStr = new StringBuilder();
        for (i = 0; i < numFuncs; ++i) {
            exprStr.append(openFunc);
        }
        exprStr.append(baseArg);
        for (i = 0; i < numFuncs; ++i) {
            exprStr.append(closeFunc);
        }
        return exprStr.toString();
    }

    @Test
    public void TestAppxCountDistinctOption() throws AnalysisException {
        TQueryOptions queryOptions = new TQueryOptions();
        queryOptions.setAppx_count_distinct(true);
        ArrayList<String> countDistinctFns = new ArrayList<String>();
        ArrayList<String> allCountDistinctFns = new ArrayList<String>();
        Table alltypesTbl = catalog_.getOrLoadTable("functional", "alltypes");
        for (Column col : alltypesTbl.getColumns()) {
            String colName = col.getName();
            String countDistinctFn = String.format("count(distinct %s)", colName);
            SelectStmt stmt = (SelectStmt)this.AnalyzesOk(String.format("select %s, sum(distinct smallint_col), avg(float_col), min(%s) from functional.alltypes", countDistinctFn, colName), this.createAnalysisCtx(queryOptions));
            this.validateSingleColAppxCountDistinctRewrite(stmt, colName, 4, 1, 1);
            countDistinctFns.add(countDistinctFn);
        }
        SelectStmt alltypesStmt = (SelectStmt)this.AnalyzesOk(String.format("select %s from functional.alltypes", Joiner.on((String)",").join(countDistinctFns)), this.createAnalysisCtx(queryOptions));
        this.assertAllNdvAggExprs(alltypesStmt, alltypesTbl.getColumns().size());
        allCountDistinctFns.addAll(countDistinctFns);
        countDistinctFns.clear();
        Table decimalTbl = catalog_.getOrLoadTable("functional", "decimal_tbl");
        for (Column col : decimalTbl.getColumns()) {
            String colName = col.getName();
            SelectStmt stmt = (SelectStmt)this.AnalyzesOk(String.format("select count(distinct %s), sum(distinct d1), avg(d2), min(%s) from functional.decimal_tbl", colName, colName), this.createAnalysisCtx(queryOptions));
            countDistinctFns.add(String.format("count(distinct %s)", colName));
            this.validateSingleColAppxCountDistinctRewrite(stmt, colName, 4, 1, 1);
        }
        SelectStmt decimalTblStmt = (SelectStmt)this.AnalyzesOk(String.format("select %s from functional.decimal_tbl", Joiner.on((String)",").join(countDistinctFns)), this.createAnalysisCtx(queryOptions));
        this.assertAllNdvAggExprs(decimalTblStmt, decimalTbl.getColumns().size());
        allCountDistinctFns.addAll(countDistinctFns);
        countDistinctFns.clear();
        Table dateTbl = catalog_.getOrLoadTable("functional", "date_tbl");
        for (Column col : dateTbl.getColumns()) {
            String colName = col.getName();
            String countDistinctFn = String.format("count(distinct %s)", colName);
            SelectStmt stmt = (SelectStmt)this.AnalyzesOk(String.format("select %s, avg(%s), min(%s) from functional.date_tbl", countDistinctFn, colName, colName), this.createAnalysisCtx(queryOptions));
            this.validateSingleColAppxCountDistinctRewrite(stmt, colName, 3, 0, 1);
            countDistinctFns.add(countDistinctFn);
        }
        SelectStmt dateStmt = (SelectStmt)this.AnalyzesOk(String.format("select %s from functional.date_tbl", Joiner.on((String)",").join(countDistinctFns)), this.createAnalysisCtx(queryOptions));
        this.assertAllNdvAggExprs(dateStmt, dateTbl.getColumns().size());
        allCountDistinctFns.addAll(countDistinctFns);
        SelectStmt comboStmt = (SelectStmt)this.AnalyzesOk(String.format("select %s from functional.alltypes cross join functional.decimal_tbl cross join functional.date_tbl", Joiner.on((String)",").join(allCountDistinctFns)), this.createAnalysisCtx(queryOptions));
        this.assertAllNdvAggExprs(comboStmt, alltypesTbl.getColumns().size() + decimalTbl.getColumns().size() + dateTbl.getColumns().size());
        SelectStmt noRewriteStmt = (SelectStmt)this.AnalyzesOk("select count(distinct int_col, bigint_col), count(distinct string_col, float_col) from functional.alltypes");
        this.assertNoNdvAggExprs(noRewriteStmt, 2);
        noRewriteStmt = (SelectStmt)this.AnalyzesOk("select avg(distinct int_col), sum(distinct float_col) from functional.alltypes", this.createAnalysisCtx(queryOptions));
        this.assertNoNdvAggExprs(noRewriteStmt, 2);
    }

    private void validateSingleColAppxCountDistinctRewrite(SelectStmt stmt, String rewrittenColName, int expNumAggExprs, int expNumDistinctExprs, int expNumNdvExprs) {
        MultiAggregateInfo multiAggInfo = stmt.getMultiAggInfo();
        List aggExprs = multiAggInfo.getAggExprs();
        Assert.assertEquals((long)expNumAggExprs, (long)aggExprs.size());
        int numDistinctExprs = 0;
        int numNdvExprs = 0;
        for (FunctionCallExpr aggExpr : aggExprs) {
            if (aggExpr.isDistinct()) {
                Assert.assertEquals((Object)"sum", (Object)aggExpr.getFnName().toString());
                ++numDistinctExprs;
            }
            if (!aggExpr.getFnName().toString().equals("ndv")) continue;
            Assert.assertEquals((Object)ToSqlUtils.getIdentSql((String)rewrittenColName), (Object)((Expr)aggExpr.getChild(0)).toSql());
            ++numNdvExprs;
        }
        Assert.assertEquals((long)expNumDistinctExprs, (long)numDistinctExprs);
        Assert.assertEquals((long)expNumNdvExprs, (long)numNdvExprs);
    }

    private void assertAllNdvAggExprs(SelectStmt stmt, int expectedNumAggExprs) {
        MultiAggregateInfo multiAggInfo = stmt.getMultiAggInfo();
        List aggExprs = multiAggInfo.getAggExprs();
        Assert.assertEquals((long)expectedNumAggExprs, (long)aggExprs.size());
        for (FunctionCallExpr aggExpr : aggExprs) {
            Assert.assertFalse((boolean)aggExpr.isDistinct());
            Assert.assertEquals((Object)"ndv", (Object)aggExpr.getFnName().toString());
        }
    }

    private void assertNoNdvAggExprs(SelectStmt stmt, int expectedNumAggExprs) {
        MultiAggregateInfo multiAggInfo = stmt.getMultiAggInfo();
        List aggExprs = multiAggInfo.getAggExprs();
        Assert.assertEquals((long)expectedNumAggExprs, (long)aggExprs.size());
        for (FunctionCallExpr aggExpr : aggExprs) {
            Assert.assertTrue((boolean)aggExpr.isDistinct());
            Assert.assertNotEquals((Object)"ndv", (Object)aggExpr.getFnName().toString());
        }
    }

    @Test
    public void TestImplicitArgumentCasts() throws AnalysisException {
        FunctionName fnName = new FunctionName("_impala_builtins", "greatest");
        Function tinyIntFn = new Function(fnName, new Type[]{ScalarType.DOUBLE}, (Type)Type.DOUBLE, true);
        Function decimalFn = new Function(fnName, new Type[]{ScalarType.TINYINT, ScalarType.createDecimalType((int)30, (int)10)}, (Type)Type.INVALID, false);
        Assert.assertFalse((boolean)tinyIntFn.compare(decimalFn, Function.CompareMode.IS_SUPERTYPE_OF));
        Assert.assertTrue((boolean)tinyIntFn.compare(decimalFn, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF));
        Db db = catalog_.getDb("_impala_builtins");
        Function foundFn = db.getFunction(decimalFn, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        Assert.assertNotNull((Object)foundFn);
        Assert.assertTrue((boolean)foundFn.getArgs()[0].isDecimal());
        Function doubleDecimalFn = new Function(fnName, new Type[]{ScalarType.DOUBLE, ScalarType.createDecimalType((int)30, (int)10)}, (Type)Type.INVALID, false);
        foundFn = db.getFunction(doubleDecimalFn, Function.CompareMode.IS_SUPERTYPE_OF);
        Assert.assertNull((Object)foundFn);
        foundFn = db.getFunction(doubleDecimalFn, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        Assert.assertNotNull((Object)foundFn);
        Assert.assertEquals((Object)Type.DOUBLE, (Object)foundFn.getArgs()[0]);
        Function floatDecimalFn = new Function(fnName, new Type[]{ScalarType.FLOAT, ScalarType.createDecimalType((int)10, (int)7)}, (Type)Type.INVALID, false);
        foundFn = db.getFunction(floatDecimalFn, Function.CompareMode.IS_SUPERTYPE_OF);
        Assert.assertNull((Object)foundFn);
        foundFn = db.getFunction(floatDecimalFn, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        Assert.assertNotNull((Object)foundFn);
        Assert.assertEquals((Object)Type.FLOAT, (Object)foundFn.getArgs()[0]);
        Function floatBigIntFn = new Function(fnName, new Type[]{ScalarType.FLOAT, ScalarType.BIGINT}, (Type)Type.INVALID, false);
        foundFn = db.getFunction(floatBigIntFn, Function.CompareMode.IS_SUPERTYPE_OF);
        Assert.assertNotNull((Object)foundFn);
        Assert.assertEquals((Object)Type.DOUBLE, (Object)foundFn.getArgs()[0]);
        FunctionName lagFnName = new FunctionName("_impala_builtins", "lag");
        Function lagStringFn = new Function(lagFnName, new Type[]{ScalarType.STRING, Type.TINYINT}, (Type)Type.INVALID, false);
        foundFn = db.getFunction(lagStringFn, Function.CompareMode.IS_SUPERTYPE_OF);
        Assert.assertNotNull((Object)foundFn);
        Assert.assertEquals((Object)Type.STRING, (Object)foundFn.getArgs()[0]);
        Function lagDateFn = new Function(lagFnName, new Type[]{ScalarType.DATE, Type.TINYINT}, (Type)Type.INVALID, false);
        foundFn = db.getFunction(lagDateFn, Function.CompareMode.IS_INDISTINGUISHABLE);
        Assert.assertNull((Object)foundFn);
        foundFn = db.getFunction(lagDateFn, Function.CompareMode.IS_SUPERTYPE_OF);
        Assert.assertNotNull((Object)foundFn);
        Assert.assertEquals((Object)Type.DATE, (Object)foundFn.getArgs()[0]);
        FunctionName ifFnName = new FunctionName("_impala_builtins", "if");
        Function ifStringDateFn = new Function(ifFnName, new Type[]{ScalarType.BOOLEAN, ScalarType.STRING, ScalarType.DATE}, (Type)Type.INVALID, false);
        foundFn = db.getFunction(ifStringDateFn, Function.CompareMode.IS_SUPERTYPE_OF);
        Assert.assertNull((Object)foundFn);
        foundFn = db.getFunction(ifStringDateFn, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        Assert.assertNotNull((Object)foundFn);
        Assert.assertEquals((Object)Type.DATE, (Object)foundFn.getArgs()[1]);
        Assert.assertEquals((Object)Type.DATE, (Object)foundFn.getArgs()[2]);
        ifStringDateFn = new Function(ifFnName, new Type[]{ScalarType.BOOLEAN, ScalarType.TIMESTAMP, ScalarType.DATE}, (Type)Type.INVALID, false);
        foundFn = db.getFunction(ifStringDateFn, Function.CompareMode.IS_SUPERTYPE_OF);
        Assert.assertNull((Object)foundFn);
        foundFn = db.getFunction(ifStringDateFn, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        Assert.assertNotNull((Object)foundFn);
        Assert.assertEquals((Object)Type.TIMESTAMP, (Object)foundFn.getArgs()[1]);
        Assert.assertEquals((Object)Type.TIMESTAMP, (Object)foundFn.getArgs()[2]);
        FunctionName yearFnName = new FunctionName("_impala_builtins", "year");
        Function yearStringFn = new Function(yearFnName, new Type[]{ScalarType.STRING}, (Type)Type.INT, false);
        foundFn = db.getFunction(yearStringFn, Function.CompareMode.IS_SUPERTYPE_OF);
        Assert.assertNull((Object)foundFn);
        foundFn = db.getFunction(yearStringFn, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        Assert.assertNotNull((Object)foundFn);
        Assert.assertEquals((Object)Type.TIMESTAMP, (Object)foundFn.getArgs()[0]);
    }

    @Test
    public void TestCastFormatClauseFromString() throws AnalysisException {
        this.AnalysisError("select cast('05-01-2017' AS DATETIME FORMAT 'MM-dd-yyyy')", "Unsupported data type: DATETIME");
        this.AnalysisError("select cast('05-01-2017' AS INT FORMAT 'MM-dd-yyyy')", "FORMAT clause is not applicable from STRING to INT");
        this.AnalysisError("select cast('05-01-2017' AS STRING FORMAT 'MM-dd-yyyy')", "FORMAT clause is not applicable from STRING to STRING");
        this.AnalysisError("select cast('05-01-2017' AS BOOLEAN FORMAT 'MM-dd-yyyy')", "FORMAT clause is not applicable from STRING to BOOLEAN");
        this.AnalysisError("select cast('05-01-2017' AS DOUBLE FORMAT 'MM-dd-yyyy')", "FORMAT clause is not applicable from STRING to DOUBLE");
        this.AnalysisError("select cast('05-01-2017' AS TIMESTAMP FORMAT '')", "FORMAT clause can't be empty");
        this.AnalyzesOk("select cast('05-01-2017' AS TIMESTAMP FORMAT 'MM-dd-yyyy')");
        this.AnalyzesOk("select cast('05-01-2017' AS DATE FORMAT 'MM-dd-yyyy')");
    }

    @Test
    public void TestCastFormatClauseFromDatetime() throws AnalysisException {
        this.RunCastFormatTestOnType("TIMESTAMP");
        this.RunCastFormatTestOnType("DATE");
    }

    @Test
    public void TestMatchingCasts() throws AnalysisException {
        String clause = "sum(CASE WHEN id IS NOT NULL THEN cast(0.4 as decimal(20,10)) ELSE 0 END)";
        this.AnalyzesOk("SELECT CASE WHEN (" + clause + ") > 0 THEN (" + clause + ") ELSE null END q FROM functional.alltypes");
    }

    private void RunCastFormatTestOnType(String type) {
        String to_timestamp_cast = "cast('05-01-2017' as " + type + ")";
        this.AnalysisError("select cast(" + to_timestamp_cast + " as DATETIME FORMAT 'MM-dd-yyyy')", "Unsupported data type: DATETIME");
        if (!type.equals("TIMESTAMP")) {
            this.AnalysisError("select cast(" + to_timestamp_cast + " as TIMESTAMP FORMAT 'MM-dd-yyyy')", "FORMAT clause is not applicable from " + type + " to TIMESTAMP");
        }
        if (!type.equals("DATE")) {
            this.AnalysisError("select cast(" + to_timestamp_cast + " as DATE FORMAT 'MM-dd-yyyy')", "FORMAT clause is not applicable from " + type + " to DATE");
        }
        this.AnalysisError("select cast(" + to_timestamp_cast + " AS INT FORMAT 'MM-dd-yyyy')", "FORMAT clause is not applicable from " + type + " to INT");
        this.AnalysisError("select cast(" + to_timestamp_cast + " AS BOOLEAN FORMAT 'MM-dd-yyyy')", "FORMAT clause is not applicable from " + type + " to BOOLEAN");
        this.AnalysisError("select cast(" + to_timestamp_cast + " AS DOUBLE FORMAT 'MM-dd-yyyy')", "FORMAT clause is not applicable from " + type + " to DOUBLE");
        this.AnalysisError("select cast(" + to_timestamp_cast + " AS STRING FORMAT '')", "FORMAT clause can't be empty");
        this.AnalyzesOk("select cast(" + to_timestamp_cast + " AS STRING FORMAT 'MM-dd-yyyy')");
        this.AnalyzesOk("select cast(" + to_timestamp_cast + " AS VARCHAR FORMAT 'MM-dd-yyyy')");
        this.AnalyzesOk("select cast(" + to_timestamp_cast + " AS CHAR(10) FORMAT 'MM-dd-yyyy')");
    }

    @Test
    public void TestToStringOnCastFormatClause() throws AnalysisException {
        String cast_str = "CAST('05-01-2017' AS TIMESTAMP FORMAT 'MM-dd-yyyy')";
        SelectStmt select = (SelectStmt)this.AnalyzesOk("select " + cast_str);
        Assert.assertEquals((Object)cast_str, (Object)((Expr)select.getResultExprs().get(0)).toSqlImpl());
        cast_str = "CAST('05-01-2017' AS DATE FORMAT 'MM-dd-yyyy')";
        select = (SelectStmt)this.AnalyzesOk("select " + cast_str);
        Assert.assertEquals((Object)cast_str, (Object)((Expr)select.getResultExprs().get(0)).toSqlImpl());
        cast_str = "CAST('2019-01-01te\\'xt' AS DATE FORMAT 'YYYY\\'MM\\'DD\"te\\'xt\"')";
        select = (SelectStmt)this.AnalyzesOk("select " + cast_str);
        Assert.assertEquals((Object)cast_str, (Object)((Expr)select.getResultExprs().get(0)).toSqlImpl());
        cast_str = "select CAST(\"2019-01-02te'xt\" AS DATE FORMAT \"YYYY'MM'DD\\\"te'xt\\\"\")";
        select = (SelectStmt)this.AnalyzesOk(cast_str);
        String expected_str = "CAST('2019-01-02te\\'xt' AS DATE FORMAT 'YYYY\\'MM\\'DD\\\"te\\'xt\\\"')";
        Assert.assertEquals((Object)expected_str, (Object)((Expr)select.getResultExprs().get(0)).toSqlImpl());
        cast_str = "select CAST(\"2019-01-02te\\'xt\" AS DATE FORMAT \"YYYY-MM-DD\\\"te\\\\'xt\\\"\")";
        select = (SelectStmt)this.AnalyzesOk(cast_str);
        expected_str = "CAST('2019-01-02te\\'xt' AS DATE FORMAT 'YYYY-MM-DD\\\"te\\\\\\'xt\\\"')";
        Assert.assertEquals((Object)expected_str, (Object)((Expr)select.getResultExprs().get(0)).toSqlImpl());
    }

    @Test
    public void testUnsafeCasts() {
        AnalysisContext unsafeCtx = this.createAnalysisCtx();
        unsafeCtx.getQueryOptions().setAllow_unsafe_casts(true);
        String[] numericTypes = new String[]{"tinyint", "smallint", "int", "bigint", "float", "double"};
        Pair[] stringTypes = new Pair[]{Pair.create((Object)"string", (Object)"alltypesnopart"), Pair.create((Object)"varchar", (Object)"chars_medium"), Pair.create((Object)"char", (Object)"chars_medium")};
        for (String numericType : numericTypes) {
            for (Pair stringType : stringTypes) {
                String numericToStringStatement = String.format("insert into functional.%s(%s_col) values(cast(100 as %s))", stringType.second, stringType.first, numericType);
                String stringToNumericStatement = String.format("insert into functional.alltypesnopart(%s_col) values(\"100\")", numericType);
                String nonConstStatement = String.format("insert into functional.alltypesnopart(%s_col) select string_col from functional.alltypes", numericType);
                this.AnalyzesOk(numericToStringStatement, unsafeCtx);
                this.AnalyzesOk(stringToNumericStatement, unsafeCtx);
                this.AnalysisError(nonConstStatement, unsafeCtx, "Unsafe implicit cast is prohibited for non-const expression: string_col");
            }
        }
        this.AnalysisError("insert into functional.alltypesnopart(string_col) values (cast(100 as decimal))", unsafeCtx, "Target table 'functional.alltypesnopart' is incompatible with source expressions.\nExpression 'cast(100 as decimal(9,0))' (type: DECIMAL(9,0)) is not compatible with column 'string_col' (type: STRING)");
    }
}

