/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import java.util.HashSet;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.analysis.ParseNode;
import org.apache.impala.authorization.AuthorizationConfig;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.NoopAuthorizationFactory;
import org.apache.impala.authorization.ranger.RangerAuthorizationConfig;
import org.apache.impala.authorization.ranger.RangerAuthorizationFactory;
import org.apache.impala.catalog.Principal;
import org.apache.impala.catalog.Role;
import org.apache.impala.catalog.User;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FrontendTestBase;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.util.EventSequence;
import org.junit.Test;

public class AnalyzeAuthStmtsTest
extends FrontendTestBase {
    protected static final String SERVER_NAME = "server1";
    protected static final String RANGER_SERVICE_TYPE = "hive";
    protected static final String RANGER_APP_ID = "impala";

    public AnalyzeAuthStmtsTest() {
        catalog_.getAuthPolicy().addPrincipal((Principal)new Role("myRole", new HashSet()));
        catalog_.getAuthPolicy().addPrincipal((Principal)new User("myUser", new HashSet()));
    }

    @Override
    public ParseNode AnalyzesOk(String stmt) {
        return this.AnalyzesOk(stmt, this.createAnalysisCtx("default"), null);
    }

    @Override
    public void AnalysisError(String stmt, String expectedErrorString) {
        this.AnalysisError(stmt, this.createAnalysisCtx("default"), expectedErrorString);
    }

    @Override
    protected AnalysisContext createAnalysisCtx(String defaultDb) {
        TQueryCtx queryCtx = TestUtils.createQueryContext(defaultDb, System.getProperty("user.name"));
        EventSequence timeline = new EventSequence("Authorization Test");
        AnalysisContext analysisCtx = new AnalysisContext(queryCtx, (AuthorizationFactory)new RangerAuthorizationFactory((AuthorizationConfig)new RangerAuthorizationConfig(RANGER_SERVICE_TYPE, RANGER_APP_ID, SERVER_NAME, null, null, null)), timeline);
        return analysisCtx;
    }

    private AnalysisContext createAuthDisabledAnalysisCtx() {
        TQueryCtx queryCtx = TestUtils.createQueryContext("default", System.getProperty("user.name"));
        EventSequence timeline = new EventSequence("Authorization Test");
        AnalysisContext analysisCtx = new AnalysisContext(queryCtx, (AuthorizationFactory)new NoopAuthorizationFactory(), timeline);
        return analysisCtx;
    }

    @Test
    public void AnalyzeShowRoles() {
        this.AnalyzesOk("SHOW ROLES");
        this.AnalyzesOk("SHOW ROLE GRANT GROUP myGroup");
        this.AnalyzesOk("SHOW CURRENT ROLES");
        AnalysisContext authDisabledCtx = this.createAuthDisabledAnalysisCtx();
        this.AnalysisError("SHOW ROLES", authDisabledCtx, "Authorization is not enabled.");
        this.AnalysisError("SHOW ROLE GRANT GROUP myGroup", authDisabledCtx, "Authorization is not enabled.");
        this.AnalysisError("SHOW CURRENT ROLES", authDisabledCtx, "Authorization is not enabled.");
    }

    @Test
    public void AnalyzeShowGrantPrincipal() {
        for (String type : new String[]{"ROLE myRole", "USER myUser", "GROUP myGroup"}) {
            this.AnalyzesOk(String.format("SHOW GRANT %s", type));
            this.AnalyzesOk(String.format("SHOW GRANT %s ON SERVER", type));
            this.AnalyzesOk(String.format("SHOW GRANT %s ON DATABASE functional", type));
            this.AnalyzesOk(String.format("SHOW GRANT %s ON TABLE functional.alltypes", type));
            this.AnalyzesOk(String.format("SHOW GRANT %s ON COLUMN functional.alltypes.year", type));
            this.AnalyzesOk(String.format("SHOW GRANT %s ON URI 'hdfs:////test-warehouse//foo'", type));
            AnalysisContext authDisabledCtx = this.createAuthDisabledAnalysisCtx();
            this.AnalysisError("SHOW GRANT ROLE myRole", authDisabledCtx, "Authorization is not enabled.");
            this.AnalysisError("SHOW GRANT ROLE myRole ON SERVER", authDisabledCtx, "Authorization is not enabled.");
            this.AnalysisError(String.format("SHOW GRANT %s on DATABASE foo", type), "Error setting/showing privileges for database 'foo'. Verify that the database exists and that you have permissions to issue a GRANT/REVOKE/SHOW GRANT statement.");
            this.AnalysisError(String.format("SHOW GRANT %s on TABLE foo.bar", type), "Error setting/showing privileges for table 'foo.bar'. Verify that the table exists and that you have permissions to issue a GRANT/REVOKE/SHOW GRANT statement.");
            this.AnalysisError(String.format("SHOW GRANT %s on COLUMN foo.bar.baz", type), "Error setting/showing privileges for table 'foo.bar'. Verify that the table exists and that you have permissions to issue a GRANT/REVOKE/SHOW GRANT statement.");
        }
    }

    @Test
    public void AnalyzeCreateDropRole() throws AnalysisException {
        this.AnalyzesOk("DROP ROLE myRole");
        this.AnalyzesOk("CREATE ROLE doesNotExist");
        this.AnalyzesOk("DROP ROLE MYrole");
        AnalysisContext authDisabledCtx = this.createAuthDisabledAnalysisCtx();
        this.AnalysisError("DROP ROLE myRole", authDisabledCtx, "Authorization is not enabled.");
        this.AnalysisError("CREATE ROLE doesNotExist", authDisabledCtx, "Authorization is not enabled.");
    }

    @Test
    public void AnalyzeGrantRevokeRole() throws AnalysisException {
        this.AnalyzesOk("GRANT ROLE myrole TO GROUP abc");
        this.AnalyzesOk("REVOKE ROLE myrole FROM GROUP abc");
        AnalysisContext authDisabledCtx = this.createAuthDisabledAnalysisCtx();
        this.AnalysisError("GRANT ROLE myrole TO GROUP abc", authDisabledCtx, "Authorization is not enabled.");
        this.AnalysisError("REVOKE ROLE myrole FROM GROUP abc", authDisabledCtx, "Authorization is not enabled.");
    }

    @Test
    public void AnalyzeGrantRevokePriv() throws AnalysisException {
        String[] idents = new String[]{"myRole", "ROLE myRole", "GROUP myGroup", "USER myUser"};
        boolean[] isGrantVals = new boolean[]{true, false};
        for (String ident : idents) {
            for (boolean isGrant : isGrantVals) {
                Object[] formatArgs = new String[]{"REVOKE", "FROM", ident};
                if (isGrant) {
                    formatArgs = new String[]{"GRANT", "TO", ident};
                }
                this.AnalyzesOk(String.format("%s ALL ON TABLE alltypes %s %s", formatArgs), this.createAnalysisCtx("functional"));
                this.AnalyzesOk(String.format("%s ALL ON TABLE functional.alltypes %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s ALL ON TABLE functional_kudu.alltypes %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s ALL ON DATABASE functional %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s ALL ON SERVER %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s ALL ON SERVER server1 %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s ALL ON URI 'hdfs:////abc//123' %s %s", formatArgs));
                this.AnalysisError(String.format("%s ALL ON URI 'xxxx:////abc//123' %s %s", formatArgs), "No FileSystem for scheme: xxxx");
                this.AnalysisError(String.format("%s ALL ON STORAGEHANDLER_URI 'kudu://localhost/tbl' %s %s", formatArgs), "Only 'RWSTORAGE' privilege may be applied at storage handler URI scope in privilege spec.");
                this.AnalysisError(String.format("%s ALL ON DATABASE does_not_exist %s %s", formatArgs), "Error setting/showing privileges for database 'does_not_exist'. Verify that the database exists and that you have permissions to issue a GRANT/REVOKE/SHOW GRANT statement.");
                this.AnalysisError(String.format("%s ALL ON TABLE does_not_exist %s %s", formatArgs), "Error setting/showing privileges for table 'does_not_exist'. Verify that the table exists and that you have permissions to issue a GRANT/REVOKE/SHOW GRANT statement.");
                this.AnalysisError(String.format("%s ALL ON SERVER does_not_exist %s %s", formatArgs), "Specified server name 'does_not_exist' does not match the configured server name 'server1'");
                this.AnalyzesOk(String.format("%s INSERT ON TABLE alltypesagg %s %s", formatArgs), this.createAnalysisCtx("functional"));
                this.AnalyzesOk(String.format("%s INSERT ON TABLE functional_kudu.alltypessmall %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s INSERT ON TABLE functional.alltypesagg %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s INSERT ON DATABASE functional %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s INSERT ON SERVER %s %s", formatArgs));
                this.AnalysisError(String.format("%s INSERT ON URI 'hdfs:////abc//123' %s %s", formatArgs), "Only 'ALL' privilege may be applied at URI scope in privilege spec.");
                this.AnalysisError(String.format("%s INSERT ON STORAGEHANDLER_URI 'kudu://localhost/tbl' %s %s", formatArgs), "Only 'RWSTORAGE' privilege may be applied at storage handler URI scope in privilege spec.");
                this.AnalyzesOk(String.format("%s SELECT ON TABLE alltypessmall %s %s", formatArgs), this.createAnalysisCtx("functional"));
                this.AnalyzesOk(String.format("%s SELECT ON TABLE functional.alltypessmall %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s SELECT ON TABLE functional_kudu.alltypessmall %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s SELECT ON DATABASE functional %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s SELECT ON SERVER %s %s", formatArgs));
                this.AnalysisError(String.format("%s SELECT ON URI 'hdfs:////abc//123' %s %s", formatArgs), "Only 'ALL' privilege may be applied at URI scope in privilege spec.");
                this.AnalysisError(String.format("%s SELECT ON STORAGEHANDLER_URI 'kudu://localhost/tbl' %s %s", formatArgs), "Only 'RWSTORAGE' privilege may be applied at storage handler URI scope in privilege spec.");
                this.AnalyzesOk(String.format("%s SELECT (id, int_col) ON TABLE functional.alltypes %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s SELECT (id, id) ON TABLE functional.alltypes %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s SELECT (id, int_col, year, month) ON TABLE alltypes %s %s", formatArgs), this.createAnalysisCtx("functional"));
                this.AnalyzesOk(String.format("%s SELECT (id, bool_col) ON TABLE functional_kudu.alltypessmall %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s SELECT (id, bool_col) ON TABLE functional.alltypes_hive_view %s %s", formatArgs));
                this.AnalysisError(String.format("%s SELECT () ON TABLE functional.alltypes %s %s", formatArgs), "Empty column list in column privilege spec.");
                this.AnalysisError(String.format("%s INSERT (id, tinyint_col) ON TABLE functional.alltypes %s %s", formatArgs), "Only 'SELECT' privileges are allowed in a column privilege spec.");
                this.AnalysisError(String.format("%s ALL (id, tinyint_col) ON TABLE functional.alltypes %s %s", formatArgs), "Only 'SELECT' privileges are allowed in a column privilege spec.");
                this.AnalysisError(String.format("%s SELECT (invalid_col) ON TABLE functional.alltypes %s %s", formatArgs), "Error setting/showing column-level privileges for table 'functional.alltypes'. Verify that both table and columns exist and that you have permissions to issue a GRANT/REVOKE/SHOW GRANT statement.");
                this.AnalysisError(String.format("%s SELECT (id, int_col) ON TABLE functional.does_not_exist %s %s", formatArgs), "Error setting/showing privileges for table 'functional.does_not_exist'. Verify that the table exists and that you have permissions to issue a GRANT/REVOKE/SHOW GRANT statement.");
                this.AnalyzesOk(String.format("%s REFRESH ON TABLE functional.alltypes %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s REFRESH ON DATABASE functional %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s REFRESH ON SERVER %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s REFRESH ON SERVER server1 %s %s", formatArgs));
                this.AnalysisError(String.format("%s REFRESH ON URI 'hdfs:////abc//123' %s %s", formatArgs), "Only 'ALL' privilege may be applied at URI scope in privilege spec.");
                this.AnalysisError(String.format("%s REFRESH ON STORAGEHANDLER_URI 'kudu://localhost/tbl' %s %s", formatArgs), "Only 'RWSTORAGE' privilege may be applied at storage handler URI scope in privilege spec.");
                this.AnalyzesOk(String.format("%s CREATE ON SERVER %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s CREATE ON SERVER server1 %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s CREATE ON DATABASE functional %s %s", formatArgs));
                this.AnalysisError(String.format("%s CREATE ON TABLE functional.alltypes %s %s", formatArgs), "Create-level privileges on tables are not supported.");
                this.AnalysisError(String.format("%s CREATE ON URI 'hdfs:////abc//123' %s %s", formatArgs), "Only 'ALL' privilege may be applied at URI scope in privilege spec.");
                this.AnalysisError(String.format("%s CREATE ON STORAGEHANDLER_URI 'kudu://localhost/tbl' %s %s", formatArgs), "Only 'RWSTORAGE' privilege may be applied at storage handler URI scope in privilege spec.");
                this.AnalyzesOk(String.format("%s ALTER ON SERVER %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s ALTER ON SERVER server1 %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s ALTER ON DATABASE functional %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s ALTER ON TABLE functional.alltypes %s %s", formatArgs));
                this.AnalysisError(String.format("%s ALTER ON URI 'hdfs:////abc/123' %s %s", formatArgs), "Only 'ALL' privilege may be applied at URI scope in privilege spec.");
                this.AnalysisError(String.format("%s ALTER ON STORAGEHANDLER_URI 'kudu://localhost/tbl' %s %s", formatArgs), "Only 'RWSTORAGE' privilege may be applied at storage handler URI scope in privilege spec.");
                this.AnalyzesOk(String.format("%s DROP ON SERVER %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s DROP ON SERVER server1 %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s DROP ON DATABASE functional %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s DROP ON TABLE functional.alltypes %s myrole", formatArgs));
                this.AnalysisError(String.format("%s DROP ON URI 'hdfs:////abc/123' %s %s", formatArgs), "Only 'ALL' privilege may be applied at URI scope in privilege spec.");
                this.AnalysisError(String.format("%s DROP ON STORAGEHANDLER_URI 'kudu://localhost/tbl' %s %s", formatArgs), "Only 'RWSTORAGE' privilege may be applied at storage handler URI scope in privilege spec.");
                this.AnalyzesOk(String.format("%s RWSTORAGE ON STORAGEHANDLER_URI 'kudu://localhost/tbl' %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s RWSTORAGE ON STORAGEHANDLER_URI '*://*' %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s RWSTORAGE ON STORAGEHANDLER_URI 'kudu://*' %s %s", formatArgs));
                this.AnalyzesOk(String.format("%s RWSTORAGE ON STORAGEHANDLER_URI 'kudu://localhost/*' %s %s", formatArgs));
                this.AnalysisError(String.format("%s DROP ON STORAGEHANDLER_URI 'abc://localhost/tbl' %s %s", formatArgs), "The storage type \"abc\" is not supported. A storage handler URI should be in the form of <storage_type>://<hostname>[:<port>]/<path_to_resource>.");
                this.AnalysisError(String.format("%s RWSTORAGE ON STORAGEHANDLER_URI 'kudu://*/*' %s %s", formatArgs), "A storage handler URI should be in the form of <storage_type>://<hostname>[:<port>]/<path_to_resource>.");
            }
            AnalysisContext authDisabledCtx = this.createAuthDisabledAnalysisCtx();
            this.AnalysisError("GRANT ALL ON SERVER TO myRole", authDisabledCtx, "Authorization is not enabled.");
            this.AnalysisError("REVOKE ALL ON SERVER FROM myRole", authDisabledCtx, "Authorization is not enabled.");
            TQueryCtx noUserNameQueryCtx = TestUtils.createQueryContext("default", "");
            EventSequence timeline = new EventSequence("Authorization Test");
            AnalysisContext noUserNameCtx = new AnalysisContext(noUserNameQueryCtx, (AuthorizationFactory)new RangerAuthorizationFactory((AuthorizationConfig)new RangerAuthorizationConfig(RANGER_SERVICE_TYPE, RANGER_APP_ID, SERVER_NAME, null, null, null)), timeline);
            this.AnalysisError("GRANT ALL ON SERVER TO myRole", noUserNameCtx, "Cannot execute authorization statement with an empty username.");
        }
    }
}

