/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.extdatasource;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.impala.extdatasource.thrift.TBinaryPredicate;
import org.apache.impala.extdatasource.thrift.TCloseParams;
import org.apache.impala.extdatasource.thrift.TCloseResult;
import org.apache.impala.extdatasource.thrift.TColumnDesc;
import org.apache.impala.extdatasource.thrift.TGetNextParams;
import org.apache.impala.extdatasource.thrift.TGetNextResult;
import org.apache.impala.extdatasource.thrift.TOpenParams;
import org.apache.impala.extdatasource.thrift.TOpenResult;
import org.apache.impala.extdatasource.thrift.TPrepareParams;
import org.apache.impala.extdatasource.thrift.TPrepareResult;
import org.apache.impala.extdatasource.thrift.TRowBatch;
import org.apache.impala.extdatasource.thrift.TTableSchema;
import org.apache.impala.extdatasource.util.SerializationUtils;
import org.apache.impala.extdatasource.v1.ExternalDataSource;
import org.apache.impala.thrift.TColumnData;
import org.apache.impala.thrift.TColumnType;
import org.apache.impala.thrift.TErrorCode;
import org.apache.impala.thrift.TPrimitiveType;
import org.apache.impala.thrift.TScalarType;
import org.apache.impala.thrift.TStatus;
import org.apache.impala.thrift.TTypeNode;
import org.apache.impala.thrift.TTypeNodeType;

public class AllTypesDataSource
implements ExternalDataSource {
    private static final int NUM_ROWS_RETURNED = 5000;
    private static final int INITIAL_BATCH_SIZE = 500;
    private static final int BATCH_SIZE_INCREMENT = 100;
    private static final TStatus STATUS_OK = new TStatus(TErrorCode.OK, (List)Lists.newArrayList());
    private int currRow_ = 0;
    private boolean eos_ = false;
    private int batchSize_;
    private TTableSchema schema_;
    private DataSourceState state_ = DataSourceState.CREATED;
    private String scanHandle_;
    private String validatePredicatesResult_;

    public TPrepareResult prepare(TPrepareParams params) {
        Preconditions.checkState((this.state_ == DataSourceState.CREATED ? 1 : 0) != 0);
        ArrayList accepted = Lists.newArrayList();
        int numRowsReturned = 0;
        if (this.validatePredicates(params.getPredicates())) {
            for (int i = 0; i < params.getPredicatesSize(); ++i) {
                accepted.add(i);
            }
            numRowsReturned = 1;
        } else {
            for (int i = 0; i < params.getPredicatesSize(); ++i) {
                if (i % 2 != 0) continue;
                accepted.add(i);
            }
            numRowsReturned = 5000;
        }
        return new TPrepareResult(STATUS_OK).setAccepted_conjuncts((List)accepted).setNum_rows_estimate((long)numRowsReturned);
    }

    private boolean validatePredicates(List<List<TBinaryPredicate>> predicates) {
        if (predicates == null || predicates.isEmpty()) {
            return false;
        }
        TBinaryPredicate firstPredicate = predicates.get(0).get(0);
        if (!firstPredicate.getValue().isSetString_val()) {
            return false;
        }
        String colVal = firstPredicate.getValue().getString_val();
        if (!colVal.toUpperCase().startsWith("VALIDATE_PREDICATES##")) {
            return false;
        }
        String[] colValParts = colVal.split("##");
        Preconditions.checkArgument((colValParts.length == 2 ? 1 : 0) != 0);
        String[] expectedPredicates = colValParts[1].split("&&");
        Preconditions.checkArgument((expectedPredicates.length == predicates.size() - 1 ? 1 : 0) != 0);
        String result = "SUCCESS";
        for (int i = 1; i < predicates.size(); ++i) {
            String[] predicateParts = expectedPredicates[i - 1].trim().split(" ");
            Preconditions.checkArgument((predicateParts.length == 3 ? 1 : 0) != 0);
            TBinaryPredicate predicate = (TBinaryPredicate)Iterables.getOnlyElement((Iterable)predicates.get(i));
            Preconditions.checkArgument((boolean)predicate.getValue().isSetInt_val());
            String slotName = predicate.getCol().getName().toUpperCase();
            int intVal = predicate.getValue().getInt_val();
            if (predicateParts[0].toUpperCase().equals(slotName) && predicateParts[1].toUpperCase().equals(predicate.getOp().name()) && predicateParts[2].equals(Integer.toString(intVal))) continue;
            result = "Failed predicate, expected=" + expectedPredicates[i - 1].trim() + " actual=" + predicate.toString();
        }
        this.validatePredicatesResult_ = result;
        return true;
    }

    public TOpenResult open(TOpenParams params) {
        Preconditions.checkState((this.state_ == DataSourceState.CREATED ? 1 : 0) != 0);
        this.state_ = DataSourceState.OPENED;
        this.batchSize_ = 500;
        this.schema_ = params.getRow_schema();
        if (this.validatePredicates(params.getPredicates())) {
            Preconditions.checkArgument((this.schema_.getColsSize() == 1 ? 1 : 0) != 0);
            TColumnDesc firstCol = (TColumnDesc)this.schema_.getCols().get(0);
            TColumnType firstType = firstCol.getType();
            Preconditions.checkState((firstType.getTypesSize() == 1 ? 1 : 0) != 0);
            Preconditions.checkState((((TTypeNode)firstType.types.get(0)).getType() == TTypeNodeType.SCALAR ? 1 : 0) != 0);
            Preconditions.checkArgument((((TTypeNode)firstType.types.get((int)0)).scalar_type.getType() == TPrimitiveType.STRING ? 1 : 0) != 0);
        }
        this.scanHandle_ = UUID.randomUUID().toString();
        return new TOpenResult(STATUS_OK).setScan_handle(this.scanHandle_);
    }

    public TGetNextResult getNext(TGetNextParams params) {
        Preconditions.checkState((this.state_ == DataSourceState.OPENED ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)params.getScan_handle().equals(this.scanHandle_));
        if (this.eos_) {
            return new TGetNextResult(STATUS_OK).setEos(this.eos_);
        }
        if (this.validatePredicatesResult_ != null) {
            TColumnData colData = new TColumnData();
            colData.setIs_null((List)Lists.newArrayList((Object[])new Boolean[]{false}));
            colData.setString_vals((List)Lists.newArrayList((Object[])new String[]{this.validatePredicatesResult_}));
            this.eos_ = true;
            return new TGetNextResult(STATUS_OK).setEos(this.eos_).setRows(new TRowBatch().setCols((List)Lists.newArrayList((Object[])new TColumnData[]{colData})).setNum_rows(1L));
        }
        ArrayList cols = Lists.newArrayList();
        for (int i = 0; i < this.schema_.getColsSize(); ++i) {
            cols.add(new TColumnData().setIs_null((List)Lists.newArrayList()));
        }
        int numAdded = 0;
        while (this.currRow_ < 5000 && numAdded < this.batchSize_) {
            this.addRow(cols);
            ++numAdded;
            ++this.currRow_;
        }
        this.batchSize_ += 100;
        if (this.currRow_ == 5000) {
            this.eos_ = true;
        }
        return new TGetNextResult(STATUS_OK).setEos(this.eos_).setRows(new TRowBatch().setCols((List)cols).setNum_rows((long)numAdded));
    }

    private void addRow(List<TColumnData> cols) {
        block12: for (int i = 0; i < cols.size(); ++i) {
            TColumnDesc colDesc = (TColumnDesc)this.schema_.getCols().get(i);
            TColumnData colData = cols.get(i);
            TColumnType type = colDesc.getType();
            if (((TTypeNode)type.types.get(0)).getType() != TTypeNodeType.SCALAR) {
                throw new UnsupportedOperationException("Unsupported column type: " + ((TTypeNode)type.types.get(0)).getType());
            }
            Preconditions.checkState((type.getTypesSize() == 1 ? 1 : 0) != 0);
            TScalarType scalarType = ((TTypeNode)type.types.get((int)0)).scalar_type;
            switch (scalarType.type) {
                case TINYINT: {
                    colData.addToIs_null(false);
                    colData.addToByte_vals((byte)(this.currRow_ % 10));
                    continue block12;
                }
                case SMALLINT: {
                    colData.addToIs_null(false);
                    colData.addToShort_vals((short)(this.currRow_ % 100));
                    continue block12;
                }
                case INT: 
                case DATE: {
                    colData.addToIs_null(false);
                    colData.addToInt_vals(this.currRow_);
                    continue block12;
                }
                case BIGINT: {
                    colData.addToIs_null(false);
                    colData.addToLong_vals((long)this.currRow_ * 10L);
                    continue block12;
                }
                case DOUBLE: {
                    colData.addToIs_null(false);
                    colData.addToDouble_vals((double)this.currRow_);
                    continue block12;
                }
                case FLOAT: {
                    colData.addToIs_null(false);
                    colData.addToDouble_vals((double)((float)(1.1 * (double)this.currRow_)));
                    continue block12;
                }
                case STRING: {
                    if (this.currRow_ % 5 == 0) {
                        colData.addToIs_null(true);
                        continue block12;
                    }
                    colData.addToIs_null(false);
                    colData.addToString_vals(String.valueOf(this.currRow_));
                    continue block12;
                }
                case BOOLEAN: {
                    colData.addToIs_null(false);
                    colData.addToBool_vals(this.currRow_ % 2 == 0);
                    continue block12;
                }
                case TIMESTAMP: {
                    colData.addToIs_null(false);
                    colData.addToBinary_vals(SerializationUtils.encodeTimestamp((Timestamp)new Timestamp(this.currRow_)));
                    continue block12;
                }
                case DECIMAL: {
                    colData.addToIs_null(false);
                    BigInteger maxUnscaled = BigInteger.TEN.pow(scalarType.getPrecision());
                    BigInteger val = maxUnscaled.subtract(BigInteger.valueOf(this.currRow_ + 1));
                    val = val.mod(maxUnscaled);
                    if (this.currRow_ % 2 == 0) {
                        val = val.negate();
                    }
                    colData.addToBinary_vals(SerializationUtils.encodeDecimal((BigDecimal)new BigDecimal(val)));
                    continue block12;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported column type: " + scalarType.getType());
                }
            }
        }
    }

    public TCloseResult close(TCloseParams params) {
        Preconditions.checkState((this.state_ == DataSourceState.OPENED ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)params.getScan_handle().equals(this.scanHandle_));
        this.state_ = DataSourceState.CLOSED;
        return new TCloseResult(STATUS_OK);
    }

    private static enum DataSourceState {
        CREATED,
        OPENED,
        CLOSED;

    }
}

