/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.extdatasource.util;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Timestamp;

public class SerializationUtils {
    public static ByteBuffer encodeDecimal(BigDecimal decimal) {
        if (decimal == null) {
            throw new NullPointerException("decimal cannot be null.");
        }
        return ByteBuffer.wrap(decimal.unscaledValue().toByteArray());
    }

    public static ByteBuffer encodeTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            throw new NullPointerException("timestamp cannot be null.");
        }
        ByteBuffer buffer = ByteBuffer.allocate(12);
        buffer.putLong(timestamp.getTime() / 1000L);
        buffer.putInt(timestamp.getNanos());
        buffer.rewind();
        return buffer;
    }
}

