/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.datagenerator;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class CsvToHBaseConverter {
    public static void convertAllTypesTable(String inDir, String outDir, String hbaseTableName) {
        File inDirFile = new File(inDir);
        File outDirFile = new File(outDir);
        if (!outDirFile.exists()) {
            outDirFile.mkdirs();
        }
        try {
            String[] children;
            FileWriter outFile = new FileWriter(outDirFile.getAbsolutePath() + "/" + hbaseTableName + ".hbase");
            PrintWriter out = new PrintWriter(outFile);
            for (String csvFile : children = inDirFile.list()) {
                String csvLine;
                if (!csvFile.endsWith(".txt")) continue;
                FileInputStream finstream = new FileInputStream(inDirFile.getAbsolutePath() + "/" + csvFile);
                DataInputStream in = new DataInputStream(finstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((csvLine = br.readLine()) != null) {
                    CsvToHBaseConverter.convertLine(csvLine, out, hbaseTableName);
                }
                in.close();
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void convertLine(String csvLine, PrintWriter out, String hbaseTableName) throws IOException {
        String[] parts = csvLine.split(",");
        if (parts.length != 11) {
            throw new IOException("Line does not have 11 columns: " + csvLine);
        }
        out.format("put '%s', '%s', '%s', '%s'\n", hbaseTableName, parts[0], "d:bigint_col", parts[5]);
        out.format("put '%s', '%s', '%s', '%s'\n", hbaseTableName, parts[0], "d:bool_col", parts[1]);
        out.format("put '%s', '%s', '%s', '%s'\n", hbaseTableName, parts[0], "d:date_string_col", parts[8]);
        out.format("put '%s', '%s', '%s', '%s'\n", hbaseTableName, parts[0], "d:double_col", parts[7]);
        out.format("put '%s', '%s', '%s', '%s'\n", hbaseTableName, parts[0], "d:float_col", parts[6]);
        out.format("put '%s', '%s', '%s', '%s'\n", hbaseTableName, parts[0], "d:int_col", parts[4]);
        out.format("put '%s', '%s', '%s', '%s'\n", hbaseTableName, parts[0], "d:smallint_col", parts[3]);
        out.format("put '%s', '%s', '%s', '%s'\n", hbaseTableName, parts[0], "d:string_col", parts[9]);
        out.format("put '%s', '%s', '%s', '%s'\n", hbaseTableName, parts[0], "d:timestamp_col", parts[10]);
        out.format("put '%s', '%s', '%s', '%s'\n", hbaseTableName, parts[0], "d:tinyint_col", parts[2]);
    }

    public static void main(String[] args) throws Exception {
        CsvToHBaseConverter.convertAllTypesTable("AllTypesError", "HBaseAllTypesError", "functional_hbase.hbasealltypeserror");
        CsvToHBaseConverter.convertAllTypesTable("AllTypesErrorNoNulls", "HBaseAllTypesErrorNoNulls", "functional_hbase.hbasealltypeserrornonulls");
        System.exit(0);
    }
}

