/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.datagenerator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class RandomNestedDataGenerator {
    public static Random rand;
    public static int maxNormalStrLen;
    public static int maxNumListItems;
    public static int numElementsGenerated;
    public static ArrayList<Double> doubleCache;
    public static ArrayList<Float> floatCache;
    public static ArrayList<Integer> intCache;
    public static ArrayList<Long> longCache;
    public static ArrayList<String> stringCache;
    public static String alphabet;
    public static final Integer NUM_ELEMENTS;
    public static final Integer RAND_SEED;
    public static final Double CHANCE_UNIQUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateDataToFile(String schemaFile, int targetNumElements, String outputFile, Optional<Long> seed) throws IOException {
        RandomNestedDataGenerator.buildCache();
        rand = seed.isPresent() ? new Random(seed.get()) : new Random();
        Schema schema = new Schema.Parser().parse(new File(schemaFile));
        Configuration conf = new Configuration();
        conf.set("parquet.avro.write-old-list-structure", "false");
        try (AvroParquetWriter writer = new AvroParquetWriter(new Path("file:///" + outputFile), schema, CompressionCodecName.UNCOMPRESSED, 0x8000000, 0x100000, false, conf);){
            while (numElementsGenerated < targetNumElements) {
                GenericData.Record record = (GenericData.Record)RandomNestedDataGenerator.generateDatum(schema, 0);
                writer.write((Object)record);
            }
        }
    }

    private static void buildCache() {
        RandomNestedDataGenerator.buildDoubleCache();
        RandomNestedDataGenerator.buildFloatCache();
        RandomNestedDataGenerator.buildIntCache();
        RandomNestedDataGenerator.buildLongCache();
        RandomNestedDataGenerator.buildStringCache();
    }

    private static void buildDoubleCache() {
        rand = new Random(RAND_SEED.intValue());
        doubleCache = new ArrayList();
        for (double i = 0.0; i < (double)NUM_ELEMENTS.intValue(); i += 1.0) {
            doubleCache.add(i);
        }
    }

    private static void buildFloatCache() {
        rand = new Random(RAND_SEED.intValue());
        floatCache = new ArrayList();
        for (float i = 0.0f; i < (float)NUM_ELEMENTS.intValue(); i += 1.0f) {
            floatCache.add(Float.valueOf(i));
        }
    }

    private static void buildIntCache() {
        rand = new Random(RAND_SEED.intValue());
        intCache = new ArrayList();
        for (int i = 0; i < NUM_ELEMENTS; ++i) {
            intCache.add(i);
        }
    }

    private static void buildLongCache() {
        rand = new Random(RAND_SEED.intValue());
        longCache = new ArrayList();
        for (long i = 0L; i < (long)NUM_ELEMENTS.intValue(); ++i) {
            longCache.add(i);
        }
    }

    private static void buildStringCache() {
        rand = new Random(RAND_SEED.intValue());
        stringCache = new ArrayList();
        for (int i = 0; i < NUM_ELEMENTS; ++i) {
            StringBuilder sb = new StringBuilder();
            int len = rand.nextInt(maxNormalStrLen);
            for (int j = 0; j < len; ++j) {
                sb.append(alphabet.charAt(rand.nextInt(alphabet.length())));
            }
            stringCache.add(sb.toString());
        }
    }

    private static boolean isOptional(Schema schema) {
        if (schema.getType() != Schema.Type.UNION) {
            return false;
        }
        for (Schema s : schema.getTypes()) {
            if (s.getType() != Schema.Type.NULL) continue;
            return true;
        }
        return false;
    }

    private static int generateListLength(int depth) {
        if (rand.nextDouble() < 0.1) {
            return 0;
        }
        return rand.nextInt(maxNumListItems);
    }

    private static Schema getNonNullSchema(Schema schema) {
        if (schema.getType() != Schema.Type.UNION) {
            return schema;
        }
        assert (schema.getTypes().size() == 2);
        for (Schema s : schema.getTypes()) {
            if (s.getType() == Schema.Type.NULL) continue;
            return s;
        }
        assert (false);
        return null;
    }

    private static boolean chooseNull() {
        return rand.nextDouble() < 0.2;
    }

    private static Double getRandomDouble() {
        ++numElementsGenerated;
        if (rand.nextDouble() < CHANCE_UNIQUE) {
            return rand.nextDouble();
        }
        return doubleCache.get(rand.nextInt(doubleCache.size()));
    }

    private static Float getRandomFloat() {
        ++numElementsGenerated;
        if (rand.nextDouble() < CHANCE_UNIQUE) {
            return Float.valueOf(rand.nextFloat());
        }
        return floatCache.get(rand.nextInt(floatCache.size()));
    }

    private static Integer getRandomInt() {
        ++numElementsGenerated;
        if (rand.nextDouble() < CHANCE_UNIQUE) {
            return rand.nextInt();
        }
        return intCache.get(rand.nextInt(intCache.size()));
    }

    private static Long getRandomLong() {
        ++numElementsGenerated;
        if (rand.nextDouble() < CHANCE_UNIQUE) {
            return rand.nextLong();
        }
        return longCache.get(rand.nextInt(longCache.size()));
    }

    private static Boolean getRandomBoolean() {
        ++numElementsGenerated;
        return rand.nextBoolean();
    }

    private static String getRandomString() {
        ++numElementsGenerated;
        if (rand.nextDouble() < CHANCE_UNIQUE) {
            StringBuilder sb = new StringBuilder();
            int len = rand.nextInt(900);
            for (int i = 0; i < len; ++i) {
                sb.append(alphabet.charAt(rand.nextInt(alphabet.length())));
            }
            return sb.toString();
        }
        return stringCache.get(rand.nextInt(stringCache.size()));
    }

    private static Object generateDatum(Schema schema, int depth) {
        if (RandomNestedDataGenerator.isOptional(schema) && RandomNestedDataGenerator.chooseNull()) {
            return null;
        }
        schema = RandomNestedDataGenerator.getNonNullSchema(schema);
        switch (schema.getType()) {
            case RECORD: {
                GenericRecordBuilder builder = new GenericRecordBuilder(schema);
                for (Schema.Field f : schema.getFields()) {
                    builder.set(f, RandomNestedDataGenerator.generateDatum(f.schema(), depth));
                }
                return builder.build();
            }
            case ARRAY: {
                Schema elementSchema = schema.getElementType();
                ArrayList<Object> arr = new ArrayList<Object>();
                int numElements = RandomNestedDataGenerator.generateListLength(depth);
                for (int i = 0; i < numElements; ++i) {
                    arr.add(RandomNestedDataGenerator.generateDatum(elementSchema, depth + 1));
                }
                return arr;
            }
            case MAP: {
                Schema valueSchema = schema.getValueType();
                HashMap<String, Object> m = new HashMap<String, Object>();
                int numElements = RandomNestedDataGenerator.generateListLength(depth);
                for (int i = 0; i < numElements; ++i) {
                    String key = RandomNestedDataGenerator.getRandomString();
                    m.put(key, RandomNestedDataGenerator.generateDatum(valueSchema, depth + 1));
                }
                return m;
            }
            case BOOLEAN: {
                return (boolean)RandomNestedDataGenerator.getRandomBoolean();
            }
            case DOUBLE: {
                return (double)RandomNestedDataGenerator.getRandomDouble();
            }
            case FLOAT: {
                return Float.valueOf(RandomNestedDataGenerator.getRandomFloat().floatValue());
            }
            case INT: {
                return (int)RandomNestedDataGenerator.getRandomInt();
            }
            case LONG: {
                return (long)RandomNestedDataGenerator.getRandomLong();
            }
            case STRING: {
                return RandomNestedDataGenerator.getRandomString();
            }
        }
        assert (false);
        return null;
    }

    public static void main(String[] args) throws Exception {
        int num_args = args.length;
        if (num_args < 5 || num_args > 6) {
            System.err.println("Arguments: schema_file num_elements max_normal_str_len max_list_len output_file [random_seed]");
            System.exit(1);
        }
        String schemaFile = args[0];
        int numElements = Integer.valueOf(args[1]);
        maxNormalStrLen = Integer.valueOf(args[2]);
        maxNumListItems = Integer.valueOf(args[3]);
        String outputFile = args[4];
        Optional<Long> seed = num_args > 5 ? Optional.of(Long.valueOf(args[5])) : Optional.empty();
        RandomNestedDataGenerator.generateDataToFile(schemaFile, numElements, outputFile, seed);
    }

    static {
        numElementsGenerated = 0;
        alphabet = "abcdfghijklmnopqrstuvwxyz0123456789";
        NUM_ELEMENTS = 100;
        RAND_SEED = 12345;
        CHANCE_UNIQUE = 0.02;
    }
}

