/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.datagenerator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

class TestDataGenerator {
    private static final int DEFAULT_NUM_PARTITIONS = 24;
    private static final int DEFAULT_MAX_TUPLES_PER_PARTITION = 310;
    private static final int DEFAULT_END_YEAR = 2010;
    private static int id = 0;

    TestDataGenerator() {
    }

    private static void GenerateAllTypesData(String dir, int numPartitions, int maxTuplesPerPartition) throws IOException {
        id = 0;
        int numYears = Math.max(numPartitions / 12 - 1, 1);
        int startYear = Math.max(2010 - numYears, 0);
        GregorianCalendar date = new GregorianCalendar(startYear, 0, 1);
        GregorianCalendar endDate = new GregorianCalendar(2010, 11, 31);
        for (int months = 0; date.before(endDate) && months < numPartitions; ++months) {
            GregorianCalendar nextMonth = (GregorianCalendar)date.clone();
            nextMonth.add(2, 1);
            TestDataGenerator.GenerateAllTypesPartition(dir, date, nextMonth, 10, maxTuplesPerPartition, false);
            date = nextMonth;
        }
    }

    private static void GenerateAllTypesAggData(String dir, boolean writeNulls) throws IOException {
        id = 0;
        int startYear = 2010;
        GregorianCalendar date = new GregorianCalendar(startYear, 0, 1);
        GregorianCalendar endDate = (GregorianCalendar)date.clone();
        endDate.add(5, 10);
        while (date.before(endDate)) {
            GregorianCalendar nextDay = (GregorianCalendar)date.clone();
            nextDay.add(5, 1);
            TestDataGenerator.GenerateAllTypesPartition(dir, date, nextDay, 1000, 1000, writeNulls);
            date = nextDay;
        }
    }

    private static void GenerateAllTypesPartition(String dir, Calendar startDate, Calendar endDate, int intsPerDay, int maxTuplesPerPartition, boolean writeNulls) throws IOException {
        SimpleDateFormat filenameFormat = new SimpleDateFormat("yyMMdd");
        PrintWriter writer = new PrintWriter(new FileWriter(new File(new File(dir), filenameFormat.format(startDate.getTime()) + ".txt")));
        Calendar date = (Calendar)startDate.clone();
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yy");
        SimpleDateFormat tsf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        int count = 0;
        while (date.before(endDate) && count < maxTuplesPerPartition) {
            for (int int_col = 0; int_col < intsPerDay && count < maxTuplesPerPartition; ++count, ++int_col) {
                boolean bool_col = id % 2 == 0;
                byte tinyint_col = (byte)(int_col % 10);
                short smallint_col = (short)(int_col % 100);
                long bigint_col = int_col * 10;
                float float_col = (float)(1.1 * (double)int_col);
                double double_col = 10.1 * (double)int_col;
                String date_string_col = df.format(date.getTime());
                String string_col = String.valueOf(int_col);
                String timestamp_col = tsf.format(date.getTime());
                writer.format("%d,%b,%s,%s,%s,%s,", id, bool_col, writeNulls && tinyint_col == 0 ? "" : Byte.toString(tinyint_col), writeNulls && smallint_col == 0 ? "" : Short.toString(smallint_col), writeNulls && int_col == 0 ? "" : Integer.toString(int_col), writeNulls && bigint_col == 0L ? "" : Long.toString(bigint_col));
                writer.format("%s,%s,%s,%s,%s\n", writeNulls && int_col == 0 ? "" : Float.toString(float_col), writeNulls && int_col == 0 ? "" : Double.toString(double_col), date_string_col, string_col, timestamp_col);
                ++id;
                date.add(12, 1);
                date.add(14, (int)bigint_col);
            }
            date.add(5, 1);
        }
        writer.close();
    }

    private static void GenerateDecimalData(String dir, int numRows) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(new File(new File(dir), "data.txt")));
        double col1 = 0.0;
        double col2 = 100.0;
        double col3 = 0.0;
        double col1Delta = 0.1111;
        double col2Delta = 1.22222;
        double col3Delta = 0.1;
        for (int i = 0; i < numRows; ++i) {
            if (i % 10 == 0) {
                col3 = 0.0;
            }
            String s1 = BigDecimal.valueOf(col1).setScale(4, 4).toString();
            String s2 = BigDecimal.valueOf(col2).setScale(5, 4).toString();
            String s3 = BigDecimal.valueOf(col3).setScale(1, 4).toString();
            writer.format("%s,%s,%s\n", s1, s2, s3);
            col1 += col1Delta;
            col2 += col2Delta;
            col3 += col3Delta;
        }
        writer.close();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: TestDataGenerator BaseOutputDirectory");
        }
        TimeZone.setDefault(TimeZone.getTimeZone("America/Los_Angeles"));
        String dirName = args[0] + "/AllTypes";
        File dir = new File(dirName);
        dir.mkdirs();
        TestDataGenerator.GenerateAllTypesData(dirName, 24, 310);
        dirName = args[0] + "/AllTypesSmall";
        dir = new File(dirName);
        dir.mkdirs();
        TestDataGenerator.GenerateAllTypesData(dirName, 4, 25);
        dirName = args[0] + "/AllTypesTiny";
        dir = new File(dirName);
        dir.mkdirs();
        TestDataGenerator.GenerateAllTypesData(dirName, 4, 2);
        dirName = args[0] + "/AllTypesAgg";
        dir = new File(dirName);
        dir.mkdirs();
        TestDataGenerator.GenerateAllTypesAggData(dirName, true);
        dirName = args[0] + "/AllTypesAggNoNulls";
        dir = new File(dirName);
        dir.mkdirs();
        TestDataGenerator.GenerateAllTypesAggData(dirName, false);
        dirName = args[0] + "/DecimalTiny";
        dir = new File(dirName);
        dir.mkdirs();
        TestDataGenerator.GenerateDecimalData(dirName, 100);
    }
}

