/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.datagenerator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroParquetWriter;
import org.kitesdk.data.spi.JsonUtil;

public class JsonToParquetConverter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 3 && args.length != 4) {
            System.err.println("Usage: [--legacy_collection_format] <schema path> <json path> <output path>");
            System.exit(1);
        }
        int i = 0;
        boolean legacyCollectionFormat = false;
        if (args.length == 4) {
            legacyCollectionFormat = true;
        }
        int n = ++i;
        File schemaPath = new File(args[n]);
        int n2 = ++i;
        File jsonPath = new File(args[n2]);
        int n3 = ++i;
        ++i;
        Path outputPath = new Path("file://" + args[n3]);
        Schema schema = new Schema.Parser().parse(schemaPath);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = (JsonNode)mapper.readValue(jsonPath, JsonNode.class);
        Preconditions.checkArgument((boolean)root.isArray(), (Object)"Input JSON should be an array of records");
        Configuration conf = new Configuration();
        if (legacyCollectionFormat) {
            conf.set("parquet.avro.write-old-list-structure", "true");
        } else {
            conf.set("parquet.avro.write-old-list-structure", "false");
        }
        try (AvroParquetWriter writer = new AvroParquetWriter(outputPath, schema, AvroParquetWriter.DEFAULT_COMPRESSION_CODEC_NAME, 0x8000000, 0x100000, true, conf);){
            for (JsonNode jsonRecord : root) {
                System.out.println("record: " + jsonRecord);
                GenericRecord record = (GenericRecord)JsonUtil.convertToAvro((GenericData)GenericData.get(), (JsonNode)jsonRecord, (Schema)schema);
                writer.write((Object)record);
            }
        }
    }
}

