/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.util;

import java.util.function.Predicate;
import org.apache.calcite.sql.parser.SqlParserUtil;

public class ParserUtil {
    public static String replaceEscapedChars(String input) throws MalformedUnicodeEscape {
        int length = input.length();
        if (length <= 1) {
            return input;
        }
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char currentChar = input.charAt(i);
            if (currentChar == '\\' && i + 1 < length) {
                char nextChar = input.charAt(i + 1);
                switch (nextChar) {
                    case 'b': {
                        builder.append('\b');
                        ++i;
                        break;
                    }
                    case 'f': {
                        builder.append('\f');
                        ++i;
                        break;
                    }
                    case 'n': {
                        builder.append('\n');
                        ++i;
                        break;
                    }
                    case 'r': {
                        builder.append('\r');
                        ++i;
                        break;
                    }
                    case 't': {
                        builder.append('\t');
                        ++i;
                        break;
                    }
                    case '$': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '.': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        builder.append(nextChar);
                        ++i;
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        int charsToConsume;
                        int n = charsToConsume = nextChar == 'u' ? 4 : 8;
                        if (i + 1 + charsToConsume >= length) {
                            throw new MalformedUnicodeEscape(i);
                        }
                        int endIdx = ParserUtil.calculateMaxCharsInSequence(input, i + 2, charsToConsume, SqlParserUtil::isHexDigit);
                        if (endIdx != i + 2 + charsToConsume) {
                            throw new MalformedUnicodeEscape(i);
                        }
                        builder.appendCodePoint(Integer.parseInt(input.substring(i + 2, endIdx), 16));
                        i = endIdx - 1;
                        break;
                    }
                    case 'x': {
                        int endIdx = ParserUtil.calculateMaxCharsInSequence(input, i + 2, 2, SqlParserUtil::isHexDigit);
                        if (endIdx > i + 2) {
                            builder.appendCodePoint(Integer.parseInt(input.substring(i + 2, endIdx), 16));
                            i = endIdx - 1;
                            break;
                        }
                        builder.append(nextChar);
                        ++i;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        int endIdx = ParserUtil.calculateMaxCharsInSequence(input, i + 2, 2, SqlParserUtil::isOctalDigit);
                        builder.appendCodePoint(Integer.parseInt(input.substring(i + 1, endIdx), 8));
                        i = endIdx - 1;
                        break;
                    }
                    default: {
                        builder.append(currentChar);
                        break;
                    }
                }
                continue;
            }
            builder.append(currentChar);
        }
        return builder.toString();
    }

    private static int calculateMaxCharsInSequence(CharSequence seq, int beginIndex, int maxCharsToMatch, Predicate<Character> predicate) {
        int idx;
        int end = Math.min(seq.length(), beginIndex + maxCharsToMatch);
        for (idx = beginIndex; idx < end && predicate.test(Character.valueOf(seq.charAt(idx))); ++idx) {
        }
        return idx;
    }

    public static class MalformedUnicodeEscape
    extends Exception {
        public final int i;

        MalformedUnicodeEscape(int i) {
            this.i = i;
        }
    }
}

