/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.type;

import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.impala.analysis.ArithmeticExpr;
import org.apache.impala.analysis.TypesUtil;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaTypeSystemImpl
extends RelDataTypeSystemImpl {
    protected static final Logger LOG = LoggerFactory.getLogger((String)ImpalaTypeSystemImpl.class.getName());
    private static final int MAX_BINARY_PRECISION = Integer.MAX_VALUE;
    private static final int MAX_TIMESTAMP_PRECISION = 15;
    private static final int MAX_TIMESTAMP_WITH_LOCAL_TIME_ZONE_PRECISION = 15;
    private static final int DEFAULT_TINYINT_PRECISION = 3;
    private static final int DEFAULT_SMALLINT_PRECISION = 5;
    private static final int DEFAULT_INTEGER_PRECISION = 10;
    private static final int DEFAULT_BIGINT_PRECISION = 19;
    private static final int DEFAULT_FLOAT_PRECISION = 7;
    private static final int DEFAULT_DOUBLE_PRECISION = 15;
    public static final RelDataTypeFactory TYPE_FACTORY = new JavaTypeFactoryImpl((RelDataTypeSystem)new ImpalaTypeSystemImpl());

    public int getMaxScale(SqlTypeName typeName) {
        switch (typeName) {
            case DECIMAL: {
                return this.getMaxNumericScale();
            }
            case INTERVAL_YEAR: 
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 9;
            }
        }
        return -1;
    }

    public int getDefaultPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case BINARY: 
            case VARBINARY: {
                return -1;
            }
            case CHAR: {
                return -1;
            }
            case VARCHAR: {
                return -1;
            }
            case DECIMAL: {
                return -1;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 2;
            }
        }
        return this.getMaxPrecision(typeName);
    }

    public int getMaxPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case BINARY: 
            case VARBINARY: {
                return Integer.MAX_VALUE;
            }
            case TIME: 
            case TIMESTAMP: {
                return 15;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return 15;
            }
            case CHAR: {
                return 255;
            }
            case VARCHAR: {
                return Integer.MAX_VALUE;
            }
            case DECIMAL: {
                return this.getMaxNumericPrecision();
            }
            case INTERVAL_YEAR: 
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 10;
            }
            case TINYINT: {
                return 3;
            }
            case SMALLINT: {
                return 5;
            }
            case INTEGER: {
                return 10;
            }
            case BIGINT: {
                return 19;
            }
            case FLOAT: {
                return 7;
            }
            case DOUBLE: {
                return 15;
            }
        }
        return -1;
    }

    public int getMaxNumericScale() {
        return 38;
    }

    public int getMaxNumericPrecision() {
        return 38;
    }

    public boolean isSchemaCaseSensitive() {
        return false;
    }

    public RelDataType deriveSumType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        RelDataType rdt = null;
        switch (argumentType.getSqlTypeName()) {
            case DECIMAL: {
                if (argumentType.getPrecision() == 38) {
                    return argumentType;
                }
                rdt = typeFactory.createSqlType(SqlTypeName.DECIMAL, 38, argumentType.getScale());
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                rdt = typeFactory.createSqlType(SqlTypeName.DOUBLE);
                break;
            }
            default: {
                rdt = typeFactory.createSqlType(SqlTypeName.BIGINT);
            }
        }
        return typeFactory.createTypeWithNullability(rdt, true);
    }

    public static RelDataType deriveArithmeticType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2, ArithmeticExpr.Operator op) {
        try {
            Type t1 = ImpalaTypeConverter.createImpalaType(type1);
            Type t2 = ImpalaTypeConverter.createImpalaType(type2);
            if (t1.equals((Object)Type.TIMESTAMP) || t2.equals((Object)Type.TIMESTAMP)) {
                return ImpalaTypeConverter.getRelDataType((Type)Type.TIMESTAMP);
            }
            if (SqlTypeName.INTERVAL_TYPES.contains(type1.getSqlTypeName())) {
                return type1;
            }
            if (SqlTypeName.INTERVAL_TYPES.contains(type2.getSqlTypeName())) {
                return type2;
            }
            Type retType = TypesUtil.getArithmeticResultType((Type)t1, (Type)t2, (ArithmeticExpr.Operator)op, (boolean)true);
            SqlTypeName sqlTypeName = ImpalaTypeConverter.getRelDataType(retType).getSqlTypeName();
            RelDataType preNullableType = sqlTypeName == SqlTypeName.DECIMAL ? typeFactory.createSqlType(sqlTypeName, retType.getPrecision().intValue(), retType.getDecimalDigits().intValue()) : typeFactory.createSqlType(sqlTypeName);
            boolean nullable = type1.isNullable() && type2.isNullable();
            return typeFactory.createTypeWithNullability(preNullableType, nullable);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RelDataType deriveDecimalPlusType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        return ImpalaTypeSystemImpl.deriveArithmeticType(typeFactory, type1, type2, ArithmeticExpr.Operator.ADD);
    }

    public RelDataType deriveDecimalMultiplyType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        return ImpalaTypeSystemImpl.deriveArithmeticType(typeFactory, type1, type2, ArithmeticExpr.Operator.MULTIPLY);
    }

    public RelDataType deriveDecimalDivideType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        return ImpalaTypeSystemImpl.deriveArithmeticType(typeFactory, type1, type2, ArithmeticExpr.Operator.DIVIDE);
    }

    public RelDataType deriveDecimalModType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        return ImpalaTypeSystemImpl.deriveArithmeticType(typeFactory, type1, type2, ArithmeticExpr.Operator.MOD);
    }

    public RelDataType deriveAvgAggType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        try {
            switch (argumentType.getSqlTypeName()) {
                case DECIMAL: {
                    ScalarType t1 = (ScalarType)ImpalaTypeConverter.createImpalaType(argumentType);
                    int digitsBefore = t1.decimalPrecision() - t1.decimalScale();
                    int digitsAfter = t1.decimalScale();
                    int resultScale = Math.max(6, digitsAfter);
                    int resultPrecision = digitsBefore + resultScale;
                    return typeFactory.createSqlType(SqlTypeName.DECIMAL, resultPrecision, resultScale);
                }
                case TIMESTAMP: {
                    return argumentType;
                }
            }
            return typeFactory.createSqlType(SqlTypeName.DOUBLE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

