/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.type;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.implicit.TypeCoercionImpl;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.catalog.Type;

public class ImpalaTypeCoercionImpl
extends TypeCoercionImpl {
    public ImpalaTypeCoercionImpl(RelDataTypeFactory typeFactory, SqlValidator validator) {
        super(typeFactory, validator);
    }

    public RelDataType getWiderTypeFor(List<RelDataType> typeList, boolean stringPromotion) {
        ArrayList<RelDataType> newTypeList = new ArrayList<RelDataType>();
        for (RelDataType type : typeList) {
            if (type.getSqlTypeName().equals((Object)SqlTypeName.CHAR)) {
                newTypeList.add(ImpalaTypeConverter.getRelDataType((Type)Type.STRING));
                continue;
            }
            newTypeList.add(type);
        }
        return ImpalaTypeConverter.getCompatibleType(newTypeList, this.factory);
    }

    public boolean inOperationCoercion(SqlCallBinding binding) {
        if (!(binding.operand(1) instanceof SqlNodeList)) {
            return false;
        }
        SqlCall call = binding.getCall();
        SqlValidatorScope scope = binding.getScope();
        SqlNode leftOperand = call.operand(0);
        RelDataType leftOperandType = this.deriveType(this.validator, scope, leftOperand);
        SqlNodeList inList = (SqlNodeList)call.operand(1);
        ArrayList<RelDataType> rightOperandTypes = new ArrayList<RelDataType>();
        HashSet<RelDataType> uniqueRightOperandTypes = new HashSet<RelDataType>();
        for (SqlNode node : inList) {
            RelDataType derivedType = this.deriveType(this.validator, scope, node);
            rightOperandTypes.add(derivedType);
            uniqueRightOperandTypes.add(derivedType);
        }
        RelDataType commonType = ImpalaTypeConverter.getCompatibleType(uniqueRightOperandTypes, this.factory);
        commonType = ImpalaTypeConverter.getCompatibleType(commonType, leftOperandType, this.factory);
        boolean coerced = this.coerceInOperand(scope, call, 0, leftOperandType, commonType);
        return coerced |= this.coerceInList(scope, inList, uniqueRightOperandTypes, rightOperandTypes, commonType);
    }

    private boolean coerceInOperand(SqlValidatorScope scope, SqlCall call, int index, RelDataType fromType, RelDataType toType) {
        if (!this.needsCasting(fromType, toType)) {
            return false;
        }
        SqlNode castNode = ImpalaTypeCoercionImpl.castTo(call.operand(index), toType);
        call.setOperand(index, castNode);
        this.updateInferredType(castNode, toType);
        return true;
    }

    private boolean coerceInList(SqlValidatorScope scope, SqlNodeList inList, Set<RelDataType> uniqueFromTypes, List<RelDataType> fromTypes, RelDataType toType) {
        boolean coerced = uniqueFromTypes.stream().anyMatch(ft -> this.needsCasting((RelDataType)ft, toType));
        if (coerced) {
            for (int i = 0; i < inList.size(); ++i) {
                if (!this.needsCasting(fromTypes.get(i), toType)) continue;
                SqlNode castNode = ImpalaTypeCoercionImpl.castTo(inList.get(i), toType);
                inList.set(i, castNode);
                this.updateInferredType(castNode, toType);
            }
        }
        return coerced;
    }

    private boolean needsCasting(RelDataType fromType, RelDataType toType) {
        if (fromType.getSqlTypeName().equals((Object)SqlTypeName.NULL)) {
            return false;
        }
        return !toType.getSqlTypeName().equals((Object)fromType.getSqlTypeName());
    }

    private RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlNode node) {
        if (node instanceof SqlCharStringLiteral) {
            return ImpalaTypeConverter.getRelDataType((Type)Type.STRING);
        }
        return validator.deriveType(scope, node);
    }

    private static SqlNode castTo(SqlNode node, RelDataType type) {
        return SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, new SqlNode[]{node, SqlTypeUtil.convertTypeToSpec((RelDataType)type).withNullable(Boolean.valueOf(type.isNullable()))});
    }
}

