/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.type;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

public class ImpalaSqlIntervalQualifier
extends SqlIntervalQualifier {
    public ImpalaSqlIntervalQualifier(TimeUnit startUnit, int startPrecision, TimeUnit endUnit, int fractionalSecondPrecision, SqlParserPos pos) {
        super(startUnit, startPrecision, endUnit, fractionalSecondPrecision, pos);
    }

    public ImpalaSqlIntervalQualifier(TimeUnit startUnit, TimeUnit endUnit, SqlParserPos pos) {
        super(startUnit, endUnit, pos);
    }

    public ImpalaSqlIntervalQualifier(String timeFrameName, SqlParserPos pos) {
        super(timeFrameName, pos);
    }

    public int[] evaluateIntervalLiteral(String value, SqlParserPos pos, RelDataTypeSystem typeSystem) {
        switch (this.timeUnitRange) {
            case MILLISECOND: 
            case MICROSECOND: 
            case NANOSECOND: {
                break;
            }
            default: {
                return super.evaluateIntervalLiteral(value, pos, typeSystem);
            }
        }
        String value0 = value;
        value = value.trim();
        int sign = this.getIntervalSign(value);
        value = ImpalaSqlIntervalQualifier.stripLeadingSign(value);
        if (Util.isNullOrEmpty((String)value)) {
            throw this.invalidValueException(pos, value0);
        }
        return this.evaluateIntervalLiteralAsSubSeconds(typeSystem, sign, value, value0, pos);
    }

    private int[] evaluateIntervalLiteralAsSubSeconds(RelDataTypeSystem typeSystem, int sign, String value, String originalValue, SqlParserPos pos) {
        String intervalPattern = "(\\d+)";
        Matcher m = Pattern.compile(intervalPattern).matcher(value);
        if (m.matches()) {
            BigDecimal subseconds;
            try {
                subseconds = ImpalaSqlIntervalQualifier.parseField(m, 1);
            }
            catch (NumberFormatException e) {
                throw this.invalidValueException(pos, originalValue);
            }
            return ImpalaSqlIntervalQualifier.fillIntervalValueArray(sign, subseconds);
        }
        throw this.invalidValueException(pos, originalValue);
    }

    private static String stripLeadingSign(String value) {
        String unsignedValue = value;
        if (!(Util.isNullOrEmpty((String)value) || '-' != value.charAt(0) && '+' != value.charAt(0))) {
            unsignedValue = value.substring(1);
        }
        return unsignedValue;
    }

    private static BigDecimal parseField(Matcher m, int i) {
        return new BigDecimal((String)Nullness.castNonNull((Object)m.group(i)));
    }

    private CalciteContextException invalidValueException(SqlParserPos pos, String value) {
        return SqlUtil.newContextException((SqlParserPos)pos, (Resources.ExInst)Static.RESOURCE.unsupportedIntervalLiteral("'" + value + "'", "INTERVAL " + this.toString()));
    }

    private static int[] fillIntervalValueArray(int sign, BigDecimal subseconds) {
        int[] ret = new int[]{sign, subseconds.intValue(), 0};
        return ret;
    }
}

