/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.service;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlQualified;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.calcite.schema.CalciteTable;
import org.apache.impala.calcite.schema.ImpalaViewTable;
import org.apache.impala.catalog.BuiltinsDb;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaSqlValidatorImpl
extends SqlValidatorImpl {
    private Analyzer analyzer_;
    protected static final Logger LOG = LoggerFactory.getLogger((String)ImpalaSqlValidatorImpl.class.getName());

    public ImpalaSqlValidatorImpl(SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory, SqlValidator.Config config, Analyzer analyzer) {
        super(opTab, catalogReader, typeFactory, config);
        this.analyzer_ = analyzer;
    }

    public void validateIdentifier(SqlIdentifier id, SqlValidatorScope scope) {
        super.validateIdentifier(id, scope);
        SqlQualified fqId = scope.fullyQualify(id);
        SqlIdentifier prefix = id.getComponent(0, 1);
        SqlNameMatcher nameMatcher = this.getCatalogReader().nameMatcher();
        SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
        scope.resolve((List)prefix.names, nameMatcher, false, (SqlValidatorScope.Resolved)resolved);
        if (resolved.count() == 1) {
            SqlValidatorScope.Resolve resolve = resolved.only();
            SqlValidatorNamespace fromNs = resolve.namespace;
            SqlValidatorTable validatorTable = fromNs.getTable();
            if (validatorTable instanceof CalciteTable) {
                FeFsTable feFsTable = ((CalciteTable)validatorTable).getFeFsTable();
                this.analyzer_.registerPrivReq(builder -> builder.allOf(Privilege.SELECT).onColumn(feFsTable.getDb().getName(), feFsTable.getTableName().getTbl(), (String)fqId.identifier.names.get(1), feFsTable.getOwnerUser()).build());
                return;
            }
            if (validatorTable instanceof RelOptTableImpl) {
                Preconditions.checkState((boolean)(validatorTable.table() instanceof ImpalaViewTable));
                FeView view = ((ImpalaViewTable)validatorTable.table()).getFeView();
                this.analyzer_.registerPrivReq(builder -> builder.allOf(Privilege.SELECT).onColumn(view.getDb().getName(), view.getTableName().getTbl(), (String)fqId.identifier.names.get(1), view.getOwnerUser()).build());
            }
        }
    }

    public void validateCall(SqlCall call, SqlValidatorScope scope) {
        super.validateCall(call, scope);
        SqlOperator operator = call.getOperator();
        if (operator instanceof SqlFunction) {
            this.analyzer_.registerPrivReq(builder -> builder.allOf(Privilege.VIEW_METADATA).onDb(BuiltinsDb.getInstance().getName(), null).build());
        }
    }
}

