/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.service;

import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.ParsedStatement;
import org.apache.impala.calcite.rel.node.ImpalaPlanRel;
import org.apache.impala.calcite.rel.node.NodeWithExprs;
import org.apache.impala.calcite.service.CalciteAnalysisResult;
import org.apache.impala.calcite.service.CalciteOptimizer;
import org.apache.impala.calcite.service.CalcitePhysPlanCreator;
import org.apache.impala.calcite.service.CalciteRelNodeConverter;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.DataSink;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanRootSink;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.planner.SingleNodePlannerIntf;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TResultSetMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteSingleNodePlanner
implements SingleNodePlannerIntf {
    protected static final Logger LOG = LoggerFactory.getLogger((String)CalciteSingleNodePlanner.class.getName());
    private final PlannerContext ctx_;
    private final CalciteAnalysisResult analysisResult_;
    private NodeWithExprs rootNode_;

    public CalciteSingleNodePlanner(PlannerContext ctx) {
        this.ctx_ = ctx;
        this.analysisResult_ = (CalciteAnalysisResult)ctx.getAnalysisResult();
    }

    public PlanNode createSingleNodePlan() throws ImpalaException {
        CalciteRelNodeConverter relNodeConverter = new CalciteRelNodeConverter(this.analysisResult_);
        RelNode logicalPlan = relNodeConverter.convert(this.analysisResult_.getValidatedNode());
        CalciteOptimizer optimizer = new CalciteOptimizer(this.analysisResult_, this.ctx_.getTimeline());
        ImpalaPlanRel optimizedPlan = optimizer.optimize(logicalPlan);
        CalcitePhysPlanCreator physPlanCreator = new CalcitePhysPlanCreator(this.analysisResult_.getAnalyzer(), this.ctx_);
        this.rootNode_ = physPlanCreator.create(optimizedPlan);
        this.analysisResult_.getAnalyzer().computeValueTransferGraph();
        return this.rootNode_.planNode_;
    }

    public DataSink createDataSink(ExprSubstitutionMap rootNodeSmap) {
        return new PlanRootSink(this.rootNode_.outputExprs_);
    }

    public List<String> getColLabels() {
        return this.rootNode_.fieldNames_;
    }

    public TResultSetMetadata getTResultSetMetadata(ParsedStatement parsedStmt) {
        TResultSetMetadata metadata = new TResultSetMetadata();
        int colCnt = this.rootNode_.outputExprs_.size();
        for (int i = 0; i < colCnt; ++i) {
            TColumn colDesc = new TColumn(this.rootNode_.fieldNames_.get(i).toLowerCase(), this.rootNode_.outputExprs_.get(i).getType().toThrift());
            metadata.addToColumns(colDesc);
        }
        return metadata;
    }
}

