/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.service;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.PlannerImpl;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;
import org.apache.impala.calcite.operators.ImpalaConvertletTable;
import org.apache.impala.calcite.operators.ImpalaRexBuilder;
import org.apache.impala.calcite.schema.ImpalaRelMetadataProvider;
import org.apache.impala.calcite.service.CalciteAnalysisResult;
import org.apache.impala.calcite.service.CalciteValidator;
import org.apache.impala.calcite.service.CompilerStep;
import org.apache.impala.calcite.util.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteRelNodeConverter
implements CompilerStep {
    protected static final Logger LOG = LoggerFactory.getLogger((String)CalciteRelNodeConverter.class.getName());
    private final RelOptTable.ViewExpander viewExpander_;
    private final RelOptCluster cluster_;
    private final RelOptPlanner planner_;
    private final RelDataTypeFactory typeFactory_;
    private final SqlValidator sqlValidator_;
    private final CalciteCatalogReader reader_;

    public CalciteRelNodeConverter(CalciteAnalysisResult analysisResult) {
        this.typeFactory_ = analysisResult.getTypeFactory();
        this.reader_ = analysisResult.getCatalogReader();
        this.sqlValidator_ = analysisResult.getSqlValidator();
        this.planner_ = new VolcanoPlanner();
        this.planner_.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        this.cluster_ = RelOptCluster.create((RelOptPlanner)this.planner_, (RexBuilder)new ImpalaRexBuilder(this.typeFactory_));
        this.viewExpander_ = CalciteRelNodeConverter.createViewExpander(analysisResult.getSqlValidator().getCatalogReader().getRootSchema().plus());
        this.cluster_.setMetadataProvider((RelMetadataProvider)ImpalaRelMetadataProvider.DEFAULT);
    }

    public CalciteRelNodeConverter(CalciteValidator validator) {
        this.typeFactory_ = validator.getTypeFactory();
        this.reader_ = validator.getCatalogReader();
        this.sqlValidator_ = validator.getSqlValidator();
        this.planner_ = new VolcanoPlanner();
        this.planner_.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        this.cluster_ = RelOptCluster.create((RelOptPlanner)this.planner_, (RexBuilder)new ImpalaRexBuilder(this.typeFactory_));
        this.viewExpander_ = CalciteRelNodeConverter.createViewExpander(validator.getCatalogReader().getRootSchema().plus());
        this.cluster_.setMetadataProvider((RelMetadataProvider)ImpalaRelMetadataProvider.DEFAULT);
    }

    private static RelOptTable.ViewExpander createViewExpander(SchemaPlus schemaPlus) {
        SqlParser.Config parserConfig = SqlParser.configBuilder().setCaseSensitive(false).build().withQuoting(Quoting.BACK_TICK);
        FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(schemaPlus).parserConfig(parserConfig).traitDefs(new RelTraitDef[]{ConventionTraitDef.INSTANCE}).build();
        return new PlannerImpl(config);
    }

    public RelNode convert(SqlNode validatedNode) {
        SqlToRelConverter relConverter = new SqlToRelConverter(this.viewExpander_, this.sqlValidator_, (Prepare.CatalogReader)this.reader_, this.cluster_, (SqlRexConvertletTable)ImpalaConvertletTable.INSTANCE, SqlToRelConverter.config().withCreateValuesRel(false));
        RelRoot root = relConverter.convertQuery(validatedNode, false, true);
        RelNode relNode = root.project();
        LogUtil.logDebug(relNode, "Plan after conversion from Abstract Syntax Tree");
        RelNode subQueryRemovedPlan = this.runProgram((List<RelOptRule>)ImmutableList.of((Object)CoreRules.JOIN_SUB_QUERY_TO_CORRELATE, (Object)CoreRules.PROJECT_SUB_QUERY_TO_CORRELATE, (Object)CoreRules.FILTER_SUB_QUERY_TO_CORRELATE), relNode);
        LogUtil.logDebug(subQueryRemovedPlan, "Plan after subquery removal phase");
        RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(this.cluster_, (RelOptSchema)this.reader_);
        RelNode decorrelatedPlan = RelDecorrelator.decorrelateQuery((RelNode)subQueryRemovedPlan, (RelBuilder)relBuilder);
        LogUtil.logDebug(decorrelatedPlan, "Plan after subquery decorrelation phase");
        return decorrelatedPlan;
    }

    public RelOptCluster getCluster() {
        return this.cluster_;
    }

    @Override
    public void logDebug(Object resultObject) {
        LogUtil.logDebug(resultObject, "RelNodeConverter plan");
    }

    private RelNode runProgram(List<RelOptRule> rules, RelNode currentNode) {
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addRuleCollection(rules);
        builder.addMatchOrder(HepMatchOrder.BOTTOM_UP);
        HepPlanner planner = new HepPlanner(builder.build(), currentNode.getCluster().getPlanner().getContext(), false, null, RelOptCostImpl.FACTORY);
        planner.setRoot(currentNode);
        return planner.findBestExp();
    }
}

