/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.service;

import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.impala.calcite.parser.ImpalaSqlParserImpl;
import org.apache.impala.calcite.service.CalciteJniFrontend;
import org.apache.impala.calcite.service.CompilerStep;
import org.apache.impala.calcite.validate.ImpalaConformance;
import org.apache.impala.common.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteQueryParser
implements CompilerStep {
    protected static final Logger LOG = LoggerFactory.getLogger((String)CalciteQueryParser.class.getName());
    private final String sqlStmt_;

    public CalciteQueryParser(CalciteJniFrontend.QueryContext queryCtx) {
        this.sqlStmt_ = queryCtx.getStmt();
    }

    public CalciteQueryParser(String stmt) {
        this.sqlStmt_ = stmt;
    }

    public SqlNode parse() throws ParseException {
        try {
            SqlParser parser = SqlParser.create((String)this.sqlStmt_, (SqlParser.Config)SqlParser.config().withParserFactory(ImpalaSqlParserImpl.FACTORY).withConformance(ImpalaConformance.INSTANCE).withQuoting(Quoting.BACK_TICK_BACKSLASH));
            SqlNode sqlNode = parser.parseQuery();
            return sqlNode;
        }
        catch (SqlParseException e) {
            throw new ParseException(e.getMessage());
        }
    }

    @Override
    public void logDebug(Object resultObject) {
        if (!(resultObject instanceof SqlNode)) {
            LOG.debug("Parser produced an unknown output: " + resultObject);
            return;
        }
        LOG.debug("Parsed node: " + resultObject);
    }
}

