/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.service;

import java.util.Set;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.analysis.ParsedStatement;
import org.apache.impala.analysis.StmtMetadataLoader;
import org.apache.impala.analysis.TableName;
import org.apache.impala.calcite.service.CalciteMetadataHandler;
import org.apache.impala.calcite.service.CalciteQueryParser;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.thrift.TQueryCtx;

public class CalciteParsedStatement
implements ParsedStatement {
    private final SqlNode parsedNode_;
    private final boolean isExplain_;
    private final String sql_;
    private final Set<TableName> tableNames_;

    public CalciteParsedStatement(TQueryCtx queryCtx) throws ImpalaException {
        this.sql_ = queryCtx.client_request.stmt;
        CalciteQueryParser queryParser = new CalciteQueryParser(this.sql_);
        SqlNode parsedSqlNode = queryParser.parse();
        this.isExplain_ = parsedSqlNode instanceof SqlExplain;
        if (this.isExplain_) {
            parsedSqlNode = ((SqlExplain)parsedSqlNode).getExplicandum();
        }
        this.parsedNode_ = parsedSqlNode;
        CalciteMetadataHandler.TableVisitor tableVisitor = new CalciteMetadataHandler.TableVisitor(queryCtx.session.database);
        this.parsedNode_.accept((SqlVisitor)tableVisitor);
        this.tableNames_ = tableVisitor.tableNames_;
    }

    public Set<TableName> getTablesInQuery(StmtMetadataLoader loader) {
        return this.tableNames_;
    }

    public Object getTopLevelNode() {
        return this.parsedNode_;
    }

    public boolean isExplain() {
        return this.isExplain_;
    }

    public boolean isQueryStmt() {
        return true;
    }

    public String toSql() {
        return this.sql_;
    }

    public void handleAuthorizationException(AnalysisContext.AnalysisResult analysisResult) {
    }

    public SqlNode getParsedSqlNode() {
        return SqlNode.clone((SqlNode)this.parsedNode_);
    }
}

