/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.service;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.JoinProjectTransposeRule;
import org.apache.calcite.rel.rules.PruneEmptyRules;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.RelFieldTrimmer;
import org.apache.calcite.tools.RelBuilder;
import org.apache.impala.calcite.coercenodes.CoerceNodes;
import org.apache.impala.calcite.rel.node.ConvertToImpalaRelRules;
import org.apache.impala.calcite.rel.node.ImpalaPlanRel;
import org.apache.impala.calcite.rules.CombineValuesNodesRule;
import org.apache.impala.calcite.rules.ExtractLiteralAgg;
import org.apache.impala.calcite.rules.ImpalaJoinProjectTransposeRule;
import org.apache.impala.calcite.rules.ImpalaMinusToDistinctRule;
import org.apache.impala.calcite.rules.RewriteRexOverRule;
import org.apache.impala.calcite.service.CalciteAnalysisResult;
import org.apache.impala.calcite.service.CalciteValidator;
import org.apache.impala.calcite.service.CompilerStep;
import org.apache.impala.calcite.util.LogUtil;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.util.EventSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteOptimizer
implements CompilerStep {
    protected static final Logger LOG = LoggerFactory.getLogger((String)CalciteOptimizer.class.getName());
    private final CalciteCatalogReader reader_;
    private final SqlValidator validator_;
    private final EventSequence timeline_;
    JoinProjectTransposeRule.Config JOIN_PROJECT_LEFT = (JoinProjectTransposeRule.Config)JoinProjectTransposeRule.Config.LEFT_OUTER.withOperandSupplier(b0 -> b0.operand(LogicalJoin.class).inputs(new RelRule.OperandTransform[]{b1 -> b1.operand(LogicalProject.class).inputs(new RelRule.OperandTransform[]{b2 -> b2.operand(LogicalJoin.class).anyInputs()})})).withDescription("JoinProjectTransposeRule(Project-Other)").as(JoinProjectTransposeRule.Config.class);
    JoinProjectTransposeRule.Config JOIN_PROJECT_RIGHT = (JoinProjectTransposeRule.Config)JoinProjectTransposeRule.Config.RIGHT_OUTER.withOperandSupplier(b0 -> b0.operand(LogicalJoin.class).inputs(new RelRule.OperandTransform[]{b1 -> b1.operand(RelNode.class).anyInputs(), b2 -> b2.operand(LogicalProject.class).inputs(new RelRule.OperandTransform[]{b3 -> b3.operand(LogicalJoin.class).anyInputs()})})).withDescription("JoinProjectTransposeRule(Other-Project)").as(JoinProjectTransposeRule.Config.class);

    public CalciteOptimizer(CalciteAnalysisResult analysisResult, EventSequence timeline) {
        this.reader_ = analysisResult.getCatalogReader();
        this.validator_ = analysisResult.getSqlValidator();
        this.timeline_ = timeline;
    }

    public CalciteOptimizer(CalciteValidator validator, EventSequence timeline) {
        this.reader_ = validator.getCatalogReader();
        this.validator_ = validator.getSqlValidator();
        this.timeline_ = timeline;
    }

    public ImpalaPlanRel optimize(RelNode logPlan) throws ImpalaException {
        RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(logPlan.getCluster(), (RelOptSchema)this.reader_);
        RexBuilder rexBuilder = logPlan.getCluster().getRexBuilder();
        this.timeline_.markEvent("Starting optimization");
        RelNode expandedNodesPlan = this.runExpandNodesProgram(logPlan);
        this.timeline_.markEvent("Expanded plan");
        LogUtil.logDebug(expandedNodesPlan, "Plan after expanded plan phase.");
        RelNode coercedNodesPlan = CoerceNodes.coerceNodes(expandedNodesPlan, rexBuilder);
        this.timeline_.markEvent("Coerced plan");
        LogUtil.logDebug(coercedNodesPlan, "Plan after it has been coerced.");
        RelNode preJoinOptimizedPlan = this.runOptimizeNodesProgram(relBuilder, coercedNodesPlan);
        this.timeline_.markEvent("Created optimized plan pre join");
        LogUtil.logDebug(preJoinOptimizedPlan, "Optimized plan before join rules have been applied.");
        RelNode optimizedJoinPlan = this.runJoinProgram(preJoinOptimizedPlan);
        this.timeline_.markEvent("Created optimized join plan");
        LogUtil.logDebug(optimizedJoinPlan, "Optimized plan after join optimization.");
        RelNode postOptimizedJoinPlan = this.runOptimizeNodesProgram(relBuilder, optimizedJoinPlan);
        this.timeline_.markEvent("Created optimized plan post join");
        LogUtil.logDebug(postOptimizedJoinPlan, "Optimized plan after a second pass of rules applied after join optimization.");
        RelNode preImpalaConvertPlan = this.runPreImpalaConvertProgram(postOptimizedJoinPlan);
        LogUtil.logDebug(preImpalaConvertPlan, "Optimized plan after final preparation done before conversion to physical nodes.");
        ImpalaPlanRel finalOptimizedPlan = this.runImpalaConvertProgram(preImpalaConvertPlan);
        this.timeline_.markEvent("Created final Impala convert plan");
        LogUtil.logDebug(finalOptimizedPlan, "Final Impala optimized plan");
        return finalOptimizedPlan;
    }

    private RelNode runExpandNodesProgram(RelNode plan) throws ImpalaException {
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addMatchOrder(HepMatchOrder.BOTTOM_UP);
        builder.addRuleCollection((Collection)ImmutableList.of((Object)CoreRules.INTERSECT_TO_DISTINCT, (Object)CoreRules.UNION_TO_DISTINCT, (Object)((Object)ImpalaMinusToDistinctRule.Config.DEFAULT.toRule()), (Object)((Object)new CombineValuesNodesRule()), (Object)((Object)new ExtractLiteralAgg()), (Object)CoreRules.SORT_REMOVE_CONSTANT_KEYS));
        builder.addMatchOrder(HepMatchOrder.BOTTOM_UP);
        return this.runProgram(plan, builder.build());
    }

    private RelNode runOptimizeNodesProgram(RelBuilder relBuilder, RelNode plan) throws ImpalaException {
        RelFieldTrimmer trimmer = new RelFieldTrimmer(this.validator_, relBuilder);
        RelNode trimmedPlan = trimmer.trim(plan);
        HepProgramBuilder builder = new HepProgramBuilder();
        ImmutableList interRules = ImmutableList.of((Object)CoreRules.UNION_PULL_UP_CONSTANTS, (Object)CoreRules.AGGREGATE_ANY_PULL_UP_CONSTANTS, (Object)CoreRules.FILTER_PROJECT_TRANSPOSE, (Object)CoreRules.FILTER_SET_OP_TRANSPOSE, (Object)CoreRules.JOIN_CONDITION_PUSH, (Object)CoreRules.FILTER_INTO_JOIN, (Object)CoreRules.FILTER_AGGREGATE_TRANSPOSE, (Object)CoreRules.PROJECT_JOIN_TRANSPOSE, (Object)CoreRules.UNION_REMOVE, (Object)CoreRules.PROJECT_TO_SEMI_JOIN, (Object)CoreRules.FILTER_VALUES_MERGE, (Object)CoreRules.FILTER_MERGE, (Object[])new RelOptRule[]{CoreRules.PROJECT_MERGE, PruneEmptyRules.PROJECT_INSTANCE, PruneEmptyRules.AGGREGATE_INSTANCE, PruneEmptyRules.SORT_INSTANCE, PruneEmptyRules.FILTER_INSTANCE, PruneEmptyRules.UNION_INSTANCE, PruneEmptyRules.JOIN_LEFT_INSTANCE, PruneEmptyRules.JOIN_RIGHT_INSTANCE});
        builder.addMatchOrder(HepMatchOrder.TOP_DOWN);
        builder.addRuleCollection((Collection)interRules);
        return trimmer.trim(this.runProgram(plan, builder.build()));
    }

    private RelNode runJoinProgram(RelNode plan) throws ImpalaException {
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addRuleInstance((RelOptRule)CoreRules.JOIN_PUSH_TRANSITIVE_PREDICATES);
        builder.addRuleCollection((Collection)ImmutableList.of((Object)((Object)ImpalaJoinProjectTransposeRule.LEFT_OUTER), (Object)((Object)ImpalaJoinProjectTransposeRule.RIGHT_OUTER), (Object)CoreRules.FILTER_PROJECT_TRANSPOSE, (Object)CoreRules.PROJECT_MERGE, (Object)CoreRules.FILTER_INTO_JOIN));
        builder.addMatchOrder(HepMatchOrder.BOTTOM_UP);
        builder.addRuleInstance((RelOptRule)CoreRules.JOIN_CONDITION_PUSH);
        builder.addRuleInstance((RelOptRule)CoreRules.JOIN_TO_MULTI_JOIN);
        builder.addRuleInstance((RelOptRule)CoreRules.MULTI_JOIN_OPTIMIZE);
        return this.runProgram(plan, builder.build());
    }

    private RelNode runPreImpalaConvertProgram(RelNode plan) throws ImpalaException {
        HepProgramBuilder builder = new HepProgramBuilder();
        RelNode retRelNode = plan;
        builder.addMatchOrder(HepMatchOrder.BOTTOM_UP);
        builder.addRuleCollection((Collection)ImmutableList.of((Object)((Object)RewriteRexOverRule.INSTANCE), (Object)CoreRules.FILTER_PROJECT_TRANSPOSE));
        return this.runProgram(retRelNode, builder.build());
    }

    private ImpalaPlanRel runImpalaConvertProgram(RelNode plan) throws ImpalaException {
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addRuleCollection((Collection)ImmutableList.of((Object)((Object)new ConvertToImpalaRelRules.ImpalaScanRule()), (Object)((Object)new ConvertToImpalaRelRules.ImpalaSortRule()), (Object)((Object)new ConvertToImpalaRelRules.ImpalaProjectRule()), (Object)((Object)new ConvertToImpalaRelRules.ImpalaAggRule()), (Object)((Object)new ConvertToImpalaRelRules.ImpalaJoinRule()), (Object)((Object)new ConvertToImpalaRelRules.ImpalaFilterRule()), (Object)((Object)new ConvertToImpalaRelRules.ImpalaUnionRule()), (Object)((Object)new ConvertToImpalaRelRules.ImpalaValuesRule())));
        return (ImpalaPlanRel)this.runProgram(plan, builder.build());
    }

    private RelNode runProgram(RelNode currentNode, HepProgram program) {
        HepPlanner planner = new HepPlanner(program, currentNode.getCluster().getPlanner().getContext(), true, null, RelOptCostImpl.FACTORY);
        planner.setRoot(currentNode);
        return planner.findBestExp();
    }

    public String getDebugString(Object optimizedPlan, String planString) {
        return RelOptUtil.dumpPlan((String)("[" + planString + "]"), (RelNode)((RelNode)optimizedPlan), (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.NON_COST_ATTRIBUTES);
    }

    @Override
    public void logDebug(Object resultObject) {
        LogUtil.logDebug(resultObject, "Optimized Plan");
    }
}

