/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.service;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StmtMetadataLoader;
import org.apache.impala.analysis.TableName;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.NoopAuthorizationFactory;
import org.apache.impala.calcite.schema.CalciteDb;
import org.apache.impala.calcite.schema.ImpalaCalciteCatalogReader;
import org.apache.impala.calcite.service.CalciteJniFrontend;
import org.apache.impala.calcite.service.CompilerStep;
import org.apache.impala.calcite.type.ImpalaTypeSystemImpl;
import org.apache.impala.calcite.util.SimplifiedAnalyzer;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.UnsupportedFeatureException;
import org.apache.impala.thrift.TQueryCtx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteMetadataHandler
implements CompilerStep {
    protected static final Logger LOG = LoggerFactory.getLogger((String)CalciteMetadataHandler.class.getName());
    private final StmtMetadataLoader.StmtTableCache stmtTableCache_;
    private final CalciteCatalogReader reader_;
    private final Analyzer analyzer_;

    public CalciteMetadataHandler(SqlNode parsedNode, CalciteJniFrontend.QueryContext queryCtx) throws ImpalaException {
        StmtMetadataLoader stmtMetadataLoader = new StmtMetadataLoader(queryCtx.getFrontend(), queryCtx.getCurrentDb(), queryCtx.getTimeline());
        TableVisitor tableVisitor = new TableVisitor(queryCtx.getCurrentDb());
        parsedNode.accept((SqlVisitor)tableVisitor);
        this.stmtTableCache_ = stmtMetadataLoader.loadTables(tableVisitor.tableNames_);
        this.reader_ = CalciteMetadataHandler.createCalciteCatalogReader(this.stmtTableCache_, queryCtx.getTQueryCtx(), queryCtx.getCurrentDb());
        this.analyzer_ = this.createAnalyzer(this.stmtTableCache_, queryCtx);
        List<String> errorTables = CalciteMetadataHandler.populateCalciteSchema(this.reader_, queryCtx.getFrontend().getCatalog(), this.stmtTableCache_, this.analyzer_);
        tableVisitor.checkForComplexTable(this.stmtTableCache_, errorTables, queryCtx);
    }

    public static CalciteCatalogReader createCalciteCatalogReader(StmtMetadataLoader.StmtTableCache stmtTableCache, TQueryCtx queryCtx, String database) {
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl((RelDataTypeSystem)new ImpalaTypeSystemImpl());
        Properties props = new Properties();
        props.setProperty(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), "false");
        CalciteConnectionConfigImpl config = new CalciteConnectionConfigImpl(props);
        CalciteSchema rootSchema = CalciteSchema.createRootSchema((boolean)true);
        return new ImpalaCalciteCatalogReader(rootSchema, Collections.singletonList(database), (RelDataTypeFactory)typeFactory, (CalciteConnectionConfig)config, queryCtx, stmtTableCache);
    }

    public static List<String> populateCalciteSchema(CalciteCatalogReader reader, FeCatalog catalog, StmtMetadataLoader.StmtTableCache stmtTableCache, Analyzer analyzer) throws ImpalaException {
        ArrayList<String> notFoundTables = new ArrayList<String>();
        CalciteSchema rootSchema = reader.getRootSchema();
        HashMap<String, CalciteDb.Builder> dbSchemas = new HashMap<String, CalciteDb.Builder>();
        for (TableName tableName : stmtTableCache.tables.keySet()) {
            FeDb db = catalog.getDb(tableName.getDb());
            if (db == null) {
                notFoundTables.add(tableName.toString());
                continue;
            }
            FeTable feTable = db.getTable(tableName.getTbl());
            if (feTable == null) {
                notFoundTables.add(tableName.toString());
                continue;
            }
            CalciteDb.Builder dbBuilder = dbSchemas.getOrDefault(tableName.getDb(), new CalciteDb.Builder(reader));
            dbBuilder.addTable(tableName.getTbl().toLowerCase(), feTable, analyzer);
            dbSchemas.put(tableName.getDb().toLowerCase(), dbBuilder);
        }
        for (String dbName : dbSchemas.keySet()) {
            rootSchema.add(dbName, (Schema)((CalciteDb.Builder)dbSchemas.get(dbName.toLowerCase())).build());
        }
        return notFoundTables;
    }

    public StmtMetadataLoader.StmtTableCache getStmtTableCache() {
        return this.stmtTableCache_;
    }

    public CalciteCatalogReader getCalciteCatalogReader() {
        return this.reader_;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer_;
    }

    private Analyzer createAnalyzer(StmtMetadataLoader.StmtTableCache stmtTableCache, CalciteJniFrontend.QueryContext queryCtx) throws ImpalaException {
        return new SimplifiedAnalyzer(stmtTableCache, queryCtx.getTQueryCtx(), (AuthorizationFactory)new NoopAuthorizationFactory(), null);
    }

    public static boolean anyTableContainsColumn(StmtMetadataLoader.StmtTableCache stmtTableCache, String columnName) {
        String onlyColumnPart = columnName.split("\\.")[0];
        for (FeTable table : stmtTableCache.tables.values()) {
            if (table.getColumn(onlyColumnPart) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void logDebug(Object resultObject) {
        LOG.debug("Loaded tables: " + this.stmtTableCache_.tables.values().stream().map(feTable -> feTable.getName().toString()).collect(Collectors.joining(", ")));
    }

    public static class TableVisitor
    extends SqlBasicVisitor<Void> {
        private final String currentDb_;
        public final Set<TableName> tableNames_ = new HashSet<TableName>();
        public final List<String> errorTables_ = new ArrayList<String>();
        public final Stack<Set<TableName>> withItemTableNames_ = new Stack();

        public TableVisitor(String currentDb) {
            this.currentDb_ = currentDb.toLowerCase();
        }

        public Void visit(SqlCall call) {
            SqlSelect select;
            if (call instanceof SqlWith) {
                this.withItemTableNames_.push(new HashSet());
            }
            if (call.getKind() == SqlKind.SELECT && (select = (SqlSelect)call).getFrom() != null) {
                this.tableNames_.addAll(this.getTableNames(select.getFrom()));
            }
            if (call.getKind() == SqlKind.WITH_ITEM) {
                TableName tableName = new TableName(this.currentDb_.toLowerCase(), ((String)((SqlWithItem)call).name.names.get(0)).toLowerCase());
                this.withItemTableNames_.peek().add(tableName);
            }
            Void v = (Void)super.visit(call);
            if (call instanceof SqlWith) {
                this.withItemTableNames_.pop();
            }
            return v;
        }

        private List<TableName> getTableNames(SqlNode fromNode) {
            SqlBasicCall basicCall;
            ArrayList<TableName> localTableNames = new ArrayList<TableName>();
            if (fromNode instanceof SqlIdentifier) {
                String tableName = fromNode.toString();
                List parts = Splitter.on((char)'.').splitToList((CharSequence)tableName);
                if (parts.size() == 1) {
                    TableName tableNameToAdd = new TableName(this.currentDb_.toLowerCase(), ((String)parts.get(0)).toLowerCase());
                    if (!this.isRegisteredBySqlWithItem(tableNameToAdd)) {
                        localTableNames.add(tableNameToAdd);
                    }
                } else if (parts.size() == 2) {
                    localTableNames.add(new TableName(((String)parts.get(0)).toLowerCase(), ((String)parts.get(1)).toLowerCase()));
                } else {
                    this.errorTables_.add(tableName);
                    return localTableNames;
                }
            }
            if (fromNode instanceof SqlJoin) {
                localTableNames.addAll(this.getTableNames(((SqlJoin)fromNode).getLeft()));
                localTableNames.addAll(this.getTableNames(((SqlJoin)fromNode).getRight()));
            }
            if (fromNode instanceof SqlBasicCall && (basicCall = (SqlBasicCall)fromNode).getKind().equals((Object)SqlKind.AS)) {
                localTableNames.addAll(this.getTableNames(basicCall.operand(0)));
            }
            return localTableNames;
        }

        private boolean isRegisteredBySqlWithItem(TableName tableName) {
            for (Set set : this.withItemTableNames_) {
                if (!set.contains(tableName)) continue;
                return true;
            }
            return false;
        }

        public void checkForComplexTable(StmtMetadataLoader.StmtTableCache stmtTableCache, List<String> errorTables, CalciteJniFrontend.QueryContext queryCtx) throws ImpalaException {
            ArrayList<String> allErrorTables = new ArrayList<String>();
            allErrorTables.addAll(this.errorTables_);
            allErrorTables.addAll(errorTables);
            for (String errorTable : allErrorTables) {
                List parts = Splitter.on((char)'.').splitToList((CharSequence)errorTable);
                if (parts.size() > 2) {
                    throw new UnsupportedFeatureException("Complex column " + errorTable + " not supported.");
                }
                if (parts.size() != 2) continue;
                if (CalciteMetadataHandler.anyTableContainsColumn(stmtTableCache, (String)parts.get(1))) {
                    throw new UnsupportedFeatureException("Complex column " + errorTable + " not supported.");
                }
                TableName potentialComplexTable = new TableName(this.currentDb_.toLowerCase(), ((String)parts.get(0)).toLowerCase());
                StmtMetadataLoader errorLoader = new StmtMetadataLoader(queryCtx.getFrontend(), queryCtx.getCurrentDb(), queryCtx.getTimeline());
                StmtMetadataLoader.StmtTableCache errorCache = errorLoader.loadTables((Set)Sets.newHashSet((Object[])new TableName[]{potentialComplexTable}));
                if (!CalciteMetadataHandler.anyTableContainsColumn(errorCache, (String)parts.get(1))) continue;
                throw new UnsupportedFeatureException("Complex column " + errorTable + " not supported.");
            }
        }
    }
}

