/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.service;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlNode;
import org.apache.impala.analysis.Parser;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.StmtMetadataLoader;
import org.apache.impala.calcite.operators.ImpalaOperatorTable;
import org.apache.impala.calcite.rel.node.ImpalaPlanRel;
import org.apache.impala.calcite.rel.node.NodeWithExprs;
import org.apache.impala.calcite.service.CalciteCompilerFactory;
import org.apache.impala.calcite.service.CalciteMetadataHandler;
import org.apache.impala.calcite.service.CalciteOptimizer;
import org.apache.impala.calcite.service.CalcitePhysPlanCreator;
import org.apache.impala.calcite.service.CalciteQueryParser;
import org.apache.impala.calcite.service.CalciteRelNodeConverter;
import org.apache.impala.calcite.service.CalciteValidator;
import org.apache.impala.calcite.service.CompilerStep;
import org.apache.impala.calcite.service.ExecRequestCreator;
import org.apache.impala.catalog.BuiltinsDb;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.JniUtil;
import org.apache.impala.common.ParseException;
import org.apache.impala.common.UnsupportedFeatureException;
import org.apache.impala.service.Frontend;
import org.apache.impala.service.FrontendProfile;
import org.apache.impala.service.JniFrontend;
import org.apache.impala.thrift.TClientRequest;
import org.apache.impala.thrift.TExecRequest;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.util.EventSequence;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteJniFrontend
extends JniFrontend {
    protected static final Logger LOG = LoggerFactory.getLogger((String)CalciteJniFrontend.class.getName());
    private static Pattern LEFT_SEMI = Pattern.compile(".*\\bleft\\ssemi\\b.*", 2);
    private static Pattern RIGHT_SEMI = Pattern.compile(".*\\bright\\ssemi\\b.*", 2);
    private static Pattern LEFT_ANTI = Pattern.compile(".*\\bleft\\santi\\b.*", 2);
    private static Pattern RIGHT_ANTI = Pattern.compile(".*\\bright\\santi\\b.*", 2);
    private static Pattern INPUT_FILE_NAME = Pattern.compile(".*\\binput__file__name\\b.*", 2);
    private static Pattern FILE_POSITION = Pattern.compile(".*\\bfile__position\\b.*", 2);
    private static Pattern TABLE_NOT_FOUND = Pattern.compile(".*\\bTable '(.*)' not found\\b.*", 2);
    private static Pattern COLUMN_NOT_FOUND = Pattern.compile(".*\\bColumn '(.*)' not found\\b.*", 2);

    public CalciteJniFrontend(byte[] thriftBackendConfig, boolean isBackendTest) throws ImpalaException, TException {
        super(thriftBackendConfig, isBackendTest);
        CalciteJniFrontend.loadCalciteImpalaFunctions();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] createExecRequest(byte[] thriftQueryContext) throws ImpalaException {
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        QueryContext queryCtx = new QueryContext(thriftQueryContext, this.getFrontend());
        CalciteMetadataHandler mdHandler = null;
        try {
            CalciteCompilerFactory.checkOptionSupportedInCalcite(queryCtx.getTQueryCtx());
        }
        catch (UnsupportedFeatureException e) {
            return this.runThroughOriginalPlanner(thriftQueryContext, queryCtx);
        }
        try (FrontendProfile.Scope scope = FrontendProfile.createNewWithScope();){
            LOG.info("Using Calcite Planner for the following query: " + queryCtx.getStmt());
            RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of((RelMetadataProvider)DefaultRelMetadataProvider.INSTANCE));
            CalciteQueryParser queryParser = new CalciteQueryParser(queryCtx);
            SqlNode parsedSqlNode = queryParser.parse();
            this.markEvent(queryParser, parsedSqlNode, queryCtx, "Parsed query");
            mdHandler = new CalciteMetadataHandler(parsedSqlNode, queryCtx);
            this.markEvent(mdHandler, null, queryCtx, "Loaded tables");
            boolean isExplain = false;
            if (parsedSqlNode instanceof SqlExplain) {
                isExplain = true;
                parsedSqlNode = ((SqlExplain)parsedSqlNode).getExplicandum();
            }
            CalciteValidator validator = new CalciteValidator(mdHandler, queryCtx);
            SqlNode validatedNode = validator.validate(parsedSqlNode);
            this.markEvent(mdHandler, validatedNode, queryCtx, "Validated query");
            CalciteRelNodeConverter relNodeConverter = new CalciteRelNodeConverter(validator);
            RelNode logicalPlan = relNodeConverter.convert(validatedNode);
            this.markEvent(mdHandler, logicalPlan, queryCtx, "Created initial logical plan");
            CalciteOptimizer optimizer = new CalciteOptimizer(validator, queryCtx.getTimeline());
            ImpalaPlanRel optimizedPlan = optimizer.optimize(logicalPlan);
            this.markEvent(mdHandler, optimizedPlan, queryCtx, "Optimized logical plan");
            CalcitePhysPlanCreator physPlanCreator = new CalcitePhysPlanCreator(mdHandler, queryCtx);
            NodeWithExprs rootNode = physPlanCreator.create(optimizedPlan);
            this.markEvent(mdHandler, rootNode, queryCtx, "Created physical plan");
            ExecRequestCreator execRequestCreator = new ExecRequestCreator(physPlanCreator, queryCtx, mdHandler, isExplain);
            TExecRequest execRequest = execRequestCreator.create(rootNode);
            this.markEvent(mdHandler, execRequest, queryCtx, "Created exec request");
            byte[] serializedRequest = JniUtil.serializeToThrift((TBase)execRequest);
            queryCtx.getTimeline().markEvent("Serialized request");
            byte[] byArray = serializedRequest;
            return byArray;
        }
        catch (ParseException e) {
            CalciteJniFrontend.throwUnsupportedIfKnownException((Exception)((Object)e));
            if (Parser.parse((String)queryCtx.getStmt()) instanceof SelectStmt) {
                throw e;
            }
            LOG.info("Calcite planner failed to parse query: " + queryCtx.getStmt());
            LOG.info("Going to use original Impala planner.");
            return this.runThroughOriginalPlanner(thriftQueryContext, queryCtx);
        }
        catch (ImpalaException e) {
            if (mdHandler == null) throw e;
            CalciteJniFrontend.throwUnsupportedIfKnownException(e, mdHandler.getStmtTableCache());
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public byte[] runThroughOriginalPlanner(byte[] thriftQueryContext, QueryContext queryCtx) throws ImpalaException {
        LOG.info("Using Impala Planner for the following query: " + queryCtx.getStmt());
        return super.createExecRequest(thriftQueryContext);
    }

    private void markEvent(CompilerStep compilerStep, Object stepResult, QueryContext queryCtx, String stepMessage) {
        LOG.info(stepMessage);
        queryCtx.getTimeline().markEvent(stepMessage);
        if (LOG.isDebugEnabled()) {
            compilerStep.logDebug(stepResult);
        }
    }

    private static void loadCalciteImpalaFunctions() {
        ImpalaOperatorTable.create(BuiltinsDb.getInstance());
    }

    private static void throwUnsupportedIfKnownException(Exception e) throws ImpalaException {
        String s = e.toString().replace("\n", " ");
        if (LEFT_ANTI.matcher(s).matches() || RIGHT_ANTI.matcher(s).matches()) {
            throw new UnsupportedFeatureException("Anti joins not supported.");
        }
        if (LEFT_SEMI.matcher(s).matches() || RIGHT_SEMI.matcher(s).matches()) {
            throw new UnsupportedFeatureException("Semi joins not supported.");
        }
        if (INPUT_FILE_NAME.matcher(s).matches() || FILE_POSITION.matcher(s).matches()) {
            throw new UnsupportedFeatureException("Virtual columns not supported.");
        }
    }

    public static void throwUnsupportedIfKnownException(ImpalaException e, StmtMetadataLoader.StmtTableCache stmtTableCache) throws ImpalaException {
        CalciteJniFrontend.throwUnsupportedIfKnownException((Exception)((Object)e));
        String s = e.toString().replace("\n", " ");
        Matcher m = TABLE_NOT_FOUND.matcher(s);
        if (m.matches() && CalciteMetadataHandler.anyTableContainsColumn(stmtTableCache, m.group(1))) {
            throw new UnsupportedFeatureException("Complex column " + m.group(1) + " not supported.");
        }
        m = COLUMN_NOT_FOUND.matcher(s);
        if (m.matches() && CalciteMetadataHandler.anyTableContainsColumn(stmtTableCache, m.group(1))) {
            throw new UnsupportedFeatureException("Complex column " + m.group(1) + " not supported.");
        }
    }

    public static class QueryContext {
        private final TQueryCtx queryCtx_ = new TQueryCtx();
        private final String stmt_;
        private final String currentDb_;
        private final Frontend frontend_;
        private final EventSequence timeline_;

        public QueryContext(byte[] thriftQueryContext, Frontend frontend) throws ImpalaException {
            JniUtil.deserializeThrift((TBase)this.queryCtx_, (byte[])thriftQueryContext);
            if (this.queryCtx_.getClient_request() != null && this.queryCtx_.getClient_request().getQuery_options() != null && !this.queryCtx_.getClient_request().getQuery_options().isSetMt_dop()) {
                this.queryCtx_.getClient_request().getQuery_options().setMt_dop(0);
            }
            this.frontend_ = frontend;
            this.stmt_ = this.queryCtx_.getClient_request().getStmt();
            this.currentDb_ = this.queryCtx_.getSession().getDatabase();
            this.timeline_ = new EventSequence("Frontend Timeline (Calcite Planner)");
        }

        public QueryContext(TQueryOptions options, Frontend frontend, String stmt) throws ImpalaException {
            this.queryCtx_.setClient_request(new TClientRequest("FeTests", options));
            this.frontend_ = frontend;
            this.stmt_ = stmt;
            this.currentDb_ = "default";
            this.timeline_ = new EventSequence("Frontend Timeline (Calcite Planner)");
        }

        public TQueryCtx getTQueryCtx() {
            return this.queryCtx_;
        }

        public Frontend getFrontend() {
            return this.frontend_;
        }

        public String getStmt() {
            return this.stmt_;
        }

        public String getCurrentDb() {
            return this.currentDb_;
        }

        public EventSequence getTimeline() {
            return this.timeline_;
        }
    }
}

