/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.service;

import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.analysis.AnalysisDriver;
import org.apache.impala.analysis.ParsedStatement;
import org.apache.impala.analysis.StmtMetadataLoader;
import org.apache.impala.authorization.AuthorizationContext;
import org.apache.impala.calcite.operators.ImpalaOperatorTable;
import org.apache.impala.calcite.service.CalciteAnalysisDriver;
import org.apache.impala.calcite.service.CalciteParsedStatement;
import org.apache.impala.calcite.service.CalciteSingleNodePlanner;
import org.apache.impala.catalog.BuiltinsDb;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.UnsupportedFeatureException;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.planner.SingleNodePlannerIntf;
import org.apache.impala.service.CompilerFactory;
import org.apache.impala.thrift.TQueryCtx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteCompilerFactory
implements CompilerFactory {
    protected static final Logger LOG = LoggerFactory.getLogger((String)CalciteCompilerFactory.class.getName());
    private static final String PLANNER = "CalcitePlanner";

    public ParsedStatement createParsedStatement(TQueryCtx queryCtx) throws ImpalaException {
        CalciteCompilerFactory.checkOptionSupportedInCalcite(queryCtx);
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of((RelMetadataProvider)DefaultRelMetadataProvider.INSTANCE));
        return new CalciteParsedStatement(queryCtx);
    }

    public AnalysisDriver createAnalysisDriver(AnalysisContext ctx, ParsedStatement parsedStmt, StmtMetadataLoader.StmtTableCache stmtTableCache, AuthorizationContext authzCtx) throws AnalysisException {
        return new CalciteAnalysisDriver(ctx, parsedStmt, stmtTableCache, authzCtx);
    }

    public SingleNodePlannerIntf createSingleNodePlanner(PlannerContext ctx) throws ImpalaException {
        return new CalciteSingleNodePlanner(ctx);
    }

    public String getPlannerString() {
        return PLANNER;
    }

    public static void checkOptionSupportedInCalcite(TQueryCtx queryCtx) throws ImpalaException {
        if (!queryCtx.getClient_request().getQuery_options().isDecimal_v2()) {
            throw new UnsupportedFeatureException("Decimal v1 not supported in Calcite, falling back to Impala compiler.");
        }
        if (queryCtx.getClient_request().getQuery_options().isAppx_count_distinct()) {
            throw new UnsupportedFeatureException("Approximate count distinct is not supported in Calcite, falling back to Impala compiler.");
        }
    }

    static {
        System.setProperty("calcite.default.charset", "UTF8");
        ImpalaOperatorTable.create(BuiltinsDb.getInstance());
    }
}

