/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.service;

import java.util.Set;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.implicit.TypeCoercionFactory;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.analysis.AnalysisDriver;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ParsedStatement;
import org.apache.impala.analysis.StmtMetadataLoader;
import org.apache.impala.analysis.TableName;
import org.apache.impala.authorization.AuthorizationContext;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.authorization.PrivilegeRequestBuilder;
import org.apache.impala.calcite.operators.ImpalaOperatorTable;
import org.apache.impala.calcite.service.CalciteAnalysisResult;
import org.apache.impala.calcite.service.CalciteMetadataHandler;
import org.apache.impala.calcite.service.CalciteParsedStatement;
import org.apache.impala.calcite.service.CalciteQueryParser;
import org.apache.impala.calcite.service.ImpalaSqlValidatorImpl;
import org.apache.impala.calcite.type.ImpalaTypeCoercionFactory;
import org.apache.impala.calcite.type.ImpalaTypeSystemImpl;
import org.apache.impala.calcite.util.SimplifiedAnalyzer;
import org.apache.impala.calcite.validate.ImpalaConformance;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.ParseException;
import org.apache.impala.common.UnsupportedFeatureException;
import org.apache.impala.thrift.TQueryCtx;

public class CalciteAnalysisDriver
implements AnalysisDriver {
    public final TQueryCtx queryCtx_;
    public final AuthorizationFactory authzFactory_;
    public final CalciteParsedStatement parsedStmt_;
    public SqlNode validatedNode_;
    public RelDataTypeFactory typeFactory_;
    public ImpalaSqlValidatorImpl sqlValidator_;
    private CalciteCatalogReader reader_;
    private final AnalysisContext ctx_;
    private final StmtMetadataLoader.StmtTableCache stmtTableCache_;
    private final AuthorizationContext authzCtx_;
    private final Analyzer analyzer_;

    public CalciteAnalysisDriver(AnalysisContext ctx, ParsedStatement parsedStmt, StmtMetadataLoader.StmtTableCache stmtTableCache, AuthorizationContext authzCtx) {
        this.queryCtx_ = ctx.getQueryCtx();
        this.authzFactory_ = ctx.getAuthzFactory();
        this.parsedStmt_ = (CalciteParsedStatement)parsedStmt;
        this.ctx_ = ctx;
        this.stmtTableCache_ = stmtTableCache;
        this.authzCtx_ = authzCtx;
        this.analyzer_ = this.createAnalyzer(ctx, stmtTableCache, authzCtx);
    }

    public AnalysisContext.AnalysisResult analyze() {
        try {
            if (this.stmtTableCache_.needsAnyTableMasksInQuery_) {
                throw new UnsupportedFeatureException("Column masking and row filtering are not yet supported by the Calcite planner.");
            }
            this.reader_ = CalciteMetadataHandler.createCalciteCatalogReader(this.stmtTableCache_, this.queryCtx_, this.queryCtx_.session.database);
            CalciteMetadataHandler.populateCalciteSchema(this.reader_, this.ctx_.getCatalog(), this.stmtTableCache_, this.analyzer_);
            this.typeFactory_ = new JavaTypeFactoryImpl((RelDataTypeSystem)new ImpalaTypeSystemImpl());
            this.sqlValidator_ = new ImpalaSqlValidatorImpl((SqlOperatorTable)ImpalaOperatorTable.getInstance(), (SqlValidatorCatalogReader)this.reader_, this.typeFactory_, SqlValidator.Config.DEFAULT.withIdentifierExpansion(true).withConformance(ImpalaConformance.INSTANCE).withTypeCoercionEnabled(true).withTypeCoercionFactory((TypeCoercionFactory)new ImpalaTypeCoercionFactory()), this.analyzer_);
            this.registerPrivReqsInTables(this.parsedStmt_.getTablesInQuery(null), false, this.stmtTableCache_.catalog, this.sqlValidator_);
            this.validatedNode_ = this.sqlValidator_.validate(this.parsedStmt_.getParsedSqlNode());
            return new CalciteAnalysisResult(this);
        }
        catch (ImpalaException e) {
            return new CalciteAnalysisResult(this, e);
        }
        catch (CalciteContextException e) {
            return new CalciteAnalysisResult(this, (ImpalaException)new AnalysisException(e.getMessage(), e.getCause()));
        }
    }

    public Analyzer createAnalyzer(AnalysisContext ctx, StmtMetadataLoader.StmtTableCache stmtTableCache, AuthorizationContext authzCtx) {
        return new SimplifiedAnalyzer(stmtTableCache, ctx.getQueryCtx(), ctx.getAuthzFactory(), null);
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory_;
    }

    public CalciteCatalogReader getCatalogReader() {
        return this.reader_;
    }

    public SqlValidator getSqlValidator() {
        return this.sqlValidator_;
    }

    public SqlNode getValidatedNode() {
        return this.validatedNode_;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer_;
    }

    public ParsedStatement getParsedStmt() {
        return this.parsedStmt_;
    }

    private void registerPrivReqsInTables(Set<TableName> tableNamesInQuery, boolean shouldMaskPrivChecks, FeCatalog catalog, ImpalaSqlValidatorImpl validator) throws ParseException {
        for (TableName tableName : tableNamesInQuery) {
            boolean childViewCreatedBySuperuser;
            FeTable feTable = this.registerTablePrivReq(tableName, catalog);
            if (!(feTable instanceof FeView)) continue;
            String sql = ((FeView)feTable).getQueryStmt().toSql();
            CalciteQueryParser queryParser = new CalciteQueryParser(sql);
            SqlNode parsedSqlNode = queryParser.parse();
            CalciteMetadataHandler.TableVisitor tableVisitor = new CalciteMetadataHandler.TableVisitor("default");
            parsedSqlNode.accept((SqlVisitor)tableVisitor);
            boolean bl = childViewCreatedBySuperuser = !PrivilegeRequestBuilder.isViewCreatedByNonSuperuser((FeTable)feTable);
            if (shouldMaskPrivChecks || childViewCreatedBySuperuser) {
                this.analyzer_.setMaskPrivChecks(null);
            }
            validator.validate(parsedSqlNode);
            this.registerPrivReqsInTables(tableVisitor.tableNames_, shouldMaskPrivChecks || childViewCreatedBySuperuser, catalog, validator);
            if (shouldMaskPrivChecks || !childViewCreatedBySuperuser) continue;
            this.analyzer_.unsetMaskPrivChecks();
        }
    }

    private FeTable registerTablePrivReq(TableName tableName, FeCatalog catalog) {
        FeTable feTable = this.getFeTable(tableName, catalog);
        if (feTable == null) {
            this.analyzer_.registerPrivReq(builder -> {
                builder.onTableUnknownOwner(tableName.getDb(), tableName.getTbl()).allOf(Privilege.SELECT);
                return builder.build();
            });
        } else {
            this.analyzer_.registerAuthAndAuditEvent(feTable, Privilege.SELECT);
        }
        return feTable;
    }

    private FeTable getFeTable(TableName tableName, FeCatalog catalog) {
        FeDb db = catalog.getDb(tableName.getDb());
        if (db == null) {
            return null;
        }
        return db.getTable(tableName.getTbl());
    }
}

