/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinRelationInfo {
    protected static final Logger LOG = LoggerFactory.getLogger((String)JoinRelationInfo.class.getName());
    private final List<EqualityConjunction> equalityConjunctions_;
    private final RexNode nonEqualityConjunction_;
    private final Double DISTINCT_PERCENTAGE = 0.95;
    private final Join join_;
    private final RelMetadataQuery mq_;

    public JoinRelationInfo(Join join, RexBuilder rexBuilder, RelMetadataQuery mq) {
        List conjunctions = RelOptUtil.conjunctions((RexNode)join.getCondition());
        this.join_ = join;
        this.mq_ = mq;
        ImmutableList.Builder equalityConjBuilder = ImmutableList.builder();
        ImmutableList.Builder nonEqualityConjBuilder = ImmutableList.builder();
        Object foundConj = null;
        for (RexNode conjunction : conjunctions) {
            EqualityConjunction equalityConj = this.createEqualityConjunction(join, conjunction, mq);
            if (equalityConj != null) {
                equalityConjBuilder.add((Object)equalityConj);
                continue;
            }
            nonEqualityConjBuilder.add((Object)conjunction);
        }
        this.equalityConjunctions_ = equalityConjBuilder.build();
        ImmutableList nonEqualityConjs = nonEqualityConjBuilder.build();
        this.nonEqualityConjunction_ = nonEqualityConjs.size() > 0 ? RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)nonEqualityConjs) : null;
    }

    public boolean useDefaultRowCount() {
        return this.equalityConjunctions_.size() == 0;
    }

    public Double getRowCount() {
        Preconditions.checkState((this.equalityConjunctions_.size() != 0 ? 1 : 0) != 0);
        EqualityConjunction conj0 = this.equalityConjunctions_.get(0);
        Double ret = conj0.lhsNumRows_ * conj0.rhsNumRows_ / this.getDistinctRows();
        if (this.join_.getJoinType() == JoinRelType.LEFT || this.join_.getJoinType() == JoinRelType.FULL) {
            ret = Math.max(conj0.lhsNumRows_, ret);
        }
        if (this.join_.getJoinType() == JoinRelType.RIGHT || this.join_.getJoinType() == JoinRelType.FULL) {
            ret = Math.max(conj0.rhsNumRows_, ret);
        }
        return ret;
    }

    private EqualityConjunction createEqualityConjunction(Join join, RexNode conjunction, RelMetadataQuery mq) {
        Pair<Integer, Integer> joinCols = JoinRelationInfo.getJoinInputRefs(join, conjunction);
        if (joinCols == null) {
            return null;
        }
        EqualityConjunction candidate = new EqualityConjunction(join, mq, joinCols);
        if (candidate.lhsNumRows_ == null || candidate.rhsNumRows_ == null) {
            return null;
        }
        return candidate;
    }

    private static Pair<Integer, Integer> getJoinInputRefs(Join joinRel, RexNode joinCond) {
        if (!(joinCond instanceof RexCall)) {
            return null;
        }
        if (((RexCall)joinCond).getOperator() != SqlStdOperatorTable.EQUALS) {
            return null;
        }
        ImmutableBitSet leftCols = RelOptUtil.InputFinder.bits((RexNode)((RexNode)((RexCall)joinCond).getOperands().get(0)));
        ImmutableBitSet rightCols = RelOptUtil.InputFinder.bits((RexNode)((RexNode)((RexCall)joinCond).getOperands().get(1)));
        Preconditions.checkState((leftCols.cardinality() == 1 && rightCols.cardinality() == 1 ? 1 : 0) != 0);
        int nFieldsLeft = joinRel.getLeft().getRowType().getFieldList().size();
        int nFieldsRight = joinRel.getRight().getRowType().getFieldList().size();
        ImmutableBitSet rightFieldsBitSet = ImmutableBitSet.range((int)nFieldsLeft, (int)(nFieldsLeft + nFieldsRight));
        if (rightFieldsBitSet.contains(leftCols)) {
            ImmutableBitSet t = leftCols;
            leftCols = rightCols;
            rightCols = t;
        }
        int leftColIdx = leftCols.nextSetBit(0);
        int rightColIdx = rightCols.nextSetBit(0) - nFieldsLeft;
        return new Pair((Object)leftColIdx, (Object)rightColIdx);
    }

    public double getDistinctRows() {
        double maxLeft = 1.0;
        double maxRight = 1.0;
        for (EqualityConjunction equalityConj : this.equalityConjunctions_) {
            if (maxLeft < equalityConj.lhsNumRows_) {
                maxLeft = Math.min(equalityConj.lhsNumRows_, maxLeft * equalityConj.lhsNdv_);
            }
            if (!(maxRight < equalityConj.rhsNumRows_)) continue;
            maxRight = Math.min(equalityConj.rhsNumRows_, maxRight * equalityConj.rhsNdv_);
        }
        return Math.max(maxLeft, maxRight);
    }

    public static class EqualityConjunction {
        public final Double lhsNumRows_;
        public final Double rhsNumRows_;
        public final Double lhsNdv_;
        public final Double rhsNdv_;

        public EqualityConjunction(Join join, RelMetadataQuery mq, Pair<Integer, Integer> joinCols) {
            RelNode leftInput = join.getLeft();
            RelNode rightInput = join.getRight();
            this.lhsNumRows_ = mq.getRowCount(leftInput);
            this.rhsNumRows_ = mq.getRowCount(rightInput);
            ImmutableBitSet leftColumnBitSet = ImmutableBitSet.of((int)((Integer)joinCols.left));
            ImmutableBitSet rightColumnBitSet = ImmutableBitSet.of((int)((Integer)joinCols.right));
            this.lhsNdv_ = mq.getDistinctRowCount(leftInput, leftColumnBitSet, null);
            this.rhsNdv_ = mq.getDistinctRowCount(rightInput, rightColumnBitSet, null);
        }
    }
}

