/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdSize;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.impala.calcite.schema.CalciteTable;
import org.apache.impala.catalog.Column;

public class ImpalaRelMdSize
extends RelMdSize {
    public static final ImpalaRelMdSize INSTANCE = new ImpalaRelMdSize();
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((MetadataHandler)INSTANCE, (Method[])new Method[]{BuiltInMethod.AVERAGE_COLUMN_SIZES.method, BuiltInMethod.AVERAGE_ROW_SIZE.method});

    public List<Double> averageColumnSizes(TableScan scan, RelMetadataQuery mq) {
        ImmutableList.Builder list = ImmutableList.builder();
        CalciteTable table = (CalciteTable)scan.getTable();
        Preconditions.checkState((scan.getRowType().getFieldCount() == table.getColumns().size() ? 1 : 0) != 0);
        for (int i = 0; i < table.getColumns().size(); ++i) {
            Column c = table.getColumn(i);
            double avgSize = c.getStats().getAvgSize();
            if (avgSize == -1.0) {
                avgSize = this.averageTypeValueSize(((RelDataTypeField)table.getRowType().getFieldList().get(i)).getType());
            }
            list.add((Object)avgSize);
        }
        return list.build();
    }

    public Double averageTypeValueSize(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case BOOLEAN: 
            case TINYINT: {
                return 1.0;
            }
            case SMALLINT: {
                return 2.0;
            }
            case INTEGER: 
            case FLOAT: 
            case REAL: 
            case DECIMAL: 
            case DATE: 
            case TIME: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                return 4.0;
            }
            case BIGINT: 
            case DOUBLE: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 8.0;
            }
            case BINARY: {
                return type.getPrecision();
            }
            case VARBINARY: {
                return Math.min((double)type.getPrecision(), 100.0);
            }
            case CHAR: {
                return (double)type.getPrecision() * 2.0;
            }
            case VARCHAR: {
                return Math.min((double)type.getPrecision() * 2.0, 100.0);
            }
            case ROW: {
                Double average = 0.0;
                for (RelDataTypeField field : type.getFieldList()) {
                    average = average + this.averageTypeValueSize(field.getType());
                }
                return average;
            }
        }
        return null;
    }
}

