/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.schema;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdRowCount;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.NumberUtil;
import org.apache.impala.calcite.schema.CalciteTable;
import org.apache.impala.calcite.schema.FilterSelectivityEstimator;
import org.apache.impala.calcite.schema.JoinRelationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaRelMdRowCount
extends RelMdRowCount {
    protected static final Logger LOG = LoggerFactory.getLogger((String)ImpalaRelMdRowCount.class.getName());
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.ROW_COUNT.method, (MetadataHandler)new ImpalaRelMdRowCount());

    protected ImpalaRelMdRowCount() {
    }

    public Double getRowCount(Filter filter, RelMetadataQuery mq) {
        RelNode input = filter.getInput();
        CalciteTable table = this.getTable(input);
        RexNode condition = filter.getCondition();
        Double inputRowCount = mq.getRowCount(input);
        Preconditions.checkState((inputRowCount >= 0.0 ? 1 : 0) != 0);
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(input, mq);
        Double selectivity = condition != null ? estimator.estimateSelectivity(condition) : 1.0;
        return NumberUtil.multiply((Double)inputRowCount, (Double)selectivity);
    }

    public Double getRowCount(Join join, RelMetadataQuery mq) {
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        JoinRelationInfo info = new JoinRelationInfo(join, rexBuilder, mq);
        return info.useDefaultRowCount() ? super.getRowCount(join, mq) : info.getRowCount();
    }

    public Double getRowCount(TableScan ts, RelMetadataQuery mq) {
        return ts.getTable().getRowCount();
    }

    private CalciteTable getTable(RelNode input) {
        return input instanceof HepRelVertex ? (CalciteTable)((HepRelVertex)input).getCurrentRel().getTable() : (CalciteTable)input.getTable();
    }
}

