/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.schema;

import java.lang.reflect.Method;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.impala.calcite.schema.ImpalaCost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaRelMdNonCumulativeCost
implements BuiltInMetadata.NonCumulativeCost.Handler {
    public static final double cpuUnitCost = 1.0E-6;
    public static final double netCost = 1.5E-4;
    public static final double localFSWrite = 6.0E-4;
    public static final double localFSRead = 6.0E-4;
    public static final double hdfsWrite = 0.005999999999999999;
    public static final double hdfsRead = 9.0E-4;
    protected static final Logger LOG = LoggerFactory.getLogger((String)ImpalaRelMdNonCumulativeCost.class.getName());
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.NON_CUMULATIVE_COST.method, (MetadataHandler)new ImpalaRelMdNonCumulativeCost());

    public RelOptCost getNonCumulativeCost(RelNode rel, RelMetadataQuery mq) {
        if (rel instanceof Join) {
            return this.getJoinCost((Join)rel, mq);
        }
        if (rel instanceof TableScan) {
            return this.getScanCost((TableScan)rel, mq);
        }
        if (rel instanceof Aggregate) {
            return this.getAggregateCost((Aggregate)rel, mq);
        }
        return ImpalaCost.ZERO;
    }

    private RelOptCost getJoinCost(Join join, RelMetadataQuery mq) {
        Double leftRCount = mq.getRowCount(join.getLeft());
        Double rightRCount = mq.getRowCount(join.getRight());
        Double leftRAverageSize = mq.getAverageRowSize(join.getLeft());
        Double rightRAverageSize = mq.getAverageRowSize(join.getRight());
        if (leftRCount == null || rightRCount == null || leftRAverageSize == null || rightRAverageSize == null) {
            return null;
        }
        double rowCount = leftRCount + rightRCount;
        double cpuCost = rowCount * 1.0E-6;
        double ioCost = rightRCount * rightRAverageSize * 1.5E-4;
        RelOptCost finalCost = ImpalaCost.FACTORY.makeCost(1.0, cpuCost, ioCost);
        return finalCost;
    }

    private RelOptCost getScanCost(TableScan scan, RelMetadataQuery mq) {
        double cardinality = mq.getRowCount((RelNode)scan);
        double avgTupleSize = mq.getAverageRowSize((RelNode)scan);
        return new ImpalaCost(0.0, 9.0E-4 * cardinality * avgTupleSize);
    }

    private RelOptCost getAggregateCost(Aggregate agg, RelMetadataQuery mq) {
        if (mq.distribution((RelNode)agg).getKeys().containsAll(agg.getGroupSet().asList())) {
            return ImpalaCost.ZERO;
        }
        Double rCount = mq.getRowCount(agg.getInput());
        if (rCount == null) {
            return null;
        }
        double cpuCost = rCount * Math.log(rCount) * 1.0E-6;
        Double rAverageSize = mq.getAverageRowSize(agg.getInput());
        if (rAverageSize == null) {
            return null;
        }
        double ioCost = 0.0;
        ioCost += rCount * rAverageSize * 6.0E-4;
        ioCost += rCount * rAverageSize * 6.0E-4;
        return ImpalaCost.FACTORY.makeCost(1.0, cpuCost, ioCost += rCount * rAverageSize * 1.5E-4);
    }
}

