/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.schema;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdDistinctRowCount;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.impala.calcite.schema.CalciteTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaRelMdDistinctRowCount
extends RelMdDistinctRowCount {
    protected static final Logger LOG = LoggerFactory.getLogger((String)ImpalaRelMdDistinctRowCount.class.getName());
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.DISTINCT_ROW_COUNT.method, (MetadataHandler)new ImpalaRelMdDistinctRowCount());

    public Double getDistinctRowCount(TableScan scan, RelMetadataQuery mq, ImmutableBitSet groupKey, RexNode predicate) {
        double distinctRows = 1.0;
        CalciteTable table = (CalciteTable)scan.getTable();
        double totalRows = table.getRowCount();
        Preconditions.checkState((totalRows >= 0.0 ? 1 : 0) != 0);
        for (Integer i : groupKey.asList()) {
            long distinctValues = table.getColumn(i).getStats().getNumDistinctValues();
            if (distinctValues < 0L) {
                return totalRows;
            }
            if (!((distinctRows *= (double)distinctValues) >= totalRows)) continue;
            return totalRows;
        }
        return distinctRows;
    }

    public Double getDistinctRowCount(Aggregate rel, RelMetadataQuery mq, ImmutableBitSet groupKey, RexNode predicate) {
        return Math.min(mq.getRowCount((RelNode)rel), super.getDistinctRowCount(rel, mq, groupKey, predicate));
    }

    public Double getDistinctRowCount(Filter rel, RelMetadataQuery mq, ImmutableBitSet groupKey, RexNode predicate) {
        Double rowCount = mq.getRowCount((RelNode)rel);
        Preconditions.checkState((rowCount >= 0.0 ? 1 : 0) != 0);
        Double childRowCount = mq.getRowCount(rel.getInput(0));
        Double distinctRowCount = mq.getDistinctRowCount(rel.getInput(0), groupKey, predicate);
        Preconditions.checkState((rowCount <= childRowCount ? 1 : 0) != 0);
        return Math.max(1.0, distinctRowCount * rowCount / childRowCount);
    }

    public Double getDistinctRowCount(Join rel, RelMetadataQuery mq, ImmutableBitSet groupKey, RexNode predicate) {
        return Math.min(mq.getRowCount((RelNode)rel), super.getDistinctRowCount(rel, mq, groupKey, predicate));
    }
}

