/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.schema;

import java.util.Objects;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptCostFactory;

public class ImpalaCost
implements RelOptCost {
    static final ImpalaCost INFINITY = new ImpalaCost(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY){

        @Override
        public String toString() {
            return "{inf}";
        }
    };
    static final ImpalaCost HUGE = new ImpalaCost(Double.MAX_VALUE, Double.MAX_VALUE){

        @Override
        public String toString() {
            return "{huge}";
        }
    };
    static final ImpalaCost ZERO = new ImpalaCost(0.0, 0.0){

        @Override
        public String toString() {
            return "{0}";
        }
    };
    static final ImpalaCost TINY = new ImpalaCost(1.0, 0.0){

        @Override
        public String toString() {
            return "{tiny}";
        }
    };
    public static final RelOptCostFactory FACTORY = new Factory();
    final double cpu;
    final double io;

    ImpalaCost(double cpu, double io) {
        this.cpu = cpu;
        this.io = io;
    }

    public double getCpu() {
        return this.cpu;
    }

    public boolean isInfinite() {
        return this == INFINITY || this.cpu == Double.POSITIVE_INFINITY || this.io == Double.POSITIVE_INFINITY;
    }

    public double getIo() {
        return this.io;
    }

    public boolean isLe(RelOptCost other) {
        return this.cpu + this.io < other.getCpu() + other.getIo() || this.cpu + this.io == other.getCpu() + other.getIo();
    }

    public boolean isLt(RelOptCost other) {
        return this.isLe(other) && !this.equals(other);
    }

    public double getRows() {
        return 1.0;
    }

    public int hashCode() {
        return Objects.hash(this.cpu, this.io);
    }

    public boolean equals(RelOptCost other) {
        return this == other || this.cpu + this.io == other.getCpu() + other.getIo();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImpalaCost) {
            return this.equals((ImpalaCost)obj);
        }
        return false;
    }

    public boolean isEqWithEpsilon(RelOptCost other) {
        if (!(other instanceof ImpalaCost)) {
            return false;
        }
        ImpalaCost that = (ImpalaCost)other;
        return this == other || Math.abs(1.0 - (this.cpu + this.io) / (other.getCpu() + other.getIo())) < 0.01;
    }

    public RelOptCost minus(RelOptCost other) {
        if (this == INFINITY) {
            return this;
        }
        ImpalaCost that = (ImpalaCost)other;
        return new ImpalaCost(this.cpu - that.cpu, this.io - that.io);
    }

    public RelOptCost multiplyBy(double factor) {
        if (this == INFINITY) {
            return this;
        }
        return new ImpalaCost(this.cpu * factor, this.io * factor);
    }

    public double divideBy(RelOptCost cost) {
        ImpalaCost that = (ImpalaCost)cost;
        double d = 1.0;
        double n = 0.0;
        if (this.cpu != 0.0 && !Double.isInfinite(this.cpu) && that.cpu != 0.0 && !Double.isInfinite(that.cpu)) {
            d *= this.cpu / that.cpu;
            n += 1.0;
        }
        if (this.io != 0.0 && !Double.isInfinite(this.io) && that.io != 0.0 && !Double.isInfinite(that.io)) {
            d *= this.io / that.io;
            n += 1.0;
        }
        if (n == 0.0) {
            return 1.0;
        }
        return Math.pow(d, 1.0 / n);
    }

    public RelOptCost plus(RelOptCost other) {
        ImpalaCost that = (ImpalaCost)other;
        if (this == INFINITY || that == INFINITY) {
            return INFINITY;
        }
        return new ImpalaCost(this.cpu + that.cpu, this.io + that.io);
    }

    public String toString() {
        return "{" + this.cpu + " cpu, " + this.io + " io}";
    }

    private static class Factory
    implements RelOptCostFactory {
        private Factory() {
        }

        public RelOptCost makeCost(double rowCount, double dCpu, double dIo) {
            return new ImpalaCost(dCpu, dIo);
        }

        public RelOptCost makeHugeCost() {
            return HUGE;
        }

        public RelOptCost makeInfiniteCost() {
            return INFINITY;
        }

        public RelOptCost makeTinyCost() {
            return TINY;
        }

        public RelOptCost makeZeroCost() {
            return ZERO;
        }
    }
}

