/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.schema;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.impala.calcite.rel.util.RexInputRefCollector;
import org.apache.impala.calcite.schema.CalciteTable;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.ColumnStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterSelectivityEstimator {
    protected static final Logger LOG = LoggerFactory.getLogger(FilterSelectivityEstimator.class);
    private final RelNode childRel_;
    private final double childCardinality_;
    private final RelMetadataQuery mq_;
    public static final double RANGE_COMPARISON_SELECTIVITY = 0.3333333333333333;
    public static final double BETWEEN_SELECTIVITY = 0.1111111111111111;

    public FilterSelectivityEstimator(RelNode childRel, RelMetadataQuery mq) {
        this.mq_ = mq;
        this.childRel_ = childRel instanceof HepRelVertex ? ((HepRelVertex)childRel).getCurrentRel() : childRel;
        this.childCardinality_ = mq.getRowCount(childRel);
    }

    public Double estimateSelectivity(RexNode rexNode) {
        if (rexNode instanceof RexInputRef) {
            return this.estimateInputRefSelectivity((RexInputRef)rexNode);
        }
        if (rexNode instanceof RexCall) {
            return this.estimateCallSelectivity((RexCall)rexNode);
        }
        return 1.0;
    }

    private Double estimateInputRefSelectivity(RexInputRef inputRef) {
        if (inputRef.getType().getSqlTypeName() != SqlTypeName.BOOLEAN) {
            return 1.0;
        }
        if (!(this.childRel_ instanceof TableScan)) {
            return 0.5;
        }
        CalciteTable table = (CalciteTable)this.childRel_.getTable();
        Preconditions.checkNotNull((Object)((Object)table));
        Column column = table.getColumn(inputRef.getIndex());
        if (column.getStats() != null) {
            ColumnStats stats = column.getStats();
            if (stats.getNumTrues() == 0L && stats.getNumFalses() == 0L) {
                return 0.0;
            }
            return (double)stats.getNumTrues() / this.childCardinality_;
        }
        return 0.5;
    }

    private Double estimateCallSelectivity(RexCall call) {
        switch (call.getOperator().getKind()) {
            case EQUALS: 
            case LIKE: 
            case IS_NOT_DISTINCT_FROM: {
                return this.computeEqualsSelectivity(call);
            }
            case AND: {
                return this.computeConjunctionSelectivity(call);
            }
            case OR: {
                return this.computeDisjunctionSelectivity(call);
            }
            case NOT: 
            case NOT_EQUALS: {
                return this.computeNotEqualitySelectivity(call);
            }
            case IS_NULL: {
                return this.computeIsNullSelectivity(call);
            }
            case IS_NOT_NULL: {
                return this.computeIsNotNullSelectivity(call);
            }
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case GREATER_THAN: {
                return 0.3333333333333333;
            }
            case BETWEEN: {
                return 0.1111111111111111;
            }
            case IN: {
                return this.computeInSelectivity(call);
            }
        }
        return this.computeEqualsSelectivity(call);
    }

    private Double computeNotEqualitySelectivity(RexCall call) {
        Double tmpNDV = this.getMaxNDV(call);
        return tmpNDV > 1.0 ? (tmpNDV - 1.0) / tmpNDV : 1.0;
    }

    private Double computeEqualsSelectivity(RexCall call) {
        return 1.0 / this.getMaxNDV(call);
    }

    private Double computeIsNullSelectivity(RexCall call) {
        Join join;
        if (this.childRel_ instanceof TableScan && call.getOperands().get(0) instanceof RexInputRef) {
            TableScan tableScan = (TableScan)this.childRel_;
            return (double)this.getNumNulls(call, tableScan) / Math.max(this.mq_.getRowCount((RelNode)tableScan), 1.0);
        }
        if (this.childRel_ instanceof Join && (join = (Join)this.childRel_).getJoinType() != JoinRelType.INNER) {
            return 0.6666666666666667;
        }
        return this.computeEqualsSelectivity(call);
    }

    private Double computeIsNotNullSelectivity(RexCall call) {
        Join join;
        if (this.childRel_ instanceof TableScan && call.getOperands().get(0) instanceof RexInputRef) {
            TableScan tableScan = (TableScan)this.childRel_;
            double noOfNulls = this.getNumNulls(call, tableScan);
            double totalNoOfTuples = this.mq_.getRowCount((RelNode)tableScan);
            return (totalNoOfTuples - noOfNulls) / Math.max(totalNoOfTuples, 1.0);
        }
        if (this.childRel_ instanceof Join && (join = (Join)this.childRel_).getJoinType() != JoinRelType.INNER) {
            return 0.3333333333333333;
        }
        return this.computeNotEqualitySelectivity(call);
    }

    private Double computeInSelectivity(RexCall call) {
        Double selectivity = this.computeEqualsSelectivity(call);
        selectivity = selectivity * (double)(call.operands.size() - 1);
        return Math.min(selectivity, 1.0);
    }

    private Double computeDisjunctionSelectivity(RexCall call) {
        double selectivity = 1.0;
        for (RexNode dje : call.getOperands()) {
            Double tmpCardinality = this.childCardinality_ * this.estimateSelectivity(dje);
            Double tmpSelectivity = tmpCardinality > 1.0 && tmpCardinality < this.childCardinality_ ? 1.0 - tmpCardinality / this.childCardinality_ : 1.0;
            selectivity *= tmpSelectivity.doubleValue();
        }
        if (selectivity < 0.0) {
            selectivity = 0.0;
        }
        return 1.0 - selectivity;
    }

    private Double computeConjunctionSelectivity(RexCall call) {
        double selectivity = 1.0;
        for (RexNode cje : call.getOperands()) {
            selectivity *= this.estimateSelectivity(cje).doubleValue();
        }
        return selectivity;
    }

    private long getNumNulls(RexCall call, TableScan t) {
        Preconditions.checkState((call.getOperator().getKind() == SqlKind.IS_NULL || call.getOperator().getKind() == SqlKind.IS_NOT_NULL ? 1 : 0) != 0);
        Preconditions.checkState((call.getOperands().size() == 1 ? 1 : 0) != 0);
        Preconditions.checkState((boolean)(call.getOperands().get(0) instanceof RexInputRef));
        RexInputRef inputRef = (RexInputRef)call.getOperands().get(0);
        CalciteTable table = (CalciteTable)t.getTable();
        Column column = table.getColumn(inputRef.getIndex());
        return column.getStats() != null ? column.getStats().getNumNulls() : 0L;
    }

    private Double getMaxNDV(RexCall call) {
        HashSet<Integer> inputRefs = new HashSet<Integer>();
        for (RexNode op : call.getOperands()) {
            inputRefs.addAll(RexInputRefCollector.getInputRefs(op));
        }
        double maxNDV = 1.0;
        for (Integer index : inputRefs) {
            maxNDV = Math.max(this.getDistinctRowCount(index), maxNDV);
        }
        return maxNDV;
    }

    private Double getDistinctRowCount(int indx) {
        ImmutableBitSet bitSetOfRqdProj = ImmutableBitSet.of((int)indx);
        return this.mq_.getDistinctRowCount(this.childRel_, bitSetOfRqdProj, (RexNode)this.childRel_.getCluster().getRexBuilder().makeLiteral(true));
    }
}

