/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.schema;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptAbstractTable;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlAccessType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.SqlModality;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BaseTableRef;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.calcite.rel.util.ImpalaBaseTableRef;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.calcite.type.ImpalaTypeSystemImpl;
import org.apache.impala.calcite.util.SimplifiedAnalyzer;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.Pair;
import org.apache.impala.common.UnsupportedFeatureException;
import org.apache.impala.planner.HdfsEstimatedMissingTableStats;
import org.apache.impala.planner.HdfsPartitionPruner;
import org.apache.impala.util.AcidUtils;

public class CalciteTable
extends RelOptAbstractTable
implements Table,
Prepare.PreparingTable {
    private final FeFsTable table_;
    private final Map<Integer, Integer> impalaPositionMap_;
    private final List<String> qualifiedTableName_;
    private final List<Column> columns_;
    private final SimplifiedAnalyzer analyzer_;
    private final HdfsEstimatedMissingTableStats estimatedMissingStats_;

    public CalciteTable(FeTable table, CalciteCatalogReader reader, Analyzer analyzer) throws ImpalaException {
        super((RelOptSchema)reader, table.getName(), CalciteTable.buildColumnsForRelDataType(table));
        this.table_ = (FeFsTable)table;
        this.qualifiedTableName_ = table.getTableName().toPath();
        this.columns_ = table.getColumnsInHiveOrder();
        this.impalaPositionMap_ = this.buildPositionMap();
        this.analyzer_ = (SimplifiedAnalyzer)analyzer;
        this.estimatedMissingStats_ = this.table_.getNumRows() < 0L ? new HdfsEstimatedMissingTableStats(analyzer.getQueryOptions(), this.table_, this.table_.loadAllPartitions(), -1L) : null;
        this.checkIfTableIsSupported(table);
    }

    public static RelDataType buildColumnsForRelDataType(FeTable table) throws ImpalaException {
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl((RelDataTypeSystem)new ImpalaTypeSystemImpl());
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder((RelDataTypeFactory)typeFactory);
        for (Column column : table.getColumnsInHiveOrder()) {
            if (column.getType().isComplexType()) {
                throw new UnsupportedFeatureException("Calcite does not support complex types yet.");
            }
            RelDataType type = ImpalaTypeConverter.createRelDataType((RelDataTypeFactory)typeFactory, column.getType());
            builder.add(column.getName(), type);
        }
        return builder.build();
    }

    private void checkIfTableIsSupported(FeTable table) throws ImpalaException {
        if (table instanceof FeView) {
            throw new UnsupportedFeatureException("Views are not supported yet.");
        }
        if (!(table instanceof FeFsTable)) {
            String tableType = table.getClass().getSimpleName().replace("Table", "");
            throw new UnsupportedFeatureException(tableType + " tables are not supported yet.");
        }
    }

    public BaseTableRef createBaseTableRef(SimplifiedAnalyzer analyzer) throws ImpalaException {
        TableRef tblRef = new TableRef(this.qualifiedTableName_, null);
        Path resolvedPath = analyzer.resolvePath(tblRef.getPath(), Path.PathType.TABLE_REF);
        ImpalaBaseTableRef baseTblRef = new ImpalaBaseTableRef(tblRef, resolvedPath, analyzer);
        baseTblRef.analyze(analyzer);
        return baseTblRef;
    }

    public List<? extends FeFsPartition> getPrunedPartitions(Analyzer analyzer, TupleDescriptor tupleDesc) throws ImpalaException {
        HdfsPartitionPruner pruner = new HdfsPartitionPruner(tupleDesc);
        ArrayList conjuncts = new ArrayList();
        Pair impalaPair = pruner.prunePartitions(analyzer, conjuncts, true, null);
        return (List)impalaPair.first;
    }

    public FeFsTable getFeFsTable() {
        return this.table_;
    }

    public List<String> getQualifiedName() {
        return this.qualifiedTableName_;
    }

    public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, SqlNode parent, CalciteConnectionConfig config) {
        return true;
    }

    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.TABLE;
    }

    public boolean isRolledUp(String column) {
        return false;
    }

    public Statistic getStatistic() {
        return null;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return this.getRowType();
    }

    public <T> T unwrap(Class<T> arg0) {
        return arg0.isInstance((Object)this) ? (T)arg0.cast((Object)this) : null;
    }

    public boolean columnHasDefaultValue(RelDataType rowType, int ordinal, InitializerContext initializerContext) {
        throw new UnsupportedOperationException();
    }

    public boolean isTemporal() {
        return false;
    }

    public boolean supportsModality(SqlModality modality) {
        return true;
    }

    public SqlAccessType getAllowedAccess() {
        return SqlAccessType.ALL;
    }

    public SqlMonotonicity getMonotonicity(String columnName) {
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    public double getRowCount() {
        if ((double)this.table_.getNumRows() >= 0.0) {
            return this.table_.getNumRows();
        }
        Preconditions.checkNotNull((Object)this.estimatedMissingStats_);
        return this.estimatedMissingStats_.statsNumRows_;
    }

    public List<Column> getColumns() {
        return this.columns_;
    }

    public Column getColumn(int i) {
        return this.columns_.get(i);
    }

    private Map<Integer, Integer> buildPositionMap() {
        HashMap<Integer, Integer> impalaPositionMap = new HashMap<Integer, Integer>();
        int i = 0;
        for (Column column : this.table_.getColumnsInHiveOrder()) {
            impalaPositionMap.put(column.getPosition(), i);
            ++i;
        }
        return impalaPositionMap;
    }

    public int getCalcitePosition(int impalaPosition) {
        return this.impalaPositionMap_.get(impalaPosition);
    }

    public int getNumberColumnsIncludingAcid() {
        return this.impalaPositionMap_.keySet().size();
    }

    public boolean canApplyCountStarOptimization(List<String> fieldNames) {
        Set fileFormats = this.table_.getFileFormats();
        if (fileFormats.size() != 1) {
            return false;
        }
        if (!(fileFormats.contains(HdfsFileFormat.ORC) || fileFormats.contains(HdfsFileFormat.PARQUET) || fileFormats.contains(HdfsFileFormat.HUDI_PARQUET))) {
            return false;
        }
        if (AcidUtils.isFullAcidTable((Map)this.table_.getMetaStoreTable().getParameters())) {
            return false;
        }
        return this.isOnlyClusteredCols(fieldNames);
    }

    public boolean isOnlyClusteredCols(List<String> fieldNames) {
        for (int i = 0; i < fieldNames.size(); ++i) {
            if (this.table_.isClusteringColumn(this.table_.getColumn(fieldNames.get(i)))) continue;
            return false;
        }
        return true;
    }
}

