/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.schema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.calcite.schema.CalciteTable;
import org.apache.impala.calcite.schema.ImpalaViewTable;
import org.apache.impala.calcite.type.ImpalaTypeSystemImpl;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.local.LocalFsTable;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.UnsupportedFeatureException;

public class CalciteDb
extends AbstractSchema {
    private final Map<String, Table> tableMap_;

    private CalciteDb(Map<String, Table> tableMap) {
        this.tableMap_ = tableMap;
    }

    protected Map<String, Table> getTableMap() {
        return this.tableMap_;
    }

    public static class Builder {
        private CalciteCatalogReader reader_;
        private final Map<String, Table> tableMap_ = new HashMap<String, Table>();

        public Builder(CalciteCatalogReader reader) {
            this.reader_ = reader;
        }

        public Builder addTable(String tableName, FeTable table, Analyzer analyzer) throws ImpalaException {
            if (this.tableMap_.containsKey(tableName)) {
                return this;
            }
            if (table instanceof LocalFsTable || table instanceof HdfsTable) {
                this.tableMap_.put(tableName.toLowerCase(), new CalciteTable(table, this.reader_, analyzer));
                return this;
            }
            if (table instanceof FeView) {
                this.tableMap_.put(tableName.toLowerCase(), (Table)Builder.createViewTable(table));
                return this;
            }
            throw new UnsupportedFeatureException("Table " + table.getFullName() + " has unsupported type " + table.getClass().getSimpleName() + ". The Calcite planner only supports HdfsTable's and FeView's.");
        }

        private static ViewTable createViewTable(FeTable feTable) throws ImpalaException {
            RelDataType rowType = CalciteTable.buildColumnsForRelDataType(feTable);
            JavaTypeFactory typeFactory = (JavaTypeFactory)ImpalaTypeSystemImpl.TYPE_FACTORY;
            Type elementType = typeFactory.getJavaClass(rowType);
            return new ImpalaViewTable(elementType, RelDataTypeImpl.proto((RelDataType)rowType), ((FeView)feTable).getQueryStmt().toSql(), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)feTable.getDb().getName().toLowerCase(), (Object)feTable.getName().toLowerCase()), (FeView)feTable);
        }

        public CalciteDb build() {
            return new CalciteDb((Map)ImmutableMap.copyOf(this.tableMap_));
        }
    }
}

