/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.impala.calcite.operators.ImpalaAggOperator;
import org.apache.impala.calcite.operators.ImpalaCustomOperatorTable;
import org.apache.impala.calcite.operators.ImpalaOperator;

public class RewriteRexOverRule
extends RelOptRule {
    private final RelFactories.ProjectFactory projectFactory = RelFactories.DEFAULT_PROJECT_FACTORY;
    public static final RewriteRexOverRule INSTANCE = new RewriteRexOverRule();

    private RewriteRexOverRule() {
        super(RewriteRexOverRule.operand(Project.class, (RelOptRuleOperandChildren)RewriteRexOverRule.any()));
    }

    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        RelNode input = project.getInput();
        RexBuilder rexBuilder = project.getCluster().getRexBuilder();
        RexOverReplacer replacer = new RexOverReplacer(rexBuilder);
        ArrayList<RexNode> exprs = new ArrayList<RexNode>();
        for (RexNode r : project.getProjects()) {
            exprs.add(replacer.apply(r));
        }
        if (!replacer.replacedValue) {
            return;
        }
        RelNode newProject = this.projectFactory.createProject(input, Collections.emptyList(), exprs, project.getRowType().getFieldNames());
        call.transformTo(newProject);
    }

    private static class RexOverReplacer
    extends RexShuttle {
        public boolean replacedValue;
        private final RexBuilder rexBuilder;

        public RexOverReplacer(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitOver(RexOver over) {
            if (over.getOperator().getName().toLowerCase().equals("percent_rank")) {
                this.replacedValue = true;
                return this.replacePercentRank(over);
            }
            if (over.getOperator().getName().toLowerCase().equals("cume_dist")) {
                this.replacedValue = true;
                return this.replaceCumeDist(over);
            }
            if (over.getOperator().getName().toLowerCase().equals("ntile")) {
                this.replacedValue = true;
                return this.replaceNTile(over);
            }
            return super.visitOver(over);
        }

        public RexNode replaceCumeDist(RexOver over) {
            ImmutableList<RexFieldCollation> reversedCollation = RexOverReplacer.reverseCollation((List<RexFieldCollation>)over.getWindow().orderKeys);
            RelDataType bigintType = this.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
            RexNode rankNode = this.rexBuilder.makeOver(bigintType, (SqlAggFunction)SqlStdOperatorTable.RANK, over.getOperands(), (List)over.getWindow().partitionKeys, reversedCollation, over.getWindow().getLowerBound(), over.getWindow().getUpperBound(), over.getWindow().isRows(), true, false, over.isDistinct(), over.ignoreNulls());
            RexNode countNode = this.rexBuilder.makeOver(bigintType, ImpalaCustomOperatorTable.COUNT, over.getOperands(), (List)over.getWindow().partitionKeys, ImmutableList.of(), over.getWindow().getLowerBound(), over.getWindow().getUpperBound(), over.getWindow().isRows(), true, false, over.isDistinct(), over.ignoreNulls());
            RexNode one = this.rexBuilder.makeCast(bigintType, (RexNode)this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(1L)));
            RexNode countMinusRank = this.rexBuilder.makeCall((SqlOperator)ImpalaCustomOperatorTable.MINUS, new RexNode[]{countNode, rankNode});
            RexNode countMinusRankPlusOne = this.rexBuilder.makeCall((SqlOperator)ImpalaCustomOperatorTable.PLUS, new RexNode[]{countMinusRank, one});
            RexNode numeratorDouble = this.rexBuilder.makeCast(over.type, countMinusRankPlusOne);
            RexNode denominatorDouble = this.rexBuilder.makeCast(over.type, countNode);
            return this.rexBuilder.makeCall((SqlOperator)ImpalaCustomOperatorTable.DIVIDE, new RexNode[]{numeratorDouble, denominatorDouble});
        }

        public RexNode replacePercentRank(RexOver over) {
            RelDataType bigintType = this.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
            RexNode rankNode = this.rexBuilder.makeOver(bigintType, (SqlAggFunction)SqlStdOperatorTable.RANK, over.getOperands(), (List)over.getWindow().partitionKeys, over.getWindow().orderKeys, over.getWindow().getLowerBound(), over.getWindow().getUpperBound(), over.getWindow().isRows(), true, false, over.isDistinct(), over.ignoreNulls());
            RexNode one = this.rexBuilder.makeCast(bigintType, (RexNode)this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(1L)));
            RexNode rankNodeMinusOne = this.rexBuilder.makeCall((SqlOperator)ImpalaCustomOperatorTable.MINUS, new RexNode[]{rankNode, one});
            RexNode rankDouble = this.rexBuilder.makeCast(over.type, rankNodeMinusOne);
            RexNode countNode = this.rexBuilder.makeOver(bigintType, ImpalaCustomOperatorTable.COUNT, over.getOperands(), (List)over.getWindow().partitionKeys, ImmutableList.of(), over.getWindow().getLowerBound(), over.getWindow().getUpperBound(), over.getWindow().isRows(), true, false, over.isDistinct(), over.ignoreNulls());
            RexNode countNodeMinusOne = this.rexBuilder.makeCall((SqlOperator)ImpalaCustomOperatorTable.MINUS, new RexNode[]{countNode, one});
            RexNode countDouble = this.rexBuilder.makeCast(over.type, countNodeMinusOne);
            RexNode rankDivCount = this.rexBuilder.makeCall((SqlOperator)ImpalaCustomOperatorTable.DIVIDE, new RexNode[]{rankDouble, countDouble});
            RexNode caseCountOne = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{countNode, one});
            RexNode zeroDouble = this.rexBuilder.makeCast(over.type, (RexNode)this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(0L)));
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{caseCountOne, zeroDouble, rankDivCount});
        }

        public RexNode replaceNTile(RexOver over) {
            RelDataType bigintType = this.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
            RexNode rowNumberNode = this.rexBuilder.makeOver(bigintType, (SqlAggFunction)SqlStdOperatorTable.ROW_NUMBER, new ArrayList(), (List)over.getWindow().partitionKeys, over.getWindow().orderKeys, over.getWindow().getLowerBound(), over.getWindow().getUpperBound(), over.getWindow().isRows(), true, false, over.isDistinct(), over.ignoreNulls());
            ImmutableList orderKeys = ImmutableList.of();
            RexNode countNode = this.rexBuilder.makeOver(bigintType, ImpalaCustomOperatorTable.COUNT, new ArrayList(), (List)over.getWindow().partitionKeys, orderKeys, over.getWindow().getLowerBound(), over.getWindow().getUpperBound(), over.getWindow().isRows(), true, false, over.isDistinct(), over.ignoreNulls());
            RexNode one = this.rexBuilder.makeCast(bigintType, (RexNode)this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(1L)));
            RexNode zero = this.rexBuilder.makeCast(bigintType, (RexNode)this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(0L)));
            RexNode minCountNTile = this.rexBuilder.makeCall((SqlOperator)new ImpalaAggOperator("least"), new RexNode[]{countNode, (RexNode)over.getOperands().get(0)});
            RexNode rowNumberMinusOne = this.rexBuilder.makeCall((SqlOperator)ImpalaCustomOperatorTable.MINUS, new RexNode[]{rowNumberNode, one});
            RexNode numeratorInt = this.rexBuilder.makeCall((SqlOperator)ImpalaCustomOperatorTable.MULTIPLY, new RexNode[]{minCountNTile, rowNumberMinusOne});
            RexNode NTileMinusOne = this.rexBuilder.makeCall((SqlOperator)new ImpalaOperator("int_divide"), new RexNode[]{numeratorInt, countNode});
            return this.rexBuilder.makeCall(over.getType(), (SqlOperator)ImpalaCustomOperatorTable.PLUS, (List)ImmutableList.of((Object)NTileMinusOne, (Object)one));
        }

        private static ImmutableList<RexFieldCollation> reverseCollation(List<RexFieldCollation> collationList) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (RexFieldCollation collation : collationList) {
                ImmutableSet.Builder directionBuilder = ImmutableSet.builder();
                switch (collation.getDirection()) {
                    case ASCENDING: 
                    case STRICTLY_ASCENDING: {
                        directionBuilder.add((Object)SqlKind.DESCENDING);
                    }
                }
                if (collation.getNullDirection() == RelFieldCollation.NullDirection.FIRST) {
                    directionBuilder.add((Object)SqlKind.NULLS_LAST);
                }
                builder.add((Object)new RexFieldCollation((RexNode)collation.getKey(), (Set)directionBuilder.build()));
            }
            return builder.build();
        }
    }
}

