/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rules;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.impala.calcite.operators.ImpalaOperator;
import org.apache.impala.calcite.rules.ImmutableImpalaMinusToDistinctRule;
import org.immutables.value.Value;

@Value.Enclosing
public class ImpalaMinusToDistinctRule
extends RelRule<Config>
implements TransformationRule {
    protected ImpalaMinusToDistinctRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        Minus minus = (Minus)call.rel(0);
        if (minus.all) {
            return;
        }
        RelOptCluster cluster = minus.getCluster();
        RelBuilder relBuilder = call.builder();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        int branchCount = minus.getInputs().size();
        for (int i = 0; i < branchCount; ++i) {
            relBuilder.push(minus.getInput(i));
            relBuilder.projectPlus(new RexNode[]{relBuilder.literal((Object)new BigDecimal(i))});
        }
        relBuilder.union(true, branchCount);
        RelNode union = relBuilder.peek();
        int originalFieldCnt = union.getRowType().getFieldCount() - 1;
        ImmutableList.Builder projects = ImmutableList.builder();
        projects.addAll((Iterable)Util.first((List)relBuilder.fields(), (int)originalFieldCnt));
        for (int i = 0; i < branchCount; ++i) {
            RexNode equalsNode = relBuilder.equals((RexNode)relBuilder.field(originalFieldCnt), (RexNode)relBuilder.literal((Object)new BigDecimal(i)));
            RexLiteral one = relBuilder.literal((Object)new BigDecimal(1));
            RexNode ifOp = rexBuilder.makeCall((SqlOperator)new ImpalaOperator("if"), (List)ImmutableList.of((Object)equalsNode, (Object)one, (Object)rexBuilder.makeNullLiteral(one.getType())));
            projects.add((Object)ifOp);
        }
        relBuilder.project((Iterable)projects.build());
        ImmutableList.Builder aggCalls = ImmutableList.builder();
        for (int i = 0; i < branchCount; ++i) {
            aggCalls.add((Object)relBuilder.count(new RexNode[]{relBuilder.field(originalFieldCnt + i)}));
        }
        ImmutableBitSet groupSet = ImmutableBitSet.range((int)originalFieldCnt);
        relBuilder.aggregate(relBuilder.groupKey(groupSet), (Iterable)aggCalls.build());
        ImmutableList.Builder filters = ImmutableList.builder();
        for (int i = 0; i < branchCount; ++i) {
            SqlBinaryOperator operator = i == 0 ? SqlStdOperatorTable.GREATER_THAN : SqlStdOperatorTable.EQUALS;
            filters.add((Object)rexBuilder.makeCall((SqlOperator)operator, new RexNode[]{relBuilder.field(originalFieldCnt + i), relBuilder.literal((Object)new BigDecimal(0))}));
        }
        relBuilder.filter((Iterable)filters.build());
        relBuilder.project((Iterable)Util.first((List)relBuilder.fields(), (int)originalFieldCnt));
        call.transformTo(relBuilder.build());
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableImpalaMinusToDistinctRule.Config.builder().operandSupplier(b -> b.operand(LogicalMinus.class).anyInputs()).build();

        default public ImpalaMinusToDistinctRule toRule() {
            return new ImpalaMinusToDistinctRule(this);
        }
    }
}

