/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rules;

import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.rules.JoinProjectTransposeRule;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Enclosing
public class ImpalaJoinProjectTransposeRule
extends JoinProjectTransposeRule {
    protected static final Logger LOG = LoggerFactory.getLogger((String)ImpalaJoinProjectTransposeRule.class.getName());
    public static ImpalaJoinProjectTransposeRule LEFT_OUTER = new ImpalaJoinProjectTransposeRule(JoinProjectTransposeRule.Config.LEFT_OUTER);
    public static ImpalaJoinProjectTransposeRule RIGHT_OUTER = new ImpalaJoinProjectTransposeRule(JoinProjectTransposeRule.Config.RIGHT_OUTER);

    public ImpalaJoinProjectTransposeRule(JoinProjectTransposeRule.Config config) {
        super(config);
    }

    public void onMatch(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        if (join.getJoinType() == JoinRelType.SEMI) {
            return;
        }
        if (this.hasLeftChild(call) && !this.hasJoinChild(call.rel(1))) {
            return;
        }
        if (this.hasRightChild(call) && !this.hasJoinChild(call.rel(2))) {
            return;
        }
        super.onMatch(call);
    }

    private boolean hasJoinChild(RelNode relNode) {
        if (relNode instanceof HepRelVertex) {
            relNode = ((HepRelVertex)relNode).getCurrentRel();
        }
        if (relNode instanceof Join) {
            return true;
        }
        if (relNode instanceof Filter || relNode instanceof Project) {
            return this.hasJoinChild(relNode.getInput(0));
        }
        return false;
    }
}

