/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rules;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.util.ImmutableBitSet;

public class ExtractLiteralAgg
extends RelOptRule {
    public ExtractLiteralAgg() {
        super(ExtractLiteralAgg.operand(LogicalAggregate.class, (RelOptRuleOperandChildren)ExtractLiteralAgg.none()));
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalAggregate aggregate = (LogicalAggregate)call.rel(0);
        if (this.hasSingleLiteralAgg(aggregate.getAggCallList())) {
            LogicalAggregate newAggregate = LogicalAggregate.create((RelNode)aggregate.getInput(), (List)aggregate.getHints(), (ImmutableBitSet)aggregate.getGroupSet(), (List)aggregate.getGroupSets(), new ArrayList());
            RexBuilder rexBuilder = aggregate.getCluster().getRexBuilder();
            ArrayList<Object> projects = new ArrayList<Object>();
            for (int i = 0; i < aggregate.getRowType().getFieldCount() - 1; ++i) {
                projects.add(rexBuilder.makeInputRef((RelNode)aggregate, i));
            }
            AggregateCall aggCall = (AggregateCall)aggregate.getAggCallList().get(0);
            Preconditions.checkState((boolean)(aggCall.rexList.get(0) instanceof RexLiteral));
            projects.add(aggCall.rexList.get(0));
            LogicalProject projectRelNode = LogicalProject.create((RelNode)newAggregate, new ArrayList(), projects, (List)aggregate.getRowType().getFieldNames(), new HashSet());
            call.transformTo((RelNode)projectRelNode);
        }
    }

    private boolean hasSingleLiteralAgg(List<AggregateCall> aggCallList) {
        if (aggCallList.size() != 1) {
            return false;
        }
        AggregateCall aggCall = aggCallList.get(0);
        return aggCall.getAggregation().getName().equals("LITERAL_AGG");
    }
}

