/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;

public class CombineValuesNodesRule
extends RelOptRule {
    public CombineValuesNodesRule() {
        super(CombineValuesNodesRule.operand(LogicalUnion.class, (RelOptRuleOperandChildren)CombineValuesNodesRule.none()));
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalUnion union = (LogicalUnion)call.rel(0);
        ArrayList<Object> newRelNodes = new ArrayList<Object>();
        RelDataType rowType = union.getRowType();
        ImmutableList.Builder rowBuilder = new ImmutableList.Builder();
        int numTuples = 0;
        for (RelNode input : union.getInputs()) {
            RelNode realInput;
            RelNode relNode = realInput = input instanceof HepRelVertex ? ((HepRelVertex)input).getCurrentRel() : input;
            if (realInput instanceof LogicalValues) {
                rowBuilder.addAll((Iterable)((LogicalValues)realInput).getTuples());
                ++numTuples;
                continue;
            }
            newRelNodes.add(input);
        }
        if (numTuples > 1) {
            LogicalValues newValues = LogicalValues.create((RelOptCluster)union.getCluster(), (RelDataType)rowType, (ImmutableList)rowBuilder.build());
            newRelNodes.add(newValues);
            LogicalUnion newUnion = union.copy(union.getTraitSet(), newRelNodes, union.all);
            call.transformTo((RelNode)newUnion);
        }
    }
}

