/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rel.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaException;

public class TupleDescriptorFactory {
    private final String tupleLabel;
    private final List<RelDataTypeField> relDataTypeFields;
    private final List<String> fieldLabels;

    public TupleDescriptorFactory(String tupleLabel, List<Expr> exprList, RelDataType rowType) {
        this(tupleLabel, TupleDescriptorFactory.getLabelsFromExprs(exprList), rowType.getFieldList());
    }

    public TupleDescriptorFactory(String tupleLabel, RelDataType rowType) {
        this(tupleLabel, TupleDescriptorFactory.getLabelsFromRelDataType(rowType), rowType.getFieldList());
    }

    private TupleDescriptorFactory(String tupleLabel, List<String> fieldLabels, List<RelDataTypeField> relDataTypeFields) {
        this.tupleLabel = tupleLabel;
        this.fieldLabels = fieldLabels;
        this.relDataTypeFields = relDataTypeFields;
        Preconditions.checkArgument((fieldLabels.size() == relDataTypeFields.size() ? 1 : 0) != 0);
    }

    public TupleDescriptor create(Analyzer analyzer) throws ImpalaException {
        TupleDescriptor tupleDesc = analyzer.getDescTbl().createTupleDescriptor(this.tupleLabel);
        tupleDesc.setIsMaterialized(true);
        for (int i = 0; i < this.relDataTypeFields.size(); ++i) {
            RelDataTypeField relDataTypeField = this.relDataTypeFields.get(i);
            String fieldLabel = this.fieldLabels.get(i);
            SlotDescriptor slotDesc = analyzer.addSlotDescriptor(tupleDesc);
            Type impalaType = ImpalaTypeConverter.createImpalaType(relDataTypeField.getType());
            slotDesc.setType(impalaType);
            slotDesc.setLabel(fieldLabel);
            slotDesc.setIsMaterialized(true);
        }
        tupleDesc.computeMemLayout();
        return tupleDesc;
    }

    private static List<String> getLabelsFromExprs(List<Expr> exprs) {
        ArrayList<String> fieldLabels = new ArrayList<String>();
        for (Expr expr : exprs) {
            fieldLabels.add(expr.toSql());
        }
        return fieldLabels;
    }

    private static List<String> getLabelsFromRelDataType(RelDataType rowType) {
        ArrayList<String> fieldLabels = new ArrayList<String>();
        for (RelDataTypeField field : rowType.getFieldList()) {
            fieldLabels.add(field.getName());
        }
        return fieldLabels;
    }
}

