/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rel.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rex.RexBuilder;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.calcite.rel.util.ExprConjunctsConverter;
import org.apache.impala.calcite.schema.CalciteTable;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.Pair;
import org.apache.impala.planner.HdfsPartitionPruner;

public class PrunedPartitionHelper {
    private final List<? extends FeFsPartition> prunedPartitions_;
    private final List<Expr> partitionedConjuncts_;
    private final List<Expr> nonPartitionedConjuncts_;

    public PrunedPartitionHelper(CalciteTable table, ExprConjunctsConverter converter, TupleDescriptor tupleDesc, RexBuilder rexBuilder, Analyzer analyzer) throws ImpalaException {
        HdfsPartitionPruner pruner = new HdfsPartitionPruner(tupleDesc);
        List<Expr> conjuncts = converter.getImpalaConjuncts();
        Pair impalaPair = pruner.prunePartitions(analyzer, new ArrayList<Expr>(conjuncts), true, null);
        this.prunedPartitions_ = (List)impalaPair.first;
        ImmutableList.Builder partitionedConjBuilder = new ImmutableList.Builder();
        ImmutableList.Builder nonPartitionedConjBuilder = new ImmutableList.Builder();
        List partitionSlots = tupleDesc.getPartitionSlots();
        for (Expr conjunct : conjuncts) {
            if (HdfsPartitionPruner.isPartitionPrunedFilterConjunct((List)partitionSlots, (Expr)conjunct)) {
                partitionedConjBuilder.add((Object)conjunct);
                continue;
            }
            nonPartitionedConjBuilder.add((Object)conjunct);
        }
        this.partitionedConjuncts_ = partitionedConjBuilder.build();
        this.nonPartitionedConjuncts_ = nonPartitionedConjBuilder.build();
    }

    public List<? extends FeFsPartition> getPrunedPartitions() {
        return this.prunedPartitions_;
    }

    public List<Expr> getPartitionedConjuncts() {
        return this.partitionedConjuncts_;
    }

    public List<Expr> getNonPartitionedConjuncts() {
        return this.nonPartitionedConjuncts_;
    }
}

