/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rel.node;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.impala.calcite.rel.node.ImpalaAggRel;
import org.apache.impala.calcite.rel.node.ImpalaPlanRel;
import org.apache.impala.planner.PlannerContext;

public class ParentPlanRelContext {
    public final PlannerContext ctx_;
    public final RexNode filterCondition_;
    public final ImmutableBitSet inputRefs_;
    public final ImpalaPlanRel.RelNodeType parentType_;
    public final RelDataType parentRowType_;
    public ImpalaAggRel parentAggregate_;

    private ParentPlanRelContext(PlannerContext plannerContext) {
        this.ctx_ = plannerContext;
        this.filterCondition_ = null;
        this.inputRefs_ = null;
        this.parentType_ = null;
        this.parentRowType_ = null;
        this.parentAggregate_ = null;
    }

    private ParentPlanRelContext(Builder builder) {
        this.ctx_ = builder.context_;
        this.filterCondition_ = builder.filterCondition_;
        this.inputRefs_ = builder.inputRefs_;
        this.parentType_ = builder.parentType_;
        this.parentRowType_ = builder.parentRowType_;
        this.parentAggregate_ = builder.parentAggregate_;
    }

    public static ParentPlanRelContext createRootContext(PlannerContext context) {
        return new ParentPlanRelContext(context);
    }

    public static class Builder {
        private PlannerContext context_;
        private RexNode filterCondition_;
        private ImmutableBitSet inputRefs_;
        private ImpalaPlanRel.RelNodeType parentType_;
        private RelDataType parentRowType_;
        private ImpalaAggRel parentAggregate_;

        public Builder(PlannerContext plannerContext) {
            this.context_ = plannerContext;
            this.parentType_ = null;
        }

        public Builder(ParentPlanRelContext planRelContext, ImpalaPlanRel planRel) {
            this.context_ = planRelContext.ctx_;
            this.filterCondition_ = planRelContext.filterCondition_;
            this.parentType_ = planRel.relNodeType();
            this.parentAggregate_ = ImpalaPlanRel.canPassThroughParentAggregate(planRel) ? planRelContext.parentAggregate_ : null;
        }

        public void setFilterCondition(RexNode filterCondition) {
            this.filterCondition_ = filterCondition;
        }

        public void setInputRefs(ImmutableBitSet inputRefs) {
            this.inputRefs_ = inputRefs;
        }

        public void setParentRowType(RelDataType parentRowType) {
            this.parentRowType_ = parentRowType;
        }

        public void setParentType(ImpalaPlanRel.RelNodeType parentType) {
            this.parentType_ = parentType;
        }

        public void setParentAggregate(ImpalaAggRel parentAggregate) {
            this.parentAggregate_ = parentAggregate;
        }

        public ParentPlanRelContext build() {
            return new ParentPlanRelContext(this);
        }
    }
}

