/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rel.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.calcite.rel.node.NodeWithExprs;
import org.apache.impala.calcite.rel.node.ParentPlanRelContext;
import org.apache.impala.calcite.rel.phys.ImpalaUnionNode;
import org.apache.impala.calcite.rel.util.ExprConjunctsConverter;
import org.apache.impala.calcite.rel.util.TupleDescriptorFactory;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.EmptySetNode;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.SelectNode;

public class NodeCreationUtils {
    public static NodeWithExprs createSelectNode(RexNode filterCondition, Analyzer analyzer, NodeWithExprs nodeWithExprs, PlanNodeId nodeId, RexBuilder rexBuilder) throws ImpalaException {
        Preconditions.checkNotNull((Object)filterCondition);
        ExprConjunctsConverter converter = new ExprConjunctsConverter(filterCondition, nodeWithExprs.outputExprs_, rexBuilder, analyzer);
        List<Expr> filterConjuncts = converter.getImpalaConjuncts();
        SelectNode selectNode = SelectNode.createFromCalcite((PlanNodeId)nodeId, (PlanNode)nodeWithExprs.planNode_, filterConjuncts);
        selectNode.init(analyzer);
        return new NodeWithExprs((PlanNode)selectNode, nodeWithExprs);
    }

    public static NodeWithExprs createEmptySetPlanNode(PlanNodeId nodeId, Analyzer analyzer, RelDataType rowType) throws ImpalaException {
        TupleDescriptorFactory tupleDescFactory = new TupleDescriptorFactory("empty set", rowType);
        TupleDescriptor tupleDesc = tupleDescFactory.create(analyzer);
        EmptySetNode emptySetNode = new EmptySetNode(nodeId, (List)ImmutableList.of((Object)tupleDesc.getId()));
        emptySetNode.init(analyzer);
        List<Expr> outputExprs = NodeCreationUtils.createOutputExprs(tupleDesc.getSlots());
        return new NodeWithExprs((PlanNode)emptySetNode, outputExprs, rowType.getFieldNames());
    }

    public static NodeWithExprs createUnionPlanNode(PlanNodeId nodeId, Analyzer analyzer, RelDataType rowType, List<NodeWithExprs> childrenPlanNodes, boolean unionAll) throws ImpalaException {
        TupleDescriptorFactory tupleDescFactory = new TupleDescriptorFactory("union", rowType);
        TupleDescriptor tupleDesc = tupleDescFactory.create(analyzer);
        List<Expr> outputExprs = NodeCreationUtils.createOutputExprs(tupleDesc.getSlots());
        if (unionAll) {
            NodeCreationUtils.registerUnionValueTransfers(analyzer, outputExprs, childrenPlanNodes);
        }
        ImpalaUnionNode unionNode = new ImpalaUnionNode(nodeId, tupleDesc.getId(), outputExprs, childrenPlanNodes);
        unionNode.init(analyzer);
        return new NodeWithExprs((PlanNode)unionNode, outputExprs, rowType.getFieldNames());
    }

    public static List<Expr> createOutputExprs(List<SlotDescriptor> slotDescs) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (SlotDescriptor slotDesc : slotDescs) {
            slotDesc.setIsMaterialized(true);
            builder.add((Object)new SlotRef(slotDesc));
        }
        return builder.build();
    }

    public static NodeWithExprs wrapInSelectNodeIfNeeded(ParentPlanRelContext context, NodeWithExprs planNode, RexBuilder rexBuilder) throws ImpalaException {
        return context.filterCondition_ != null ? NodeCreationUtils.createSelectNode(context.filterCondition_, context.ctx_.getRootAnalyzer(), planNode, context.ctx_.getNextNodeId(), rexBuilder) : planNode;
    }

    private static void registerUnionValueTransfers(Analyzer analyzer, List<Expr> outputExprs, List<NodeWithExprs> childrenPlanNodes) {
        for (NodeWithExprs nodeWithExprs : childrenPlanNodes) {
            Preconditions.checkState((outputExprs.size() == nodeWithExprs.outputExprs_.size() ? 1 : 0) != 0);
        }
        for (int i = 0; i < outputExprs.size(); ++i) {
            SlotRef unionExpr = outputExprs.get(i).unwrapSlotRef(false);
            if (unionExpr == null) continue;
            for (NodeWithExprs nodeWithExprs : childrenPlanNodes) {
                SlotRef inputExpr = nodeWithExprs.outputExprs_.get(i).unwrapSlotRef(false);
                if (inputExpr == null) continue;
                analyzer.registerValueTransfer(unionExpr.getSlotId(), inputExpr.getSlotId());
            }
        }
    }
}

