/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rel.node;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.calcite.functions.AnalyzedNullLiteral;
import org.apache.impala.calcite.rel.node.ImpalaPlanRel;
import org.apache.impala.calcite.rel.node.NodeCreationUtils;
import org.apache.impala.calcite.rel.node.NodeWithExprs;
import org.apache.impala.calcite.rel.node.ParentPlanRelContext;
import org.apache.impala.calcite.rel.util.ExprConjunctsConverter;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaValuesRel
extends Values
implements ImpalaPlanRel {
    protected static final Logger LOG = LoggerFactory.getLogger((String)ImpalaValuesRel.class.getName());

    public ImpalaValuesRel(Values values) {
        super(values.getCluster(), values.getRowType(), values.getTuples(), values.getTraitSet());
    }

    @Override
    public NodeWithExprs getPlanNode(ParentPlanRelContext context) throws ImpalaException {
        if (context.parentType_ == ImpalaPlanRel.RelNodeType.UNION && this.getTuples().size() == 1) {
            return this.getValuesExprs(context, (List)this.getTuples().get(0));
        }
        PlanNodeId nodeId = context.ctx_.getNextNodeId();
        RelDataType rowType = context.parentRowType_ != null ? context.parentRowType_ : this.getRowType();
        List<NodeWithExprs> nodeWithExprsList = this.getValuesExprs(context);
        NodeWithExprs retNode = NodeCreationUtils.createUnionPlanNode(nodeId, context.ctx_.getRootAnalyzer(), rowType, nodeWithExprsList, false);
        return NodeCreationUtils.wrapInSelectNodeIfNeeded(context, retNode, this.getCluster().getRexBuilder());
    }

    private List<NodeWithExprs> getValuesExprs(ParentPlanRelContext context) throws ImpalaException {
        ArrayList<NodeWithExprs> nodeWithExprsList = new ArrayList<NodeWithExprs>();
        for (List literals : this.getTuples()) {
            nodeWithExprsList.add(this.getValuesExprs(context, literals));
        }
        return nodeWithExprsList;
    }

    private NodeWithExprs getValuesExprs(ParentPlanRelContext context, List<RexLiteral> literals) throws ImpalaException {
        PlanNode retNode = null;
        ArrayList<Expr> outputExprs = new ArrayList<Expr>();
        int i = 0;
        for (RexLiteral literal : literals) {
            ExprConjunctsConverter converter = new ExprConjunctsConverter((RexNode)literal, new ArrayList<Expr>(), this.getCluster().getRexBuilder(), context.ctx_.getRootAnalyzer());
            if (context.parentRowType_ != null) {
                LiteralExpr literalExpr = this.getLiteralExprWithType((LiteralExpr)converter.getImpalaConjuncts().get(0), ((RelDataTypeField)context.parentRowType_.getFieldList().get(i)).getType(), context.ctx_.getRootAnalyzer());
                outputExprs.add((Expr)literalExpr);
            } else {
                outputExprs.addAll(converter.getImpalaConjuncts());
            }
            ++i;
        }
        return new NodeWithExprs(retNode, outputExprs, this.getRowType().getFieldNames());
    }

    private LiteralExpr getLiteralExprWithType(LiteralExpr expr, RelDataType type, Analyzer analyzer) throws ImpalaException {
        Type impalaType = ImpalaTypeConverter.createImpalaType(type);
        if (expr instanceof NullLiteral) {
            AnalyzedNullLiteral nullLiteral = new AnalyzedNullLiteral(impalaType);
            nullLiteral.analyze(analyzer);
            return nullLiteral;
        }
        return LiteralExpr.createFromUnescapedStr((String)expr.getStringValue(), (Type)impalaType);
    }

    @Override
    public ImpalaPlanRel.RelNodeType relNodeType() {
        return ImpalaPlanRel.RelNodeType.VALUES;
    }
}

