/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rel.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.JoinOperator;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.analysis.TupleIsNullPredicate;
import org.apache.impala.calcite.functions.AnalyzedFunctionCallExpr;
import org.apache.impala.calcite.functions.AnalyzedNullLiteral;
import org.apache.impala.calcite.functions.FunctionResolver;
import org.apache.impala.calcite.rel.node.ImpalaPlanRel;
import org.apache.impala.calcite.rel.node.NodeWithExprs;
import org.apache.impala.calcite.rel.node.ParentPlanRelContext;
import org.apache.impala.calcite.rel.phys.ImpalaHashJoinNode;
import org.apache.impala.calcite.rel.phys.ImpalaHdfsScanNode;
import org.apache.impala.calcite.rel.phys.ImpalaNestedLoopJoinNode;
import org.apache.impala.calcite.rel.util.CreateExprVisitor;
import org.apache.impala.calcite.rel.util.ExprConjunctsConverter;
import org.apache.impala.calcite.rel.util.RexInputRefCollector;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.JoinNode;
import org.apache.impala.planner.PlanNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaJoinRel
extends Join
implements ImpalaPlanRel {
    protected static final Logger LOG = LoggerFactory.getLogger((String)ImpalaJoinRel.class.getName());

    public ImpalaJoinRel(Join join) {
        super(join.getCluster(), join.getTraitSet(), join.getLeft(), join.getRight(), join.getCondition(), join.getJoinType(), new HashSet());
    }

    public ImpalaJoinRel(RelOptCluster cluster, RelTraitSet relTraitSet, RelNode leftInput, RelNode rightInput, RexNode condition, JoinRelType joinType) {
        super(cluster, relTraitSet, leftInput, rightInput, condition, joinType, new HashSet());
    }

    public ImpalaJoinRel copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new ImpalaJoinRel(this.getCluster(), traitSet, left, right, conditionExpr, joinType);
    }

    @Override
    public NodeWithExprs getPlanNode(ParentPlanRelContext context) throws ImpalaException {
        Object joinNode;
        NodeWithExprs leftInput = this.getChildPlanNode(this.getInput(0), context);
        NodeWithExprs rightInput = this.getChildPlanNode(this.getInput(1), context);
        Analyzer analyzer = context.ctx_.getRootAnalyzer();
        JoinOperator joinOp = this.getImpalaJoinOp();
        ArrayList<BinaryPredicate> equiJoinConjuncts = new ArrayList<BinaryPredicate>();
        ArrayList<Expr> otherJoinConjuncts = new ArrayList<Expr>();
        JoinNode.DistributionMode distMode = JoinNode.DistributionMode.NONE;
        ArrayList<Expr> outputExprs = new ArrayList<Expr>();
        outputExprs.addAll(this.getOutputExprs(analyzer, leftInput, true, joinOp));
        outputExprs.addAll(this.getOutputExprs(analyzer, rightInput, false, joinOp));
        if (!this.getCondition().isAlwaysTrue()) {
            List<ConjunctInfo> conjunctInfos = this.getConditionConjuncts(this.getCondition(), leftInput, rightInput, analyzer);
            for (ConjunctInfo conjunctInfo : conjunctInfos) {
                if (conjunctInfo.isEquiJoin_) {
                    equiJoinConjuncts.add((BinaryPredicate)conjunctInfo.conjunct_);
                    continue;
                }
                otherJoinConjuncts.add(conjunctInfo.conjunct_);
            }
        }
        ArrayList<Expr> filterConjuncts = new ArrayList<Expr>();
        if (context.filterCondition_ != null) {
            ExprConjunctsConverter converter = new ExprConjunctsConverter(context.filterCondition_, outputExprs, this.getCluster().getRexBuilder(), analyzer);
            filterConjuncts.addAll(converter.getImpalaConjuncts());
        }
        Object object = joinNode = equiJoinConjuncts.size() == 0 ? new ImpalaNestedLoopJoinNode(context.ctx_.getNextNodeId(), leftInput.planNode_, rightInput.planNode_, false, distMode, joinOp, otherJoinConjuncts, filterConjuncts, analyzer) : new ImpalaHashJoinNode(context.ctx_.getNextNodeId(), leftInput.planNode_, rightInput.planNode_, false, distMode, joinOp, equiJoinConjuncts, otherJoinConjuncts, filterConjuncts, analyzer);
        if (equiJoinConjuncts.size() > 0) {
            ArrayList<BinaryPredicate> equiJoinExprs = new ArrayList<BinaryPredicate>(equiJoinConjuncts);
            this.registerConjuncts(this.getJoinConjunctListToRegister(equiJoinExprs), analyzer, (PlanNode)joinNode);
        }
        return new NodeWithExprs((PlanNode)joinNode, outputExprs, this.getRowType().getFieldNames());
    }

    private NodeWithExprs getChildPlanNode(RelNode relInput, ParentPlanRelContext context) throws ImpalaException {
        ImpalaPlanRel inputPlanRel = (ImpalaPlanRel)relInput;
        ParentPlanRelContext.Builder builder = new ParentPlanRelContext.Builder(context, this);
        builder.setFilterCondition(null);
        return inputPlanRel.getPlanNode(builder.build());
    }

    private List<Expr> getOutputExprs(Analyzer analyzer, NodeWithExprs input, boolean isLeftInput, JoinOperator joinOp) throws ImpalaException {
        if (isLeftInput) {
            if (joinOp == JoinOperator.RIGHT_SEMI_JOIN || joinOp == JoinOperator.RIGHT_ANTI_JOIN) {
                return new ArrayList<Expr>();
            }
            if (joinOp != JoinOperator.RIGHT_OUTER_JOIN && joinOp != JoinOperator.FULL_OUTER_JOIN) {
                return input.outputExprs_;
            }
        } else {
            if (joinOp == JoinOperator.LEFT_SEMI_JOIN || joinOp == JoinOperator.LEFT_ANTI_JOIN) {
                return new ArrayList<Expr>();
            }
            if (joinOp != JoinOperator.LEFT_OUTER_JOIN && joinOp != JoinOperator.FULL_OUTER_JOIN) {
                return input.outputExprs_;
            }
        }
        ArrayList<Expr> wrappedExprs = new ArrayList<Expr>();
        for (Expr expr : input.outputExprs_) {
            Expr exprToAdd = TupleIsNullPredicate.requiresNullWrapping((Expr)expr, (Analyzer)analyzer) ? ImpalaJoinRel.createIfTupleIsNullPredicate(analyzer, expr, input.planNode_.getTupleIds()) : expr;
            wrappedExprs.add(exprToAdd);
        }
        return wrappedExprs;
    }

    private static Expr createIfTupleIsNullPredicate(Analyzer analyzer, Expr expr, List<TupleId> tupleIds) throws ImpalaException {
        ArrayList<Expr> tmpArgs = new ArrayList<Expr>();
        TupleIsNullPredicate tupleIsNullExpr = new TupleIsNullPredicate(tupleIds);
        tupleIsNullExpr.analyze(analyzer);
        tmpArgs.add((Expr)tupleIsNullExpr);
        AnalyzedNullLiteral nullLiteral = new AnalyzedNullLiteral(expr.getType());
        nullLiteral.analyze(analyzer);
        tmpArgs.add((Expr)nullLiteral);
        tmpArgs.add(expr);
        ImmutableList typeNames = ImmutableList.of((Object)Type.BOOLEAN, (Object)expr.getType(), (Object)expr.getType());
        Function conditionalFunc = FunctionResolver.getExactFunction("if", ImpalaTypeConverter.getRelDataTypesForArgs((List<Type>)typeNames));
        Preconditions.checkNotNull((Object)conditionalFunc, (String)"Could not create IF function for arg types %s and return type %s", (Object)typeNames, (Object)expr.getType());
        AnalyzedFunctionCallExpr retExpr = new AnalyzedFunctionCallExpr(conditionalFunc, tmpArgs, expr.getType());
        retExpr.analyze(analyzer);
        return retExpr;
    }

    private JoinOperator getImpalaJoinOp() throws ImpalaException {
        switch (this.getJoinType()) {
            case INNER: {
                return JoinOperator.INNER_JOIN;
            }
            case FULL: {
                return JoinOperator.FULL_OUTER_JOIN;
            }
            case LEFT: {
                return JoinOperator.LEFT_OUTER_JOIN;
            }
            case RIGHT: {
                return JoinOperator.RIGHT_OUTER_JOIN;
            }
            case SEMI: {
                return JoinOperator.LEFT_SEMI_JOIN;
            }
            case ANTI: {
                return JoinOperator.LEFT_ANTI_JOIN;
            }
        }
        throw new AnalysisException("Unsupported join type: " + this.getJoinType());
    }

    public List<Expr> getJoinConjunctListToRegister(List<Expr> joinConjuncts) {
        ArrayList<Expr> conjunctsToRegister = new ArrayList<Expr>();
        for (Expr joinConjunct : joinConjuncts) {
            conjunctsToRegister.addAll(this.getJoinConjunctToRegister(joinConjunct));
        }
        return conjunctsToRegister;
    }

    public List<Expr> getJoinConjunctToRegister(Expr joinConjunct) {
        Preconditions.checkState((joinConjunct.getChildren().size() == 2 ? 1 : 0) != 0);
        ArrayList leftSideSlotRefs = new ArrayList();
        ArrayList rightSideSlotRefs = new ArrayList();
        ((Expr)joinConjunct.getChild(0)).collect(SlotRef.class, leftSideSlotRefs);
        ((Expr)joinConjunct.getChild(1)).collect(SlotRef.class, rightSideSlotRefs);
        if (leftSideSlotRefs.size() == 0) {
            return Lists.newArrayList();
        }
        if (rightSideSlotRefs.size() == 0) {
            return Lists.newArrayList((Object[])new Expr[]{(Expr)joinConjunct.getChild(0)});
        }
        if (leftSideSlotRefs.size() > 1 || rightSideSlotRefs.size() > 1) {
            return Lists.newArrayList((Object[])new Expr[]{(Expr)joinConjunct.getChild(0), (Expr)joinConjunct.getChild(1)});
        }
        if (((SlotRef)leftSideSlotRefs.get(0)).getType() != ((SlotRef)rightSideSlotRefs.get(0)).getType()) {
            return Lists.newArrayList((Object[])new Expr[]{(Expr)joinConjunct.getChild(0), (Expr)joinConjunct.getChild(1)});
        }
        return Lists.newArrayList((Object[])new Expr[]{joinConjunct});
    }

    private List<Expr> getAllInputExprs(NodeWithExprs leftInput, NodeWithExprs rightInput) {
        ArrayList<Expr> allExprs = new ArrayList<Expr>();
        allExprs.addAll(leftInput.outputExprs_);
        allExprs.addAll(rightInput.outputExprs_);
        return allExprs;
    }

    private RexNode getCanonical(RexNode conjunct, int numLHSExprs) {
        if (!conjunct.isA(SqlKind.EQUALS)) {
            return conjunct;
        }
        boolean swapExprs = false;
        MinIndexVisitor visitor = new MinIndexVisitor();
        RexNode lhsRexCall = (RexNode)((RexCall)conjunct).getOperands().get(0);
        RexNode rhsRexCall = (RexNode)((RexCall)conjunct).getOperands().get(1);
        lhsRexCall.accept((RexVisitor)visitor);
        int minIndex = visitor.getMinIndex();
        if (minIndex != Integer.MAX_VALUE) {
            if (minIndex >= numLHSExprs) {
                swapExprs = true;
            }
        } else {
            visitor.reset();
            rhsRexCall.accept((RexVisitor)visitor);
            minIndex = visitor.getMinIndex();
            Preconditions.checkState((minIndex != Integer.MAX_VALUE ? 1 : 0) != 0);
            if (minIndex < numLHSExprs) {
                swapExprs = true;
            }
        }
        if (swapExprs) {
            conjunct = this.getCluster().getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rhsRexCall, lhsRexCall});
        }
        return conjunct;
    }

    private List<ConjunctInfo> getConditionConjuncts(RexNode condition, NodeWithExprs leftInput, NodeWithExprs rightInput, Analyzer analyzer) {
        ArrayList<ConjunctInfo> conjunctInfos = new ArrayList<ConjunctInfo>();
        CreateExprVisitor visitor = new CreateExprVisitor(this.getCluster().getRexBuilder(), this.getAllInputExprs(leftInput, rightInput), analyzer);
        List conjuncts = RelOptUtil.conjunctions((RexNode)this.getCondition());
        for (RexNode conj : conjuncts) {
            conj = this.getCanonical(conj, leftInput.outputExprs_.size());
            Expr impalaConjunct = (Expr)conj.accept((RexVisitor)visitor);
            conjunctInfos.add(new ConjunctInfo(impalaConjunct, this.isEquijoinConjunct(conj, leftInput)));
        }
        return conjunctInfos;
    }

    private boolean isEquijoinConjunct(RexNode conjunct, NodeWithExprs leftInput) {
        if (!conjunct.isA(SqlKind.EQUALS)) {
            return false;
        }
        Preconditions.checkState((boolean)(conjunct instanceof RexCall));
        RexCall call = (RexCall)conjunct;
        RexNode left = (RexNode)call.getOperands().get(0);
        Set<Integer> inputRefs = RexInputRefCollector.getInputRefs(left);
        if (inputRefs.size() == 0) {
            return false;
        }
        for (Integer inputRef : inputRefs) {
            if (inputRef < leftInput.outputExprs_.size()) continue;
            return false;
        }
        RexNode right = (RexNode)call.getOperands().get(1);
        inputRefs = RexInputRefCollector.getInputRefs(right);
        if (inputRefs.size() == 0) {
            return false;
        }
        for (Integer inputRef : inputRefs) {
            if (inputRef >= leftInput.outputExprs_.size()) continue;
            return false;
        }
        return true;
    }

    private void registerConjuncts(List<Expr> equiJoinExprs, Analyzer analyzer, PlanNode joinNode) throws ImpalaException {
        JoinOperator joinOp = this.getImpalaJoinOp();
        if (joinOp == JoinOperator.RIGHT_OUTER_JOIN) {
            List<TableRef> lhsTableRefs = this.getTableRefs((PlanNode)joinNode.getChild(0));
            this.registerOuterJoinedTids(lhsTableRefs, analyzer, joinOp);
        }
        List<TableRef> rhsTableRefs = this.getTableRefs((PlanNode)joinNode.getChild(1));
        if (joinOp == JoinOperator.LEFT_OUTER_JOIN) {
            this.registerOuterJoinedTids(rhsTableRefs, analyzer, joinOp);
        }
        for (TableRef tableRef : rhsTableRefs) {
            analyzer.registerOnClauseConjuncts(equiJoinExprs, tableRef);
        }
    }

    private void registerOuterJoinedTids(List<TableRef> tableRefs, Analyzer analyzer, JoinOperator joinOp) {
        for (TableRef tableRef : tableRefs) {
            analyzer.registerOuterJoinedTids((List)tableRef.getId().asList(), tableRef);
            tableRef.setJoinOp(joinOp);
        }
    }

    private List<TableRef> getTableRefs(PlanNode planNode) {
        if (planNode instanceof ImpalaHdfsScanNode) {
            ImpalaHdfsScanNode scanNode = (ImpalaHdfsScanNode)planNode;
            return Lists.newArrayList((Object[])new TableRef[]{scanNode.getTableRef()});
        }
        ArrayList<TableRef> tableRefs = new ArrayList<TableRef>();
        for (PlanNode child : planNode.getChildren()) {
            tableRefs.addAll(this.getTableRefs(child));
        }
        return tableRefs;
    }

    @Override
    public ImpalaPlanRel.RelNodeType relNodeType() {
        return ImpalaPlanRel.RelNodeType.JOIN;
    }

    private static class MinIndexVisitor
    extends RexVisitorImpl<Void> {
        private int minIndex = Integer.MAX_VALUE;

        public MinIndexVisitor() {
            super(true);
        }

        public Void visitInputRef(RexInputRef inputRef) {
            this.minIndex = Math.min(inputRef.getIndex(), this.minIndex);
            return null;
        }

        public int getMinIndex() {
            return this.minIndex;
        }

        public void reset() {
            this.minIndex = Integer.MAX_VALUE;
        }
    }

    private static class ConjunctInfo {
        public final Expr conjunct_;
        public final boolean isEquiJoin_;

        public ConjunctInfo(Expr conjunct, boolean isEquiJoin) {
            this.conjunct_ = conjunct;
            this.isEquiJoin_ = isEquiJoin;
        }
    }
}

