/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rel.node;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.rel.core.TableScan;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BaseTableRef;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.calcite.rel.node.ImpalaPlanRel;
import org.apache.impala.calcite.rel.node.NodeWithExprs;
import org.apache.impala.calcite.rel.node.ParentPlanRelContext;
import org.apache.impala.calcite.rel.phys.ImpalaHdfsScanNode;
import org.apache.impala.calcite.rel.util.ExprConjunctsConverter;
import org.apache.impala.calcite.rel.util.PrunedPartitionHelper;
import org.apache.impala.calcite.schema.CalciteTable;
import org.apache.impala.calcite.util.SimplifiedAnalyzer;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.UnsupportedFeatureException;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.planner.ScanNode;
import org.apache.impala.planner.SingleNodePlanner;

public class ImpalaHdfsScanRel
extends TableScan
implements ImpalaPlanRel {
    public ImpalaHdfsScanRel(TableScan scan) {
        super(scan.getCluster(), scan.getTraitSet(), (List)scan.getHints(), scan.getTable());
    }

    @Override
    public NodeWithExprs getPlanNode(ParentPlanRelContext context) throws ImpalaException {
        CalciteTable table = (CalciteTable)this.getTable();
        BaseTableRef baseTblRef = table.createBaseTableRef((SimplifiedAnalyzer)context.ctx_.getRootAnalyzer());
        this.produceSlotDescriptorsForTable(baseTblRef, context);
        TupleDescriptor tupleDesc = baseTblRef.getDesc();
        List<Expr> outputExprs = this.createScanOutputExprs(tupleDesc.getSlots());
        Analyzer analyzer = context.ctx_.getRootAnalyzer();
        ExprConjunctsConverter converter = new ExprConjunctsConverter(context.filterCondition_, outputExprs, this.getCluster().getRexBuilder(), analyzer);
        PrunedPartitionHelper pph = new PrunedPartitionHelper(table, converter, tupleDesc, this.getCluster().getRexBuilder(), context.ctx_.getRootAnalyzer());
        List<? extends FeFsPartition> impalaPartitions = pph.getPrunedPartitions();
        List<Expr> partitionConjuncts = pph.getPartitionedConjuncts();
        List<Expr> filterConjuncts = pph.getNonPartitionedConjuncts();
        PlanNodeId nodeId = context.ctx_.getNextNodeId();
        SlotDescriptor countStarDesc = this.canUseCountStarOptimization(table, context, filterConjuncts) ? ScanNode.createCountStarOptimizationDesc((TupleDescriptor)tupleDesc, (Analyzer)analyzer) : null;
        SlotRef countStarOptimizationExpr = countStarDesc != null ? new SlotRef(countStarDesc) : null;
        Object physicalNode = SingleNodePlanner.addAcidSlotsIfNeeded((Analyzer)analyzer, (TableRef)baseTblRef, impalaPartitions) ? SingleNodePlanner.createAcidJoinNode((Analyzer)analyzer, (TableRef)baseTblRef, filterConjuncts, impalaPartitions, partitionConjuncts, (PlannerContext)context.ctx_) : new ImpalaHdfsScanNode(nodeId, tupleDesc, impalaPartitions, (TableRef)baseTblRef, null, partitionConjuncts, filterConjuncts, countStarDesc, this.isPartitionScanOnly(context, table));
        physicalNode.setOutputSmap(new ExprSubstitutionMap());
        physicalNode.init(analyzer);
        return new NodeWithExprs((PlanNode)physicalNode, outputExprs, this.getRowType().getFieldNames(), (Expr)countStarOptimizationExpr);
    }

    private List<Expr> createScanOutputExprs(List<SlotDescriptor> slotDescs) throws ImpalaException {
        CalciteTable calciteTable = (CalciteTable)this.getTable();
        FeFsTable table = calciteTable.getFeFsTable();
        int totalCols = calciteTable.getNumberColumnsIncludingAcid();
        ArrayList<Object> scanOutputExprs = new ArrayList<Object>(Collections.nCopies(totalCols, null));
        for (SlotDescriptor slotDesc : slotDescs) {
            Column impalaColumn = slotDesc.getColumn();
            if (impalaColumn == null) {
                Preconditions.checkState((boolean)slotDesc.getLabel().equals("stats: num_rows"));
                continue;
            }
            Integer calcitePosition = calciteTable.getCalcitePosition(impalaColumn.getPosition());
            if (calcitePosition == null) {
                throw new UnsupportedFeatureException("Calcite does not support column: " + slotDesc.getColumn().getName());
            }
            scanOutputExprs.set(calcitePosition, new SlotRef(slotDesc));
        }
        return scanOutputExprs;
    }

    private void produceSlotDescriptorsForTable(BaseTableRef baseTblRef, ParentPlanRelContext context) throws ImpalaException {
        for (String fieldName : this.getInputRefFieldNames(context)) {
            SlotRef slotref = new SlotRef(Path.createRawPath((String)baseTblRef.getUniqueAlias(), (String)fieldName));
            slotref.analyze(context.ctx_.getRootAnalyzer());
            SlotDescriptor slotDesc = slotref.getDesc();
            if (slotDesc.getType().isComplexType()) {
                throw new UnsupportedFeatureException(String.format(fieldName + " is a complex type (array/map) column. This is not currently supported.", new Object[0]));
            }
            slotDesc.setIsMaterialized(true);
        }
    }

    private SlotDescriptor getCountStarDescriptor(List<SlotDescriptor> slotDescs) {
        Optional<SlotDescriptor> returnVal = slotDescs.stream().filter(n -> n.getLabel().equals("stats: num_rows")).findFirst();
        return returnVal.isPresent() ? returnVal.get() : null;
    }

    private boolean isPartitionScanOnly(ParentPlanRelContext context, CalciteTable table) throws ImpalaException {
        return context.parentAggregate_ != null && context.parentAggregate_.hasDistinctOnly() && table.isOnlyClusteredCols(this.getInputRefFieldNames(context));
    }

    private boolean canUseCountStarOptimization(CalciteTable table, ParentPlanRelContext context, List<Expr> filterConjuncts) {
        if (context.parentAggregate_ == null || !context.parentAggregate_.hasCountStarOnly()) {
            return false;
        }
        if (!table.canApplyCountStarOptimization(this.getInputRefFieldNames(context))) {
            return false;
        }
        return filterConjuncts.size() <= 0;
    }

    private List<String> getInputRefFieldNames(ParentPlanRelContext context) {
        if (context.inputRefs_ == null) {
            return this.getRowType().getFieldNames();
        }
        ArrayList<String> inputRefFieldNames = new ArrayList<String>();
        for (Integer i : context.inputRefs_) {
            inputRefFieldNames.add((String)this.getRowType().getFieldNames().get(i));
        }
        return inputRefFieldNames;
    }

    @Override
    public ImpalaPlanRel.RelNodeType relNodeType() {
        return ImpalaPlanRel.RelNodeType.HDFSSCAN;
    }
}

