/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rel.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.impala.calcite.rel.node.ImpalaPlanRel;
import org.apache.impala.calcite.rel.node.NodeWithExprs;
import org.apache.impala.calcite.rel.node.ParentPlanRelContext;
import org.apache.impala.common.ImpalaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaFilterRel
extends Filter
implements ImpalaPlanRel {
    protected static final Logger LOG = LoggerFactory.getLogger((String)ImpalaFilterRel.class.getName());

    public ImpalaFilterRel(Filter filter) {
        super(filter.getCluster(), filter.getTraitSet(), filter.getInput(), filter.getCondition());
    }

    private ImpalaFilterRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexNode condition) {
        super(cluster, traits, child, condition);
    }

    public Filter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new ImpalaFilterRel(this.getCluster(), traitSet, input, condition);
    }

    @Override
    public NodeWithExprs getPlanNode(ParentPlanRelContext context) throws ImpalaException {
        Preconditions.checkState((this.getInputs().size() == 1 ? 1 : 0) != 0);
        return this.getChildPlanNode(context);
    }

    private NodeWithExprs getChildPlanNode(ParentPlanRelContext context) throws ImpalaException {
        ImpalaPlanRel relInput = (ImpalaPlanRel)this.getInput(0);
        ParentPlanRelContext.Builder builder = new ParentPlanRelContext.Builder(context, this);
        RexNode newFilterCondition = this.createNewCondition(context.filterCondition_, this.getCondition());
        builder.setFilterCondition(newFilterCondition);
        if (context.inputRefs_ != null) {
            ImmutableBitSet inputRefs = RelOptUtil.InputFinder.bits((List)Lists.newArrayList((Object[])new RexNode[]{this.getCondition()}), null);
            builder.setInputRefs(inputRefs.union(context.inputRefs_));
        }
        return relInput.getPlanNode(builder.build());
    }

    private RexNode createNewCondition(RexNode previousCondition, RexNode newCondition) {
        if (previousCondition == null) {
            return newCondition;
        }
        ImmutableList conditions = ImmutableList.of((Object)previousCondition, (Object)newCondition);
        return RexUtil.composeConjunction((RexBuilder)this.getCluster().getRexBuilder(), (Iterable)conditions);
    }

    @Override
    public ImpalaPlanRel.RelNodeType relNodeType() {
        return ImpalaPlanRel.RelNodeType.FILTER;
    }
}

