/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rel.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.commons.collections.CollectionUtils;
import org.apache.impala.analysis.AnalyticExpr;
import org.apache.impala.analysis.AnalyticInfo;
import org.apache.impala.analysis.AnalyticWindow;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FunctionParams;
import org.apache.impala.analysis.OrderByElement;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TupleIsNullPredicate;
import org.apache.impala.calcite.functions.AnalyzedAnalyticExpr;
import org.apache.impala.calcite.functions.AnalyzedFunctionCallExpr;
import org.apache.impala.calcite.functions.FunctionResolver;
import org.apache.impala.calcite.functions.RexCallConverter;
import org.apache.impala.calcite.functions.RexLiteralConverter;
import org.apache.impala.calcite.rel.node.ImpalaPlanRel;
import org.apache.impala.calcite.rel.node.NodeCreationUtils;
import org.apache.impala.calcite.rel.node.NodeWithExprs;
import org.apache.impala.calcite.rel.node.ParentPlanRelContext;
import org.apache.impala.calcite.rel.util.CreateExprVisitor;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.AnalyticPlanner;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlannerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaAnalyticRel
extends Project
implements ImpalaPlanRel {
    protected static final Logger LOG = LoggerFactory.getLogger(ImpalaAnalyticRel.class);

    public ImpalaAnalyticRel(Project project) {
        super(project.getCluster(), project.getTraitSet(), (List)project.getHints(), project.getInput(0), project.getProjects(), project.getRowType());
    }

    private ImpalaAnalyticRel(RelOptCluster cluster, RelTraitSet traits, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traits, new ArrayList(), input, projects, rowType);
    }

    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
        return new ImpalaAnalyticRel(this.getCluster(), traitSet, input, projects, rowType);
    }

    @Override
    public NodeWithExprs getPlanNode(ParentPlanRelContext context) throws ImpalaException {
        List projects = this.getProjects();
        NodeWithExprs inputNodeWithExprs = this.getChildPlanNode(context, projects);
        ImpalaPlanRel inputRel = (ImpalaPlanRel)this.getInput(0);
        List<RexOver> overExprs = ImpalaAnalyticRel.gatherRexOver(projects);
        List<GroupedAnalyticExpr> groupAnalyticExprs = this.getGroupedAnalyticExprs(overExprs, context.ctx_, inputRel, inputNodeWithExprs.outputExprs_);
        ArrayList<AnalyticExpr> analyticExprs = new ArrayList<AnalyticExpr>();
        for (GroupedAnalyticExpr g : groupAnalyticExprs) {
            analyticExprs.add(g.analyticExpr);
        }
        AnalyticInfo analyticInfo = AnalyticInfo.create(analyticExprs, (Analyzer)context.ctx_.getRootAnalyzer());
        AnalyticPlanner analyticPlanner = new AnalyticPlanner(analyticInfo, context.ctx_.getRootAnalyzer(), context.ctx_);
        List nonNullExprs = inputNodeWithExprs.outputExprs_.stream().filter(e -> e != null).collect(Collectors.toList());
        List tupleIsNullPreds = TupleIsNullPredicate.getUniqueBoundTupleIsNullPredicates(nonNullExprs, (List)inputNodeWithExprs.planNode_.getTupleIds());
        PlanNode planNode = analyticPlanner.createSingleNodePlan(inputNodeWithExprs.planNode_, Collections.emptyList(), new ArrayList(), tupleIsNullPreds);
        Map<RexNode, Expr> mapping = this.createRexNodeExprMapping(inputRel, planNode, projects, inputNodeWithExprs.outputExprs_, groupAnalyticExprs, context.ctx_, analyticInfo);
        List<Expr> outputExprs = this.getOutputExprs(mapping, projects, context.ctx_.getRootAnalyzer());
        NodeWithExprs retNode = new NodeWithExprs(planNode, outputExprs, this.getRowType().getFieldNames());
        return NodeCreationUtils.wrapInSelectNodeIfNeeded(context, retNode, this.getCluster().getRexBuilder());
    }

    private NodeWithExprs getChildPlanNode(ParentPlanRelContext context, List<RexNode> projects) throws ImpalaException {
        ImpalaPlanRel relInput = (ImpalaPlanRel)this.getInput(0);
        ParentPlanRelContext.Builder builder = new ParentPlanRelContext.Builder(context, this);
        builder.setFilterCondition(null);
        builder.setInputRefs(RelOptUtil.InputFinder.bits(projects, null));
        return relInput.getPlanNode(builder.build());
    }

    private AnalyticExpr getAnalyticExpr(RexOver rexOver, PlannerContext ctx, ImpalaPlanRel inputRel, List<Expr> inputExprs) throws ImpalaException {
        RexWindow rexWindow = rexOver.getWindow();
        Function fn = this.getFunction(rexOver);
        Type impalaRetType = ImpalaTypeConverter.createImpalaType(rexOver.getType());
        CreateExprVisitor visitor = new CreateExprVisitor(this.getCluster().getRexBuilder(), inputExprs, ctx.getRootAnalyzer());
        List<Expr> operands = CreateExprVisitor.getExprs(visitor, (List<RexNode>)rexOver.operands);
        FunctionParams params = new FunctionParams(rexOver.isDistinct(), rexOver.ignoreNulls(), operands);
        AnalyzedFunctionCallExpr fnCall = new AnalyzedFunctionCallExpr(fn, params, impalaRetType);
        fnCall.analyze(ctx.getRootAnalyzer());
        fnCall.setIsAnalyticFnCall(true);
        List<Object> partitionExprs = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)rexWindow.partitionKeys)) {
            partitionExprs = CreateExprVisitor.getExprs(visitor, (List<RexNode>)rexWindow.partitionKeys);
        }
        ArrayList<OrderByElement> orderByElements = new ArrayList<OrderByElement>();
        if (rexWindow.orderKeys != null) {
            for (RexFieldCollation ok : rexWindow.orderKeys) {
                Expr orderByExpr = CreateExprVisitor.getExpr(visitor, (RexNode)ok.left);
                boolean nullsFirst = ok.getDirection() == RelFieldCollation.Direction.ASCENDING ? ((ImmutableSet)ok.right).contains((Object)SqlKind.NULLS_FIRST) : !((ImmutableSet)ok.right).contains((Object)SqlKind.NULLS_FIRST);
                OrderByElement orderByElement = new OrderByElement(orderByExpr, ok.getDirection() == RelFieldCollation.Direction.ASCENDING, Boolean.valueOf(nullsFirst));
                orderByElements.add(orderByElement);
            }
        }
        AnalyticWindow window = null;
        if (!(partitionExprs.isEmpty() && orderByElements.isEmpty() || this.skipWindowGeneration(fn))) {
            AnalyticWindow.Boundary lBoundary = this.getWindowBoundary(rexWindow.getLowerBound(), ctx, inputRel, visitor);
            AnalyticWindow.Boundary rBoundary = this.getWindowBoundary(rexWindow.getUpperBound(), ctx, inputRel, visitor);
            window = new AnalyticWindow(rexWindow.isRows() ? AnalyticWindow.Type.ROWS : AnalyticWindow.Type.RANGE, lBoundary, rBoundary);
        }
        AnalyzedAnalyticExpr retExpr = new AnalyzedAnalyticExpr(fnCall, partitionExprs, orderByElements, window);
        retExpr.analyze(ctx.getRootAnalyzer());
        return retExpr;
    }

    private boolean skipWindowGeneration(Function fn) {
        return fn.functionName().equals("lag") || fn.functionName().equals("lead") || fn.functionName().equals("row_number");
    }

    private AnalyticWindow.Boundary getWindowBoundary(RexWindowBound wb, PlannerContext ctx, ImpalaPlanRel inputRel, CreateExprVisitor visitor) throws ImpalaException {
        Preconditions.checkNotNull((Object)wb);
        if (wb.isCurrentRow()) {
            return new AnalyticWindow.Boundary(AnalyticWindow.BoundaryType.CURRENT_ROW, null);
        }
        if (wb.isPreceding()) {
            if (wb.isUnbounded()) {
                return new AnalyticWindow.Boundary(AnalyticWindow.BoundaryType.UNBOUNDED_PRECEDING, null);
            }
            Expr operand = CreateExprVisitor.getExpr(visitor, wb.getOffset());
            return new AnalyticWindow.Boundary(AnalyticWindow.BoundaryType.PRECEDING, operand, new BigDecimal(RexLiteral.intValue((RexNode)wb.getOffset())));
        }
        if (wb.isUnbounded()) {
            return new AnalyticWindow.Boundary(AnalyticWindow.BoundaryType.UNBOUNDED_FOLLOWING, null);
        }
        Expr operand = CreateExprVisitor.getExpr(visitor, wb.getOffset());
        return new AnalyticWindow.Boundary(AnalyticWindow.BoundaryType.FOLLOWING, operand, new BigDecimal(RexLiteral.intValue((RexNode)wb.getOffset())));
    }

    private List<Expr> getOutputExprs(Map<RexNode, Expr> mapping, List<RexNode> projects, Analyzer analyzer) throws ImpalaException {
        AnalyticRexVisitor visitor = new AnalyticRexVisitor(mapping, this.getCluster().getRexBuilder(), analyzer);
        LinkedHashMap projectExprs = new LinkedHashMap();
        ArrayList<Expr> outputExprs = new ArrayList<Expr>();
        for (RexNode rexNode : projects) {
            Expr expr = (Expr)rexNode.accept((RexVisitor)visitor);
            expr.analyze(analyzer);
            outputExprs.add(expr);
        }
        return outputExprs;
    }

    public static List<RexOver> gatherRexOver(List<RexNode> exprs) {
        final ArrayList<RexOver> result = new ArrayList<RexOver>();
        RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

            public Void visitOver(RexOver over) {
                result.add(over);
                return (Void)super.visitOver(over);
            }
        };
        for (RexNode expr : exprs) {
            expr.accept((RexVisitor)visitor);
        }
        return result;
    }

    private Function getFunction(RexOver exp) throws ImpalaException {
        RelDataType retType = exp.getType();
        SqlAggFunction aggFunction = exp.getAggOperator();
        ArrayList operandTypes = Lists.newArrayList();
        for (RexNode operand : exp.operands) {
            operandTypes.add(operand.getType());
        }
        return FunctionResolver.getExactFunction(aggFunction.getName(), aggFunction.getKind(), operandTypes);
    }

    private List<GroupedAnalyticExpr> getGroupedAnalyticExprs(List<RexOver> overExprs, PlannerContext ctx, ImpalaPlanRel inputRel, List<Expr> inputExprs) throws ImpalaException {
        ArrayList<AnalyticExpr> analyticExprs = new ArrayList<AnalyticExpr>();
        ArrayList<ArrayList> overExprsList = new ArrayList<ArrayList>();
        for (RexOver over : overExprs) {
            AnalyticExpr analyticExpr = this.getAnalyticExpr(over, ctx, inputRel, inputExprs);
            int index = analyticExprs.indexOf(analyticExpr);
            if (index == -1) {
                analyticExprs.add(analyticExpr);
                overExprsList.add(Lists.newArrayList((Object[])new RexOver[]{over}));
                continue;
            }
            ((List)overExprsList.get(index)).add(over);
        }
        Preconditions.checkState((analyticExprs.size() == overExprsList.size() ? 1 : 0) != 0);
        ArrayList<GroupedAnalyticExpr> groupedAnalyticExprs = new ArrayList<GroupedAnalyticExpr>();
        for (int i = 0; i < analyticExprs.size(); ++i) {
            groupedAnalyticExprs.add(new GroupedAnalyticExpr((AnalyticExpr)analyticExprs.get(i), (List)overExprsList.get(i)));
        }
        return groupedAnalyticExprs;
    }

    private Map<RexNode, Expr> createRexNodeExprMapping(ImpalaPlanRel inputRel, PlanNode planNode, List<RexNode> projects, List<Expr> inputExprs, List<GroupedAnalyticExpr> groupAnalyticExprs, PlannerContext ctx, AnalyticInfo analyticInfo) {
        ExprSubstitutionMap outputExprMap = planNode.getOutputSmap();
        LinkedHashMap<RexNode, Expr> mapping = new LinkedHashMap<RexNode, Expr>();
        for (int pos : this.getInputReferences(projects)) {
            Expr e = inputExprs.get(pos).substitute(outputExprMap, ctx.getRootAnalyzer(), true);
            mapping.put((RexNode)RexInputRef.of((int)pos, (List)this.getInput(0).getRowType().getFieldList()), e);
        }
        for (int i = 0; i < groupAnalyticExprs.size(); ++i) {
            GroupedAnalyticExpr g = groupAnalyticExprs.get(i);
            SlotDescriptor slotDesc = (SlotDescriptor)analyticInfo.getOutputTupleDesc().getSlots().get(i);
            SlotRef logicalOutputSlot = new SlotRef(slotDesc);
            for (RexOver over : g.overExprsList) {
                mapping.put((RexNode)over, outputExprMap.get((Expr)logicalOutputSlot));
            }
        }
        return mapping;
    }

    private Set<Integer> getInputReferences(List<RexNode> projects) {
        RelOptUtil.InputReferencedVisitor shuttle = new RelOptUtil.InputReferencedVisitor();
        shuttle.apply(projects);
        return shuttle.inputPosReferenced;
    }

    @Override
    public ImpalaPlanRel.RelNodeType relNodeType() {
        return ImpalaPlanRel.RelNodeType.PROJECT;
    }

    private static class AnalyticRexVisitor
    extends RexVisitorImpl<Expr> {
        private final Map<RexNode, Expr> exprsMap_;
        private final RexBuilder rexBuilder_;
        private final Analyzer analyzer_;

        public AnalyticRexVisitor(Map<RexNode, Expr> exprsMap, RexBuilder rexBuilder, Analyzer analyzer) {
            super(false);
            this.exprsMap_ = exprsMap;
            this.rexBuilder_ = rexBuilder;
            this.analyzer_ = analyzer;
        }

        public Expr visitCall(RexCall rexCall) {
            ArrayList params = Lists.newArrayList();
            for (RexNode operand : rexCall.getOperands()) {
                params.add(operand.accept((RexVisitor)this));
            }
            try {
                return RexCallConverter.getExpr(rexCall, params, this.rexBuilder_, this.analyzer_);
            }
            catch (ImpalaException e) {
                throw new RuntimeException(e);
            }
        }

        public Expr visitLiteral(RexLiteral rexLiteral) {
            return RexLiteralConverter.getExpr(rexLiteral);
        }

        public Expr visitInputRef(RexInputRef rexInputRef) {
            return this.exprsMap_.get(rexInputRef);
        }

        public Expr visitOver(RexOver over) {
            return this.exprsMap_.get(over);
        }

        public Expr visitLocalRef(RexLocalRef localRef) {
            throw new RuntimeException("Not supported");
        }

        public Expr visitCorrelVariable(RexCorrelVariable correlVariable) {
            throw new RuntimeException("Not supported");
        }

        public Expr visitDynamicParam(RexDynamicParam dynamicParam) {
            throw new RuntimeException("Not supported");
        }

        public Expr visitRangeRef(RexRangeRef rangeRef) {
            throw new RuntimeException("Not supported");
        }

        public Expr visitFieldAccess(RexFieldAccess fieldAccess) {
            throw new RuntimeException("Not supported");
        }

        public Expr visitSubQuery(RexSubQuery subQuery) {
            throw new RuntimeException("Not supported");
        }

        public Expr visitTableInputRef(RexTableInputRef fieldRef) {
            throw new RuntimeException("Not supported");
        }

        public Expr visitPatternFieldRef(RexPatternFieldRef fieldRef) {
            throw new RuntimeException("Not supported");
        }
    }

    private static class GroupedAnalyticExpr {
        public final AnalyticExpr analyticExpr;
        public final List<RexOver> overExprsList;

        public GroupedAnalyticExpr(AnalyticExpr analyticExpr, List<RexOver> overExprsList) {
            this.analyticExpr = analyticExpr;
            this.overExprsList = overExprsList;
        }
    }
}

