/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rel.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.fun.SqlSingleValueAggFunction;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.impala.analysis.AggregateInfo;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.FunctionParams;
import org.apache.impala.analysis.MultiAggregateInfo;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.calcite.functions.AnalyzedFunctionCallExpr;
import org.apache.impala.calcite.functions.AnalyzedNullLiteral;
import org.apache.impala.calcite.functions.FunctionResolver;
import org.apache.impala.calcite.rel.node.ImpalaPlanRel;
import org.apache.impala.calcite.rel.node.NodeWithExprs;
import org.apache.impala.calcite.rel.node.ParentPlanRelContext;
import org.apache.impala.calcite.rel.util.ExprConjunctsConverter;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.calcite.util.SimplifiedAnalyzer;
import org.apache.impala.catalog.AggregateFunction;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.AggregationNode;
import org.apache.impala.planner.CardinalityCheckNode;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlannerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaAggRel
extends Aggregate
implements ImpalaPlanRel {
    protected static final Logger LOG = LoggerFactory.getLogger((String)ImpalaAggRel.class.getName());

    public ImpalaAggRel(Aggregate agg) {
        super(agg.getCluster(), agg.getTraitSet(), (List)agg.getHints(), agg.getInput(), agg.getGroupSet(), (List)agg.getGroupSets(), agg.getAggCallList());
    }

    public ImpalaAggRel(RelOptCluster cluster, RelTraitSet relTraitSet, List<RelHint> hints, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, relTraitSet, hints, input, groupSet, groupSets, aggCalls);
    }

    @Override
    public NodeWithExprs getPlanNode(ParentPlanRelContext context) throws ImpalaException {
        Preconditions.checkState((this.getInputs().size() == 1 ? 1 : 0) != 0);
        NodeWithExprs inputWithExprs = this.getChildPlanNode(context);
        PlanNode input = inputWithExprs.planNode_;
        Preconditions.checkState((boolean)(context.ctx_.getRootAnalyzer() instanceof SimplifiedAnalyzer));
        SimplifiedAnalyzer simplifiedAnalyzer = (SimplifiedAnalyzer)context.ctx_.getRootAnalyzer();
        if (this.isCardinalityCheckRelNode()) {
            return this.getCardinalityCheckNode(inputWithExprs, context.ctx_);
        }
        List<Expr> groupingExprs = this.getGroupingExprs(inputWithExprs.outputExprs_);
        List<FunctionCallExpr> aggExprs = this.getAggregateExprs(context.ctx_, inputWithExprs.outputExprs_, simplifiedAnalyzer, inputWithExprs.countStarOptimization_);
        List<List<Expr>> groupingSets = this.getGroupingSets(simplifiedAnalyzer, inputWithExprs.outputExprs_);
        MultiAggregateInfo multiAggInfo = new MultiAggregateInfo(groupingExprs, aggExprs, groupingSets);
        multiAggInfo.analyze((Analyzer)simplifiedAnalyzer);
        multiAggInfo.materializeRequiredSlots((Analyzer)simplifiedAnalyzer, new ExprSubstitutionMap());
        AggregateInfo aggInfo = multiAggInfo.hasTransposePhase() ? multiAggInfo.getTransposeAggInfo() : (AggregateInfo)multiAggInfo.getAggClasses().get(0);
        PlanNode aggNode = this.getTopLevelAggNode(input, multiAggInfo, context.ctx_);
        List<Expr> outputExprs = this.createMappedOutputExprs(multiAggInfo, groupingExprs, aggExprs, aggInfo.getResultTupleDesc().getSlots());
        if (context.filterCondition_ != null) {
            ExprConjunctsConverter converter = new ExprConjunctsConverter(context.filterCondition_, outputExprs, this.getCluster().getRexBuilder(), simplifiedAnalyzer);
            simplifiedAnalyzer.setUnassignedConjuncts(converter.getImpalaConjuncts());
        }
        aggNode.init((Analyzer)simplifiedAnalyzer);
        simplifiedAnalyzer.clearUnassignedConjuncts();
        return new NodeWithExprs(aggNode, outputExprs, this.getRowType().getFieldNames());
    }

    private NodeWithExprs getChildPlanNode(ParentPlanRelContext context) throws ImpalaException {
        ImpalaPlanRel relInput = (ImpalaPlanRel)this.getInput(0);
        ParentPlanRelContext.Builder builder = new ParentPlanRelContext.Builder(context, this);
        builder.setFilterCondition(null);
        builder.setParentAggregate(this);
        builder.setInputRefs(ImmutableBitSet.of((Iterable)RelOptUtil.getAllFields((Aggregate)this)));
        return relInput.getPlanNode(builder.build());
    }

    private List<Expr> getGroupingExprs(List<Expr> inputExprs) {
        ArrayList exprs = Lists.newArrayList();
        Iterator iterator = super.getGroupSet().iterator();
        while (iterator.hasNext()) {
            int groupIndex = (Integer)iterator.next();
            exprs.add(inputExprs.get(groupIndex));
        }
        return exprs;
    }

    private List<List<Expr>> getGroupingSets(Analyzer analyzer, List<Expr> inputExprs) throws ImpalaException {
        if (Aggregate.isSimple((Aggregate)this)) {
            return null;
        }
        ArrayList allGroupSetExprs = Lists.newArrayList();
        ImmutableList groupSets = super.getGroupSets();
        if (groupSets.size() == 0) {
            return allGroupSetExprs;
        }
        ImmutableBitSet groupSet = super.getGroupSet();
        Map<Integer, Type> gbExprTypes = groupSet.asList().stream().collect(Collectors.toMap(groupByField -> groupByField, groupByField -> ((Expr)inputExprs.get((int)groupByField)).getType()));
        for (int i = 0; i < groupSets.size(); ++i) {
            ImmutableBitSet presentGbFields = (ImmutableBitSet)groupSets.get(i);
            LinkedHashMap<Integer, Object> oneGroupExprs = new LinkedHashMap<Integer, Object>();
            Iterator iterator = groupSet.iterator();
            while (iterator.hasNext()) {
                int groupByField2 = (Integer)iterator.next();
                if (presentGbFields.get(groupByField2)) {
                    oneGroupExprs.put(groupByField2, inputExprs.get(groupByField2));
                    continue;
                }
                Type nullType = gbExprTypes.get(groupByField2);
                AnalyzedNullLiteral nullLiteral = new AnalyzedNullLiteral(nullType);
                nullLiteral.analyze(analyzer);
                oneGroupExprs.put(groupByField2, (Object)nullLiteral);
            }
            allGroupSetExprs.add(new ArrayList(oneGroupExprs.values()));
        }
        return allGroupSetExprs;
    }

    private PlanNode getTopLevelAggNode(PlanNode input, MultiAggregateInfo multiAggInfo, PlannerContext ctx) throws ImpalaException {
        Analyzer analyzer = ctx.getRootAnalyzer();
        AggregationNode firstPhaseAgg = new AggregationNode(ctx.getNextNodeId(), input, multiAggInfo, MultiAggregateInfo.AggPhase.FIRST);
        if (!multiAggInfo.hasSecondPhase() && !multiAggInfo.hasTransposePhase()) {
            return firstPhaseAgg;
        }
        firstPhaseAgg.init(analyzer);
        firstPhaseAgg.setIntermediateTuple();
        AggregationNode secondPhaseAgg = null;
        if (multiAggInfo.hasSecondPhase()) {
            firstPhaseAgg.unsetNeedsFinalize();
            secondPhaseAgg = new AggregationNode(ctx.getNextNodeId(), (PlanNode)firstPhaseAgg, multiAggInfo, MultiAggregateInfo.AggPhase.SECOND);
            if (!multiAggInfo.hasTransposePhase()) {
                return secondPhaseAgg;
            }
            secondPhaseAgg.init(analyzer);
        }
        AggregationNode transposePhaseAgg = firstPhaseAgg;
        if (multiAggInfo.hasTransposePhase()) {
            AggregationNode inputAgg = secondPhaseAgg != null ? secondPhaseAgg : firstPhaseAgg;
            transposePhaseAgg = new AggregationNode(ctx.getNextNodeId(), (PlanNode)inputAgg, multiAggInfo, MultiAggregateInfo.AggPhase.TRANSPOSE);
        }
        return transposePhaseAgg;
    }

    public boolean hasDistinctOnly() throws ImpalaException {
        for (AggregateCall aggCall : this.getAggCallList()) {
            Function fn = this.getFunction(aggCall);
            if (fn == null) {
                return false;
            }
            Preconditions.checkState((boolean)(fn instanceof AggregateFunction));
            AggregateFunction aggFn = (AggregateFunction)fn;
            if (aggFn.ignoresDistinct() || aggCall.isDistinct()) continue;
            return false;
        }
        return true;
    }

    public boolean hasCountStarOnly() {
        if (this.getAggCallList().size() == 0) {
            return false;
        }
        for (AggregateCall aggCall : this.getAggCallList()) {
            if (!aggCall.getAggregation().getKind().equals((Object)SqlKind.COUNT)) {
                return false;
            }
            if (aggCall.getArgList().size() <= 0) continue;
            return false;
        }
        return true;
    }

    private List<FunctionCallExpr> getAggregateExprs(PlannerContext ctx, List<Expr> inputExprs, Analyzer analyzer, Expr countStarOptimization) throws ImpalaException, AnalysisException {
        ArrayList exprs = Lists.newArrayList();
        ImpalaPlanRel input = (ImpalaPlanRel)this.getInput(0);
        for (AggregateCall aggCall : this.getAggCallList()) {
            if (this.hasCountStarOnly() && countStarOptimization != null) {
                ArrayList<Expr> args = new ArrayList<Expr>();
                args.add(countStarOptimization);
                FunctionCallExpr sumFn = new FunctionCallExpr("sum_init_zero", args);
                sumFn.analyzeNoThrow(analyzer);
                exprs.add(sumFn);
                continue;
            }
            List operands = aggCall.getArgList().stream().map(t -> (Expr)inputExprs.get((int)t)).collect(Collectors.toList());
            Function fn = this.getFunction(aggCall);
            Preconditions.checkState((fn != null ? 1 : 0) != 0, (Object)("Could not find the Impala function for " + aggCall.getAggregation().getName()));
            Type impalaRetType = ImpalaTypeConverter.createImpalaType(aggCall.getType());
            FunctionParams params = new FunctionParams(aggCall.isDistinct(), operands);
            AnalyzedFunctionCallExpr e = new AnalyzedFunctionCallExpr(fn, params, impalaRetType);
            e.analyze(analyzer);
            exprs.add(e);
        }
        return exprs;
    }

    private Function getFunction(AggregateCall aggCall) throws ImpalaException {
        RelDataType retType = aggCall.getType();
        SqlAggFunction aggFunction = aggCall.getAggregation();
        ArrayList operandTypes = Lists.newArrayList();
        RelNode input = this.getInput(0);
        Iterator iterator = aggCall.getArgList().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            RelDataType relDataType = ((RelDataTypeField)input.getRowType().getFieldList().get(i)).getType();
            operandTypes.add(relDataType);
        }
        return FunctionResolver.getExactFunction(aggFunction.getName(), aggFunction.getKind(), operandTypes);
    }

    private boolean isCardinalityCheckRelNode() {
        return this.getAggCallList().size() == 1 && ((AggregateCall)this.getAggCallList().get(0)).getAggregation() instanceof SqlSingleValueAggFunction;
    }

    private NodeWithExprs getCardinalityCheckNode(NodeWithExprs inputNodeWithExprs, PlannerContext ctx) throws ImpalaException {
        inputNodeWithExprs.planNode_.setLimit(2L);
        int inputRef = (Integer)((AggregateCall)this.getAggCallList().get(0)).getArgList().get(0);
        ImmutableList outputExprs = ImmutableList.of((Object)inputNodeWithExprs.outputExprs_.get(inputRef));
        CardinalityCheckNode cardinalityCheckNode = new CardinalityCheckNode(ctx.getNextNodeId(), inputNodeWithExprs.planNode_, "CARDINALITY CHECK");
        cardinalityCheckNode.init(ctx.getRootAnalyzer());
        return new NodeWithExprs((PlanNode)cardinalityCheckNode, (List<Expr>)outputExprs, this.getRowType().getFieldNames());
    }

    public Aggregate copy(RelTraitSet relTraitSet, RelNode relNode, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        return new ImpalaAggRel(this.getCluster(), relTraitSet, new ArrayList<RelHint>(), relNode, groupSet, groupSets, aggCalls);
    }

    public List<Expr> createMappedOutputExprs(MultiAggregateInfo multiAggInfo, List<Expr> groupingExprs, List<FunctionCallExpr> aggExprs, List<SlotDescriptor> slotDescs) {
        Expr slotRefExpr;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        int numSlots = groupingExprs.size() + aggExprs.size();
        boolean index = false;
        for (Expr expr : groupingExprs) {
            slotRefExpr = multiAggInfo.getOutputSmap().get(expr);
            Preconditions.checkNotNull((Object)slotRefExpr);
            builder.add((Object)slotRefExpr);
        }
        for (FunctionCallExpr functionCallExpr : aggExprs) {
            slotRefExpr = multiAggInfo.getOutputSmap().get((Expr)functionCallExpr);
            Preconditions.checkNotNull((Object)slotRefExpr);
            builder.add((Object)slotRefExpr);
        }
        return builder.build();
    }

    @Override
    public ImpalaPlanRel.RelNodeType relNodeType() {
        return ImpalaPlanRel.RelNodeType.AGGREGATE;
    }
}

